/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.util;

import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.CompactStringObjectMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnumResolver
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<Enum<?>> _enumClass;
    protected final Enum<?>[] _enums;
    protected final HashMap<String, Enum<?>> _enumsById;
    protected final Enum<?> _defaultValue;
    protected final boolean _isIgnoreCase;
    protected final boolean _isFromIntValue;

    public EnumResolver(Class<Enum<?>> clazz, Enum<?>[] enumArray, HashMap<String, Enum<?>> hashMap, Enum<?> enum_, boolean bl, boolean bl2) {
        this._enumClass = clazz;
        this._enums = enumArray;
        this._enumsById = hashMap;
        this._defaultValue = enum_;
        this._isIgnoreCase = bl;
        this._isFromIntValue = bl2;
    }

    @Deprecated
    public EnumResolver(Class<Enum<?>> clazz, Enum<?>[] enumArray, HashMap<String, Enum<?>> hashMap, Enum<?> enum_, boolean bl) {
        this(clazz, enumArray, hashMap, enum_, bl, false);
    }

    public static EnumResolver constructFor(DeserializationConfig serializable, Class<?> clazz) {
        DeserializationConfig deserializationConfig = serializable;
        serializable = deserializationConfig.getAnnotationIntrospector();
        return EnumResolver._constructFor(clazz, (AnnotationIntrospector)serializable, deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS));
    }

    public static EnumResolver _constructFor(Class<?> clazz, AnnotationIntrospector object, boolean bl) {
        HashMap hashMap;
        Class<?> clazz2 = clazz;
        clazz = EnumResolver._enumClass(clazz2);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz2);
        String[] stringArray = ((AnnotationIntrospector)object).findEnumValues(clazz, enumArray, new String[enumArray.length]);
        String[][] stringArray2 = new String[stringArray.length][];
        ((AnnotationIntrospector)object).findEnumAliases(clazz, enumArray, stringArray2);
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String[] stringArray3 = stringArray[i2];
            if (stringArray3 == null) {
                stringArray3 = enum_.name();
            }
            hashMap2.put((String)stringArray3, enum_);
            stringArray3 = stringArray2[i2];
            if (stringArray3 == null) continue;
            for (String string : stringArray3) {
                if (hashMap2.containsKey(string)) continue;
                hashMap2.put(string, enum_);
            }
        }
        object = EnumResolver._enumDefault((AnnotationIntrospector)object, clazz);
        return new EnumResolver(clazz, enumArray, hashMap2, (Enum<?>)object, bl, false);
    }

    public static EnumResolver constructUsingToString(DeserializationConfig serializable, Class<?> clazz) {
        DeserializationConfig deserializationConfig = serializable;
        serializable = deserializationConfig.getAnnotationIntrospector();
        return EnumResolver._constructUsingToString(clazz, (AnnotationIntrospector)serializable, deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS));
    }

    public static EnumResolver _constructUsingToString(Class<?> clazz, AnnotationIntrospector object, boolean bl) {
        HashMap hashMap;
        Class<?> clazz2 = clazz;
        clazz = EnumResolver._enumClass(clazz2);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz2);
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        String[][] stringArray = new String[enumArray.length][];
        if (object != null) {
            ((AnnotationIntrospector)object).findEnumAliases(clazz, enumArray, stringArray);
        }
        int n2 = enumArray.length;
        while ((n2 += -1) >= 0) {
            Enum<?> enum_ = enumArray[n2];
            hashMap2.put(enum_.toString(), enum_);
            String[] stringArray2 = stringArray[n2];
            if (stringArray2 == null) continue;
            for (String string : stringArray2) {
                if (hashMap2.containsKey(string)) continue;
                hashMap2.put(string, enum_);
            }
        }
        object = EnumResolver._enumDefault((AnnotationIntrospector)object, clazz);
        return new EnumResolver(clazz, enumArray, hashMap2, (Enum<?>)object, bl, false);
    }

    public static EnumResolver constructUsingMethod(DeserializationConfig serializable, Class<?> clazz, AnnotatedMember annotatedMember) {
        DeserializationConfig deserializationConfig = serializable;
        serializable = deserializationConfig.getAnnotationIntrospector();
        return EnumResolver._constructUsingMethod(clazz, annotatedMember, (AnnotationIntrospector)serializable, deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS));
    }

    public static EnumResolver _constructUsingMethod(Class<?> object, AnnotatedMember annotatedMember, AnnotationIntrospector annotationIntrospector, boolean bl) {
        HashMap hashMap;
        Class<?> clazz = object;
        object = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        int n2 = enumArray.length;
        while ((n2 += -1) >= 0) {
            Object object2;
            Enum<?> enum_ = enumArray[n2];
            try {
                object2 = annotatedMember.getValue(enum_);
                if (object2 == null) continue;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + enum_ + ": " + exception.getMessage());
            }
            hashMap2.put(object2.toString(), enum_);
        }
        Class<Enum<?>> clazz2 = object;
        object = EnumResolver._enumDefault(annotationIntrospector, object);
        boolean bl2 = EnumResolver._isIntType(annotatedMember.getRawType());
        return new EnumResolver(clazz2, enumArray, hashMap2, (Enum<?>)object, bl, bl2);
    }

    public static Class<Enum<?>> _enumClass(Class<?> clazz) {
        return clazz;
    }

    public static Enum<?>[] _enumConstants(Class<?> clazz) {
        Enum<?>[] enumArray = EnumResolver._enumClass(clazz).getEnumConstants();
        if (enumArray != null) {
            return enumArray;
        }
        throw new IllegalArgumentException("No enum constants for class ".concat(clazz.getName()));
    }

    public static Enum<?> _enumDefault(AnnotationIntrospector annotationIntrospector, Class<?> clazz) {
        return annotationIntrospector != null ? annotationIntrospector.findDefaultEnumValue(EnumResolver._enumClass(clazz)) : null;
    }

    public static boolean _isIntType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            clazz = ClassUtil.wrapperType(clazz);
        }
        return clazz == Long.class || clazz == Integer.class || clazz == Short.class || clazz == Byte.class;
    }

    @Deprecated
    public EnumResolver(Class<Enum<?>> clazz, Enum<?>[] enumArray, HashMap<String, Enum<?>> hashMap, Enum<?> enum_) {
        this(clazz, enumArray, hashMap, enum_, false, false);
    }

    @Deprecated
    public static EnumResolver constructFor(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        return EnumResolver._constructFor(clazz, annotationIntrospector, false);
    }

    @Deprecated
    public static EnumResolver constructUnsafe(Class<?> clazz, AnnotationIntrospector annotationIntrospector) {
        return EnumResolver._constructFor(clazz, annotationIntrospector, false);
    }

    @Deprecated
    public static EnumResolver constructUsingToString(Class<Enum<?>> clazz, AnnotationIntrospector annotationIntrospector) {
        return EnumResolver._constructUsingToString(clazz, annotationIntrospector, false);
    }

    @Deprecated
    public static EnumResolver constructUnsafeUsingToString(Class<?> clazz, AnnotationIntrospector annotationIntrospector) {
        return EnumResolver._constructUsingToString(clazz, annotationIntrospector, false);
    }

    @Deprecated
    public static EnumResolver constructUsingToString(Class<Enum<?>> clazz) {
        return EnumResolver._constructUsingToString(clazz, null, false);
    }

    @Deprecated
    public static EnumResolver constructUsingMethod(Class<Enum<?>> clazz, AnnotatedMember annotatedMember, AnnotationIntrospector annotationIntrospector) {
        return EnumResolver._constructUsingMethod(clazz, annotatedMember, annotationIntrospector, false);
    }

    @Deprecated
    public static EnumResolver constructUnsafeUsingMethod(Class<?> clazz, AnnotatedMember annotatedMember, AnnotationIntrospector annotationIntrospector) {
        return EnumResolver._constructUsingMethod(clazz, annotatedMember, annotationIntrospector, false);
    }

    public CompactStringObjectMap constructLookup() {
        return CompactStringObjectMap.construct(this._enumsById);
    }

    public Enum<?> findEnum(String string) {
        Enum<?> enum_ = this._enumsById.get(string);
        if (enum_ == null && this._isIgnoreCase) {
            return this._findEnumCaseInsensitive(string);
        }
        return enum_;
    }

    public Enum<?> _findEnumCaseInsensitive(String string) {
        for (Map.Entry entry : ((EnumResolver)this)._enumsById.entrySet()) {
            if (!string.equalsIgnoreCase((String)entry.getKey())) continue;
            return (Enum)entry.getValue();
        }
        return null;
    }

    public Enum<?> getEnum(int n2) {
        if (n2 >= 0) {
            Enum<?>[] enumArray = enumArray._enums;
            if (n2 < enumArray._enums.length) {
                return enumArray[n2];
            }
        }
        return null;
    }

    public Enum<?> getDefaultValue() {
        return this._defaultValue;
    }

    public Enum<?>[] getRawEnums() {
        return this._enums;
    }

    public List<Enum<?>> getEnums() {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList(enumArray._enums.length);
        Enum<?>[] enumArray = enumArray._enums;
        int n2 = enumArray._enums.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList2.add(enumArray[i2]);
        }
        return arrayList2;
    }

    public Collection<String> getEnumIds() {
        return this._enumsById.keySet();
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }

    public int lastValidIndex() {
        return this._enums.length - 1;
    }

    public boolean isFromIntValue() {
        return this._isFromIntValue;
    }
}

