/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.util;

import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.databind.SerializationConfig;
import com.privatefasterxml.jackson.databind.SerializationFeature;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class EnumValues
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<Enum<?>> _enumClass;
    private final Enum<?>[] _values;
    private final SerializableString[] _textual;
    private transient EnumMap<?, SerializableString> _asMap;

    private EnumValues(Class<Enum<?>> clazz, SerializableString[] serializableStringArray) {
        this._enumClass = clazz;
        this._values = clazz.getEnumConstants();
        this._textual = serializableStringArray;
    }

    public static EnumValues construct(SerializationConfig serializationConfig, Class<Enum<?>> clazz) {
        if (serializationConfig.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
            return EnumValues.constructFromToString(serializationConfig, clazz);
        }
        return EnumValues.constructFromName(serializationConfig, clazz);
    }

    public static EnumValues constructFromName(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz) {
        String[] stringArray = ClassUtil.findEnumType(clazz);
        Enum<?>[] enumArray = stringArray.getEnumConstants();
        if (enumArray != null) {
            stringArray = mapperConfig.getAnnotationIntrospector().findEnumValues((Class<?>)stringArray, enumArray, new String[enumArray.length]);
            SerializableString[] serializableStringArray = new SerializableString[enumArray.length];
            int n2 = enumArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Enum<?> enum_ = enumArray[i2];
                String string = stringArray[i2];
                if (string == null) {
                    string = enum_.name();
                }
                int n3 = enum_.ordinal();
                serializableStringArray[n3] = mapperConfig.compileString(string);
            }
            return EnumValues.construct(clazz, serializableStringArray);
        }
        throw new IllegalArgumentException("Cannot determine enum constants for Class ".concat(clazz.getName()));
    }

    public static EnumValues constructFromToString(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz) {
        Enum<?>[] enumArray = ClassUtil.findEnumType(clazz).getEnumConstants();
        if (enumArray != null) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(enumArray.length);
            int n2 = enumArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList2.add(enumArray[i2].toString());
            }
            return EnumValues.construct(mapperConfig, clazz, arrayList2);
        }
        throw new IllegalArgumentException("Cannot determine enum constants for Class ".concat(clazz.getName()));
    }

    public static EnumValues construct(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz, List<String> list) {
        int n2 = list.size();
        SerializableString[] serializableStringArray = new SerializableString[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            serializableStringArray[i2] = mapperConfig.compileString(list.get(i2));
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    public static EnumValues construct(Class<Enum<?>> clazz, SerializableString[] serializableStringArray) {
        return new EnumValues(clazz, serializableStringArray);
    }

    public SerializableString serializedValueFor(Enum<?> enum_) {
        return this._textual[enum_.ordinal()];
    }

    public Collection<SerializableString> values() {
        return Arrays.asList(this._textual);
    }

    public List<Enum<?>> enums() {
        return Arrays.asList(this._values);
    }

    public EnumMap<?, SerializableString> internalMap() {
        Serializable serializable = serializable2._asMap;
        if (serializable == null) {
            EnumMap enumMap;
            LinkedHashMap linkedHashMap;
            serializable = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
            Enum<?>[] enumArray = serializable2._values;
            int n2 = serializable2._values.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Enum<?> enum_ = enumArray[i2];
                serializable.put(enum_, serializable2._textual[enum_.ordinal()]);
            }
            Serializable serializable2 = enumMap;
            enumMap = new EnumMap((Map<?, SerializableString>)((Object)serializable));
            serializable = serializable2;
        }
        return serializable;
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }
}

