/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.util;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonSerializable;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.jsontype.TypeSerializer;

public class JSONWrappedObject
implements JsonSerializable {
    protected final String _prefix;
    protected final String _suffix;
    protected final Object _value;
    protected final JavaType _serializationType;

    public JSONWrappedObject(String string, String string2, Object object) {
        this(string, string2, object, null);
    }

    public JSONWrappedObject(String string, String string2, Object object, JavaType javaType) {
        this._prefix = string;
        this._suffix = string2;
        this._value = object;
        this._serializationType = javaType;
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        this.serialize(jsonGenerator, serializerProvider);
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Object object = ((JSONWrappedObject)((Object)string))._prefix;
        if (object != null) {
            jsonGenerator.writeRaw((String)object);
        }
        if ((object = ((JSONWrappedObject)((Object)string))._value) == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
        } else {
            JavaType javaType = ((JSONWrappedObject)((Object)string))._serializationType;
            if (javaType != null) {
                serializerProvider.findTypedValueSerializer(javaType, true, null).serialize(((JSONWrappedObject)((Object)string))._value, jsonGenerator, serializerProvider);
            } else {
                serializerProvider.findTypedValueSerializer(object.getClass(), true, null).serialize(((JSONWrappedObject)((Object)string))._value, jsonGenerator, serializerProvider);
            }
        }
        String string = ((JSONWrappedObject)((Object)string))._suffix;
        if (string != null) {
            jsonGenerator.writeRaw(string);
        }
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String getSuffix() {
        return this._suffix;
    }

    public Object getValue() {
        return this._value;
    }

    public JavaType getSerializationType() {
        return this._serializationType;
    }
}

