/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.util;

import com.privatefasterxml.jackson.databind.util.LookupCache;
import com.privatefasterxml.jackson.databind.util.internal.PrivateMaxEntriesMap;
import java.io.Serializable;
import java.util.Map;
import java.util.function.BiConsumer;

public class LRUMap<K, V>
implements LookupCache<K, V>,
Serializable {
    private static final long serialVersionUID = 2L;
    protected final int _initialEntries;
    protected final int _maxEntries;
    protected final transient PrivateMaxEntriesMap<K, V> _map;

    public LRUMap(int n2, int n3) {
        LRUMap lRUMap = this;
        this._initialEntries = n2;
        lRUMap._maxEntries = n3;
        lRUMap._map = new PrivateMaxEntriesMap.Builder().initialCapacity(n2).maximumCapacity(n3).concurrencyLevel(4).build();
    }

    @Override
    public V put(K k2, V v2) {
        return this._map.put(k2, v2);
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        return this._map.putIfAbsent(k2, v2);
    }

    @Override
    public V get(Object object) {
        return this._map.get(object);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    @Override
    public int size() {
        return this._map.size();
    }

    public void contents(BiConsumer<K, V> biConsumer) {
        for (Map.Entry entry : ((LRUMap)this)._map.entrySet()) {
            Object k2 = entry.getKey();
            biConsumer.accept(k2, entry.getValue());
        }
    }

    public Object readResolve() {
        LRUMap lRUMap = this;
        int n2 = lRUMap._initialEntries;
        return new LRUMap<K, V>(n2, lRUMap._maxEntries);
    }
}

