/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.util;

import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.type.ClassKey;
import com.privatefasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LRUMap<ClassKey, PropertyName> _rootNames;

    public RootNameLookup() {
        LRUMap lRUMap;
        Serializable serializable = lRUMap;
        lRUMap = new LRUMap(20, 200);
        v1._rootNames = serializable;
    }

    public PropertyName findRootName(JavaType javaType, MapperConfig<?> mapperConfig) {
        return this.findRootName(javaType.getRawClass(), mapperConfig);
    }

    public PropertyName findRootName(Class<?> clazz, MapperConfig<?> object) {
        ClassKey classKey;
        ClassKey classKey2 = classKey;
        classKey = new ClassKey(clazz);
        PropertyName propertyName = this._rootNames.get(classKey2);
        if (propertyName != null) {
            return propertyName;
        }
        MapperConfig<?> mapperConfig = object;
        object = mapperConfig.introspectClassAnnotations(clazz);
        object = mapperConfig.getAnnotationIntrospector().findRootName(((BeanDescription)object).getClassInfo());
        if (object == null || !((PropertyName)object).hasSimpleName()) {
            object = PropertyName.construct(clazz.getSimpleName());
        }
        this._rootNames.put(classKey2, (PropertyName)object);
        return object;
    }

    public Object readResolve() {
        return new RootNameLookup();
    }
}

