/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.util;

import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedField;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.util.Collections;
import java.util.Iterator;

public class SimpleBeanPropertyDefinition
extends BeanPropertyDefinition {
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final AnnotatedMember _member;
    protected final PropertyMetadata _metadata;
    protected final PropertyName _fullName;
    protected final JsonInclude.Value _inclusion;

    public SimpleBeanPropertyDefinition(AnnotationIntrospector annotationIntrospector, AnnotatedMember annotatedMember, PropertyName propertyName, PropertyMetadata propertyMetadata, JsonInclude.Value value) {
        this._annotationIntrospector = annotationIntrospector;
        this._member = annotatedMember;
        this._fullName = propertyName;
        if (propertyMetadata == null) {
            propertyMetadata = PropertyMetadata.STD_OPTIONAL;
        }
        SimpleBeanPropertyDefinition simpleBeanPropertyDefinition = this;
        simpleBeanPropertyDefinition._metadata = propertyMetadata;
        simpleBeanPropertyDefinition._inclusion = value;
    }

    public static SimpleBeanPropertyDefinition construct(MapperConfig<?> serializable, AnnotatedMember serializable2) {
        AnnotationIntrospector annotationIntrospector = serializable.getAnnotationIntrospector();
        AnnotatedMember annotatedMember = serializable2;
        serializable = PropertyName.construct(annotatedMember.getName());
        serializable2 = BeanPropertyDefinition.EMPTY_INCLUDE;
        return new SimpleBeanPropertyDefinition(annotationIntrospector, annotatedMember, (PropertyName)serializable, null, (JsonInclude.Value)serializable2);
    }

    public static SimpleBeanPropertyDefinition construct(MapperConfig<?> serializable, AnnotatedMember annotatedMember, PropertyName propertyName) {
        MapperConfig<?> mapperConfig = serializable;
        serializable = BeanPropertyDefinition.EMPTY_INCLUDE;
        return SimpleBeanPropertyDefinition.construct(mapperConfig, annotatedMember, propertyName, null, serializable);
    }

    public static SimpleBeanPropertyDefinition construct(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, PropertyName propertyName, PropertyMetadata propertyMetadata, JsonInclude.Include object) {
        object = object != null && object != JsonInclude.Include.USE_DEFAULTS ? JsonInclude.Value.construct(object, null) : BeanPropertyDefinition.EMPTY_INCLUDE;
        return new SimpleBeanPropertyDefinition(mapperConfig.getAnnotationIntrospector(), annotatedMember, propertyName, propertyMetadata, (JsonInclude.Value)object);
    }

    public static SimpleBeanPropertyDefinition construct(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, PropertyName propertyName, PropertyMetadata propertyMetadata, JsonInclude.Value value) {
        return new SimpleBeanPropertyDefinition(mapperConfig.getAnnotationIntrospector(), annotatedMember, propertyName, propertyMetadata, value);
    }

    @Override
    public BeanPropertyDefinition withSimpleName(String object) {
        PropertyName propertyName;
        if (((SimpleBeanPropertyDefinition)((Object)annotationIntrospector))._fullName.hasSimpleName((String)object) && !((SimpleBeanPropertyDefinition)((Object)annotationIntrospector))._fullName.hasNamespace()) {
            return annotationIntrospector;
        }
        SimpleBeanPropertyDefinition simpleBeanPropertyDefinition = annotationIntrospector;
        AnnotationIntrospector annotationIntrospector = simpleBeanPropertyDefinition._annotationIntrospector;
        AnnotatedMember annotatedMember = simpleBeanPropertyDefinition._member;
        PropertyName propertyName2 = propertyName;
        propertyName = new PropertyName((String)object);
        object = simpleBeanPropertyDefinition._metadata;
        JsonInclude.Value value = simpleBeanPropertyDefinition._inclusion;
        return new SimpleBeanPropertyDefinition(annotationIntrospector, annotatedMember, propertyName2, (PropertyMetadata)object, value);
    }

    @Override
    public BeanPropertyDefinition withName(PropertyName propertyName) {
        if (((SimpleBeanPropertyDefinition)((Object)annotationIntrospector))._fullName.equals(propertyName)) {
            return annotationIntrospector;
        }
        SimpleBeanPropertyDefinition simpleBeanPropertyDefinition = annotationIntrospector;
        AnnotationIntrospector annotationIntrospector = simpleBeanPropertyDefinition._annotationIntrospector;
        AnnotatedMember annotatedMember = simpleBeanPropertyDefinition._member;
        PropertyMetadata propertyMetadata = simpleBeanPropertyDefinition._metadata;
        JsonInclude.Value value = simpleBeanPropertyDefinition._inclusion;
        return new SimpleBeanPropertyDefinition(annotationIntrospector, annotatedMember, propertyName, propertyMetadata, value);
    }

    public BeanPropertyDefinition withMetadata(PropertyMetadata propertyMetadata) {
        if (propertyMetadata.equals(((SimpleBeanPropertyDefinition)((Object)annotationIntrospector))._metadata)) {
            return annotationIntrospector;
        }
        SimpleBeanPropertyDefinition simpleBeanPropertyDefinition = annotationIntrospector;
        AnnotationIntrospector annotationIntrospector = simpleBeanPropertyDefinition._annotationIntrospector;
        AnnotatedMember annotatedMember = simpleBeanPropertyDefinition._member;
        PropertyName propertyName = simpleBeanPropertyDefinition._fullName;
        JsonInclude.Value value = simpleBeanPropertyDefinition._inclusion;
        return new SimpleBeanPropertyDefinition(annotationIntrospector, annotatedMember, propertyName, propertyMetadata, value);
    }

    public BeanPropertyDefinition withInclusion(JsonInclude.Value value) {
        if (((SimpleBeanPropertyDefinition)((Object)annotationIntrospector))._inclusion == value) {
            return annotationIntrospector;
        }
        SimpleBeanPropertyDefinition simpleBeanPropertyDefinition = annotationIntrospector;
        AnnotationIntrospector annotationIntrospector = simpleBeanPropertyDefinition._annotationIntrospector;
        AnnotatedMember annotatedMember = simpleBeanPropertyDefinition._member;
        PropertyName propertyName = simpleBeanPropertyDefinition._fullName;
        PropertyMetadata propertyMetadata = simpleBeanPropertyDefinition._metadata;
        return new SimpleBeanPropertyDefinition(annotationIntrospector, annotatedMember, propertyName, propertyMetadata, value);
    }

    @Override
    public String getName() {
        return this._fullName.getSimpleName();
    }

    @Override
    public PropertyName getFullName() {
        return this._fullName;
    }

    @Override
    public boolean hasName(PropertyName propertyName) {
        return this._fullName.equals(propertyName);
    }

    @Override
    public String getInternalName() {
        return this.getName();
    }

    @Override
    public PropertyName getWrapperName() {
        AnnotationIntrospector annotationIntrospector = ((SimpleBeanPropertyDefinition)this)._annotationIntrospector;
        if (annotationIntrospector != null && (this = ((SimpleBeanPropertyDefinition)this)._member) != null) {
            return annotationIntrospector.findWrapperName((Annotated)this);
        }
        return null;
    }

    @Override
    public boolean isExplicitlyIncluded() {
        return false;
    }

    @Override
    public boolean isExplicitlyNamed() {
        return false;
    }

    @Override
    public PropertyMetadata getMetadata() {
        return this._metadata;
    }

    @Override
    public JavaType getPrimaryType() {
        AnnotatedMember annotatedMember = ((SimpleBeanPropertyDefinition)((Object)annotatedMember))._member;
        if (annotatedMember == null) {
            return TypeFactory.unknownType();
        }
        return annotatedMember.getType();
    }

    @Override
    public Class<?> getRawPrimaryType() {
        AnnotatedMember annotatedMember = ((SimpleBeanPropertyDefinition)((Object)annotatedMember))._member;
        if (annotatedMember == null) {
            return Object.class;
        }
        return annotatedMember.getRawType();
    }

    @Override
    public JsonInclude.Value findInclusion() {
        return this._inclusion;
    }

    @Override
    public boolean hasGetter() {
        return this.getGetter() != null;
    }

    @Override
    public boolean hasSetter() {
        return this.getSetter() != null;
    }

    @Override
    public boolean hasField() {
        return this._member instanceof AnnotatedField;
    }

    @Override
    public boolean hasConstructorParameter() {
        return this._member instanceof AnnotatedParameter;
    }

    @Override
    public AnnotatedMethod getGetter() {
        AnnotatedMember annotatedMember = this._member;
        if (annotatedMember instanceof AnnotatedMethod && ((AnnotatedMethod)annotatedMember).getParameterCount() == 0) {
            return (AnnotatedMethod)this._member;
        }
        return null;
    }

    @Override
    public AnnotatedMethod getSetter() {
        AnnotatedMember annotatedMember = this._member;
        if (annotatedMember instanceof AnnotatedMethod && ((AnnotatedMethod)annotatedMember).getParameterCount() == 1) {
            return (AnnotatedMethod)this._member;
        }
        return null;
    }

    @Override
    public AnnotatedField getField() {
        AnnotatedMember annotatedMember = ((SimpleBeanPropertyDefinition)((Object)annotatedMember))._member;
        return annotatedMember instanceof AnnotatedField ? (AnnotatedField)annotatedMember : null;
    }

    @Override
    public AnnotatedParameter getConstructorParameter() {
        AnnotatedMember annotatedMember = ((SimpleBeanPropertyDefinition)((Object)annotatedMember))._member;
        return annotatedMember instanceof AnnotatedParameter ? (AnnotatedParameter)annotatedMember : null;
    }

    @Override
    public Iterator<AnnotatedParameter> getConstructorParameters() {
        if ((this = ((SimpleBeanPropertyDefinition)this).getConstructorParameter()) == null) {
            return ClassUtil.emptyIterator();
        }
        return Collections.singleton(this).iterator();
    }

    @Override
    public AnnotatedMember getPrimaryMember() {
        return this._member;
    }
}

