/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.util;

import com.privatefasterxml.jackson.core.io.NumberInput;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StdDateFormat
extends DateFormat {
    protected static final String PATTERN_PLAIN_STR = "\\d\\d\\d\\d[-]\\d\\d[-]\\d\\d";
    protected static final Pattern PATTERN_PLAIN;
    protected static final Pattern PATTERN_ISO8601;
    public static final String DATE_FORMAT_STR_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    protected static final String DATE_FORMAT_STR_PLAIN = "yyyy-MM-dd";
    protected static final String DATE_FORMAT_STR_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    protected static final String[] ALL_FORMATS;
    protected static final TimeZone DEFAULT_TIMEZONE;
    protected static final Locale DEFAULT_LOCALE;
    protected static final DateFormat DATE_FORMAT_RFC1123;
    public static final StdDateFormat instance;
    protected static final Calendar CALENDAR;
    protected transient TimeZone _timezone;
    protected final Locale _locale;
    protected Boolean _lenient;
    private transient Calendar _calendar;
    private transient DateFormat _formatRFC1123;
    private boolean _tzSerializedWithColon;

    public StdDateFormat() {
        this._tzSerializedWithColon = true;
        this._locale = DEFAULT_LOCALE;
    }

    @Deprecated
    public StdDateFormat(TimeZone timeZone, Locale locale) {
        this._tzSerializedWithColon = true;
        this._timezone = timeZone;
        this._locale = locale;
    }

    public StdDateFormat(TimeZone timeZone, Locale locale, Boolean bl) {
        this(timeZone, locale, bl, false);
    }

    public StdDateFormat(TimeZone timeZone, Locale locale, Boolean bl, boolean bl2) {
        this._timezone = timeZone;
        this._locale = locale;
        this._lenient = bl;
        this._tzSerializedWithColon = bl2;
    }

    public static TimeZone getDefaultTimeZone() {
        return DEFAULT_TIMEZONE;
    }

    @Deprecated
    public static DateFormat getISO8601Format(TimeZone timeZone, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_STR_ISO8601, locale);
        simpleDateFormat.setTimeZone(DEFAULT_TIMEZONE);
        return simpleDateFormat;
    }

    @Deprecated
    public static DateFormat getRFC1123Format(TimeZone timeZone, Locale locale) {
        return StdDateFormat._cloneFormat(DATE_FORMAT_RFC1123, DATE_FORMAT_STR_RFC1123, timeZone, locale, null);
    }

    private static void pad2(StringBuffer stringBuffer, int n2) {
        int n3 = n2 / 10;
        if (n3 == 0) {
            stringBuffer.append('0');
        } else {
            stringBuffer.append((char)(n3 + 48));
            n2 -= n3 * 10;
        }
        stringBuffer.append((char)(n2 + 48));
    }

    private static void pad3(StringBuffer stringBuffer, int n2) {
        int n3 = n2 / 100;
        if (n3 == 0) {
            stringBuffer.append('0');
        } else {
            stringBuffer.append((char)(n3 + 48));
            n2 -= n3 * 100;
        }
        StdDateFormat.pad2(stringBuffer, n2);
    }

    private static void pad4(StringBuffer stringBuffer, int n2) {
        int n3 = n2 / 100;
        if (n3 == 0) {
            stringBuffer.append('0').append('0');
        } else {
            if (n3 > 99) {
                stringBuffer.append(n3);
            } else {
                StdDateFormat.pad2(stringBuffer, n3);
            }
            n2 -= n3 * 100;
        }
        StdDateFormat.pad2(stringBuffer, n2);
    }

    private Date _parseDateFromLong(String string, ParsePosition parsePosition) {
        long l2;
        try {
            l2 = NumberInput.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[1];
            Object object = objectArray;
            objectArray[0] = string;
            object = String.format("Timestamp value %s out of 64-bit value range", object);
            throw new ParseException((String)object, parsePosition.getErrorIndex());
        }
        return new Date(l2);
    }

    private static int _parse4D(String string, int n2) {
        int n3 = (string.charAt(n2) - 48) * 1000;
        n3 = (string.charAt(n2 + 1) - 48) * 100 + n3;
        n3 = (string.charAt(n2 + 2) - 48) * 10 + n3;
        return string.charAt(n2 + 3) - 48 + n3;
    }

    private static int _parse2D(String string, int n2) {
        int n3 = (string.charAt(n2) - 48) * 10;
        return string.charAt(n2 + 1) - 48 + n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final DateFormat _cloneFormat(DateFormat dateFormat, String string, TimeZone timeZone, Locale locale, Boolean bl) {
        block8: {
            block7: {
                block6: {
                    SimpleDateFormat simpleDateFormat;
                    if (locale.equals(DEFAULT_LOCALE)) break block6;
                    dateFormat = simpleDateFormat;
                    simpleDateFormat = new SimpleDateFormat(string, locale);
                    if (timeZone == null) {
                        timeZone = DEFAULT_TIMEZONE;
                    }
                    break block7;
                }
                dateFormat = (DateFormat)dateFormat.clone();
                if (timeZone == null) break block8;
            }
            dateFormat.setTimeZone(timeZone);
        }
        if (bl != null) {
            dateFormat.setLenient(bl);
        }
        return dateFormat;
    }

    public static <T> boolean _equals(T t2, T t3) {
        if (t2 == t3) {
            return true;
        }
        return t2 != null && t2.equals(t3);
    }

    static {
        Locale locale;
        TimeZone timeZone;
        PATTERN_PLAIN = Pattern.compile(PATTERN_PLAIN_STR);
        try {
            PATTERN_ISO8601 = Pattern.compile("\\d\\d\\d\\d[-]\\d\\d[-]\\d\\d[T]\\d\\d[:]\\d\\d(?:[:]\\d\\d)?(\\.\\d+)?(Z|[+-]\\d\\d(?:[:]?\\d\\d)?)?");
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        ALL_FORMATS = new String[]{DATE_FORMAT_STR_ISO8601, "yyyy-MM-dd'T'HH:mm:ss.SSS", DATE_FORMAT_STR_RFC1123, DATE_FORMAT_STR_PLAIN};
        DEFAULT_TIMEZONE = timeZone = TimeZone.getTimeZone("UTC");
        DEFAULT_LOCALE = locale = Locale.US;
        DATE_FORMAT_RFC1123 = new SimpleDateFormat(DATE_FORMAT_STR_RFC1123, locale);
        DATE_FORMAT_RFC1123.setTimeZone(timeZone);
        instance = new StdDateFormat();
        CALENDAR = new GregorianCalendar(timeZone, locale);
    }

    public StdDateFormat withTimeZone(TimeZone timeZone) {
        Serializable serializable;
        if (timeZone == null) {
            timeZone = DEFAULT_TIMEZONE;
        }
        if (timeZone != (serializable = cloneable._timezone) && !timeZone.equals(serializable)) {
            StdDateFormat stdDateFormat = cloneable;
            Cloneable cloneable = stdDateFormat._locale;
            serializable = stdDateFormat._lenient;
            boolean bl = stdDateFormat._tzSerializedWithColon;
            return new StdDateFormat(timeZone, (Locale)cloneable, (Boolean)serializable, bl);
        }
        return cloneable;
    }

    public StdDateFormat withLocale(Locale locale) {
        if (locale.equals(cloneable._locale)) {
            return cloneable;
        }
        StdDateFormat stdDateFormat = cloneable;
        Cloneable cloneable = stdDateFormat._timezone;
        Boolean bl = stdDateFormat._lenient;
        boolean bl2 = stdDateFormat._tzSerializedWithColon;
        return new StdDateFormat((TimeZone)cloneable, locale, bl, bl2);
    }

    public StdDateFormat withLenient(Boolean bl) {
        if (StdDateFormat._equals(bl, cloneable._lenient)) {
            return cloneable;
        }
        StdDateFormat stdDateFormat = cloneable;
        Cloneable cloneable = stdDateFormat._timezone;
        Locale locale = stdDateFormat._locale;
        boolean bl2 = stdDateFormat._tzSerializedWithColon;
        return new StdDateFormat((TimeZone)cloneable, locale, bl, bl2);
    }

    public StdDateFormat withColonInTimeZone(boolean bl) {
        if (cloneable._tzSerializedWithColon == bl) {
            return cloneable;
        }
        StdDateFormat stdDateFormat = cloneable;
        Cloneable cloneable = stdDateFormat._timezone;
        Locale locale = stdDateFormat._locale;
        Boolean bl2 = stdDateFormat._lenient;
        return new StdDateFormat((TimeZone)cloneable, locale, bl2, bl);
    }

    @Override
    public StdDateFormat clone() {
        StdDateFormat stdDateFormat = cloneable;
        Cloneable cloneable = stdDateFormat._timezone;
        Locale locale = stdDateFormat._locale;
        Boolean bl = stdDateFormat._lenient;
        boolean bl2 = stdDateFormat._tzSerializedWithColon;
        return new StdDateFormat((TimeZone)cloneable, locale, bl, bl2);
    }

    @Override
    public TimeZone getTimeZone() {
        return this._timezone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        if (!timeZone.equals(this._timezone)) {
            this._clearFormats();
            this._timezone = timeZone;
        }
    }

    @Override
    public void setLenient(boolean bl) {
        Boolean bl2 = bl;
        if (!StdDateFormat._equals(bl2, this._lenient)) {
            this._lenient = bl2;
            this._clearFormats();
        }
    }

    @Override
    public boolean isLenient() {
        Serializable serializable = ((StdDateFormat)serializable)._lenient;
        return serializable == null || ((Boolean)serializable).booleanValue();
    }

    public boolean isColonIncludedInTimeZone() {
        return this._tzSerializedWithColon;
    }

    @Override
    public Date parse(String objectArray) {
        StringBuilder stringBuilder;
        ParsePosition parsePosition;
        StdDateFormat stdDateFormat = object;
        Object object = objectArray.trim();
        objectArray = parsePosition;
        parsePosition = new ParsePosition(0);
        Comparable<Date> comparable = stdDateFormat._parseDate((String)object, (ParsePosition)objectArray);
        if (comparable != null) {
            return comparable;
        }
        comparable = stringBuilder;
        stringBuilder = new StringBuilder();
        String[] stringArray = ALL_FORMATS;
        int n2 = ALL_FORMATS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (((StringBuilder)comparable).length() > 0) {
                ((StringBuilder)comparable).append("\", \"");
            } else {
                ((StringBuilder)comparable).append('\"');
            }
            ((StringBuilder)comparable).append(string);
        }
        ((StringBuilder)comparable).append('\"');
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[2];
        objectArray = objectArray3;
        objectArray[0] = object;
        objectArray3[1] = ((StringBuilder)comparable).toString();
        object = String.format("Cannot parse date \"%s\": not compatible with any of standard forms (%s)", objectArray);
        throw new ParseException((String)object, objectArray2.getErrorIndex());
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        try {
            return this._parseDate(string, parsePosition);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Date _parseDate(String string, ParsePosition parsePosition) {
        char c2;
        if (this.looksLikeISO8601(string)) {
            return this.parseAsISO8601(string, parsePosition);
        }
        int n2 = string.length();
        while ((n2 += -1) >= 0 && ((c2 = string.charAt(n2)) >= '0' && c2 <= '9' || n2 <= 0 && c2 == '-')) {
        }
        if (n2 < 0 && (string.charAt(0) == '-' || NumberInput.inLongRange(string, false))) {
            return this._parseDateFromLong(string, parsePosition);
        }
        return this.parseAsRFC1123(string, parsePosition);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition object) {
        object = this._timezone;
        if (object == null) {
            object = DEFAULT_TIMEZONE;
        }
        StdDateFormat stdDateFormat = this;
        stdDateFormat._format((TimeZone)object, stdDateFormat._locale, date, stringBuffer);
        return stringBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public void _format(TimeZone timeZone, Locale cloneable, Date date, StringBuffer stringBuffer) {
        void var4_10;
        cloneable = this._getCalendar(timeZone);
        ((Calendar)cloneable).setTime(date);
        int c2 = ((Calendar)cloneable).get(1);
        if (((Calendar)cloneable).get(0) == 0) {
            this._formatBCEYear((StringBuffer)var4_10, c2);
        } else {
            if (c2 > 9999) {
                var4_10.append('+');
            }
            StdDateFormat.pad4((StringBuffer)var4_10, c2);
        }
        Cloneable cloneable2 = cloneable;
        var4_10.append('-');
        StdDateFormat.pad2((StringBuffer)var4_10, ((Calendar)cloneable2).get(2) + 1);
        var4_10.append('-');
        StdDateFormat.pad2((StringBuffer)var4_10, ((Calendar)cloneable2).get(5));
        var4_10.append('T');
        StdDateFormat.pad2((StringBuffer)var4_10, ((Calendar)cloneable2).get(11));
        var4_10.append(':');
        StdDateFormat.pad2((StringBuffer)var4_10, ((Calendar)cloneable2).get(12));
        var4_10.append(':');
        StdDateFormat.pad2((StringBuffer)var4_10, ((Calendar)cloneable2).get(13));
        var4_10.append('.');
        StdDateFormat.pad3((StringBuffer)var4_10, ((Calendar)cloneable2).get(14));
        int n2 = timeZone.getOffset(((Calendar)cloneable2).getTimeInMillis());
        if (n2 != 0) {
            void var3_9;
            int n3 = n2;
            int n4 = n3 / 60000;
            n2 = Math.abs(n4 / 60);
            int n5 = Math.abs(n4 % 60);
            if (n3 < 0) {
                int n6 = 45;
            } else {
                int n7 = 43;
            }
            var4_10.append((char)var3_9);
            StdDateFormat.pad2((StringBuffer)var4_10, n2);
            if (this._tzSerializedWithColon) {
                var4_10.append(':');
            }
            StdDateFormat.pad2((StringBuffer)var4_10, n5);
        } else if (this._tzSerializedWithColon) {
            var4_10.append("+00:00");
        } else {
            var4_10.append("+0000");
        }
    }

    public void _formatBCEYear(StringBuffer stringBuffer, int n2) {
        if (n2 == 1) {
            stringBuffer.append("+0000");
            return;
        }
        StringBuffer stringBuffer2 = stringBuffer;
        int n3 = n2 - 1;
        stringBuffer2.append('-');
        StdDateFormat.pad4(stringBuffer2, n3);
    }

    public String toString() {
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.getClass().getName();
        objectArray2[1] = this._timezone;
        objectArray2[2] = this._locale;
        objectArray[3] = this._lenient;
        return String.format("DateFormat %s: (timezone: %s, locale: %s, lenient: %s)", objectArray2);
    }

    public String toPattern() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder(100).append("[one of: 'yyyy-MM-dd'T'HH:mm:ss.SSSX', 'EEE, dd MMM yyyy HH:mm:ss zzz' (");
        String string = Boolean.FALSE.equals(((StdDateFormat)((Object)string))._lenient) ? "strict" : "lenient";
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(string).append(")]");
        return stringBuilder3.toString();
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean looksLikeISO8601(String string) {
        return string.length() >= 7 && Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(3)) && string.charAt(4) == '-' && Character.isDigit(string.charAt(5));
    }

    public Date parseAsISO8601(String string, ParsePosition objectArray) {
        try {
            return this._parseAsISO8601(string, (ParsePosition)objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray[0] = string;
            objectArray3[1] = illegalArgumentException.getMessage();
            String string2 = String.format("Cannot parse date \"%s\", problem: %s", objectArray);
            throw new ParseException(string2, objectArray2.getErrorIndex());
        }
    }

    public Date _parseAsISO8601(String string, ParsePosition parsePosition) {
        String string2;
        int n2 = string.length();
        Object[] objectArray = DEFAULT_TIMEZONE;
        if (this._timezone != null && 'Z' != string.charAt(n2 - 1)) {
            objectArray = this._timezone;
        }
        objectArray = this._getCalendar((TimeZone)objectArray);
        objectArray.clear();
        if (n2 <= 10) {
            if (PATTERN_PLAIN.matcher(string).matches()) {
                Cloneable cloneable = objectArray;
                ((Calendar)cloneable).set(StdDateFormat._parse4D(string, 0), StdDateFormat._parse2D(string, 5) - 1, StdDateFormat._parse2D(string, 8), 0, 0, 0);
                ((Calendar)cloneable).set(14, 0);
                return ((Calendar)cloneable).getTime();
            }
            string2 = DATE_FORMAT_STR_PLAIN;
        } else {
            Matcher matcher = PATTERN_ISO8601.matcher(string);
            if (matcher.matches()) {
                Matcher matcher2 = matcher;
                int n3 = matcher2.start(2);
                int n4 = matcher2.end(2);
                int n5 = n4 - n3;
                if (n5 > 1) {
                    int n6 = n5;
                    n5 = StdDateFormat._parse2D(string, n3 + 1) * 3600;
                    if (n6 >= 5) {
                        n5 = StdDateFormat._parse2D(string, n4 - 2) * 60 + n5;
                    }
                    n3 = string.charAt(n3) == '-' ? n5 * -1000 : n5 * 1000;
                    objectArray.set(15, n3);
                    objectArray.set(16, 0);
                }
                int n7 = n2;
                n3 = StdDateFormat._parse4D(string, 0);
                n2 = StdDateFormat._parse2D(string, 5) - 1;
                n4 = StdDateFormat._parse2D(string, 8);
                n5 = StdDateFormat._parse2D(string, 11);
                int n8 = StdDateFormat._parse2D(string, 14);
                int n9 = n7 > 16 && string.charAt(16) == ':' ? StdDateFormat._parse2D(string, 17) : 0;
                objectArray.set(n3, n2, n4, n5, n8, n9);
                n3 = matcher.start(1);
                n2 = n3 + 1;
                n4 = matcher.end(1);
                if (n2 >= n4) {
                    objectArray.set(14, 0);
                } else {
                    int n10 = n4;
                    n4 = 0;
                    n5 = n10 - n2;
                    switch (n5) {
                        default: {
                            if (n5 > 9) {
                                Object[] objectArray2 = new Object[2];
                                Object[] objectArray3 = objectArray2;
                                objectArray3[0] = string;
                                objectArray2[1] = matcher.group(1).substring(1);
                                throw new ParseException(String.format("Cannot parse date \"%s\": invalid fractional seconds '%s'; can use at most 9 digits", objectArray3), n2);
                            }
                        }
                        case 3: {
                            n4 = string.charAt(n3 + 3) - 48;
                        }
                        case 2: {
                            n4 = (string.charAt(n3 + 2) - 48) * 10 + n4;
                        }
                        case 1: {
                            n4 = (string.charAt(n2) - 48) * 100 + n4;
                        }
                        case 0: 
                    }
                    objectArray.set(14, n4);
                }
                return objectArray.getTime();
            }
            string2 = DATE_FORMAT_STR_ISO8601;
        }
        Object[] objectArray4 = new Object[3];
        objectArray = objectArray4;
        objectArray[0] = string;
        objectArray[1] = string2;
        objectArray4[2] = this._lenient;
        throw new ParseException(String.format("Cannot parse date \"%s\": while it seems to fit format '%s', parsing fails (leniency? %s)", objectArray), 0);
    }

    public Date parseAsRFC1123(String string, ParsePosition parsePosition) {
        if (this._formatRFC1123 == null) {
            StdDateFormat stdDateFormat = this;
            TimeZone timeZone = stdDateFormat._timezone;
            Locale locale = stdDateFormat._locale;
            Boolean bl = stdDateFormat._lenient;
            this._formatRFC1123 = StdDateFormat._cloneFormat(DATE_FORMAT_RFC1123, DATE_FORMAT_STR_RFC1123, timeZone, locale, bl);
        }
        return this._formatRFC1123.parse(string, parsePosition);
    }

    public void _clearFormats() {
        this._formatRFC1123 = null;
    }

    public Calendar _getCalendar(TimeZone timeZone) {
        Calendar calendar = this._calendar;
        if (calendar == null) {
            this._calendar = calendar = (Calendar)CALENDAR.clone();
        }
        if (!calendar.getTimeZone().equals(timeZone)) {
            calendar.setTimeZone(timeZone);
        }
        Calendar calendar2 = calendar;
        calendar2.setLenient(this.isLenient());
        return calendar2;
    }
}

