/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.util;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonStreamContext;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.StreamReadCapability;
import com.privatefasterxml.jackson.core.StreamReadFeature;
import com.privatefasterxml.jackson.core.StreamWriteCapability;
import com.privatefasterxml.jackson.core.TreeNode;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.core.base.ParserMinimalBase;
import com.privatefasterxml.jackson.core.io.NumberInput;
import com.privatefasterxml.jackson.core.json.JsonWriteContext;
import com.privatefasterxml.jackson.core.util.ByteArrayBuilder;
import com.privatefasterxml.jackson.core.util.JacksonFeatureSet;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JsonSerializable;
import com.privatefasterxml.jackson.databind.cfg.PackageVersion;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.RawValue;
import com.privatefasterxml.jackson.databind.util.TokenBufferReadContext;
import com.privatefasterxml.jackson.databind.util.g;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.TreeMap;

public class TokenBuffer
extends JsonGenerator {
    protected static final int DEFAULT_GENERATOR_FEATURES = JsonGenerator.Feature.collectDefaults();
    protected ObjectCodec _objectCodec;
    protected JsonStreamContext _parentContext;
    protected int _generatorFeatures;
    protected boolean _closed;
    protected boolean _hasNativeTypeIds;
    protected boolean _hasNativeObjectIds;
    protected boolean _mayHaveNativeIds;
    protected boolean _forceBigDecimal;
    protected Segment _first;
    protected Segment _last;
    protected int _appendAt;
    protected Object _typeId;
    protected Object _objectId;
    protected boolean _hasNativeId;
    protected JsonWriteContext _writeContext;

    public TokenBuffer(ObjectCodec object, boolean bl) {
        Segment segment;
        TokenBuffer tokenBuffer = this;
        this._hasNativeId = false;
        tokenBuffer._objectCodec = object;
        tokenBuffer._generatorFeatures = DEFAULT_GENERATOR_FEATURES;
        tokenBuffer._writeContext = JsonWriteContext.createRootContext(null);
        object = segment;
        tokenBuffer._last = new Segment();
        tokenBuffer._first = object;
        tokenBuffer._appendAt = 0;
        this._hasNativeTypeIds = bl;
        this._hasNativeObjectIds = bl;
        boolean bl2 = bl || bl;
        this._mayHaveNativeIds = bl2;
    }

    public TokenBuffer(JsonParser jsonParser) {
        this(jsonParser, null);
    }

    public TokenBuffer(JsonParser object, DeserializationContext deserializationContext) {
        boolean bl;
        Segment segment;
        JsonParser jsonParser = object;
        JsonParser jsonParser2 = object;
        TokenBuffer tokenBuffer = this;
        this._hasNativeId = false;
        this._objectCodec = ((JsonParser)object).getCodec();
        tokenBuffer._parentContext = ((JsonParser)object).getParsingContext();
        tokenBuffer._generatorFeatures = DEFAULT_GENERATOR_FEATURES;
        tokenBuffer._writeContext = JsonWriteContext.createRootContext(null);
        object = segment;
        tokenBuffer._last = new Segment();
        tokenBuffer._first = object;
        tokenBuffer._appendAt = 0;
        this._hasNativeTypeIds = jsonParser2.canReadTypeId();
        this._hasNativeObjectIds = bl = jsonParser.canReadObjectId();
        bl = this._hasNativeTypeIds || bl;
        this._mayHaveNativeIds = bl;
        bl = deserializationContext == null ? false : deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        this._forceBigDecimal = bl;
    }

    @Deprecated
    public static TokenBuffer asCopyOfValue(JsonParser jsonParser) {
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser);
        tokenBuffer.copyCurrentStructure(jsonParser);
        return tokenBuffer;
    }

    private final void _appendNativeIds(StringBuilder stringBuilder) {
        Object object = ((TokenBuffer)this)._last.findObjectId(((TokenBuffer)this)._appendAt - 1);
        if (object != null) {
            stringBuilder.append("[objectId=").append(String.valueOf(object)).append(']');
        }
        if ((this = ((TokenBuffer)this)._last.findTypeId(((TokenBuffer)this)._appendAt - 1)) != null) {
            stringBuilder.append("[typeId=").append(String.valueOf(this)).append(']');
        }
    }

    private void _copyBufferValue(JsonParser jsonParser, JsonToken jsonToken) {
        if (((TokenBuffer)object)._mayHaveNativeIds) {
            ((TokenBuffer)object)._checkNativeIds(jsonParser);
        }
        switch (g.a[jsonToken.ordinal()]) {
            default: {
                throw new RuntimeException("Internal error: unexpected token: " + (Object)((Object)jsonToken));
            }
            case 12: {
                ((TokenBuffer)object).writeObject(jsonParser.getEmbeddedObject());
                break;
            }
            case 11: {
                ((TokenBuffer)object).writeNull();
                break;
            }
            case 10: {
                ((TokenBuffer)object).writeBoolean(false);
                break;
            }
            case 9: {
                ((TokenBuffer)object).writeBoolean(true);
                break;
            }
            case 8: {
                if (((TokenBuffer)object)._forceBigDecimal) {
                    ((TokenBuffer)object).writeNumber(jsonParser.getDecimalValue());
                    break;
                }
                ((TokenBuffer)object)._appendValue(JsonToken.VALUE_NUMBER_FLOAT, jsonParser.getNumberValueExact());
                break;
            }
            case 7: {
                int n2 = g.b[jsonParser.getNumberType().ordinal()];
                if (n2 != 1) {
                    if (n2 != 2) {
                        ((TokenBuffer)object).writeNumber(jsonParser.getLongValue());
                        break;
                    }
                    ((TokenBuffer)object).writeNumber(jsonParser.getBigIntegerValue());
                    break;
                }
                ((TokenBuffer)object).writeNumber(jsonParser.getIntValue());
                break;
            }
            case 6: {
                if (jsonParser.hasTextCharacters()) {
                    TokenBuffer tokenBuffer = object;
                    JsonParser jsonParser2 = jsonParser;
                    Object object = jsonParser2.getTextCharacters();
                    int n3 = jsonParser2.getTextOffset();
                    int n4 = jsonParser2.getTextLength();
                    tokenBuffer.writeString((char[])object, n3, n4);
                    break;
                }
                ((TokenBuffer)object).writeString(jsonParser.getText());
            }
        }
    }

    private final void _checkNativeIds(JsonParser jsonParser) {
        this._typeId = jsonParser.getTypeId();
        if (this._typeId != null) {
            this._hasNativeId = true;
        }
        if ((this._objectId = jsonParser.getObjectId()) != null) {
            this._hasNativeId = true;
        }
    }

    public TokenBuffer overrideParentContext(JsonStreamContext jsonStreamContext) {
        this._parentContext = jsonStreamContext;
        return this;
    }

    public TokenBuffer forceUseOfBigDecimal(boolean bl) {
        this._forceBigDecimal = bl;
        return this;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public JsonParser asParser() {
        TokenBuffer tokenBuffer = this;
        return tokenBuffer.asParser(tokenBuffer._objectCodec);
    }

    public JsonParser asParserOnFirstToken() {
        TokenBuffer tokenBuffer = this;
        JsonParser jsonParser = tokenBuffer.asParser(tokenBuffer._objectCodec);
        jsonParser.nextToken();
        return jsonParser;
    }

    public JsonParser asParser(ObjectCodec objectCodec) {
        TokenBuffer tokenBuffer = segment;
        Segment segment = tokenBuffer._first;
        boolean bl = tokenBuffer._hasNativeTypeIds;
        boolean bl2 = tokenBuffer._hasNativeObjectIds;
        JsonStreamContext jsonStreamContext = tokenBuffer._parentContext;
        return new Parser(segment, objectCodec, bl, bl2, jsonStreamContext);
    }

    public JsonParser asParser(JsonParser versioned) {
        TokenBuffer tokenBuffer = segment;
        Segment segment = ((TokenBuffer)((Object)segment))._first;
        versioned = versioned.getCodec();
        boolean bl = tokenBuffer._hasNativeTypeIds;
        boolean bl2 = tokenBuffer._hasNativeObjectIds;
        JsonStreamContext jsonStreamContext = tokenBuffer._parentContext;
        Parser parser = new Parser(segment, (ObjectCodec)versioned, bl, bl2, jsonStreamContext);
        parser.setLocation(versioned.getTokenLocation());
        return parser;
    }

    public JsonToken firstToken() {
        return this._first.type(0);
    }

    public boolean isEmpty() {
        return this._appendAt == 0 && this._first == this._last;
    }

    public TokenBuffer append(TokenBuffer closeable) {
        if (!this._hasNativeTypeIds) {
            this._hasNativeTypeIds = ((TokenBuffer)closeable).canWriteTypeId();
        }
        if (!this._hasNativeObjectIds) {
            this._hasNativeObjectIds = ((TokenBuffer)closeable).canWriteObjectId();
        }
        boolean bl = this._hasNativeTypeIds || this._hasNativeObjectIds;
        this._mayHaveNativeIds = bl;
        closeable = ((TokenBuffer)closeable).asParser();
        while (((JsonParser)closeable).nextToken() != null) {
            this.copyCurrentStructure((JsonParser)closeable);
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public void serialize(JsonGenerator var1_1) {
        v0 = this;
        var2_2 = v0._first;
        var3_4 = -1;
        var4_6 = v0._mayHaveNativeIds;
        var5_7 = var4_6 != false && var2_2.hasIds() != false;
        block14: while (true) {
            block35: {
                block34: {
                    block33: {
                        if (++var3_4 < 16) break block33;
                        var2_3 = 0;
                        var3_5 = var2_2.next();
                        if (var3_5 == null) break block34;
                        var5_7 = var4_6 != false && var3_5.hasIds() != false;
                        var3_4 = var2_3;
                        var2_2 = var3_5;
                    }
                    if ((var6_8 = var2_2.type(var3_4)) != null) break block35;
                }
                return;
            }
            if (var5_7) {
                var7_11 = var2_2.findObjectId(var3_4);
                if (var7_11 != null) {
                    var1_1.writeObjectId(var7_11);
                }
                if ((var7_11 = var2_2.findTypeId(var3_4)) != null) {
                    var1_1.writeTypeId(var7_11);
                }
            }
            switch (g.a[var6_8.ordinal()]) {
                default: {
                    throw new RuntimeException("Internal error: should never end up through this code path");
                }
                case 12: {
                    var6_8 = var2_2.get(var3_4);
                    if (var6_8 instanceof RawValue) {
                        ((RawValue)var6_8).serialize(var1_1);
                        continue block14;
                    }
                    if (var6_8 instanceof JsonSerializable) {
                        var1_1.writeObject(var6_8);
                        continue block14;
                    }
                    var1_1.writeEmbeddedObject(var6_8);
                    continue block14;
                }
                case 10: {
                    var1_1.writeBoolean(false);
                    continue block14;
                }
                case 9: {
                    var1_1.writeBoolean(true);
                    continue block14;
                }
                case 8: {
                    var6_8 = var2_2.get(var3_4);
                    if (var6_8 instanceof Double) {
                        var6_9 = (Double)var6_8;
                        var1_1.writeNumber(var6_9);
                        continue block14;
                    }
                    if (var6_8 instanceof BigDecimal) {
                        var1_1.writeNumber((BigDecimal)var6_8);
                        continue block14;
                    }
                    if (var6_8 instanceof Float) {
                        var1_1.writeNumber(((Float)var6_8).floatValue());
                        continue block14;
                    }
                    if (var6_8 != null) break;
                }
                case 11: {
                    var1_1.writeNull();
                    continue block14;
                }
            }
            if (var6_8 instanceof String) {
                var1_1.writeNumber((String)var6_8);
                continue;
            }
            v1 = new Object[1];
            var7_11 = v1;
            v1[0] = var6_8.getClass().getName();
            this._reportError(String.format("Unrecognized value type for VALUE_NUMBER_FLOAT: %s, cannot serialize", var7_11));
            continue;
            {
                case 7: {
                    var6_8 = var2_2.get(var3_4);
                    if (var6_8 instanceof Integer) {
                        var1_1.writeNumber((Integer)var6_8);
                        continue block14;
                    }
                    if (var6_8 instanceof BigInteger) {
                        var1_1.writeNumber((BigInteger)var6_8);
                        continue block14;
                    }
                    if (var6_8 instanceof Long) {
                        var6_10 = (Long)var6_8;
                        var1_1.writeNumber(var6_10);
                        continue block14;
                    }
                    if (var6_8 instanceof Short) {
                        var1_1.writeNumber((Short)var6_8);
                        continue block14;
                    }
                    var1_1.writeNumber(((Number)var6_8).intValue());
                    continue block14;
                }
                case 6: {
                    var6_8 = var2_2.get(var3_4);
                    if (var6_8 instanceof SerializableString) {
                        var1_1.writeString((SerializableString)var6_8);
                        continue block14;
                    }
                    var1_1.writeString((String)var6_8);
                    continue block14;
                }
                case 5: {
                    var6_8 = var2_2.get(var3_4);
                    if (var6_8 instanceof SerializableString) {
                        var1_1.writeFieldName((SerializableString)var6_8);
                        continue block14;
                    }
                    var1_1.writeFieldName((String)var6_8);
                    continue block14;
                }
                case 4: {
                    var1_1.writeEndArray();
                    continue block14;
                }
                case 3: {
                    var1_1.writeStartArray();
                    continue block14;
                }
                case 2: {
                    var1_1.writeEndObject();
                    continue block14;
                }
                ** case 1:
            }
lbl109:
            // 1 sources

            var1_1.writeStartObject();
        }
    }

    public TokenBuffer deserialize(JsonParser object, DeserializationContext object2) {
        Object[] objectArray;
        if (!object.hasToken(JsonToken.FIELD_NAME)) {
            TokenBuffer tokenBuffer = this;
            tokenBuffer.copyCurrentStructure((JsonParser)object);
            return tokenBuffer;
        }
        this.writeStartObject();
        do {
            this.copyCurrentStructure((JsonParser)object);
        } while ((objectArray = object.nextToken()) == JsonToken.FIELD_NAME);
        object = JsonToken.END_OBJECT;
        if (objectArray != object) {
            DeserializationContext deserializationContext = object2;
            object2 = "Expected END_OBJECT after copying contents of a JsonParser into TokenBuffer, got " + objectArray;
            objectArray = new Object[]{};
            deserializationContext.reportWrongTokenException(TokenBuffer.class, (JsonToken)((Object)object), (String)object2, objectArray);
        }
        TokenBuffer tokenBuffer = this;
        tokenBuffer.writeEndObject();
        return tokenBuffer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        v0 = this;
        var1_2 = v1;
        new StringBuilder().append("[TokenBuffer: ");
        var2_3 = v0.asParser();
        var3_4 = 0;
        var4_5 = v0._hasNativeTypeIds || this._hasNativeObjectIds;
        while (true) {
            block12: {
                block11: {
                    try {
                        var5_6 = var2_3.nextToken();
                        if (var5_6 != null) break block11;
                        if (var3_4 >= 100) {
                            var1_2.append(" ... (truncated ").append(var3_4 - 100).append(" entries)");
                        }
                    }
                    catch (IOException var0_1) {
                        throw new IllegalStateException(var0_1);
                    }
                    v2 = var1_2;
                    v2.append(']');
                    return v2.toString();
                }
                if (var4_5) {
                    this._appendNativeIds(var1_2);
                }
                if (var3_4 >= 100) break block12;
                if (var3_4 <= 0) ** GOTO lbl-1000
                var1_2.append(", ");
lbl-1000:
                // 2 sources

                {
                    v3 = var5_6;
                    var1_2.append(var5_6.toString());
                }
                {
                    if (v3 != JsonToken.FIELD_NAME) break block12;
                }
                {
                    v4 = var1_2;
                    v5 = v4;
                    v6 = v4;
                    v7 = var2_3;
                    var1_2.append('(');
                }
                {
                    v5.append(v7.currentName());
                }
                {
                    v6.append(')');
                }
            }
            ++var3_4;
        }
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._generatorFeatures |= feature.getMask();
        return tokenBuffer;
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._generatorFeatures &= ~feature.getMask();
        return tokenBuffer;
    }

    @Override
    public boolean isEnabled(JsonGenerator.Feature feature) {
        return (this._generatorFeatures & feature.getMask()) != 0;
    }

    @Override
    public int getFeatureMask() {
        return this._generatorFeatures;
    }

    @Override
    @Deprecated
    public JsonGenerator setFeatureMask(int n2) {
        this._generatorFeatures = n2;
        return this;
    }

    @Override
    public JsonGenerator overrideStdFeatures(int n2, int n3) {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._generatorFeatures = tokenBuffer.getFeatureMask() & ~n3 | n2 & n3;
        return tokenBuffer;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public final JsonWriteContext getOutputContext() {
        return this._writeContext;
    }

    @Override
    public boolean canWriteBinaryNatively() {
        return true;
    }

    @Override
    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return JsonGenerator.DEFAULT_WRITE_CAPABILITIES;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this._closed = true;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public final void writeStartArray() {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._writeContext.writeValue();
        tokenBuffer._appendStartMarker(JsonToken.START_ARRAY);
        tokenBuffer._writeContext = tokenBuffer._writeContext.createChildArrayContext();
    }

    @Override
    public void writeStartArray(Object object) {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._writeContext.writeValue();
        tokenBuffer._appendStartMarker(JsonToken.START_ARRAY);
        tokenBuffer._writeContext = tokenBuffer._writeContext.createChildArrayContext(object);
    }

    @Override
    public void writeStartArray(Object object, int n2) {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._writeContext.writeValue();
        tokenBuffer._appendStartMarker(JsonToken.START_ARRAY);
        tokenBuffer._writeContext = tokenBuffer._writeContext.createChildArrayContext(object);
    }

    @Override
    public final void writeEndArray() {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._appendEndMarker(JsonToken.END_ARRAY);
        JsonWriteContext jsonWriteContext = tokenBuffer._writeContext.getParent();
        if (jsonWriteContext != null) {
            this._writeContext = jsonWriteContext;
        }
    }

    @Override
    public final void writeStartObject() {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._writeContext.writeValue();
        tokenBuffer._appendStartMarker(JsonToken.START_OBJECT);
        tokenBuffer._writeContext = tokenBuffer._writeContext.createChildObjectContext();
    }

    @Override
    public void writeStartObject(Object object) {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._writeContext.writeValue();
        tokenBuffer._appendStartMarker(JsonToken.START_OBJECT);
        tokenBuffer._writeContext = tokenBuffer._writeContext.createChildObjectContext(object);
    }

    @Override
    public void writeStartObject(Object object, int n2) {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._writeContext.writeValue();
        tokenBuffer._appendStartMarker(JsonToken.START_OBJECT);
        tokenBuffer._writeContext = tokenBuffer._writeContext.createChildObjectContext(object);
    }

    @Override
    public final void writeEndObject() {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._appendEndMarker(JsonToken.END_OBJECT);
        JsonWriteContext jsonWriteContext = tokenBuffer._writeContext.getParent();
        if (jsonWriteContext != null) {
            this._writeContext = jsonWriteContext;
        }
    }

    @Override
    public final void writeFieldName(String string) {
        this._writeContext.writeFieldName(string);
        this._appendFieldName(string);
    }

    @Override
    public void writeFieldName(SerializableString serializableString) {
        this._writeContext.writeFieldName(serializableString.getValue());
        this._appendFieldName(serializableString);
    }

    @Override
    public void writeString(String string) {
        if (string == null) {
            this.writeNull();
        } else {
            this._appendValue(JsonToken.VALUE_STRING, string);
        }
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) {
        String string;
        TokenBuffer tokenBuffer = string2;
        String string2 = string;
        string = new String(cArray, n2, n3);
        tokenBuffer.writeString(string2);
    }

    @Override
    public void writeString(SerializableString serializableString) {
        if (serializableString == null) {
            this.writeNull();
        } else {
            this._appendValue(JsonToken.VALUE_STRING, serializableString);
        }
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(SerializableString serializableString) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char c2) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String string) {
        RawValue rawValue;
        TokenBuffer tokenBuffer = object;
        Object object = JsonToken.VALUE_EMBEDDED_OBJECT;
        RawValue rawValue2 = rawValue;
        rawValue = new RawValue(string);
        tokenBuffer._appendValue((JsonToken)((Object)object), rawValue2);
    }

    @Override
    public void writeRawValue(String string, int n2, int n3) {
        RawValue rawValue;
        if (n2 > 0 || n3 != string.length()) {
            string = string.substring(n2, n2 + n3);
        }
        TokenBuffer tokenBuffer = object;
        Object object = JsonToken.VALUE_EMBEDDED_OBJECT;
        RawValue rawValue2 = rawValue;
        rawValue = new RawValue(string);
        tokenBuffer._appendValue((JsonToken)((Object)object), rawValue2);
    }

    @Override
    public void writeRawValue(char[] cArray, int n2, int n3) {
        String string;
        TokenBuffer tokenBuffer = object;
        Object object = JsonToken.VALUE_EMBEDDED_OBJECT;
        String string2 = string;
        string = new String(cArray, n2, n3);
        tokenBuffer._appendValue((JsonToken)((Object)object), string2);
    }

    @Override
    public void writeNumber(short s2) {
        TokenBuffer tokenBuffer = object;
        Object object = JsonToken.VALUE_NUMBER_INT;
        tokenBuffer._appendValue((JsonToken)((Object)object), s2);
    }

    @Override
    public void writeNumber(int n2) {
        TokenBuffer tokenBuffer = object;
        Object object = JsonToken.VALUE_NUMBER_INT;
        tokenBuffer._appendValue((JsonToken)((Object)object), n2);
    }

    @Override
    public void writeNumber(long l2) {
        TokenBuffer tokenBuffer = object;
        Object object = JsonToken.VALUE_NUMBER_INT;
        tokenBuffer._appendValue((JsonToken)((Object)object), l2);
    }

    @Override
    public void writeNumber(double d2) {
        TokenBuffer tokenBuffer = object;
        Object object = JsonToken.VALUE_NUMBER_FLOAT;
        tokenBuffer._appendValue((JsonToken)((Object)object), d2);
    }

    @Override
    public void writeNumber(float f2) {
        TokenBuffer tokenBuffer = object;
        Object object = JsonToken.VALUE_NUMBER_FLOAT;
        tokenBuffer._appendValue((JsonToken)((Object)object), Float.valueOf(f2));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.writeNull();
        } else {
            this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, bigDecimal);
        }
    }

    @Override
    public void writeNumber(BigInteger bigInteger) {
        if (bigInteger == null) {
            this.writeNull();
        } else {
            this._appendValue(JsonToken.VALUE_NUMBER_INT, bigInteger);
        }
    }

    @Override
    public void writeNumber(String string) {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, string);
    }

    @Override
    public void writeBoolean(boolean bl) {
        JsonToken jsonToken = bl ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
        this._appendValue(jsonToken);
    }

    @Override
    public void writeNull() {
        this._appendValue(JsonToken.VALUE_NULL);
    }

    @Override
    public void writeObject(Object object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        if (object.getClass() != byte[].class && !(object instanceof RawValue)) {
            ObjectCodec objectCodec = this._objectCodec;
            if (objectCodec == null) {
                this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, object);
            } else {
                objectCodec.writeValue(this, object);
            }
            return;
        }
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, object);
    }

    @Override
    public void writeTree(TreeNode treeNode) {
        if (treeNode == null) {
            this.writeNull();
            return;
        }
        ObjectCodec objectCodec = this._objectCodec;
        if (objectCodec == null) {
            this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, treeNode);
        } else {
            objectCodec.writeTree(this, treeNode);
        }
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        TokenBuffer tokenBuffer = object;
        Object object = new byte[n3];
        System.arraycopy(byArray, n2, object, 0, n3);
        tokenBuffer.writeObject(object);
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canWriteTypeId() {
        return this._hasNativeTypeIds;
    }

    @Override
    public boolean canWriteObjectId() {
        return this._hasNativeObjectIds;
    }

    @Override
    public void writeTypeId(Object object) {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._typeId = object;
        tokenBuffer._hasNativeId = true;
    }

    @Override
    public void writeObjectId(Object object) {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._objectId = object;
        tokenBuffer._hasNativeId = true;
    }

    @Override
    public void writeEmbeddedObject(Object object) {
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, object);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void copyCurrentEvent(JsonParser object) {
        if (this._mayHaveNativeIds) {
            this._checkNativeIds((JsonParser)object);
        }
        switch (g.a[((JsonParser)object).currentToken().ordinal()]) {
            default: {
                throw new RuntimeException("Internal error: unexpected token: " + (Object)((Object)((JsonParser)object).currentToken()));
            }
            case 12: {
                this.writeObject(((JsonParser)object).getEmbeddedObject());
                return;
            }
            case 11: {
                this.writeNull();
                return;
            }
            case 10: {
                this.writeBoolean(false);
                return;
            }
            case 9: {
                this.writeBoolean(true);
                return;
            }
            case 8: {
                int n2;
                if (this._forceBigDecimal || (n2 = g.b[((JsonParser)object).getNumberType().ordinal()]) == 3) {
                    this.writeNumber(((JsonParser)object).getDecimalValue());
                    return;
                }
                if (n2 != 4) {
                    double d2 = ((JsonParser)object).getDoubleValue();
                    this.writeNumber(d2);
                    return;
                }
                this.writeNumber(((JsonParser)object).getFloatValue());
                return;
            }
            case 7: {
                int n3 = g.b[((JsonParser)object).getNumberType().ordinal()];
                if (n3 == 1) {
                    this.writeNumber(((JsonParser)object).getIntValue());
                    return;
                }
                if (n3 != 2) {
                    long l2 = ((JsonParser)object).getLongValue();
                    this.writeNumber(l2);
                    return;
                }
                this.writeNumber(((JsonParser)object).getBigIntegerValue());
                return;
            }
            case 6: {
                if (((JsonParser)object).hasTextCharacters()) {
                    Object object2 = object;
                    object = ((JsonParser)object2).getTextCharacters();
                    int n4 = ((JsonParser)object2).getTextOffset();
                    int n5 = ((JsonParser)object2).getTextLength();
                    this.writeString((char[])object, n4, n5);
                    return;
                }
                this.writeString(((JsonParser)object).getText());
                return;
            }
            case 5: {
                this.writeFieldName(((JsonParser)object).currentName());
                return;
            }
            case 4: {
                this.writeEndArray();
                return;
            }
            case 3: {
                this.writeStartArray();
                return;
            }
            case 2: {
                this.writeEndObject();
                return;
            }
            case 1: 
        }
        this.writeStartObject();
    }

    @Override
    public void copyCurrentStructure(JsonParser jsonParser) {
        block14: {
            JsonToken jsonToken;
            block13: {
                block12: {
                    jsonToken = jsonParser.currentToken();
                    if (jsonToken != JsonToken.FIELD_NAME) break block12;
                    if (this._mayHaveNativeIds) {
                        this._checkNativeIds(jsonParser);
                    }
                    this.writeFieldName(jsonParser.currentName());
                    jsonToken = jsonParser.nextToken();
                    break block13;
                }
                if (jsonToken == null) break block14;
            }
            switch (g.a[jsonToken.ordinal()]) {
                default: {
                    this._copyBufferValue(jsonParser, jsonToken);
                    break;
                }
                case 4: {
                    this.writeEndArray();
                    break;
                }
                case 3: {
                    if (this._mayHaveNativeIds) {
                        this._checkNativeIds(jsonParser);
                    }
                    TokenBuffer tokenBuffer = this;
                    tokenBuffer.writeStartArray();
                    tokenBuffer._copyBufferContents(jsonParser);
                    break;
                }
                case 2: {
                    this.writeEndObject();
                    break;
                }
                case 1: {
                    if (this._mayHaveNativeIds) {
                        this._checkNativeIds(jsonParser);
                    }
                    TokenBuffer tokenBuffer = this;
                    tokenBuffer.writeStartObject();
                    tokenBuffer._copyBufferContents(jsonParser);
                }
            }
            return;
        }
        throw new IllegalStateException("No token available from argument `JsonParser`");
    }

    public void _copyBufferContents(JsonParser jsonParser) {
        JsonToken jsonToken;
        int n2 = 1;
        block7: while ((jsonToken = jsonParser.nextToken()) != null) {
            switch (g.a[jsonToken.ordinal()]) {
                default: {
                    this._copyBufferValue(jsonParser, jsonToken);
                    continue block7;
                }
                case 5: {
                    if (this._mayHaveNativeIds) {
                        this._checkNativeIds(jsonParser);
                    }
                    this.writeFieldName(jsonParser.currentName());
                    continue block7;
                }
                case 4: {
                    this.writeEndArray();
                    if ((n2 += -1) != 0) continue block7;
                    return;
                }
                case 3: {
                    if (this._mayHaveNativeIds) {
                        this._checkNativeIds(jsonParser);
                    }
                    this.writeStartArray();
                    ++n2;
                    continue block7;
                }
                case 2: {
                    this.writeEndObject();
                    if ((n2 += -1) != 0) continue block7;
                    return;
                }
                case 1: 
            }
            if (this._mayHaveNativeIds) {
                this._checkNativeIds(jsonParser);
            }
            this.writeStartObject();
            ++n2;
        }
    }

    public final void _appendValue(JsonToken object) {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._writeContext.writeValue();
        if (tokenBuffer._hasNativeId) {
            TokenBuffer tokenBuffer2 = this;
            int n2 = tokenBuffer2._appendAt;
            Object object2 = tokenBuffer2._objectId;
            Object object3 = tokenBuffer2._typeId;
            object = this._last.append(n2, (JsonToken)((Object)object), object2, object3);
        } else {
            object = this._last.append(this._appendAt, (JsonToken)((Object)object));
        }
        if (object == null) {
            ++this._appendAt;
        } else {
            TokenBuffer tokenBuffer3 = this;
            tokenBuffer3._last = object;
            tokenBuffer3._appendAt = 1;
        }
    }

    public final void _appendValue(JsonToken object, Object object2) {
        TokenBuffer tokenBuffer = this;
        tokenBuffer._writeContext.writeValue();
        if (tokenBuffer._hasNativeId) {
            TokenBuffer tokenBuffer2 = this;
            int n2 = tokenBuffer2._appendAt;
            Object object3 = tokenBuffer2._objectId;
            Object object4 = tokenBuffer2._typeId;
            object = this._last.append(n2, (JsonToken)((Object)object), object2, object3, object4);
        } else {
            object = this._last.append(this._appendAt, (JsonToken)((Object)object), object2);
        }
        if (object == null) {
            ++this._appendAt;
        } else {
            TokenBuffer tokenBuffer3 = this;
            tokenBuffer3._last = object;
            tokenBuffer3._appendAt = 1;
        }
    }

    public final void _appendFieldName(Object object) {
        if (this._hasNativeId) {
            TokenBuffer tokenBuffer = this;
            int n2 = tokenBuffer._appendAt;
            JsonToken jsonToken = JsonToken.FIELD_NAME;
            Object object2 = tokenBuffer._objectId;
            Object object3 = tokenBuffer._typeId;
            object = this._last.append(n2, jsonToken, object, object2, object3);
        } else {
            object = this._last.append(this._appendAt, JsonToken.FIELD_NAME, object);
        }
        if (object == null) {
            ++this._appendAt;
        } else {
            TokenBuffer tokenBuffer = this;
            tokenBuffer._last = object;
            tokenBuffer._appendAt = 1;
        }
    }

    public final void _appendStartMarker(JsonToken object) {
        if (this._hasNativeId) {
            TokenBuffer tokenBuffer = this;
            int n2 = tokenBuffer._appendAt;
            Object object2 = tokenBuffer._objectId;
            Object object3 = tokenBuffer._typeId;
            object = this._last.append(n2, (JsonToken)((Object)object), object2, object3);
        } else {
            object = this._last.append(this._appendAt, (JsonToken)((Object)object));
        }
        if (object == null) {
            ++this._appendAt;
        } else {
            TokenBuffer tokenBuffer = this;
            tokenBuffer._last = object;
            tokenBuffer._appendAt = 1;
        }
    }

    public final void _appendEndMarker(JsonToken object) {
        if ((object = this._last.append(this._appendAt, (JsonToken)((Object)object))) == null) {
            ++this._appendAt;
        } else {
            TokenBuffer tokenBuffer = this;
            tokenBuffer._last = object;
            tokenBuffer._appendAt = 1;
        }
    }

    @Override
    public void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Called operation not supported for TokenBuffer");
    }

    public static final class Segment {
        public static final int TOKENS_PER_SEGMENT = 16;
        private static final JsonToken[] TOKEN_TYPES_BY_INDEX;
        protected Segment _next;
        protected long _tokenTypes;
        protected final Object[] _tokens = new Object[16];
        protected TreeMap<Integer, Object> _nativeIds;

        private void set(int n2, JsonToken jsonToken) {
            long l2 = jsonToken.ordinal();
            if (n2 > 0) {
                l2 <<= n2 << 2;
            }
            this._tokenTypes |= l2;
        }

        private void set(int n2, JsonToken jsonToken, Object object, Object object2) {
            long l2 = jsonToken.ordinal();
            if (n2 > 0) {
                l2 <<= n2 << 2;
            }
            this._tokenTypes |= l2;
            this.assignNativeIds(n2, object, object2);
        }

        private void set(int n2, JsonToken jsonToken, Object object) {
            this._tokens[n2] = object;
            long l2 = jsonToken.ordinal();
            if (n2 > 0) {
                l2 <<= n2 << 2;
            }
            this._tokenTypes |= l2;
        }

        private void set(int n2, JsonToken jsonToken, Object object, Object object2, Object object3) {
            this._tokens[n2] = object;
            long l2 = jsonToken.ordinal();
            if (n2 > 0) {
                l2 <<= n2 << 2;
            }
            this._tokenTypes |= l2;
            this.assignNativeIds(n2, object2, object3);
        }

        private final void assignNativeIds(int n2, Object object, Object object2) {
            if (this._nativeIds == null) {
                TreeMap treeMap;
                TreeMap treeMap2 = treeMap;
                treeMap = new TreeMap();
                this._nativeIds = treeMap2;
            }
            if (object != null) {
                this._nativeIds.put(this._objectIdIndex(n2), object);
            }
            if (object2 != null) {
                this._nativeIds.put(this._typeIdIndex(n2), object2);
            }
        }

        private final int _typeIdIndex(int n2) {
            int n3 = n2;
            return n3 + n3;
        }

        private final int _objectIdIndex(int n2) {
            int n3 = n2;
            return n3 + n3 + 1;
        }

        static {
            JsonToken[] jsonTokenArray = new JsonToken[16];
            TOKEN_TYPES_BY_INDEX = jsonTokenArray;
            JsonToken[] jsonTokenArray2 = JsonToken.values();
            int n2 = Math.min(15, jsonTokenArray2.length - 1);
            System.arraycopy(jsonTokenArray2, 1, jsonTokenArray, 1, n2);
        }

        public JsonToken type(int n2) {
            long l2 = this._tokenTypes;
            if (n2 > 0) {
                l2 >>= n2 << 2;
            }
            return TOKEN_TYPES_BY_INDEX[(int)l2 & 0xF];
        }

        public int rawType(int n2) {
            long l2 = this._tokenTypes;
            if (n2 > 0) {
                l2 >>= n2 << 2;
            }
            return (int)l2 & 0xF;
        }

        public Object get(int n2) {
            return this._tokens[n2];
        }

        public Segment next() {
            return this._next;
        }

        public boolean hasIds() {
            return this._nativeIds != null;
        }

        public Segment append(int n2, JsonToken jsonToken) {
            if (n2 < 16) {
                this.set(n2, jsonToken);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, jsonToken);
            return this._next;
        }

        public Segment append(int n2, JsonToken jsonToken, Object object, Object object2) {
            if (n2 < 16) {
                this.set(n2, jsonToken, object, object2);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, jsonToken, object, object2);
            return this._next;
        }

        public Segment append(int n2, JsonToken jsonToken, Object object) {
            if (n2 < 16) {
                this.set(n2, jsonToken, object);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, jsonToken, object);
            return this._next;
        }

        public Segment append(int n2, JsonToken jsonToken, Object object, Object object2, Object object3) {
            if (n2 < 16) {
                this.set(n2, jsonToken, object, object2, object3);
                return null;
            }
            this._next = new Segment();
            this._next.set(0, jsonToken, object, object2, object3);
            return this._next;
        }

        public Object findObjectId(int n2) {
            TreeMap<Integer, Object> treeMap = this._nativeIds;
            return treeMap == null ? null : treeMap.get(this._objectIdIndex(n2));
        }

        public Object findTypeId(int n2) {
            TreeMap<Integer, Object> treeMap = this._nativeIds;
            return treeMap == null ? null : treeMap.get(this._typeIdIndex(n2));
        }
    }

    public static final class Parser
    extends ParserMinimalBase {
        protected ObjectCodec _codec;
        protected final boolean _hasNativeTypeIds;
        protected final boolean _hasNativeObjectIds;
        protected final boolean _hasNativeIds;
        protected Segment _segment;
        protected int _segmentPtr;
        protected TokenBufferReadContext _parsingContext;
        protected boolean _closed;
        protected transient ByteArrayBuilder _byteBuilder;
        protected JsonLocation _location;

        @Deprecated
        public Parser(Segment segment, ObjectCodec objectCodec, boolean bl, boolean bl2) {
            this(segment, objectCodec, bl, bl2, null);
        }

        public Parser(Segment segment, ObjectCodec objectCodec, boolean bl, boolean bl2, JsonStreamContext jsonStreamContext) {
            Parser parser = this;
            this._location = null;
            parser._segment = segment;
            parser._segmentPtr = -1;
            this._codec = objectCodec;
            this._parsingContext = TokenBufferReadContext.createRootContext(jsonStreamContext);
            this._hasNativeTypeIds = bl;
            this._hasNativeObjectIds = bl2;
            boolean bl3 = bl || bl2;
            this._hasNativeIds = bl3;
        }

        private final boolean _smallerThanInt(Number number) {
            return number instanceof Short || number instanceof Byte;
        }

        private final boolean _smallerThanLong(Number number) {
            return number instanceof Integer || number instanceof Short || number instanceof Byte;
        }

        public void setLocation(JsonLocation jsonLocation) {
            this._location = jsonLocation;
        }

        @Override
        public ObjectCodec getCodec() {
            return this._codec;
        }

        @Override
        public void setCodec(ObjectCodec objectCodec) {
            this._codec = objectCodec;
        }

        @Override
        public Version version() {
            return PackageVersion.VERSION;
        }

        @Override
        public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
            return JsonParser.DEFAULT_READ_CAPABILITIES;
        }

        public JsonToken peekNextToken() {
            if (((Parser)object)._closed) {
                return null;
            }
            Parser parser = object;
            Object object = parser._segment;
            int n2 = parser._segmentPtr + 1;
            if (n2 >= 16) {
                n2 = 0;
                object = object == null ? null : ((Segment)object).next();
            }
            return object == null ? null : ((Segment)object).type(n2);
        }

        @Override
        public void close() {
            if (!this._closed) {
                this._closed = true;
            }
        }

        @Override
        public JsonToken nextToken() {
            Object object;
            if (!this._closed && (object = this._segment) != null) {
                if (++this._segmentPtr >= 16) {
                    this._segmentPtr = 0;
                    this._segment = ((Segment)object).next();
                    if (this._segment == null) {
                        return null;
                    }
                }
                object = this._segment.type(this._segmentPtr);
                this._currToken = object;
                if (object == JsonToken.FIELD_NAME) {
                    object = this._currentObject();
                    object = object instanceof String ? (String)object : object.toString();
                    this._parsingContext.setCurrentName((String)object);
                } else if (object == JsonToken.START_OBJECT) {
                    this._parsingContext = this._parsingContext.createChildObjectContext();
                } else if (object == JsonToken.START_ARRAY) {
                    this._parsingContext = this._parsingContext.createChildArrayContext();
                } else if (object != JsonToken.END_OBJECT && object != JsonToken.END_ARRAY) {
                    this._parsingContext.updateForValue();
                } else {
                    this._parsingContext = this._parsingContext.parentOrCopy();
                }
                return this._currToken;
            }
            return null;
        }

        @Override
        public String nextFieldName() {
            Object object;
            if (!this._closed && (object = this._segment) != null) {
                int n2 = this._segmentPtr + 1;
                if (n2 < 16 && ((Segment)object).type(n2) == (object = JsonToken.FIELD_NAME)) {
                    this._segmentPtr = n2;
                    this._currToken = object;
                    object = this._segment.get(n2);
                    object = object instanceof String ? (String)object : object.toString();
                    this._parsingContext.setCurrentName((String)object);
                    return object;
                }
                return this.nextToken() == JsonToken.FIELD_NAME ? this.currentName() : null;
            }
            return null;
        }

        @Override
        public boolean isClosed() {
            return this._closed;
        }

        @Override
        public JsonStreamContext getParsingContext() {
            return this._parsingContext;
        }

        @Override
        public JsonLocation getTokenLocation() {
            return this.getCurrentLocation();
        }

        @Override
        public JsonLocation getCurrentLocation() {
            Object object = ((Parser)object)._location;
            if (object == null) {
                object = JsonLocation.NA;
            }
            return object;
        }

        @Override
        public String currentName() {
            JsonToken jsonToken = this._currToken;
            if (jsonToken != JsonToken.START_OBJECT && jsonToken != JsonToken.START_ARRAY) {
                return this._parsingContext.getCurrentName();
            }
            return this._parsingContext.getParent().getCurrentName();
        }

        @Override
        public String getCurrentName() {
            return this.currentName();
        }

        @Override
        public void overrideCurrentName(String string) {
            Parser parser = object;
            Object object = parser._parsingContext;
            JsonToken jsonToken = parser._currToken;
            if (jsonToken == JsonToken.START_OBJECT || jsonToken == JsonToken.START_ARRAY) {
                object = ((TokenBufferReadContext)object).getParent();
            }
            if (object instanceof TokenBufferReadContext) {
                try {
                    ((TokenBufferReadContext)object).setCurrentName(string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }

        @Override
        public String getText() {
            JsonToken jsonToken = ((ParserMinimalBase)this)._currToken;
            if (jsonToken != JsonToken.VALUE_STRING && jsonToken != JsonToken.FIELD_NAME) {
                if (jsonToken == null) {
                    return null;
                }
                int n2 = g.a[jsonToken.ordinal()];
                if (n2 != 7 && n2 != 8) {
                    return ((ParserMinimalBase)this)._currToken.asString();
                }
                return ClassUtil.nullOrToString(((Parser)this)._currentObject());
            }
            if ((this = ((Parser)this)._currentObject()) instanceof String) {
                return (String)this;
            }
            return ClassUtil.nullOrToString(this);
        }

        @Override
        public char[] getTextCharacters() {
            return (this = ((Parser)this).getText()) == null ? null : ((String)this).toCharArray();
        }

        @Override
        public int getTextLength() {
            return (this = ((Parser)this).getText()) == null ? 0 : ((String)this).length();
        }

        @Override
        public int getTextOffset() {
            return 0;
        }

        @Override
        public boolean hasTextCharacters() {
            return false;
        }

        @Override
        public boolean isNaN() {
            if (((ParserMinimalBase)this)._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
                if ((this = ((Parser)this)._currentObject()) instanceof Double) {
                    return ((Double)(this = (Double)this)).isNaN() || ((Double)this).isInfinite();
                }
                if (this instanceof Float) {
                    return ((Float)(this = (Float)this)).isNaN() || ((Float)this).isInfinite();
                }
            }
            return false;
        }

        @Override
        public BigInteger getBigIntegerValue() {
            Number number = this.getNumberValue();
            if (number instanceof BigInteger) {
                return (BigInteger)number;
            }
            if (this.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }

        @Override
        public BigDecimal getDecimalValue() {
            Number number = this.getNumberValue();
            if (number instanceof BigDecimal) {
                return (BigDecimal)number;
            }
            int n2 = g.b[this.getNumberType().ordinal()];
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 5) {
                        return BigDecimal.valueOf(number.doubleValue());
                    }
                } else {
                    return new BigDecimal((BigInteger)number);
                }
            }
            return BigDecimal.valueOf(number.longValue());
        }

        @Override
        public double getDoubleValue() {
            return this.getNumberValue().doubleValue();
        }

        @Override
        public float getFloatValue() {
            return this.getNumberValue().floatValue();
        }

        @Override
        public int getIntValue() {
            Number number = this._currToken == JsonToken.VALUE_NUMBER_INT ? (Number)((Number)this._currentObject()) : (Number)this.getNumberValue();
            if (!(number instanceof Integer) && !this._smallerThanInt(number)) {
                return this._convertNumberToInt(number);
            }
            return number.intValue();
        }

        @Override
        public long getLongValue() {
            Number number = this._currToken == JsonToken.VALUE_NUMBER_INT ? (Number)((Number)this._currentObject()) : (Number)this.getNumberValue();
            if (!(number instanceof Long) && !this._smallerThanLong(number)) {
                return this._convertNumberToLong(number);
            }
            return number.longValue();
        }

        @Override
        public JsonParser.NumberType getNumberType() {
            if ((this = ((Parser)this).getNumberValue()) instanceof Integer) {
                return JsonParser.NumberType.INT;
            }
            if (this instanceof Long) {
                return JsonParser.NumberType.LONG;
            }
            if (this instanceof Double) {
                return JsonParser.NumberType.DOUBLE;
            }
            if (this instanceof BigDecimal) {
                return JsonParser.NumberType.BIG_DECIMAL;
            }
            if (this instanceof BigInteger) {
                return JsonParser.NumberType.BIG_INTEGER;
            }
            if (this instanceof Float) {
                return JsonParser.NumberType.FLOAT;
            }
            if (this instanceof Short) {
                return JsonParser.NumberType.INT;
            }
            return null;
        }

        @Override
        public final Number getNumberValue() {
            Parser parser = this;
            parser._checkIsNumber();
            Object object = parser._currentObject();
            if (object instanceof Number) {
                return (Number)object;
            }
            if (object instanceof String) {
                if (((String)(object = (String)object)).indexOf(46) >= 0) {
                    return NumberInput.parseDouble((String)object, this.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
                }
                return NumberInput.parseLong((String)object);
            }
            if (object == null) {
                return null;
            }
            throw new IllegalStateException("Internal error: entry should be a Number, but is of type ".concat(object.getClass().getName()));
        }

        /*
         * Enabled aggressive block sorting
         */
        public int _convertNumberToInt(Number number) {
            block11: {
                block10: {
                    block9: {
                        if (number instanceof Long) {
                            long l2 = number.longValue();
                            int n2 = (int)l2;
                            if ((long)n2 == l2) return n2;
                            this.reportOverflowInt();
                            return n2;
                        }
                        if (!(number instanceof BigInteger)) break block9;
                        BigInteger bigInteger = (BigInteger)number;
                        if (ParserMinimalBase.BI_MIN_INT.compareTo(bigInteger) <= 0) {
                            if (ParserMinimalBase.BI_MAX_INT.compareTo(bigInteger) >= 0) return number.intValue();
                        }
                        break block10;
                    }
                    if (number instanceof Double || number instanceof Float) break block11;
                    if (!(number instanceof BigDecimal)) {
                        this._throwInternal();
                        return number.intValue();
                    }
                    BigDecimal bigDecimal = (BigDecimal)number;
                    if (ParserMinimalBase.BD_MIN_INT.compareTo(bigDecimal) <= 0) {
                        if (ParserMinimalBase.BD_MAX_INT.compareTo(bigDecimal) >= 0) return number.intValue();
                    }
                }
                this.reportOverflowInt();
                return number.intValue();
            }
            double d2 = number.doubleValue();
            if (!(d2 < -2.147483648E9)) {
                if (!(d2 > 2.147483647E9)) return (int)d2;
            }
            this.reportOverflowInt();
            return (int)d2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public long _convertNumberToLong(Number number) {
            block10: {
                block9: {
                    block8: {
                        if (!(number instanceof BigInteger)) break block8;
                        BigInteger bigInteger = (BigInteger)number;
                        if (ParserMinimalBase.BI_MIN_LONG.compareTo(bigInteger) <= 0) {
                            if (ParserMinimalBase.BI_MAX_LONG.compareTo(bigInteger) >= 0) return number.longValue();
                        }
                        break block9;
                    }
                    if (number instanceof Double || number instanceof Float) break block10;
                    if (!(number instanceof BigDecimal)) {
                        this._throwInternal();
                        return number.longValue();
                    }
                    BigDecimal bigDecimal = (BigDecimal)number;
                    if (ParserMinimalBase.BD_MIN_LONG.compareTo(bigDecimal) <= 0) {
                        if (ParserMinimalBase.BD_MAX_LONG.compareTo(bigDecimal) >= 0) return number.longValue();
                    }
                }
                this.reportOverflowLong();
                return number.longValue();
            }
            double d2 = number.doubleValue();
            if (!(d2 < -9.223372036854776E18)) {
                if (!(d2 > 9.223372036854776E18)) return (long)d2;
            }
            this.reportOverflowLong();
            return (long)d2;
        }

        @Override
        public Object getEmbeddedObject() {
            if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
                return this._currentObject();
            }
            return null;
        }

        @Override
        public byte[] getBinaryValue(Base64Variant base64Variant) {
            Object object;
            if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT && (object = this._currentObject()) instanceof byte[]) {
                return (byte[])object;
            }
            if (this._currToken == JsonToken.VALUE_STRING) {
                object = this.getText();
                if (object == null) {
                    return null;
                }
                ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
                if (byteArrayBuilder == null) {
                    ByteArrayBuilder byteArrayBuilder2;
                    byteArrayBuilder = byteArrayBuilder2;
                    byteArrayBuilder2 = new ByteArrayBuilder(100);
                    this._byteBuilder = byteArrayBuilder;
                } else {
                    byteArrayBuilder.reset();
                }
                this._decodeBase64((String)object, byteArrayBuilder, base64Variant);
                return byteArrayBuilder.toByteArray();
            }
            throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING (or VALUE_EMBEDDED_OBJECT with byte[]), cannot access as binary");
        }

        @Override
        public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) {
            byte[] byArray = ((Parser)object).getBinaryValue(base64Variant);
            Object object = byArray;
            if (byArray != null) {
                Object object2 = object;
                outputStream.write((byte[])object2, 0, ((Object)object2).length);
                return ((Object)object).length;
            }
            return 0;
        }

        @Override
        public boolean canReadObjectId() {
            return this._hasNativeObjectIds;
        }

        @Override
        public boolean canReadTypeId() {
            return this._hasNativeTypeIds;
        }

        @Override
        public Object getTypeId() {
            return this._segment.findTypeId(this._segmentPtr);
        }

        @Override
        public Object getObjectId() {
            return this._segment.findObjectId(this._segmentPtr);
        }

        public final Object _currentObject() {
            return this._segment.get(this._segmentPtr);
        }

        public final void _checkIsNumber() {
            JsonToken jsonToken = this._currToken;
            if (jsonToken != null && jsonToken.isNumeric()) {
                return;
            }
            throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, cannot use numeric value accessors");
        }

        @Override
        public void _handleEOF() {
            this._throwInternal();
        }
    }
}

