/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind.util.internal;

import com.privatefasterxml.jackson.databind.util.internal.a;
import com.privatefasterxml.jackson.databind.util.internal.e;
import com.privatefasterxml.jackson.databind.util.internal.f;
import com.privatefasterxml.jackson.databind.util.internal.g;
import com.privatefasterxml.jackson.databind.util.internal.h;
import com.privatefasterxml.jackson.databind.util.internal.j;
import com.privatefasterxml.jackson.databind.util.internal.k;
import com.privatefasterxml.jackson.databind.util.internal.m;
import com.privatefasterxml.jackson.databind.util.internal.o;
import com.privatefasterxml.jackson.databind.util.internal.p;
import com.privatefasterxml.jackson.databind.util.internal.q;
import com.privatefasterxml.jackson.databind.util.internal.r;
import com.privatefasterxml.jackson.databind.util.internal.s;
import com.privatefasterxml.jackson.databind.util.internal.u;
import com.privatefasterxml.jackson.databind.util.internal.v;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class PrivateMaxEntriesMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final int NUMBER_OF_READ_BUFFERS = Math.min(4, PrivateMaxEntriesMap.ceilingNextPowerOfTwo(NCPU));
    static final int READ_BUFFERS_MASK = NUMBER_OF_READ_BUFFERS - 1;
    static final int READ_BUFFER_THRESHOLD = 4;
    static final int READ_BUFFER_DRAIN_THRESHOLD = 8;
    static final int READ_BUFFER_SIZE = 16;
    static final int READ_BUFFER_INDEX_MASK = 15;
    static final int WRITE_BUFFER_DRAIN_THRESHOLD = 16;
    static final long serialVersionUID = 1L;
    final ConcurrentMap<K, p> data;
    final int concurrencyLevel;
    final long[] readBufferReadCount;
    final e evictionDeque;
    final AtomicLong weightedSize;
    final AtomicLong capacity;
    final Lock evictionLock;
    final Queue<Runnable> writeBuffer;
    final AtomicLongArray readBufferWriteCount;
    final AtomicLongArray readBufferDrainAtWriteCount;
    final AtomicReferenceArray<p> readBuffers;
    final AtomicReference<k> drainStatus;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;

    public static int ceilingNextPowerOfTwo(int n2) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    private static int readBufferIndex(int n2, int n3) {
        return n2 * 16 + n3;
    }

    private PrivateMaxEntriesMap(Builder<K, V> builder) {
        int n2;
        PrivateMaxEntriesMap privateMaxEntriesMap = this;
        privateMaxEntriesMap.concurrencyLevel = n2 = builder.concurrencyLevel;
        privateMaxEntriesMap.capacity = new AtomicLong(Math.min(builder.capacity, 9223372034707292160L));
        privateMaxEntriesMap.data = new ConcurrentHashMap<K, p>(builder.initialCapacity, 0.75f, n2);
        privateMaxEntriesMap.evictionLock = new ReentrantLock();
        privateMaxEntriesMap.weightedSize = new AtomicLong();
        privateMaxEntriesMap.evictionDeque = new e();
        privateMaxEntriesMap.writeBuffer = new ConcurrentLinkedQueue<Runnable>();
        privateMaxEntriesMap.drainStatus = new AtomicReference<h>(k.a);
        n2 = NUMBER_OF_READ_BUFFERS;
        privateMaxEntriesMap.readBufferReadCount = new long[n2];
        privateMaxEntriesMap.readBufferWriteCount = new AtomicLongArray(n2);
        privateMaxEntriesMap.readBufferDrainAtWriteCount = new AtomicLongArray(n2);
        privateMaxEntriesMap.readBuffers = new AtomicReferenceArray(n2 * 16);
    }

    public static void checkNotNull(Object object) {
        object.getClass();
    }

    public static void checkArgument(boolean bl) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void checkState(boolean bl) {
        if (bl) {
            return;
        }
        throw new IllegalStateException();
    }

    public static int readBufferIndex() {
        return (int)Thread.currentThread().getId() & READ_BUFFERS_MASK;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Proxy required");
    }

    public /* synthetic */ PrivateMaxEntriesMap(Builder builder, f f2) {
        this(builder);
    }

    public long capacity() {
        return this.capacity.get();
    }

    public void setCapacity(long l2) {
        PrivateMaxEntriesMap.checkArgument(l2 >= 0L);
        PrivateMaxEntriesMap privateMaxEntriesMap = this;
        privateMaxEntriesMap.evictionLock.lock();
        try {
            privateMaxEntriesMap.capacity.lazySet(Math.min(l2, 9223372034707292160L));
            privateMaxEntriesMap.drainBuffers();
            privateMaxEntriesMap.evict();
            privateMaxEntriesMap.evictionLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            this.evictionLock.unlock();
            throw throwable;
        }
    }

    public boolean hasOverflowed() {
        return this.weightedSize.get() > this.capacity.get();
    }

    public void evict() {
        while (this.hasOverflowed()) {
            p p2 = (p)this.evictionDeque.b();
            if (p2 == null) {
                return;
            }
            this.data.remove(p2.a, p2);
            this.makeDead(p2);
        }
    }

    public void afterRead(p p2) {
        PrivateMaxEntriesMap privateMaxEntriesMap = this;
        int n2 = PrivateMaxEntriesMap.readBufferIndex();
        long l2 = privateMaxEntriesMap.recordRead(n2, p2);
        privateMaxEntriesMap.drainOnReadIfNeeded(n2, l2);
    }

    public long recordRead(int n2, p p2) {
        long l2 = this.readBufferWriteCount.get(n2);
        this.readBufferWriteCount.lazySet(n2, l2 + 1L);
        int n3 = (int)(l2 & 0xFL);
        this.readBuffers.lazySet(PrivateMaxEntriesMap.readBufferIndex(n2, n3), p2);
        return l2;
    }

    public void drainOnReadIfNeeded(int n2, long l2) {
        n2 = l2 - this.readBufferDrainAtWriteCount.get(n2) < 4L ? 1 : 0;
        if (this.drainStatus.get().a(n2 != 0)) {
            this.tryToDrainBuffers();
        }
    }

    public void afterWrite(Runnable runnable) {
        PrivateMaxEntriesMap privateMaxEntriesMap = this;
        privateMaxEntriesMap.writeBuffer.add(runnable);
        privateMaxEntriesMap.drainStatus.lazySet(k.b);
        privateMaxEntriesMap.tryToDrainBuffers();
    }

    public void tryToDrainBuffers() {
        if (this.evictionLock.tryLock()) {
            j j2;
            AtomicReference<k> atomicReference;
            PrivateMaxEntriesMap privateMaxEntriesMap;
            PrivateMaxEntriesMap privateMaxEntriesMap2;
            PrivateMaxEntriesMap privateMaxEntriesMap3;
            try {
                PrivateMaxEntriesMap privateMaxEntriesMap4 = this;
                privateMaxEntriesMap3 = privateMaxEntriesMap4;
                privateMaxEntriesMap2 = privateMaxEntriesMap4;
                privateMaxEntriesMap = privateMaxEntriesMap4;
                atomicReference = privateMaxEntriesMap4.drainStatus;
                j2 = k.c;
            }
            catch (Throwable throwable) {
                PrivateMaxEntriesMap privateMaxEntriesMap5 = this;
                privateMaxEntriesMap5.drainStatus.compareAndSet(k.c, k.a);
                privateMaxEntriesMap5.evictionLock.unlock();
                throw throwable;
            }
            atomicReference.lazySet(j2);
            privateMaxEntriesMap3.drainBuffers();
            privateMaxEntriesMap2.drainStatus.compareAndSet(j2, k.a);
            privateMaxEntriesMap.evictionLock.unlock();
        }
    }

    public void drainBuffers() {
        PrivateMaxEntriesMap privateMaxEntriesMap = this;
        privateMaxEntriesMap.drainReadBuffers();
        privateMaxEntriesMap.drainWriteBuffer();
    }

    public void drainReadBuffers() {
        int n2;
        int n3 = n2 + NUMBER_OF_READ_BUFFERS;
        for (n2 = (int)Thread.currentThread().getId(); n2 < n3; ++n2) {
            this.drainReadBuffer(n2 & READ_BUFFERS_MASK);
        }
    }

    public void drainReadBuffer(int n2) {
        int n3;
        p p2;
        long l2 = this.readBufferWriteCount.get(n2);
        for (int i2 = 0; i2 < 8 && (p2 = this.readBuffers.get(n3 = PrivateMaxEntriesMap.readBufferIndex(n2, (int)(this.readBufferReadCount[n2] & 0xFL)))) != null; ++i2) {
            PrivateMaxEntriesMap privateMaxEntriesMap = this;
            this.readBuffers.lazySet(n3, null);
            privateMaxEntriesMap.applyRead(p2);
            privateMaxEntriesMap.readBufferReadCount[n2] = privateMaxEntriesMap.readBufferReadCount[n2] + 1L;
        }
        this.readBufferDrainAtWriteCount.lazySet(n2, l2);
    }

    public void applyRead(p p2) {
        if (((PrivateMaxEntriesMap)((Object)e2)).evictionDeque.a(p2)) {
            e e2 = ((PrivateMaxEntriesMap)((Object)e2)).evictionDeque;
            if (p2 != e2.b) {
                e e3 = e2;
                e3.c(p2);
                a a2 = e3.b;
                e2.b = p2;
                if (a2 == null) {
                    e2.a = p2;
                } else {
                    ((p)a2).c = p2;
                    p2.b = (p)a2;
                }
            }
        }
    }

    public void drainWriteBuffer() {
        Runnable runnable;
        for (int i2 = 0; i2 < 16 && (runnable = this.writeBuffer.poll()) != null; ++i2) {
            runnable.run();
        }
    }

    public boolean tryToRetire(p p2, v v2) {
        if (v2.a()) {
            return p2.compareAndSet(v2, new v(v2.b, -v2.a));
        }
        return false;
    }

    public void makeRetired(p p2) {
        do {
            if (((v)(this = (v)p2.get())).a()) continue;
            return;
        } while (!p2.compareAndSet(this, new v(((v)this).b, -((v)this).a)));
    }

    public void makeDead(p p2) {
        v v2;
        v v3;
        p p3;
        do {
            v v4;
            p3 = p2;
            v3 = (v)p3.get();
            v2 = v4;
            v4 = new v(v3.b, 0);
        } while (!p3.compareAndSet(v3, v2));
        AtomicLong atomicLong = this.weightedSize;
        atomicLong.lazySet(atomicLong.get() - (long)Math.abs(v3.a));
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void clear() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 53->61)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean containsKey(Object object) {
        return this.data.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        PrivateMaxEntriesMap.checkNotNull(object);
        Iterator iterator = ((PrivateMaxEntriesMap)((Object)iterator)).data.values().iterator();
        while (iterator.hasNext()) {
            if (!((v)((p)iterator.next()).get()).b.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        if ((object = (p)this.data.get(object)) == null) {
            return null;
        }
        this.afterRead((p)object);
        return (V)((v)((AtomicReference)object).get()).b;
    }

    @Override
    public V put(K k2, V v2) {
        return this.put(k2, v2, false);
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        return this.put(k2, v2, true);
    }

    public V put(K object, V object2, boolean bl) {
        v v2;
        p p2;
        v v3;
        PrivateMaxEntriesMap.checkNotNull(object);
        PrivateMaxEntriesMap.checkNotNull(object2);
        v v4 = v3;
        v3 = new v(object2, 1);
        object2 = p2;
        p2 = new p(object, v4);
        block0: while (true) {
            if ((object = this.data.putIfAbsent(((p)object2).a, (p)object2)) == null) {
                g g2;
                object = g2;
                g2 = new g(this, (p)object2);
                this.afterWrite((Runnable)object);
                return null;
            }
            if (bl) {
                this.afterRead((p)object);
                return (V)((v)((AtomicReference)object).get()).b;
            }
            do {
                if (!(v2 = (v)((AtomicReference)object).get()).a()) continue block0;
            } while (!((AtomicReference)object).compareAndSet((v)v2, (v)v4));
            break;
        }
        int n2 = 1 - v2.a;
        if (n2 == 0) {
            this.afterRead((p)object);
        } else {
            s s2;
            s s3 = s2;
            s2 = new s(this, (p)object, n2);
            this.afterWrite(s3);
        }
        return (V)v2.b;
    }

    @Override
    public V remove(Object object) {
        if ((object = (p)this.data.remove(object)) == null) {
            return null;
        }
        PrivateMaxEntriesMap privateMaxEntriesMap = this;
        privateMaxEntriesMap.makeRetired((p)object);
        privateMaxEntriesMap.afterWrite(new q(this, (p)object));
        return (V)((v)((AtomicReference)object).get()).b;
    }

    @Override
    public boolean remove(Object object, Object object2) {
        p p2 = (p)this.data.get(object);
        if (p2 != null && object2 != null) {
            Object object3;
            v v2 = (v)p2.get();
            while (object2 == (object3 = v2.b) || object3.equals(object2)) {
                if (this.tryToRetire(p2, v2)) {
                    q q2;
                    if (!this.data.remove(object, p2)) break;
                    object = q2;
                    q2 = new q(this, p2);
                    this.afterWrite((Runnable)object);
                    return true;
                }
                v2 = (v)p2.get();
                if (v2.a()) continue;
            }
            return false;
        }
        return false;
    }

    @Override
    public V replace(K object, V object2) {
        v v2;
        PrivateMaxEntriesMap.checkNotNull(object);
        PrivateMaxEntriesMap.checkNotNull(object2);
        v v3 = v2;
        v2 = new v(object2, 1);
        object = (p)this.data.get(object);
        if (object == null) {
            return null;
        }
        do {
            if (((v)(object2 = (v)((AtomicReference)object).get())).a()) continue;
            return null;
        } while (!((AtomicReference)object).compareAndSet(object2, v3));
        int n2 = 1 - ((v)object2).a;
        if (n2 == 0) {
            this.afterRead((p)object);
        } else {
            s s2;
            s s3 = s2;
            s2 = new s(this, (p)object, n2);
            this.afterWrite(s3);
        }
        return (V)((v)object2).b;
    }

    @Override
    public boolean replace(K object, V v2, V object2) {
        Object object3;
        v v3;
        PrivateMaxEntriesMap.checkNotNull(object);
        PrivateMaxEntriesMap.checkNotNull(v2);
        PrivateMaxEntriesMap.checkNotNull(object2);
        v v4 = v3;
        v3 = new v(object2, 1);
        object = (p)this.data.get(object);
        if (object == null) {
            return false;
        }
        while (((v)(object2 = (v)((AtomicReference)object).get())).a() && (v2 == (object3 = ((v)object2).b) || object3.equals(v2))) {
            if (!((AtomicReference)object).compareAndSet(object2, v4)) continue;
            int n2 = 1 - ((v)object2).a;
            if (n2 == 0) {
                this.afterRead((p)object);
            } else {
                s s2;
                object2 = s2;
                s2 = new s(this, (p)object, n2);
                this.afterWrite((Runnable)object2);
            }
            return true;
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        o o2 = this.keySet;
        if (o2 == null) {
            o o3;
            o2 = o3;
            o3 = new o(this);
            this.keySet = o2;
        }
        return o2;
    }

    @Override
    public Collection<V> values() {
        u u2 = this.values;
        if (u2 == null) {
            u u3;
            u2 = u3;
            u3 = new u(this);
            this.values = u2;
        }
        return u2;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        m m2 = this.entrySet;
        if (m2 == null) {
            m m3;
            m2 = m3;
            m3 = new m(this);
            this.entrySet = m2;
        }
        return m2;
    }

    public Object writeReplace() {
        return new r(this);
    }

    public static final class Builder<K, V> {
        static final int DEFAULT_CONCURRENCY_LEVEL = 16;
        static final int DEFAULT_INITIAL_CAPACITY = 16;
        int concurrencyLevel = 16;
        int initialCapacity = 16;
        long capacity = -1L;

        public Builder<K, V> initialCapacity(int n2) {
            PrivateMaxEntriesMap.checkArgument(n2 >= 0);
            this.initialCapacity = n2;
            return this;
        }

        public Builder<K, V> maximumCapacity(long l2) {
            PrivateMaxEntriesMap.checkArgument(l2 >= 0L);
            this.capacity = l2;
            return this;
        }

        public Builder<K, V> concurrencyLevel(int n2) {
            PrivateMaxEntriesMap.checkArgument(n2 > 0);
            this.concurrencyLevel = n2;
            return this;
        }

        public PrivateMaxEntriesMap<K, V> build() {
            PrivateMaxEntriesMap.checkState(this.capacity >= 0L);
            return new PrivateMaxEntriesMap(this, null);
        }
    }
}

