/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common;

import android.graphics.Rect;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Region {
    public static final int FULL_WIDTH = 0;
    public static final Region EMPTY = new Region(0, 0, 0, 0);
    @JsonProperty(value="width")
    private int mWidth;
    @JsonProperty(value="height")
    private int mHeight;
    @JsonProperty(value="top")
    private int mTop;
    @JsonProperty(value="left")
    private int mLeft;

    private Region() {
    }

    public Region(Rect rect) {
        this.mLeft = rect.left;
        this.mTop = rect.top;
        this.mHeight = rect.height();
        this.mWidth = rect.width();
    }

    public Region(Region region) {
        Region region2 = region;
        ArgumentGuard.notNull(region2, "other");
        this.mLeft = region2.getLeft();
        this.mTop = region.getTop();
        this.mWidth = region.getWidth();
        this.mHeight = region.getHeight();
    }

    public Region(int n, int n2, int n3, int n4) {
        ArgumentGuard.greaterThanOrEqualToZero(n, "width");
        ArgumentGuard.greaterThanOrEqualToZero(n2, "height");
        this.mWidth = n;
        this.mHeight = n2;
        this.mTop = n3;
        this.mLeft = n4;
    }

    public void makeEmpty() {
        Region region = region2;
        Region region2 = EMPTY;
        region.mLeft = region2.getLeft();
        region.mTop = region2.getTop();
        region.mWidth = region2.getWidth();
        region.mHeight = region2.getHeight();
    }

    public boolean isEmpty() {
        Region region = EMPTY;
        return this.getLeft() == region.getLeft() && this.getTop() == region.getTop() && this.getWidth() == region.getWidth() && this.getHeight() == region.getHeight();
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getTop() {
        return this.mTop;
    }

    public int getLeft() {
        return this.mLeft;
    }

    public int getBottom() {
        return this.mTop + this.mHeight;
    }

    public int getRight() {
        return this.mLeft + this.mWidth;
    }

    public Rect getRect() {
        Region region = this;
        int n = region.mLeft;
        int n2 = region.mTop;
        int n3 = n;
        int n4 = n + this.mWidth;
        n = n2 + this.mHeight;
        return new Rect(n3, n2, n4, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (Region)object;
            return this.mWidth == ((Region)object).mWidth && this.mHeight == ((Region)object).mHeight && this.mTop == ((Region)object).mTop && this.mLeft == ((Region)object).mLeft;
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mWidth;
        objectArray2[1] = this.mHeight;
        objectArray2[2] = this.mTop;
        objectArray[3] = this.mLeft;
        return Objects.hash(objectArray);
    }

    public String toString() {
        return "Region{mWidth=" + this.mWidth + ", mHeight=" + this.mHeight + ", mTop=" + this.mTop + ", mLeft=" + this.mLeft + '}';
    }
}

