/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common.utils;

import java.util.Collection;
import java.util.Objects;

public class ArgumentGuard {
    private ArgumentGuard() {
    }

    public static void notNull(Object object, String string) {
        if (object == null) {
            ArgumentGuard.formatExceptionAndTrow(string, "is null");
        }
    }

    public static void notEqual(Object object, Object object2, String string) {
        if (Objects.equals(object, object2)) {
            ArgumentGuard.formatExceptionAndTrow(string, string + " == " + object2);
        }
    }

    public static void notNullOrEmpty(String string, String string2) {
        String string3 = string;
        ArgumentGuard.notNull(string3, string2);
        if (string3.length() == 0) {
            ArgumentGuard.formatExceptionAndTrow(string2, string2 + " is empty");
        }
    }

    public static void notNullOrEmpty(Collection<?> collection, String string) {
        Collection<?> collection2 = collection;
        ArgumentGuard.notNull(collection2, string);
        if (collection2.size() == 0) {
            ArgumentGuard.formatExceptionAndTrow(string, string + " is empty");
        }
    }

    public static <T> void notNullOrEmpty(T[] TArray, String string) {
        ArgumentGuard.notNull(TArray, string);
        if (TArray.length == 0) {
            ArgumentGuard.formatExceptionAndTrow(string, string + " is empty");
        }
    }

    public static void isNull(Object object, String string) {
        if (object != null) {
            ArgumentGuard.formatExceptionAndTrow(string, string + " is not null");
        }
    }

    public static void greaterThanOrEqualToZero(long l, String string) {
        if (0L > l) {
            ArgumentGuard.formatExceptionAndTrow(string, string + " < 0");
        }
    }

    public static void greaterThanZero(long l, String string) {
        if (0L >= l) {
            ArgumentGuard.formatExceptionAndTrow(string, string + " < 1");
        }
    }

    public static void greaterThanZero(double d, String string) {
        if (0.0 >= d) {
            ArgumentGuard.formatExceptionAndTrow(string, string + " < 1");
        }
    }

    public static void notZero(long l, String string) {
        if (0L == l) {
            ArgumentGuard.formatExceptionAndTrow(string, string + " == 0");
        }
    }

    public static void isValidState(boolean bl, String string) {
        if (!bl) {
            ArgumentGuard.formatExceptionAndTrow(null, string);
        }
    }

    private static void formatExceptionAndTrow(String string, String string2) {
        Object object = Thread.currentThread().getStackTrace();
        StackTraceElement[] stackTraceElementArray = null;
        int n = 0;
        for (int i = 2; i < ((StackTraceElement[])object).length; ++i) {
            if (object[i].getClassName().equals(ArgumentGuard.class.getCanonicalName())) {
                ++n;
                continue;
            }
            if (stackTraceElementArray == null) {
                stackTraceElementArray = new StackTraceElement[((StackTraceElement[])object).length - n - 2];
            }
            int n2 = i;
            int n3 = n2 - n - 2;
            stackTraceElementArray[n3] = object[n2];
        }
        String string3 = stackTraceElementArray[0].getClassName();
        object = string3.substring(string3.lastIndexOf(46) + 1);
        if (string != null) {
            string2 = (String)object + " property name: " + string + " violates [" + string2 + "]";
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
        illegalArgumentException.setStackTrace(stackTraceElementArray);
        throw illegalArgumentException;
    }
}

