/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common;

import android.graphics.Rect;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import java.util.Objects;

public class Region {
    public static final int FULL_WIDTH = 0;
    private int width;
    private int height;
    private int top;
    private int left;
    public static final Region EMPTY = new Region(0, 0, 0, 0);

    void makeEmpty() {
        this.left = EMPTY.getLeft();
        this.top = EMPTY.getTop();
        this.width = EMPTY.getWidth();
        this.height = EMPTY.getHeight();
    }

    private Region() {
    }

    public Region(Rect rect) {
        this.left = rect.left;
        this.top = rect.top;
        this.height = rect.height();
        this.width = rect.width();
    }

    public Region(Region other) {
        ArgumentGuard.notNull(other, "other");
        this.left = other.getLeft();
        this.top = other.getTop();
        this.width = other.getWidth();
        this.height = other.getHeight();
    }

    public Region(int width, int height, int top, int left) {
        ArgumentGuard.greaterThanOrEqualToZero(width, "width");
        ArgumentGuard.greaterThanOrEqualToZero(height, "height");
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
    }

    public boolean isEmpty() {
        return this.getLeft() == EMPTY.getLeft() && this.getTop() == EMPTY.getTop() && this.getWidth() == EMPTY.getWidth() && this.getHeight() == EMPTY.getHeight();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTop() {
        return this.top;
    }

    public int getLeft() {
        return this.left;
    }

    public int getBottom() {
        return this.top + this.height;
    }

    public int getRight() {
        return this.left + this.width;
    }

    public Rect getRect() {
        return new Rect(this.left, this.top, this.left + this.width, this.top + this.height);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return this.width == region.width && this.height == region.height && this.top == region.top && this.left == region.left;
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height, this.top, this.left);
    }

    public String toString() {
        return "Region{width=" + this.width + ", height=" + this.height + ", top=" + this.top + ", left=" + this.left + '}';
    }
}

