/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common.utils;

import java.util.Collection;
import java.util.Objects;

public class ArgumentGuard {
    private ArgumentGuard() {
    }

    public static void notNull(Object param, String paramName) throws IllegalArgumentException {
        if (null == param) {
            ArgumentGuard.formatExceptionAndTrow(paramName, "is null");
        }
    }

    public static void notEqual(Object param, Object value, String paramName) {
        if (Objects.equals(param, value)) {
            ArgumentGuard.formatExceptionAndTrow(paramName, paramName + " == " + value);
        }
    }

    public static void notNullOrEmpty(String param, String paramName) throws IllegalArgumentException {
        ArgumentGuard.notNull(param, paramName);
        if (param.length() == 0) {
            ArgumentGuard.formatExceptionAndTrow(paramName, paramName + " is empty");
        }
    }

    public static void notNullOrEmpty(Collection<?> list, String paramName) throws IllegalArgumentException {
        ArgumentGuard.notNull(list, paramName);
        if (list.size() == 0) {
            ArgumentGuard.formatExceptionAndTrow(paramName, paramName + " is empty");
        }
    }

    public static <T> void notNullOrEmpty(T[] array, String paramName) throws IllegalArgumentException {
        ArgumentGuard.notNull(array, paramName);
        if (array.length == 0) {
            ArgumentGuard.formatExceptionAndTrow(paramName, paramName + " is empty");
        }
    }

    public static void isNull(Object param, String paramName) throws IllegalArgumentException {
        if (null != param) {
            ArgumentGuard.formatExceptionAndTrow(paramName, paramName + " is not null");
        }
    }

    public static void greaterThanOrEqualToZero(long param, String paramName) throws IllegalArgumentException {
        if (0L > param) {
            ArgumentGuard.formatExceptionAndTrow(paramName, paramName + " < 0");
        }
    }

    public static void greaterThanZero(long param, String paramName) throws IllegalArgumentException {
        if (0L >= param) {
            ArgumentGuard.formatExceptionAndTrow(paramName, paramName + " < 1");
        }
    }

    public static void greaterThanZero(double param, String paramName) throws IllegalArgumentException {
        if (0.0 >= param) {
            ArgumentGuard.formatExceptionAndTrow(paramName, paramName + " < 1");
        }
    }

    public static void notZero(long param, String paramName) throws IllegalArgumentException {
        if (0L == param) {
            ArgumentGuard.formatExceptionAndTrow(paramName, paramName + " == 0");
        }
    }

    public static void isValidState(boolean isValid, String errMsg) throws IllegalStateException {
        if (!isValid) {
            ArgumentGuard.formatExceptionAndTrow(null, errMsg);
        }
    }

    private static void formatExceptionAndTrow(String paramName, String reason) throws IllegalArgumentException {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        StackTraceElement[] outElements = null;
        int k = 0;
        for (int i = 2; i < elements.length; ++i) {
            if (elements[i].getClassName().equals(ArgumentGuard.class.getCanonicalName())) {
                ++k;
                continue;
            }
            if (outElements == null) {
                outElements = new StackTraceElement[elements.length - k - 2];
            }
            outElements[i - k - 2] = elements[i];
        }
        String _className = outElements[0].getClassName();
        _className = _className.substring(_className.lastIndexOf(46) + 1);
        String errorMessage = paramName != null ? _className + " property name: " + paramName + " violates [" + reason + "]" : reason;
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(errorMessage);
        illegalArgumentException.setStackTrace(outElements);
        throw illegalArgumentException;
    }
}

