/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.common;

import android.graphics.Rect;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.espresso.fluent.Padding;
import java.util.Objects;

public class Region {
    public static final int FULL_WIDTH = 0;
    public static final Region EMPTY = new Region(0, 0, 0, 0);
    private int width;
    private int height;
    private int top;
    private int left;
    private String regionId;
    private Padding padding = new Padding();
    private boolean consumedPadding = false;

    private Region() {
    }

    public Region(Rect rect) {
        this.left = rect.left;
        this.top = rect.top;
        this.height = rect.height();
        this.width = rect.width();
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setPadding(Padding padding) {
        this.padding = padding;
    }

    public Region(Region other) {
        ArgumentGuard.notNull(other, "other");
        this.left = other.getLeft();
        this.top = other.getTop();
        this.width = other.getWidth();
        this.height = other.getHeight();
        this.regionId = other.getRegionId();
        this.padding = other.getPadding();
    }

    public Region(int width, int height, int top, int left) {
        ArgumentGuard.greaterThanOrEqualToZero(width, "width");
        ArgumentGuard.greaterThanOrEqualToZero(height, "height");
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
    }

    public Region(Region other, Padding padding) {
        this(other);
        this.padding = padding;
    }

    public Region(int width, int height, int top, int left, Padding padding) {
        this(width, height, top, left);
        this.padding = padding;
    }

    public void consumePadding() {
        if (this.consumedPadding) {
            throw new IllegalStateException("Padding already consumed by this region!");
        }
        this.top = this.getTop() - this.padding.getTop();
        this.left = this.getLeft() - this.padding.getLeft();
        this.width = this.getWidth() + this.padding.getLeft() + this.padding.getRight();
        this.height = this.getHeight() + this.padding.getTop() + this.padding.getBottom();
        this.consumedPadding = true;
    }

    void makeEmpty() {
        this.left = EMPTY.getLeft();
        this.top = EMPTY.getTop();
        this.width = EMPTY.getWidth();
        this.height = EMPTY.getHeight();
    }

    public Padding getPadding() {
        return this.padding;
    }

    public boolean isEmpty() {
        return this.getLeft() == EMPTY.getLeft() && this.getTop() == EMPTY.getTop() && this.getWidth() == EMPTY.getWidth() && this.getHeight() == EMPTY.getHeight();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getBottom() {
        return this.top + this.height;
    }

    public int getRight() {
        return this.left + this.width;
    }

    public Rect getRect() {
        return new Rect(this.left, this.top, this.left + this.width, this.top + this.height);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return this.width == region.width && this.height == region.height && this.top == region.top && this.left == region.left;
    }

    public void translate(int dx, int dy) {
        this.top += dy;
        this.left += dx;
    }

    public void scale(float scaleFactor) {
        this.top = (int)Math.floor((float)this.top * scaleFactor);
        this.left = (int)Math.floor((float)this.left * scaleFactor);
        this.width = (int)Math.ceil((float)this.width * scaleFactor);
        this.height = (int)Math.ceil((float)this.height * scaleFactor);
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height, this.top, this.left);
    }

    public String toString() {
        return "Region{width=" + this.width + ", height=" + this.height + ", top=" + this.top + ", left=" + this.left + ", regionId='" + this.regionId + '\'' + ", padding=" + this.padding + ", consumedPadding=" + this.consumedPadding + '}';
    }
}

