/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.core;

import com.applitools.eyes.android.common.AccessibilityRegionByRectangle;
import com.applitools.eyes.android.common.AppOutput;
import com.applitools.eyes.android.common.EyesScreenshot;
import com.applitools.eyes.android.common.FloatingMatchSettings;
import com.applitools.eyes.android.common.GetRegion;
import com.applitools.eyes.android.common.IEyesBase;
import com.applitools.eyes.android.common.IGetAccessibilityRegion;
import com.applitools.eyes.android.common.ImageMatchSettings;
import com.applitools.eyes.android.common.MatchResult;
import com.applitools.eyes.android.common.MatchWindowData;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.common.RegionProvider;
import com.applitools.eyes.android.common.RunningSession;
import com.applitools.eyes.android.common.config.IConfigurationGetter;
import com.applitools.eyes.android.common.exceptions.OutOfBoundsException;
import com.applitools.eyes.android.common.logger.Logger;
import com.applitools.eyes.android.common.network.RestClient;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.common.utils.GeneralUtils;
import com.applitools.eyes.android.core.AppOutputWithScreenshot;
import com.applitools.eyes.android.core.EyesBase;
import com.applitools.eyes.android.core.capture.AppOutputProvider;
import com.applitools.eyes.android.core.fluent.GetFloatingRegion;
import com.applitools.eyes.android.core.fluent.ICheckSettingsInternal;
import java.util.ArrayList;

public class MatchWindowTask {
    private static final int MATCH_INTERVAL = 500;
    public static Region cropRegion = Region.EMPTY;
    private final Logger mLogger;
    private final RestClient mRestClient;
    private final RunningSession mRunningSession;
    private final int mDefaultRetryTimeout;
    private final AppOutputProvider mAppOutputProvider;
    private EyesScreenshot mLastScreenshot = null;
    private MatchResult mMatchResult;
    private String lastScreenshotHash;

    public MatchWindowTask(Logger logger, RestClient restClient, RunningSession runningSession, int retryTimeout, AppOutputProvider appOutputProvider) {
        ArgumentGuard.notNull((Object)restClient, (String)"restClient");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.greaterThanOrEqualToZero((long)retryTimeout, (String)"retryTimeout");
        ArgumentGuard.notNull((Object)appOutputProvider, (String)"appOutputProvider");
        this.mLogger = logger;
        this.mRestClient = restClient;
        this.mRunningSession = runningSession;
        this.mDefaultRetryTimeout = retryTimeout;
        this.mAppOutputProvider = appOutputProvider;
    }

    protected MatchResult performMatch(AppOutputWithScreenshot appOutput, String tag, boolean replaceLast, ImageMatchSettings imageMatchSettings, String source) {
        MatchWindowData data = new MatchWindowData(appOutput.getAppOutput(), tag, false, new MatchWindowData.Options(tag, replaceLast, false, false, false, false, imageMatchSettings, source, null));
        return this.mRestClient.matchWindow(this.mRunningSession, data);
    }

    public MatchResult matchWindow(RegionProvider regionProvider, String tag, boolean shouldRunOnceOnTimeout, int retryTimeout, ICheckSettingsInternal checkSettingsInternal, EyesBase eyes, String source) {
        if (retryTimeout < 0) {
            retryTimeout = this.mDefaultRetryTimeout;
        }
        this.mLogger.verbose(String.format("retryTimeout = %d", retryTimeout));
        EyesScreenshot screenshot = this.takeScreenshot(regionProvider, tag, shouldRunOnceOnTimeout, retryTimeout, checkSettingsInternal, eyes, source);
        this.updateLastScreenshot(screenshot);
        return this.mMatchResult;
    }

    private static void collectSimpleRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesBase eyes) {
        imageMatchSettings.setIgnoreRegions(MatchWindowTask.adaptRegions(MatchWindowTask.collectRegions(checkSettingsInternal.getIgnoreRegions(), eyes)));
        imageMatchSettings.setLayoutRegions(MatchWindowTask.adaptRegions(MatchWindowTask.collectRegions(checkSettingsInternal.getLayoutRegions(), eyes)));
        imageMatchSettings.setStrictRegions(MatchWindowTask.adaptRegions(MatchWindowTask.collectRegions(checkSettingsInternal.getStrictRegions(), eyes)));
        imageMatchSettings.setContentRegions(MatchWindowTask.adaptRegions(MatchWindowTask.collectRegions(checkSettingsInternal.getContentRegions(), eyes)));
    }

    public static Region[] adaptRegions(Region[] regions) {
        int adaptTop = cropRegion.getTop();
        int adaptLeft = cropRegion.getLeft();
        for (int i = 0; i < regions.length; ++i) {
            Region adapted;
            regions[i] = adapted = new Region(regions[i].getWidth(), regions[i].getHeight(), regions[i].getTop() - adaptTop, regions[i].getLeft() - adaptLeft);
        }
        return regions;
    }

    private static Region[] collectRegions(GetRegion[] regionProviders, EyesBase eyes) {
        ArrayList regions = new ArrayList();
        for (GetRegion regionProvider : regionProviders) {
            try {
                regions.addAll(regionProvider.getRegions());
            }
            catch (OutOfBoundsException ex) {
                eyes.getLogger().log("WARNING - ignore region was out of bounds.");
            }
        }
        return regions.toArray(new Region[0]);
    }

    private static void collectFloatingRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesBase eyes) {
        ArrayList<FloatingMatchSettings> floatingRegions = new ArrayList<FloatingMatchSettings>();
        for (GetFloatingRegion floatingRegionProvider : checkSettingsInternal.getFloatingRegions()) {
            floatingRegions.addAll(floatingRegionProvider.getRegions(eyes));
        }
        imageMatchSettings.setFloatingRegions(floatingRegions.toArray(new FloatingMatchSettings[0]));
    }

    private static void collectAccessibilityRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesBase eyes) {
        ArrayList accessibilityRegions = new ArrayList();
        for (IGetAccessibilityRegion regionProvider : checkSettingsInternal.getAccessibilityRegions()) {
            accessibilityRegions.addAll(regionProvider.getRegions((IEyesBase)eyes));
        }
        imageMatchSettings.setAccessibility(accessibilityRegions.toArray(new AccessibilityRegionByRectangle[0]));
    }

    public static ImageMatchSettings createImageMatchSettings(ICheckSettingsInternal checkSettingsInternal, EyesBase eyes) {
        ImageMatchSettings imageMatchSettings = null;
        if (checkSettingsInternal != null) {
            IConfigurationGetter configGetter = eyes.getConfigurationProvider().get();
            ImageMatchSettings defaultMatchSettings = configGetter.getDefaultMatchSettings();
            imageMatchSettings = new ImageMatchSettings(defaultMatchSettings);
            imageMatchSettings.setMatchLevel(checkSettingsInternal.getMatchLevel() != null ? checkSettingsInternal.getMatchLevel() : defaultMatchSettings.getMatchLevel());
            imageMatchSettings.setIgnoreCaret(Boolean.valueOf(checkSettingsInternal.getIgnoreCaret() != null ? checkSettingsInternal.getIgnoreCaret().booleanValue() : configGetter.getIgnoreCaret()));
            imageMatchSettings.setEnablePatterns(checkSettingsInternal.isEnablePatterns() != null ? checkSettingsInternal.isEnablePatterns().booleanValue() : configGetter.getEnablePatterns());
            imageMatchSettings.setIgnoreDisplacements(checkSettingsInternal.getIgnoreDisplacements() != null ? checkSettingsInternal.getIgnoreDisplacements().booleanValue() : configGetter.getIgnoreDisplacements());
            imageMatchSettings.setAccessibilitySettings(configGetter.getAccessibilityValidation());
            imageMatchSettings.setDensitySettings(checkSettingsInternal.getDensitySettings());
            imageMatchSettings.setVariantId(checkSettingsInternal.getVariationGroupId());
            MatchWindowTask.collectSimpleRegions(checkSettingsInternal, imageMatchSettings, eyes);
            MatchWindowTask.collectFloatingRegions(checkSettingsInternal, imageMatchSettings, eyes);
            MatchWindowTask.collectAccessibilityRegions(checkSettingsInternal, imageMatchSettings, eyes);
        }
        return imageMatchSettings;
    }

    private EyesScreenshot takeScreenshot(RegionProvider regionProvider, String tag, boolean shouldMatchWindowRunOnceOnTimeout, int retryTimeout, ICheckSettingsInternal checkSettingsInternal, EyesBase eyes, String source) {
        EyesScreenshot screenshot;
        long elapsedTimeStart = System.currentTimeMillis();
        this.lastScreenshotHash = null;
        if (0 == retryTimeout || shouldMatchWindowRunOnceOnTimeout) {
            if (shouldMatchWindowRunOnceOnTimeout) {
                GeneralUtils.sleep((long)retryTimeout);
            }
            screenshot = this.tryTakeScreenshot(regionProvider, tag, checkSettingsInternal, eyes, source);
        } else {
            screenshot = this.retryTakingScreenshot(regionProvider, tag, checkSettingsInternal, retryTimeout, eyes, source);
        }
        double elapsedTime = (System.currentTimeMillis() - elapsedTimeStart) / 1000L;
        this.mLogger.verbose(String.format("Completed in %.2f seconds", elapsedTime));
        return screenshot;
    }

    private EyesScreenshot retryTakingScreenshot(RegionProvider regionProvider, String tag, ICheckSettingsInternal checkSettingsInternal, int retryTimeout, EyesBase eyes, String source) {
        long start = System.currentTimeMillis();
        EyesScreenshot screenshot = null;
        long retry = System.currentTimeMillis() - start;
        while (retry < (long)retryTimeout) {
            GeneralUtils.sleep((long)500L);
            screenshot = this.tryTakeScreenshot(regionProvider, tag, checkSettingsInternal, eyes, source);
            if (this.mMatchResult.getAsExpected()) break;
            retry = System.currentTimeMillis() - start;
        }
        if (!this.mMatchResult.getAsExpected()) {
            screenshot = this.tryTakeScreenshot(regionProvider, tag, checkSettingsInternal, eyes, source);
        }
        return screenshot;
    }

    private EyesScreenshot tryTakeScreenshot(RegionProvider regionProvider, String tag, ICheckSettingsInternal checkSettingsInternal, EyesBase eyes, String source) {
        Boolean includeAllLayers = null;
        boolean hideCaret = true;
        if (checkSettingsInternal != null) {
            includeAllLayers = checkSettingsInternal.getIncludeAllLayers();
            hideCaret = checkSettingsInternal.getHideCaret();
        }
        AppOutputWithScreenshot appOutput = this.mAppOutputProvider.getAppOutput(regionProvider, this.mLastScreenshot, checkSettingsInternal);
        EyesScreenshot screenshot = appOutput.getScreenshot();
        AppOutput output = appOutput.getAppOutput();
        String currentScreenshotHash = GeneralUtils.getSha256hash((byte[])output.getScreenshotBytes());
        if (currentScreenshotHash != null && currentScreenshotHash.equals(this.lastScreenshotHash)) {
            this.mLogger.log("Got the same screenshot in retry. Not sending to the server.");
            return screenshot;
        }
        ImageMatchSettings imageMatchSettings = MatchWindowTask.createImageMatchSettings(checkSettingsInternal, eyes);
        this.mMatchResult = this.performMatch(appOutput, tag, this.lastScreenshotHash != null, imageMatchSettings, source);
        this.lastScreenshotHash = currentScreenshotHash;
        return screenshot;
    }

    private void updateLastScreenshot(EyesScreenshot screenshot) {
        if (screenshot != null) {
            this.mLastScreenshot = screenshot;
        }
    }
}

