/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.core;

import com.applitools.eyes.android.common.TestResults;
import com.applitools.eyes.android.common.TestResultsSummary;

public class TestFailedException
extends AssertionError {
    private TestResults testResults = null;

    public TestFailedException(TestResults testResults, String message) {
        super((Object)message);
        this.testResults = testResults;
    }

    public TestFailedException(TestResultsSummary testResultsSummary, Throwable cause) {
        super(String.format("Test suite failed: %s", testResultsSummary), cause);
    }

    public TestFailedException(String message) {
        this(null, message);
    }

    public TestResults getTestResults() {
        return this.testResults;
    }

    public TestFailedException(TestResults testResults, String scenarioIdOrName, String appIdOrName) {
        super((Object)TestFailedException.formatTestResults(testResults, scenarioIdOrName, appIdOrName));
        this.testResults = testResults;
    }

    private static String formatTestResults(TestResults testResults, String scenarioIdOrName, String appIdOrName) {
        if (scenarioIdOrName == null || appIdOrName == null) {
            return "test execution failed";
        }
        return String.format("'%s' of '%s'. See details at %s", scenarioIdOrName, appIdOrName, testResults.getUrl());
    }
}

