/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.core;

import com.applitools.eyes.android.common.AbstractProxySettings;
import com.applitools.eyes.android.common.AppEnvironment;
import com.applitools.eyes.android.common.AppOutput;
import com.applitools.eyes.android.common.BatchInfo;
import com.applitools.eyes.android.common.EyesRunner;
import com.applitools.eyes.android.common.EyesScreenshot;
import com.applitools.eyes.android.common.IEyesBase;
import com.applitools.eyes.android.common.LatestCommitInfo;
import com.applitools.eyes.android.common.MatchResult;
import com.applitools.eyes.android.common.Properties;
import com.applitools.eyes.android.common.RectangleSize;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.common.RenderingInfo;
import com.applitools.eyes.android.common.RunningSession;
import com.applitools.eyes.android.common.SessionStartInfo;
import com.applitools.eyes.android.common.SessionType;
import com.applitools.eyes.android.common.TestResults;
import com.applitools.eyes.android.common.TestResultsStatus;
import com.applitools.eyes.android.common.config.IConfigurationProvider;
import com.applitools.eyes.android.common.exceptions.EyesException;
import com.applitools.eyes.android.common.logger.LogHandler;
import com.applitools.eyes.android.common.logger.Logger;
import com.applitools.eyes.android.common.network.ConnectionFactory;
import com.applitools.eyes.android.common.network.RestClient;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.common.utils.GeneralUtils;
import com.applitools.eyes.android.core.AppOutputWithScreenshot;
import com.applitools.eyes.android.core.ClassicRunner;
import com.applitools.eyes.android.core.DiffsFoundException;
import com.applitools.eyes.android.core.FailureReports;
import com.applitools.eyes.android.core.IBitmapProvider;
import com.applitools.eyes.android.core.MatchWindowTask;
import com.applitools.eyes.android.core.NewTestException;
import com.applitools.eyes.android.core.RegionProvider;
import com.applitools.eyes.android.core.TestFailedException;
import com.applitools.eyes.android.core.capture.AppOutputProvider;
import com.applitools.eyes.android.core.debug.DebugScreenshotsProvider;
import com.applitools.eyes.android.core.debug.FileDebugScreenshotsProvider;
import com.applitools.eyes.android.core.debug.NullDebugScreenshotProvider;
import com.applitools.eyes.android.core.fluent.ICheckSettings;
import com.applitools.eyes.android.core.fluent.ICheckSettingsInternal;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class EyesBase
implements IEyesBase {
    private boolean mIsDisabled;
    private boolean mIsOpen;
    private boolean mShouldMatchWindowRunOnceOnTimeout;
    private MatchWindowTask mMatchWindowTask;
    protected Logger mLogger;
    private RestClient mRestClient;
    private RunningSession mRunningSession;
    private SessionStartInfo mSessionStartInfo;
    protected Properties mProperties;
    protected EyesScreenshot mLastScreenshot;
    private FailureReports mFailureReports;
    private String mHostingAppInfo;
    private String mOsInfo;
    private String mDeviceInfo;
    private IConfigurationProvider mConfigurationProvider;
    protected DebugScreenshotsProvider debugScreenshotsProvider;
    protected EyesRunner eyesRunner = null;

    protected EyesBase(EyesRunner eyesRunner, URI serverUrl) {
        Object object = this.eyesRunner = eyesRunner != null ? eyesRunner : new ClassicRunner();
        if (this.mIsDisabled) {
            return;
        }
        ArgumentGuard.notNull((Object)serverUrl, (String)"serverUrl");
        this.mLogger = new Logger(Thread.currentThread().toString());
        this.mRestClient = ConnectionFactory.create((URI)serverUrl, (Logger)this.mLogger);
        this.mRunningSession = null;
        this.mProperties = new Properties();
        this.mFailureReports = FailureReports.ON_CLOSE;
        this.mLastScreenshot = null;
        this.mHostingAppInfo = null;
        this.mOsInfo = null;
        this.mDeviceInfo = null;
        this.debugScreenshotsProvider = new NullDebugScreenshotProvider();
    }

    public void setRestClient(RestClient restClient) {
        if (restClient != null) {
            this.mRestClient = restClient;
            this.mLogger.log("Null was passed to setRestClient()");
        }
    }

    protected void setConfigurationProvider(IConfigurationProvider configurationProvider) {
        this.mConfigurationProvider = configurationProvider;
    }

    public IConfigurationProvider getConfigurationProvider() {
        return this.mConfigurationProvider;
    }

    public void setApiKey(String apiKey) {
        ArgumentGuard.notNull((Object)apiKey, (String)"apiKey");
        this.mRestClient.setApiKey(apiKey);
    }

    public String getApiKey() {
        return this.mRestClient.getApiKey();
    }

    public static URI getDefaultServerUrl() {
        String serverUrl = GeneralUtils.getResourceProperty((String)"APPLITOOLS_SERVER_URL");
        try {
            return new URI(serverUrl != null ? serverUrl : "https://eyesapi.applitools.com");
        }
        catch (URISyntaxException ex) {
            throw new EyesException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void setServerUrl(URI serverUrl) {
        if (serverUrl == null) {
            this.mRestClient.setServerUrl(EyesBase.getDefaultServerUrl());
        } else {
            this.mRestClient.setServerUrl(serverUrl);
        }
    }

    public URI getServerUrl() {
        return this.mRestClient.getServerUrl();
    }

    public void setIsDisabled(boolean isDisabled) {
        this.mIsDisabled = isDisabled;
    }

    public boolean getIsDisabled() {
        return this.mIsDisabled;
    }

    public void setLogHandler(LogHandler logHandler) {
        this.mLogger.setLogHandler(logHandler);
    }

    public LogHandler getLogHandler() {
        return this.mLogger.getLogHandler();
    }

    public Logger getLogger() {
        return this.mLogger;
    }

    public String getFullAgentId() {
        String agentId = this.getConfigurationProvider().get().getAgentId();
        if (agentId == null) {
            return this.getBaseAgentId();
        }
        return String.format("%s [%s]", agentId, this.getBaseAgentId());
    }

    public String getHostingAppInfo() {
        return this.mHostingAppInfo;
    }

    public void setHostingAppInfo(String hostingAppInfo) {
        this.mHostingAppInfo = hostingAppInfo;
    }

    public String getOsInfo() {
        return this.mOsInfo;
    }

    public void setOsInfo(String osInfo) {
        this.mOsInfo = osInfo;
    }

    public String getDeviceInfo() {
        return this.mDeviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.mDeviceInfo = deviceInfo;
    }

    protected void openBase(String appName, String testName, RectangleSize viewportSize, SessionType sessionType) {
        this.getConfigurationProvider().set().setAppName(appName);
        this.getConfigurationProvider().set().setTestName(testName);
        this.getConfigurationProvider().set().setViewportSize(viewportSize);
        this.getConfigurationProvider().set().setSessionType(sessionType);
        this.openBase();
    }

    protected void openBase() {
        try {
            if (this.mIsDisabled) {
                this.mLogger.verbose("Ignored");
                return;
            }
            this.mLogger.log("Agent = " + this.getFullAgentId());
            this.mLogger.verbose(String.format("openBase('%s', '%s', '%s')", this.getConfigurationProvider().get().getAppName(), this.getConfigurationProvider().get().getTestName(), this.getConfigurationProvider().get().getViewportSize()));
            this.mRestClient.setAgentId(this.getFullAgentId());
            this.validateApiKey();
            this.logOpenBase();
            this.validateSessionOpen();
            if (this.getConfigurationProvider().get().getSessionType() == null) {
                this.getConfigurationProvider().set().setSessionType(SessionType.SEQUENTIAL);
            }
            this.mIsOpen = true;
        }
        catch (EyesException e) {
            this.mLogger.log(String.format("%s", e.getMessage()));
            this.mLogger.getLogHandler().close();
            throw e;
        }
    }

    private void ensureRunningSession(RegionProvider regionProvider, ICheckSettings checkSettings) {
        if (this.mRunningSession != null) {
            return;
        }
        this.mLogger.log("No running session, calling start session...");
        this.startSession(regionProvider);
        this.mLogger.log("Done!");
        this.mMatchWindowTask = new MatchWindowTask(this.mLogger, this.mRestClient, this.mRunningSession, this.getConfigurationProvider().get().getMatchTimeout(), new AppOutputProvider(){

            @Override
            public AppOutputWithScreenshot getAppOutput(RegionProvider regionProvider, EyesScreenshot lastScreenshot, ICheckSettingsInternal iCheckSettingsInternal) {
                return EyesBase.this.getAppOutputWithScreenshot(regionProvider, lastScreenshot, iCheckSettingsInternal);
            }
        });
    }

    private void validateApiKey() {
        if (this.getApiKey() == null) {
            String errMsg = "API key is missing! Please set it using setApiKey()";
            this.mLogger.log(errMsg);
            throw new EyesException(errMsg);
        }
    }

    private void logOpenBase() {
        this.mLogger.log(String.format("Eyes server URL is '%s'", this.mRestClient.getServerUrl()));
        this.mLogger.log(String.format("Default match settings = '%s' ", this.getConfigurationProvider().get().getDefaultMatchSettings()));
        this.mLogger.log(String.format("FailureReports = '%s' ", new Object[]{this.mFailureReports}));
    }

    private void validateSessionOpen() {
        if (this.mIsDisabled) {
            this.abortIfNotClosed();
            String errMsg = "A test is already running";
            this.mLogger.log(errMsg);
            throw new EyesException(errMsg);
        }
    }

    protected void startSession(RegionProvider regionProvider) {
        this.mLogger.verbose("startSession()");
        BatchInfo testBatch = this.getConfigurationProvider().get().getBatch();
        if (testBatch == null) {
            this.mLogger.verbose("No batch set");
            testBatch = new BatchInfo(null);
            this.getConfigurationProvider().set().setBatch(new BatchInfo(null));
        } else {
            this.mLogger.verbose("Batch is " + testBatch);
        }
        AppEnvironment appEnv = this.getAppEnvironment();
        this.mLogger.verbose("Application environment is " + appEnv);
        this.mSessionStartInfo = new SessionStartInfo(this.getBaseAgentId(), this.getConfigurationProvider().get().getSessionType(), this.getConfigurationProvider().get().getAppName(), null, this.getConfigurationProvider().get().getTestName(), testBatch, this.getConfigurationProvider().get().getEnvironmentName(), appEnv, this.getConfigurationProvider().get().getBaselineEnvName(), this.getConfigurationProvider().get().getDefaultMatchSettings(), this.getConfigurationProvider().get().getBranchName(), this.getConfigurationProvider().get().getParentBranchName(), this.getConfigurationProvider().get().getBaselineBranchName(), this.getConfigurationProvider().get().getSaveDiffs(), this.mProperties, this.getParentBranchBaselineSavedBefore(), this.getLatestCommitInfo());
        this.mLogger.verbose("Starting server session...");
        this.mRunningSession = this.mRestClient.startSession(this.mSessionStartInfo);
        this.mLogger.verbose("Server session ID is " + this.mRunningSession.getId());
        String testInfo = "'" + this.getConfigurationProvider().get().getTestName() + "' of '" + this.getConfigurationProvider().get().getAppName() + "' " + appEnv;
        if (this.mRunningSession.getIsNewSession()) {
            this.mLogger.log("--- New test started - " + testInfo);
        } else {
            this.mLogger.log("--- Test started - " + testInfo);
        }
    }

    public TestResults close() {
        return this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResults close(boolean throwEx) {
        try {
            if (this.mIsDisabled) {
                this.mLogger.verbose("Ignored");
                TestResults testResults = null;
                return testResults;
            }
            this.mLogger.verbose(String.format("close(%b)", throwEx));
            ArgumentGuard.isValidState((boolean)this.mIsOpen, (String)"Eyes not open");
            this.mIsOpen = false;
            this.mLastScreenshot = null;
            if (this.mRunningSession == null) {
                this.mLogger.verbose("Server session was not started");
                this.mLogger.log("--- Empty test ended.");
                TestResults testResults = new TestResults();
                return testResults;
            }
            boolean isNewSession = this.mRunningSession.getIsNewSession();
            String sessionResultsUrl = this.mRunningSession.getUrl();
            this.mLogger.verbose("Ending server session...");
            boolean save = isNewSession && this.getConfigurationProvider().get().getSaveNewTests() || !isNewSession && this.getConfigurationProvider().get().getSaveFailedTests();
            this.mLogger.verbose("Automatically save test? " + String.valueOf(save));
            TestResults results = this.mRestClient.stopSession(this.mRunningSession, false, save);
            results.setNew(isNewSession);
            results.setUrl(sessionResultsUrl);
            this.mLogger.verbose(results.toString());
            if (!(isNewSession || 0 >= results.getMismatches() && 0 >= results.getMissing())) {
                this.mLogger.log("--- Failed test ended. See details at " + sessionResultsUrl);
                if (results.isDifferent() && throwEx) {
                    String message = "Test '" + results.getName() + "' of '" + results.getAppName() + "' detected differences!. See details at " + sessionResultsUrl;
                    throw new DiffsFoundException(results, message);
                }
                if (throwEx) {
                    String message = "'" + this.mSessionStartInfo.getScenarioIdOrName() + "' of '" + this.mSessionStartInfo.getAppIdOrName() + "'. See details at " + sessionResultsUrl;
                    throw new TestFailedException(results, message);
                }
                TestResults message = results;
                return message;
            }
            if (isNewSession) {
                String instructions = "Please approve the new baseline at " + sessionResultsUrl;
                this.mLogger.log("--- New test ended. " + instructions);
                if (throwEx && !this.getConfigurationProvider().get().getSaveNewTests()) {
                    String message = "'" + this.mSessionStartInfo.getScenarioIdOrName() + "' of '" + this.mSessionStartInfo.getAppIdOrName() + "'. " + instructions;
                    throw new NewTestException(results, message);
                }
                TestResults testResults = results;
                return testResults;
            }
            this.mLogger.log("--- Test passed. See details at " + sessionResultsUrl);
            TestResults testResults = results;
            return testResults;
        }
        finally {
            this.mRunningSession = null;
        }
    }

    protected abstract RectangleSize getViewportSize();

    public boolean getIsOpen() {
        return this.mIsOpen;
    }

    public void setBatch(BatchInfo batch) {
        if (this.mIsDisabled) {
            this.mLogger.verbose("Ignored");
            return;
        }
        this.mLogger.verbose("setBatch(" + batch + ")");
        this.getConfigurationProvider().set().setBatch(batch);
    }

    protected AppEnvironment getAppEnvironment() {
        AppEnvironment appEnv = new AppEnvironment();
        appEnv.setOs(this.getOsName());
        String hostApp = this.getConfigurationProvider().get().getHostApp();
        if (hostApp == null) {
            appEnv.setHostingApp(this.getConfigurationProvider().get().getAppName());
        } else {
            appEnv.setHostingApp(hostApp);
        }
        appEnv.setDisplaySize(this.getConfigurationProvider().get().getViewportSize() != null ? this.getConfigurationProvider().get().getViewportSize() : this.getViewportSize());
        if (this.mDeviceInfo == null) {
            this.mDeviceInfo = this.getDeviceModel();
        }
        appEnv.setHostingAppInfo(this.mHostingAppInfo);
        appEnv.setOsInfo(this.mOsInfo);
        appEnv.setDeviceInfo(this.mDeviceInfo);
        return appEnv;
    }

    public TestResults abortIfNotClosed() {
        try {
            if (this.mIsDisabled) {
                TestResults testResults = new TestResults();
                testResults.setStatus(TestResultsStatus.Disabled);
                TestResults testResults2 = testResults;
                return testResults2;
            }
            this.mIsOpen = false;
            this.mLastScreenshot = null;
            if (null == this.mRunningSession) {
                this.mLogger.verbose("Closed");
                TestResults testResults = new TestResults();
                testResults.setStatus(TestResultsStatus.NotOpened);
                TestResults testResults3 = testResults;
                return testResults3;
            }
            this.mLogger.verbose("Aborting server session...");
            try {
                this.mRestClient.stopSession(this.mRunningSession, true, false);
                this.mLogger.log("--- Test aborted.");
            }
            catch (EyesException ex) {
                this.mLogger.log("Failed to abort server session: " + ex.getMessage());
            }
        }
        finally {
            this.mRunningSession = null;
        }
        return null;
    }

    protected MatchResult checkWindowBase(RegionProvider regionProvider, String tag, boolean ignoreMismatch, ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            this.mLogger.verbose("Ignored");
            MatchResult result = new MatchResult();
            result.setAsExpected(true);
            return result;
        }
        if (tag == null) {
            tag = "";
        }
        ArgumentGuard.isValidState((boolean)this.getIsOpen(), (String)"Eyes not open");
        ArgumentGuard.notNull((Object)regionProvider, (String)"regionProvider");
        this.ensureRunningSession(regionProvider, checkSettings);
        String appName = this.getConfigurationProvider().get().getAppName();
        if (appName == null) {
            try {
                appName = this.getApplicationNameFromPackage();
            }
            catch (Exception e) {
                throw new EyesException("Please verify activity is launched or provide AppName");
            }
            this.getConfigurationProvider().set().setAppName(appName);
        }
        String source = appName;
        MatchResult result = this.matchWindow(regionProvider, tag, checkSettings, source);
        this.mLogger.verbose("MatchWindow Done!");
        if (!ignoreMismatch) {
            this.mLastScreenshot = result.getScreenshot();
        }
        this.validateResult(tag, result);
        this.mLogger.verbose("Done!");
        return result;
    }

    private MatchResult matchWindow(RegionProvider regionProvider, String tag, ICheckSettings checkSettings, String source) {
        ICheckSettingsInternal checkSettingsInternal = checkSettings instanceof ICheckSettingsInternal ? (ICheckSettingsInternal)((Object)checkSettings) : null;
        int retryTimeout = -1;
        if (checkSettingsInternal != null) {
            retryTimeout = checkSettingsInternal.getTimeout();
        }
        this.mLogger.verbose(String.format("CheckWindowBase(%s, '%s', %d)", regionProvider.getClass(), tag, retryTimeout));
        this.ensureRunningSession(regionProvider, checkSettings);
        this.mLogger.verbose("Calling match window...");
        MatchResult result = this.mMatchWindowTask.matchWindow(regionProvider, tag, this.mShouldMatchWindowRunOnceOnTimeout, retryTimeout, checkSettingsInternal, this, source);
        return result;
    }

    private void validateResult(String tag, MatchResult result) {
        if (result.getAsExpected()) {
            return;
        }
        this.mShouldMatchWindowRunOnceOnTimeout = true;
        if (!this.mRunningSession.getIsNewSession()) {
            this.mLogger.log(String.format("Mismatch! (%s)", tag));
        }
        if (this.getFailureReports() == FailureReports.IMMEDIATE) {
            throw new TestFailedException(String.format("Mismatch found in '%s' of '%s'", this.mSessionStartInfo.getScenarioIdOrName(), this.mSessionStartInfo.getAppIdOrName()));
        }
    }

    public void setFailureReports(FailureReports failureReports) {
        this.mFailureReports = failureReports;
    }

    protected void setProxy(AbstractProxySettings proxySettings) {
        this.mRestClient.setProxySettings(proxySettings);
    }

    public FailureReports getFailureReports() {
        return this.mFailureReports;
    }

    protected abstract EyesScreenshot getScreenshot(ICheckSettingsInternal var1);

    protected abstract EyesScreenshot getScreenshot(byte[] var1);

    protected abstract String getTitle();

    protected abstract String getDeviceModel();

    protected abstract String getOsName();

    protected abstract String getApplicationNameFromPackage();

    protected abstract String getParentBranchBaselineSavedBefore();

    protected abstract LatestCommitInfo getLatestCommitInfo();

    private AppOutputWithScreenshot getAppOutputWithScreenshot(RegionProvider regionProvider, EyesScreenshot lastScreenshot, ICheckSettingsInternal checkSettingsInternal) {
        byte[] image;
        this.mLogger.verbose("getting screenshot...");
        EyesScreenshot screenshot = null;
        if (!(regionProvider instanceof IBitmapProvider)) {
            screenshot = this.getScreenshot(checkSettingsInternal);
            this.mLogger.verbose("Done getting screenshot!");
        }
        Region region = regionProvider.getRegion();
        if (screenshot != null && !region.isEmpty()) {
            screenshot = screenshot.getSubScreenshot(region);
            this.debugScreenshotsProvider.save(screenshot.getImage(), "SUB_SCREENSHOT");
        }
        if ((image = regionProvider.getImage(screenshot == null ? null : screenshot.getImage())) != null) {
            screenshot = this.getScreenshot(image);
            this.debugScreenshotsProvider.save(screenshot.getImage(), "SCREENSHOT");
        }
        screenshot = this.cropIfNeeded(screenshot);
        this.mLogger.verbose("Done! Getting title...");
        String title = regionProvider instanceof IBitmapProvider ? "" : this.getTitle();
        this.mLogger.verbose("Done!");
        AppOutputWithScreenshot result = new AppOutputWithScreenshot(new AppOutput(title, screenshot.getImage(), regionProvider.getLocation()), screenshot);
        this.debugScreenshotsProvider.save(result.getScreenshot().getImage(), "RESULT");
        this.mLogger.verbose("Done!");
        return result;
    }

    private EyesScreenshot cropIfNeeded(EyesScreenshot screenshot) {
        RenderingInfo renderInfo = this.mRestClient.getRenderingInfo();
        int maxImageHeight = renderInfo.getMaxImageHeight();
        int maxImageArea = renderInfo.getMaxImageArea();
        if (screenshot.getHeight() <= maxImageHeight && screenshot.getWidth() * screenshot.getHeight() <= maxImageArea) {
            return screenshot;
        }
        int trimmedHeight = Math.min(maxImageArea / screenshot.getWidth(), maxImageHeight);
        Region newRegion = new Region(screenshot.getWidth(), trimmedHeight, 0, 0);
        if (newRegion.isEmpty()) {
            return screenshot;
        }
        screenshot = screenshot.getSubScreenshot(newRegion);
        this.debugScreenshotsProvider.save(screenshot.getImage(), "CROPPED");
        return screenshot;
    }

    public static void logSessionResultsAndThrowException(Logger logger, boolean throwEx, TestResults results) {
        TestResultsStatus status = results.getStatus();
        String sessionResultsUrl = results.getUrl();
        String scenarioIdOrName = results.getName();
        String appIdOrName = results.getAppName();
        if (status == TestResultsStatus.Unresolved) {
            if (results.isNew()) {
                logger.log("--- New test ended. Please approve the new baseline at " + sessionResultsUrl);
                if (throwEx) {
                    throw new NewTestException(results, scenarioIdOrName, appIdOrName);
                }
            } else {
                logger.log("--- Failed test ended. See details at " + sessionResultsUrl);
                if (throwEx) {
                    throw new DiffsFoundException(results, scenarioIdOrName, appIdOrName);
                }
            }
        } else if (status == TestResultsStatus.Failed) {
            logger.log("--- Failed test ended. See details at " + sessionResultsUrl);
            if (throwEx) {
                throw new TestFailedException(results, scenarioIdOrName, appIdOrName);
            }
        } else {
            logger.log("--- Test passed. See details at " + sessionResultsUrl);
        }
    }

    protected void doCloseBatch(String batchId) {
        this.mRestClient.closeBatch(batchId);
    }

    public void setSaveDebugScreenshots(boolean saveDebugScreenshots) {
        DebugScreenshotsProvider prev = this.debugScreenshotsProvider;
        this.debugScreenshotsProvider = saveDebugScreenshots ? new FileDebugScreenshotsProvider(this.mLogger) : new NullDebugScreenshotProvider();
        this.debugScreenshotsProvider.setPrefix(prev.getPrefix());
        String screenShotsPath = prev.getPath();
        if (prev.getPath() == null || prev.getPath().isEmpty()) {
            screenShotsPath = this.getDefaultDebugScreenshotPath();
        }
        this.debugScreenshotsProvider.setPath(screenShotsPath);
    }

    public boolean getSaveDebugScreenshots() {
        return !(this.debugScreenshotsProvider instanceof NullDebugScreenshotProvider);
    }

    public void setDebugScreenshotsPath(String pathToSave) {
        this.debugScreenshotsProvider.setPath(pathToSave);
    }

    public String getDebugScreenshotsPath() {
        return this.debugScreenshotsProvider.getPath();
    }

    public void setDebugScreenshotsPrefix(String prefix) {
        this.debugScreenshotsProvider.setPrefix(prefix);
    }

    public String getDebugScreenshotsPrefix() {
        return this.debugScreenshotsProvider.getPrefix();
    }

    public DebugScreenshotsProvider getDebugScreenshotsProvider() {
        return this.debugScreenshotsProvider;
    }

    protected abstract String getDefaultDebugScreenshotPath();

    protected abstract String getBaseAgentId();
}

