/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.core.debug;

import com.applitools.eyes.android.common.exceptions.EyesException;
import com.applitools.eyes.android.common.logger.Logger;
import com.applitools.eyes.android.core.debug.DebugScreenshotsProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileDebugScreenshotsProvider
extends DebugScreenshotsProvider {
    private final Logger logger;

    public FileDebugScreenshotsProvider(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void save(byte[] image, String suffix) {
        String filename = this.getPath() + this.getPrefix() + this.getFormattedTimeStamp() + "_" + suffix + ".png";
        this.saveImage(image, filename);
    }

    private void saveImage(byte[] image, String filename) {
        try {
            this.logger.verbose("Saving file: " + filename);
            File file = new File(filename);
            File path = file.getParentFile();
            if (path != null && !path.exists()) {
                this.logger.log("No Folder " + path.getAbsolutePath());
                boolean success = path.mkdirs();
                this.logger.log("Folder created");
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(image);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new EyesException("Failed to save image", (Throwable)e);
        }
    }
}

