/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.core.fluent;

import com.applitools.eyes.android.common.AccessibilityRegionByRectangle;
import com.applitools.eyes.android.common.AccessibilityRegionType;
import com.applitools.eyes.android.common.DensitySettings;
import com.applitools.eyes.android.common.IGetAccessibilityRegion;
import com.applitools.eyes.android.common.MatchLevel;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.core.fluent.FloatingRegionByRectangle;
import com.applitools.eyes.android.core.fluent.GetFloatingRegion;
import com.applitools.eyes.android.core.fluent.GetRegion;
import com.applitools.eyes.android.core.fluent.ICheckSettings;
import com.applitools.eyes.android.core.fluent.ICheckSettingsInternal;
import com.applitools.eyes.android.core.fluent.IgnoreRegionByRectangle;
import java.util.ArrayList;
import java.util.List;

public class CheckSettings<ITarget extends ICheckSettings>
implements ICheckSettings<ITarget>,
ICheckSettingsInternal {
    public static final boolean DEFAULT_HIDE_CARET = true;
    public static final boolean DEFAULT_INCLUDE_ALL_LAYERS = false;
    private Region targetRegion;
    private MatchLevel matchLevel;
    private Boolean ignoreCaret;
    private Boolean ignoreDisplacements = null;
    private Boolean includeAllLayers = null;
    private Boolean hideCaret = null;
    private boolean stitchContent = false;
    private Boolean fullpageScreenshot = null;
    private List<GetRegion> ignoreRegions = new ArrayList<GetRegion>();
    private List<GetRegion> layoutRegions = new ArrayList<GetRegion>();
    private List<GetRegion> strictRegions = new ArrayList<GetRegion>();
    private List<GetRegion> contentRegions = new ArrayList<GetRegion>();
    private List<GetFloatingRegion> floatingRegions = new ArrayList<GetFloatingRegion>();
    private int timeout = -1;
    private String name;
    private String variationGroupId = null;
    protected List<IGetAccessibilityRegion> accessibilityRegions = new ArrayList<IGetAccessibilityRegion>();
    protected Boolean enablePatterns = null;

    protected CheckSettings() {
    }

    protected CheckSettings(Region region) {
        this.targetRegion = region;
    }

    public CheckSettings(int timeout) {
        this.timeout = timeout;
    }

    protected void ignore(Region region) {
        this.ignore(new IgnoreRegionByRectangle(region));
    }

    protected void ignore(GetRegion regionProvider) {
        this.ignoreRegions.add(regionProvider);
    }

    protected void layout(Region region) {
        this.layout(new IgnoreRegionByRectangle(region));
    }

    protected void layout(GetRegion regionProvider) {
        this.layoutRegions.add(regionProvider);
    }

    protected void content(Region region) {
        this.content(new IgnoreRegionByRectangle(region));
    }

    protected void content(GetRegion regionProvider) {
        this.contentRegions.add(regionProvider);
    }

    protected void strict(Region region) {
        this.strict(new IgnoreRegionByRectangle(region));
    }

    protected void strict(GetRegion regionProvider) {
        this.strictRegions.add(regionProvider);
    }

    protected void floating_(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.floatingRegions.add(new FloatingRegionByRectangle(new Region(region.getWidth(), region.getHeight(), region.getTop(), region.getLeft()), maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
    }

    protected void floating(GetFloatingRegion regionProvider) {
        this.floatingRegions.add(regionProvider);
    }

    public ITarget clone() {
        CheckSettings<ITarget> clone = new CheckSettings<ITarget>();
        this.populateClone(clone);
        return (ITarget)clone;
    }

    @Override
    public ITarget ignore(Region region, Region ... regions) {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.ignore(region);
        for (Region r : regions) {
            clone.ignore(r);
        }
        return (ITarget)clone;
    }

    @Override
    public ITarget layout(Region region, Region ... regions) {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.layout(region);
        for (Region r : regions) {
            clone.layout(r);
        }
        return (ITarget)clone;
    }

    @Override
    public ITarget strict(Region region, Region ... regions) {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.strict(region);
        for (Region r : regions) {
            clone.strict(r);
        }
        return (ITarget)clone;
    }

    @Override
    public ITarget content(Region region, Region ... regions) {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.content(region);
        for (Region r : regions) {
            clone.content(r);
        }
        return (ITarget)clone;
    }

    @Override
    public ITarget fully() {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.stitchContent = true;
        clone.fullpageScreenshot = true;
        return (ITarget)clone;
    }

    @Override
    public ITarget fully(boolean fully) {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.stitchContent = fully;
        clone.fullpageScreenshot = fully;
        return (ITarget)clone;
    }

    @Override
    public ITarget floating(int maxOffset, Region ... regions) {
        CheckSettings clone = (CheckSettings)this.clone();
        for (Region r : regions) {
            clone.floating_(r, maxOffset, maxOffset, maxOffset, maxOffset);
        }
        return (ITarget)clone;
    }

    @Override
    public ITarget floating(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.floating_(region, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset);
        return (ITarget)clone;
    }

    @Override
    public ITarget timeout(int timeoutMilliseconds) {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.timeout = timeoutMilliseconds;
        return (ITarget)clone;
    }

    @Override
    public ITarget layout() {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.matchLevel = MatchLevel.LAYOUT;
        return (ITarget)clone;
    }

    @Override
    public ITarget exact() {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.matchLevel = MatchLevel.EXACT;
        return (ITarget)clone;
    }

    @Override
    public ITarget strict() {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.matchLevel = MatchLevel.STRICT;
        return (ITarget)clone;
    }

    @Override
    @Deprecated
    public ITarget content() {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.matchLevel = MatchLevel.CONTENT;
        return (ITarget)clone;
    }

    @Override
    public ITarget ignoreColors() {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.matchLevel = MatchLevel.IGNORE_COLORS;
        return (ITarget)clone;
    }

    @Override
    public ITarget matchLevel(MatchLevel matchLevel) {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.matchLevel = matchLevel;
        return (ITarget)clone;
    }

    @Override
    public ITarget ignoreCaret(boolean ignoreCaret) {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.ignoreCaret = ignoreCaret;
        return (ITarget)clone;
    }

    @Override
    public ITarget ignoreCaret() {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.ignoreCaret = true;
        return (ITarget)clone;
    }

    @Override
    public ITarget withName(String name) {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.name = name;
        return (ITarget)clone;
    }

    @Override
    public ITarget hideCaret() {
        this.hideCaret = true;
        return (ITarget)this;
    }

    @Override
    public ITarget hideCaret(boolean hideCaret) {
        this.hideCaret = hideCaret;
        return (ITarget)this;
    }

    @Override
    public ITarget includeAllLayers() {
        this.includeAllLayers = true;
        return (ITarget)this;
    }

    @Override
    public ITarget includeAllLayers(boolean includeAllLayers) {
        this.includeAllLayers = includeAllLayers;
        return (ITarget)this;
    }

    @Override
    public ITarget ignoreDisplacements() {
        this.ignoreDisplacements = true;
        return (ITarget)this;
    }

    @Override
    public ITarget ignoreDisplacements(boolean ignoreDisplacements) {
        this.ignoreDisplacements = ignoreDisplacements;
        return (ITarget)this;
    }

    @Override
    public ITarget accessibility(Region region, AccessibilityRegionType regionType) {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.accessibility_(region, regionType);
        return (ITarget)clone;
    }

    @Override
    public ITarget enablePatterns(boolean enablePatterns) {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.enablePatterns = enablePatterns;
        return (ITarget)clone;
    }

    @Override
    public ITarget enablePatterns() {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.enablePatterns = true;
        return (ITarget)clone;
    }

    @Override
    public ITarget variationGroupId(String variationGroupId) {
        CheckSettings clone = (CheckSettings)this.clone();
        clone.variationGroupId = variationGroupId;
        return (ITarget)clone;
    }

    protected void accessibility_(IGetAccessibilityRegion accessibilityRegionProvider) {
        this.accessibilityRegions.add(accessibilityRegionProvider);
    }

    protected void accessibility_(Region rect, AccessibilityRegionType regionType) {
        this.accessibility_((IGetAccessibilityRegion)new AccessibilityRegionByRectangle(rect, regionType));
    }

    @Override
    public Region getTargetRegion() {
        return this.targetRegion;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean getStitchContent() {
        return this.stitchContent;
    }

    @Override
    public Boolean getFullpageScreenshot() {
        return this.fullpageScreenshot;
    }

    @Override
    public MatchLevel getMatchLevel() {
        return this.matchLevel;
    }

    @Override
    public GetRegion[] getIgnoreRegions() {
        return this.ignoreRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getStrictRegions() {
        return this.strictRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getLayoutRegions() {
        return this.layoutRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetRegion[] getContentRegions() {
        return this.contentRegions.toArray(new GetRegion[0]);
    }

    @Override
    public GetFloatingRegion[] getFloatingRegions() {
        return this.floatingRegions.toArray(new GetFloatingRegion[0]);
    }

    @Override
    public Boolean getIgnoreCaret() {
        return this.ignoreCaret;
    }

    @Override
    public boolean getHideCaret() {
        return this.getHideCaret(null);
    }

    @Override
    public boolean getHideCaret(Boolean defaultValue) {
        if (this.hideCaret == null) {
            return defaultValue == null ? true : defaultValue;
        }
        return this.hideCaret;
    }

    @Override
    public boolean getIncludeAllLayers() {
        return this.getIncludeAllLayers(null);
    }

    @Override
    public boolean getIncludeAllLayers(Boolean defaultValue) {
        if (this.includeAllLayers == null) {
            return defaultValue == null ? false : defaultValue;
        }
        return this.includeAllLayers;
    }

    @Override
    public Boolean getIgnoreDisplacements() {
        return this.ignoreDisplacements;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Boolean isEnablePatterns() {
        return this.enablePatterns;
    }

    @Override
    public DensitySettings getDensitySettings() {
        return null;
    }

    @Override
    public String getVariationGroupId() {
        return this.variationGroupId;
    }

    @Override
    public IGetAccessibilityRegion[] getAccessibilityRegions() {
        return this.accessibilityRegions.toArray(new IGetAccessibilityRegion[0]);
    }

    protected void updateTargetRegion(Region region) {
        this.targetRegion = region;
    }

    protected void populateClone(CheckSettings clone) {
        clone.targetRegion = this.targetRegion;
        clone.matchLevel = this.matchLevel;
        clone.stitchContent = this.stitchContent;
        clone.timeout = this.timeout;
        clone.ignoreCaret = this.ignoreCaret;
        clone.ignoreDisplacements = this.ignoreDisplacements;
        clone.name = this.name;
        clone.includeAllLayers = this.includeAllLayers;
        clone.hideCaret = this.hideCaret;
        clone.variationGroupId = this.variationGroupId;
        clone.ignoreRegions.addAll(this.ignoreRegions);
        clone.contentRegions.addAll(this.contentRegions);
        clone.layoutRegions.addAll(this.layoutRegions);
        clone.strictRegions.addAll(this.strictRegions);
        clone.floatingRegions.addAll(this.floatingRegions);
        clone.accessibilityRegions = this.accessibilityRegions;
        clone.enablePatterns = this.enablePatterns;
        clone.fullpageScreenshot = this.fullpageScreenshot;
    }
}

