/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso;

import android.graphics.Bitmap;
import android.graphics.Rect;
import com.applitools.eyes.android.common.Location;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.common.exceptions.EyesException;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.espresso.AbstractBitmapProvider;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class BitmapProvider
extends AbstractBitmapProvider {
    private final byte[] bitmapBytes;
    private final Region targetRegion;

    public BitmapProvider(Bitmap bitmap) {
        this(bitmap, null);
    }

    public BitmapProvider(Bitmap bitmap, Region targetRegion) {
        this(bitmap, Bitmap.CompressFormat.PNG, 100, targetRegion);
    }

    private BitmapProvider(Bitmap bitmap, Bitmap.CompressFormat compressFormat, int quality, Region region) {
        try {
            ArgumentGuard.notNull((Object)bitmap, (String)"Target bitmap");
            ByteArrayOutputStream os = new ByteArrayOutputStream(bitmap.getByteCount());
            this.targetRegion = this.getAndAlignedRegion(bitmap, region);
            if (!this.targetRegion.isEmpty()) {
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)this.targetRegion.getLeft(), (int)this.targetRegion.getTop(), (int)this.targetRegion.getWidth(), (int)this.targetRegion.getHeight());
            }
            if (!bitmap.compress(compressFormat, quality, (OutputStream)os)) {
                throw new Exception("Unable to compress bitmap");
            }
            this.bitmapBytes = os.toByteArray();
        }
        catch (Exception e) {
            throw new EyesException("Error processing bitmap", (Throwable)e);
        }
    }

    private Region getAndAlignedRegion(Bitmap bitmap, Region targetRegion) {
        if (targetRegion == null) {
            return new Region(bitmap.getWidth(), bitmap.getHeight(), 0, 0);
        }
        if (targetRegion.isEmpty()) {
            return Region.EMPTY;
        }
        Rect targetRect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        if (!targetRect.intersect(targetRegion.getLeft(), targetRegion.getTop(), targetRegion.getWidth() + targetRegion.getLeft(), targetRegion.getHeight() + targetRegion.getTop())) {
            return Region.EMPTY;
        }
        return new Region(targetRect.width(), targetRect.height(), targetRect.top, targetRect.left);
    }

    public byte[] getImage(byte[] screenshotImage) {
        return this.bitmapBytes;
    }

    @Override
    public Region getRegion() {
        return Region.EMPTY;
    }

    public Location getLocation() {
        return new Location(0, 0);
    }
}

