/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import com.applitools.eyes.android.common.LazyLoadOptions;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.common.ScreenshotMode;
import com.applitools.eyes.android.common.config.IConfigurationProvider;
import com.applitools.eyes.android.common.logger.Logger;
import com.applitools.eyes.android.components.IComponentsProvider;
import com.applitools.eyes.android.components.Insets;
import com.applitools.eyes.android.core.ScreenshotProvider;
import com.applitools.eyes.android.core.debug.DebugScreenshotsProvider;
import com.applitools.eyes.android.espresso.fluent.IEspressoCheckInternal;
import com.applitools.eyes.android.espresso.fluent.OVERLAP_EDGE;
import com.applitools.eyes.android.espresso.utils.ImageUtils;
import java.util.ArrayList;

class FullPageScreenshotProvider
implements ScreenshotProvider {
    private final boolean mIncludeAllLayers;
    private final boolean mHideCaret;
    private final IComponentsProvider mComponentsProvider;
    private final DebugScreenshotsProvider debugScreenshotsProvider;
    private final Logger mLogger;
    private static final String TAG = "";
    private final int mStitchOverlapTop;
    private final int mStitchOverlapBottom;
    private final ScreenshotMode mScreenshotMode;
    private final LazyLoadOptions lazyOptions;
    private final View scrollRootElement;
    private final int waitBeforeCaptureMillis;

    public FullPageScreenshotProvider(IEspressoCheckInternal checkSettingsInternal, IComponentsProvider componentsProvider, IConfigurationProvider configurationGetter, Logger logger, DebugScreenshotsProvider debugScreenshotsProvider, View scrollRootElement) {
        this.mIncludeAllLayers = checkSettingsInternal.getIncludeAllLayers();
        this.mHideCaret = checkSettingsInternal.getHideCaret(configurationGetter.get().getHideCaret());
        this.mComponentsProvider = componentsProvider;
        this.mLogger = logger;
        this.mStitchOverlapTop = checkSettingsInternal.getStitchingOverlap(OVERLAP_EDGE.TOP, configurationGetter.get().getStitchOverlap());
        this.mStitchOverlapBottom = checkSettingsInternal.getStitchingOverlap(OVERLAP_EDGE.BOTTOM);
        this.mScreenshotMode = checkSettingsInternal.getScreenShotMode(configurationGetter.get().getScreenshotMode());
        this.lazyOptions = checkSettingsInternal.getLazyLoadOptions(configurationGetter.get().getLazyLoadOptions());
        this.waitBeforeCaptureMillis = checkSettingsInternal.getWaitBeforeCapture(configurationGetter.get().getWaitBeforeScreenshotMillis());
        this.debugScreenshotsProvider = debugScreenshotsProvider;
        this.scrollRootElement = scrollRootElement;
    }

    public byte[] getImage() {
        Bitmap bitmap;
        Activity activity = this.mComponentsProvider.getCurrentActivity();
        try {
            bitmap = this.getFullPageScreenshot(activity);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to capture screenshot.");
        }
        return ImageUtils.bitmapToBytes(bitmap);
    }

    private Bitmap getFullPageScreenshot(Activity activity) throws InterruptedException {
        View scrollableView = this.scrollRootElement;
        if (scrollableView == null) {
            scrollableView = this.mComponentsProvider.findScrollableView(activity);
        }
        if (scrollableView != null) {
            this.mLogger.log("Found scrollableView: " + scrollableView.getClass().getName() + " | height: " + scrollableView.getHeight() + " | visibility: " + scrollableView.getVisibility());
        }
        return this.getFullScreenshot(activity, scrollableView);
    }

    private Bitmap getFullScreenshot(Activity activity, View scrollableView) throws InterruptedException {
        Bitmap result = null;
        if (scrollableView != null && scrollableView.getHeight() != 0) {
            this.mLogger.log("Scrollable view instance of " + scrollableView.getClass().getSimpleName());
            if (this.mStitchOverlapTop + this.mStitchOverlapBottom >= scrollableView.getHeight()) {
                String errStr = " StitchingOverlaps top: " + this.mStitchOverlapTop + " bottom: " + this.mStitchOverlapBottom + " overlaps the whole scrollable. Please reduce the overlap sizes";
                this.mLogger.log(TAG + errStr);
                throw new InterruptedException(errStr);
            }
            this.mLogger.log("LazyOptions = " + this.lazyOptions);
            int maxScrollableHeight = this.mComponentsProvider.getFullScrollableHeight(activity, scrollableView, this.lazyOptions);
            this.mLogger.log("Max scrollable height = " + maxScrollableHeight);
            this.mLogger.log("Scrollable view height = " + scrollableView.getHeight());
            if (scrollableView.getHeight() == 0 || maxScrollableHeight <= scrollableView.getHeight()) {
                return this.mComponentsProvider.captureViewportScreenshot(activity, false, true, Boolean.valueOf(this.mIncludeAllLayers), this.mHideCaret, this.mScreenshotMode);
            }
            Insets evaluatedInsets = this.mComponentsProvider.estimateScrollingViewInsets(scrollableView, this.mStitchOverlapTop, this.mStitchOverlapBottom);
            this.mLogger.log("Estimated insets = " + evaluatedInsets);
            maxScrollableHeight -= evaluatedInsets.top + evaluatedInsets.bottom;
            Rect scrollableViewRect = new Rect();
            scrollableView.getGlobalVisibleRect(scrollableViewRect);
            this.mLogger.log("Scrollable view rect = " + scrollableViewRect);
            Rect scrollableAreaRect = new Rect(scrollableViewRect.left + evaluatedInsets.left, scrollableViewRect.top + evaluatedInsets.top, scrollableViewRect.right - evaluatedInsets.right, scrollableViewRect.bottom - evaluatedInsets.bottom);
            this.mLogger.log("Scrollable area rect = " + scrollableViewRect);
            int behaviorOffset = this.mComponentsProvider.getBehaviorOffset(activity, scrollableView);
            this.mLogger.log("BehaviorOffset = " + behaviorOffset);
            this.mLogger.log("Stitch overlap [top = " + this.mStitchOverlapTop + " bottom = " + this.mStitchOverlapBottom);
            this.disableScrollbar(activity, scrollableView);
            boolean isContentUnderStatusBar = this.mComponentsProvider.isContentUnderBars(activity, 1);
            ArrayList<Bitmap> imagesList = new ArrayList<Bitmap>();
            Bitmap headerBmp = null;
            if (scrollableAreaRect.top - (isContentUnderStatusBar ? 0 : this.mComponentsProvider.getStatusBarHeight((Context)activity)) > 0) {
                headerBmp = this.mComponentsProvider.captureFrame(activity, new Region(0, scrollableAreaRect.top - (isContentUnderStatusBar ? 0 : this.mComponentsProvider.getStatusBarHeight((Context)activity)), isContentUnderStatusBar ? 0 : this.mComponentsProvider.getStatusBarHeight((Context)activity), 0), this.mHideCaret, this.mIncludeAllLayers, this.mScreenshotMode);
            }
            if (behaviorOffset > 0) {
                this.mComponentsProvider.scrollBehavior(activity, scrollableView, behaviorOffset);
                scrollableViewRect.offset(0, -behaviorOffset);
                scrollableViewRect.bottom += behaviorOffset;
                scrollableAreaRect.offset(0, -behaviorOffset);
                scrollableAreaRect.bottom += behaviorOffset;
                Thread.sleep(this.waitBeforeCaptureMillis);
            }
            int oneScrollStep = scrollableAreaRect.height();
            int maxScrollSteps = maxScrollableHeight / oneScrollStep;
            this.mLogger.log("One scroll step = " + oneScrollStep);
            this.mLogger.log("maxScrollSteps = " + (double)maxScrollableHeight / (double)oneScrollStep);
            this.mLogger.verbose("Scrollable component: " + scrollableView);
            for (int step = 0; step <= maxScrollSteps; ++step) {
                int top = scrollableAreaRect.top;
                int height = scrollableAreaRect.height();
                if (step == maxScrollSteps && maxScrollSteps != 0) {
                    height = maxScrollableHeight % oneScrollStep;
                    top = scrollableAreaRect.top + scrollableAreaRect.height() - height;
                }
                if (height <= 0) {
                    this.mLogger.verbose("height for scrollable must be > 0, please check stitchingOverlap property");
                    break;
                }
                Bitmap scrollableViewBitmap = this.mComponentsProvider.captureFrame(activity, new Region(0, height, top, 0), this.mHideCaret, this.mIncludeAllLayers, this.mScreenshotMode);
                imagesList.add(scrollableViewBitmap);
                if (maxScrollSteps == 0) break;
                this.mComponentsProvider.scroll(activity, scrollableView, oneScrollStep, step, this.lazyOptions);
                Thread.sleep(this.waitBeforeCaptureMillis);
            }
            Rect contentRect = new Rect();
            this.mComponentsProvider.getContentView(activity).getGlobalVisibleRect(contentRect);
            int remainingHeight = contentRect.bottom - scrollableAreaRect.bottom;
            Bitmap footerBmp = null;
            this.mLogger.log("Remaining height = " + remainingHeight);
            if (remainingHeight > 0) {
                try {
                    footerBmp = this.mComponentsProvider.captureFrame(activity, new Region(0, remainingHeight, scrollableAreaRect.bottom, 0), this.mHideCaret, this.mIncludeAllLayers, this.mScreenshotMode);
                }
                catch (IllegalArgumentException ex) {
                    this.mLogger.log("IllegalArgumentException while taking bitmap with remaining height: " + ex.getMessage());
                }
            }
            Bitmap bitmap_1 = (Bitmap)imagesList.get(0);
            this.debugScreenshotsProvider.save(ImageUtils.bitmapToBytes(bitmap_1), "FULL_SCREENSHOT_PART_0");
            for (int i = 1; i < imagesList.size(); ++i) {
                Bitmap bitmap_2 = (Bitmap)imagesList.get(i);
                this.debugScreenshotsProvider.save(ImageUtils.bitmapToBytes(bitmap_2), "FULL_SCREENSHOT_PART_" + i);
                if (result == null) {
                    result = this.combineImages(bitmap_1, bitmap_2);
                    bitmap_1.recycle();
                } else {
                    result = this.combineImages(result, bitmap_2);
                }
                bitmap_2.recycle();
            }
            imagesList.clear();
            if (headerBmp != null) {
                result = result == null ? headerBmp : this.combineImages(headerBmp, result);
                headerBmp.recycle();
            }
            if (footerBmp != null) {
                result = result == null ? footerBmp : this.combineImages(result, footerBmp);
                footerBmp.recycle();
            }
            this.mComponentsProvider.scrollToTop(activity, scrollableView);
            if (behaviorOffset > 0) {
                this.mComponentsProvider.scrollBehavior(activity, scrollableView, -behaviorOffset);
            }
        } else {
            this.mLogger.log("Scrollable view is not presented");
            result = this.mComponentsProvider.captureViewportScreenshot(activity, false, true, Boolean.valueOf(this.mIncludeAllLayers), this.mHideCaret, this.mScreenshotMode);
        }
        return result;
    }

    private Bitmap combineImages(Bitmap bitmap_1, Bitmap bitmap_2) {
        int width = bitmap_1.getWidth();
        int height = bitmap_1.getHeight() + bitmap_2.getHeight();
        int top = bitmap_1.getHeight();
        Bitmap combinedBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas comboImage = new Canvas(combinedBitmap);
        comboImage.drawBitmap(bitmap_1, 0.0f, 0.0f, null);
        comboImage.drawBitmap(bitmap_2, 0.0f, (float)top, null);
        bitmap_1.recycle();
        bitmap_2.recycle();
        return combinedBitmap;
    }

    private void disableScrollbar(Activity activity, final View scrollableView) {
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                scrollableView.setVerticalScrollBarEnabled(false);
                scrollableView.setHorizontalScrollBarEnabled(false);
            }
        });
    }
}

