/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso.fluent;

import android.graphics.Bitmap;
import android.view.View;
import com.applitools.eyes.android.common.AccessibilityRegionType;
import com.applitools.eyes.android.common.DensitySettings;
import com.applitools.eyes.android.common.LazyLoadOptions;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.common.ScreenshotMode;
import com.applitools.eyes.android.common.config.Configuration;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.core.fluent.CheckSettings;
import com.applitools.eyes.android.espresso.AccessibilityRegionBySelector;
import com.applitools.eyes.android.espresso.fluent.IEspressoCheckInternal;
import com.applitools.eyes.android.espresso.fluent.IEspressoCheckSettings;
import com.applitools.eyes.android.espresso.fluent.IgnoreRegionBySelector;
import com.applitools.eyes.android.espresso.fluent.OVERLAP_EDGE;
import com.applitools.eyes.android.espresso.fluent.Padding;
import java.util.Arrays;
import org.hamcrest.Matcher;

public class EspressoCheckSettings
extends CheckSettings<IEspressoCheckSettings>
implements IEspressoCheckSettings,
IEspressoCheckInternal,
Cloneable {
    private Matcher mTargetMatcher;
    private View mTargetView;
    private boolean mGoogleMap = false;
    private boolean mIsNotSupportMap = false;
    private Integer mId;
    private boolean mDialog = false;
    private boolean mPopupView = false;
    private Integer scrollRootElementId = null;
    private View scrollRootElement = null;
    private Matcher scrollRootElementMatcher = null;
    private Bitmap mBitmap = null;
    private boolean isBitmap = false;
    private Integer[] mStitchingOverlap = new Integer[OVERLAP_EDGE.values().length];
    private ScreenshotMode mScreenshotMode = null;
    private LazyLoadOptions mLazyLoadOptions = null;
    private Integer mWaitBeforeCaptureMillis = null;
    private DensitySettings mDensitySettings = null;

    EspressoCheckSettings() {
    }

    EspressoCheckSettings(Bitmap bitmap) {
        ArgumentGuard.notNull((Object)bitmap, (String)"Check bitmap");
        this.mBitmap = bitmap;
        this.isBitmap = true;
    }

    EspressoCheckSettings(Region region) {
        super(region);
    }

    EspressoCheckSettings(Matcher matcher) {
        this.mTargetMatcher = matcher;
    }

    EspressoCheckSettings(View view) {
        this.mTargetView = view;
    }

    EspressoCheckSettings(boolean googleMap) {
        this.mGoogleMap = googleMap;
    }

    @Override
    public Matcher getTargetMatcher() {
        return this.mTargetMatcher;
    }

    @Override
    public View getTargetView() {
        return this.mTargetView;
    }

    @Override
    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    @Override
    public boolean isBitmap() {
        return this.isBitmap;
    }

    @Override
    public boolean isGoogleMap() {
        return this.mGoogleMap;
    }

    @Override
    public boolean isNotSupportMap() {
        return this.mIsNotSupportMap;
    }

    @Override
    public Integer getId() {
        return this.mId;
    }

    @Override
    public boolean isDialogView() {
        return this.mDialog;
    }

    @Override
    public boolean isPopupView() {
        return this.mPopupView;
    }

    @Override
    public View getScrollRootElement() {
        return this.scrollRootElement;
    }

    @Override
    public Integer getScrollRootElementId() {
        return this.scrollRootElementId;
    }

    @Override
    public Matcher getScrollRootElementMatcher() {
        return this.scrollRootElementMatcher;
    }

    @Override
    public boolean hasScrollRootElement() {
        return this.scrollRootElementId != null || this.scrollRootElement != null || this.scrollRootElementMatcher != null;
    }

    @Override
    public IEspressoCheckSettings region(Region region) {
        super.updateTargetRegion(region);
        return this;
    }

    @Override
    public IEspressoCheckSettings region(Matcher matcher) {
        this.mTargetMatcher = matcher;
        return this;
    }

    @Override
    public IEspressoCheckSettings ignore(Matcher ... matchers) {
        for (Matcher matcher : matchers) {
            this.ignore(new IgnoreRegionBySelector(this, matcher));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings ignore(Matcher matcher, Padding padding, Matcher ... matchers) {
        this.ignore(new IgnoreRegionBySelector(this, matcher, padding));
        for (Matcher matcher1 : matchers) {
            this.ignore(new IgnoreRegionBySelector(this, matcher1, padding));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings layout(Matcher ... matchers) {
        for (Matcher matcher : matchers) {
            this.layout(new IgnoreRegionBySelector(this, matcher));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings layout(Matcher matcher, Padding padding, Matcher ... matchers) {
        this.layout(new IgnoreRegionBySelector(this, matcher, padding));
        for (Matcher matcher1 : matchers) {
            this.layout(new IgnoreRegionBySelector(this, matcher1, padding));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings content(Matcher ... matchers) {
        for (Matcher matcher : matchers) {
            this.content(new IgnoreRegionBySelector(this, matcher));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings content(Matcher matcher, Padding padding, Matcher ... matchers) {
        this.content(new IgnoreRegionBySelector(this, matcher, padding));
        for (Matcher matcher1 : matchers) {
            this.content(new IgnoreRegionBySelector(this, matcher1, padding));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings strict(Matcher ... matchers) {
        for (Matcher matcher : matchers) {
            this.strict(new IgnoreRegionBySelector(this, matcher));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings strict(Matcher matcher, Padding padding, Matcher ... matchers) {
        this.strict(new IgnoreRegionBySelector(this, matcher, padding));
        for (Matcher matcher1 : matchers) {
            this.strict(new IgnoreRegionBySelector(this, matcher1, padding));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings accessibility(Matcher matcher, AccessibilityRegionType regionType) {
        this.accessibility_(new AccessibilityRegionBySelector(matcher, regionType));
        return this;
    }

    @Override
    public IEspressoCheckSettings isNotSupportGoogleMap() {
        this.mIsNotSupportMap = true;
        return this;
    }

    @Override
    public IEspressoCheckSettings id(int id) {
        this.mId = id;
        return this;
    }

    @Override
    public IEspressoCheckSettings dialog() {
        this.mDialog = true;
        return this;
    }

    @Override
    public IEspressoCheckSettings popup() {
        this.mPopupView = true;
        return this;
    }

    public IEspressoCheckSettings fully() {
        return (EspressoCheckSettings)super.fully();
    }

    public IEspressoCheckSettings fully(boolean fully) {
        return (EspressoCheckSettings)super.fully(fully);
    }

    @Override
    public IEspressoCheckSettings scrollRootElement(View view) {
        this.scrollRootElement = view;
        return this;
    }

    @Override
    public IEspressoCheckSettings scrollRootElement(int id) {
        this.scrollRootElementId = id;
        return this;
    }

    @Override
    public IEspressoCheckSettings scrollRootElement(Matcher matcher) {
        this.scrollRootElementMatcher = matcher;
        return this;
    }

    @Override
    public IEspressoCheckSettings stitchingOverlap(int sizePx, OVERLAP_EDGE overlapEdge) {
        if (overlapEdge != null) {
            this.mStitchingOverlap[overlapEdge.ordinal()] = Math.max(sizePx, 0);
        }
        return this;
    }

    @Override
    public int getStitchingOverlap(OVERLAP_EDGE edge) {
        return this.getStitchingOverlap(edge, null);
    }

    @Override
    public int getStitchingOverlap(OVERLAP_EDGE edge, Integer defaultValue) {
        if (this.mStitchingOverlap[edge.ordinal()] == null) {
            return defaultValue == null ? 0 : defaultValue;
        }
        return this.mStitchingOverlap[edge.ordinal()];
    }

    @Override
    public IEspressoCheckSettings setScreenshotMode(ScreenshotMode screenshotMode) {
        this.mScreenshotMode = screenshotMode;
        return this;
    }

    @Override
    public ScreenshotMode getScreenShotMode() {
        return this.getScreenShotMode(null);
    }

    @Override
    public ScreenshotMode getScreenShotMode(ScreenshotMode defaultValue) {
        if (this.mScreenshotMode == null) {
            return defaultValue == null ? Configuration.DEFAULT_SCREENSHOT_MODE : defaultValue;
        }
        return this.mScreenshotMode;
    }

    @Override
    public IEspressoCheckSettings setLazyLoadOptions(LazyLoadOptions lazyLoadOptions) {
        this.mLazyLoadOptions = lazyLoadOptions;
        return this;
    }

    @Override
    public LazyLoadOptions getLazyLoadOptions() {
        return this.getLazyLoadOptions(null);
    }

    @Override
    public LazyLoadOptions getLazyLoadOptions(LazyLoadOptions defaultValue) {
        if (this.mLazyLoadOptions == null) {
            return defaultValue == null ? new LazyLoadOptions() : defaultValue;
        }
        return this.mLazyLoadOptions;
    }

    @Override
    public IEspressoCheckSettings setWaitBeforeCapture(int millis) {
        this.mWaitBeforeCaptureMillis = millis;
        return this;
    }

    @Override
    public int getWaitBeforeCapture() {
        return this.getWaitBeforeCapture(null);
    }

    @Override
    public int getWaitBeforeCapture(Integer defaultValue) {
        if (this.mWaitBeforeCaptureMillis == null) {
            return defaultValue == null ? Configuration.DEFAULT_WAIT_BEFORE_CAPTURE : defaultValue;
        }
        return this.mWaitBeforeCaptureMillis;
    }

    public IEspressoCheckSettings setDensitySettings(DensitySettings densitySettings) {
        this.mDensitySettings = densitySettings;
        return this;
    }

    public DensitySettings getDensitySettings() {
        return this.mDensitySettings;
    }

    public EspressoCheckSettings clone() {
        EspressoCheckSettings clone = new EspressoCheckSettings();
        super.populateClone((CheckSettings)clone);
        clone.mTargetMatcher = this.mTargetMatcher;
        clone.mTargetView = this.mTargetView;
        clone.mGoogleMap = this.mGoogleMap;
        clone.mIsNotSupportMap = this.mIsNotSupportMap;
        clone.mId = this.mId;
        clone.mDialog = this.mDialog;
        clone.mPopupView = this.mPopupView;
        clone.isBitmap = this.isBitmap;
        clone.mBitmap = this.mBitmap;
        clone.mStitchingOverlap = Arrays.copyOf(this.mStitchingOverlap, this.mStitchingOverlap.length);
        clone.mScreenshotMode = this.mScreenshotMode;
        clone.mLazyLoadOptions = this.mLazyLoadOptions;
        clone.mWaitBeforeCaptureMillis = this.mWaitBeforeCaptureMillis;
        return clone;
    }

    public String toString() {
        return "EspressoCheckSettings{mTargetMatcher=" + this.mTargetMatcher + ", mTargetView=" + this.mTargetView + ", mGoogleMap=" + this.mGoogleMap + ", mIsNotSupportMap=" + this.mIsNotSupportMap + ", mId=" + this.mId + ", mDialog=" + this.mDialog + ", mPopupView=" + this.mPopupView + ", mBitmap=" + this.mBitmap + ", scrollRootElementId=" + this.scrollRootElementId + ", scrollRootElement=" + this.scrollRootElement + ", scrollRootElementMatcher=" + this.scrollRootElementMatcher + ", ignoreRegions=" + Arrays.toString(this.getIgnoreRegions()) + ", layoutRegions=" + Arrays.toString(this.getLayoutRegions()) + ", strictRegions=" + Arrays.toString(this.getStrictRegions()) + ", contentRegions=" + Arrays.toString(this.getContentRegions()) + ", floatingRegions=" + Arrays.toString(this.getFloatingRegions()) + ", accessibilityRegions=" + Arrays.toString(this.getAccessibilityRegions()) + ", mStitchingOverlap=" + Arrays.toString((Object[])this.mStitchingOverlap) + ", mLazyLoadOptions=" + this.mLazyLoadOptions + ", mScreenshotMode=" + this.mScreenshotMode + ", mWaitBeforeCaptureMillis=" + this.mWaitBeforeCaptureMillis + '}';
    }
}

