/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso.regions;

import android.graphics.Bitmap;
import android.view.View;
import com.applitools.eyes.android.common.Location;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.common.RegionProvider;
import com.applitools.eyes.android.common.ScreenshotMode;
import com.applitools.eyes.android.components.IComponentsProvider;
import com.applitools.eyes.android.espresso.BitmapProvider;
import com.applitools.eyes.android.espresso.regions.EmptyBitmapProvider;
import com.applitools.eyes.android.espresso.regions.ViewRegionProvider;

public class RegionProviderFactory {
    public static RegionProvider createViewRegionProvider(View view, boolean hideCaret, IComponentsProvider componentsProvider, boolean fully, int stitchOverlap, ScreenshotMode screenshotMode, boolean isNML) {
        if (isNML) {
            return new com.applitools.android.screenshotprovider.regions.ViewRegionProvider();
        }
        return new ViewRegionProvider(view, hideCaret, componentsProvider, fully, stitchOverlap, screenshotMode);
    }

    public static RegionProvider createBitmapProvider(Bitmap bitmap, Region targetRegion, boolean isNML) {
        if (isNML) {
            return new com.applitools.android.screenshotprovider.regions.BitmapProvider(bitmap, targetRegion);
        }
        return new BitmapProvider(bitmap, targetRegion);
    }

    public static RegionProvider createEmptyBitmapProvider(Region targetRegion, Location targetLocation, boolean isNML) {
        if (isNML) {
            return new com.applitools.android.screenshotprovider.regions.EmptyBitmapProvider();
        }
        return new EmptyBitmapProvider(targetRegion, targetLocation);
    }
}

