/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso.regions;

import android.app.Activity;
import android.content.Context;
import com.applitools.eyes.android.common.GetRegion;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.components.IComponentsProvider;
import com.applitools.eyes.android.components.ViewAndLocation;
import com.applitools.eyes.android.espresso.fluent.EspressoCheckSettings;
import com.applitools.eyes.android.espresso.fluent.Padding;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;

public class SimpleRegionBySelector
implements GetRegion {
    private final Matcher mMatcher;
    private final Padding padding;
    private final boolean isWindowBased;
    private final IComponentsProvider mComponentsProvider;

    public SimpleRegionBySelector(EspressoCheckSettings checkSettings, IComponentsProvider componentsProvider, Matcher matcher, Padding padding) {
        this.mMatcher = matcher;
        this.padding = padding;
        this.isWindowBased = checkSettings.isDialogView() || checkSettings.isPopupView();
        this.mComponentsProvider = componentsProvider;
    }

    public SimpleRegionBySelector(EspressoCheckSettings checkSettings, IComponentsProvider componentsProvider, Matcher matcher) {
        this(checkSettings, componentsProvider, matcher, new Padding());
    }

    public List<Region> getRegions() {
        this.mComponentsProvider.getLogger().verbose("SimpleRegionBySelector for matcher: " + this.mMatcher.toString());
        ViewAndLocation viewAndLocation = this.mComponentsProvider.findView(this.mMatcher);
        if (viewAndLocation == null) {
            return null;
        }
        if (this.isWindowBased) {
            int[] location = new int[2];
            viewAndLocation.getView().getLocationInWindow(location);
            ArrayList<Region> value = new ArrayList<Region>();
            value.add(new Region(viewAndLocation.getView().getWidth() + this.padding.getLeft() + this.padding.getRight(), viewAndLocation.getView().getHeight() + this.padding.getTop() + this.padding.getBottom(), location[1] - this.padding.getTop(), location[0] - this.padding.getLeft()));
            return value;
        }
        Activity activity = this.mComponentsProvider.scanForActivity(viewAndLocation.getView().getContext());
        int statusBarHeight = this.mComponentsProvider.getStatusBarHeight((Context)activity);
        int statusBarHeightToRemove = this.mComponentsProvider.isContentUnderBars(activity, 1) ? 0 : statusBarHeight;
        ArrayList<Region> value = new ArrayList<Region>();
        value.add(new Region(viewAndLocation.getView().getWidth() + this.padding.getLeft() + this.padding.getRight(), viewAndLocation.getView().getHeight() + this.padding.getTop() + this.padding.getBottom(), viewAndLocation.getLocation()[1] - statusBarHeightToRemove - this.padding.getTop(), viewAndLocation.getLocation()[0] - this.padding.getLeft()));
        return value;
    }

    public String toString() {
        return "SimpleRegionBySelector{mMatcher=" + this.mMatcher + ", padding=" + this.padding + '}';
    }
}

