/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso;

import android.app.Activity;
import android.graphics.Bitmap;
import com.applitools.eyes.android.common.ScreenshotMode;
import com.applitools.eyes.android.components.IComponentsProvider;
import com.applitools.eyes.android.core.ScreenshotProvider;
import com.applitools.eyes.android.espresso.utils.ImageUtils;

class CurrentFrameScreenshotProvider
implements ScreenshotProvider {
    private final Boolean mIncludeAllLayers;
    private final boolean mHideCaret;
    private final ScreenshotMode screenshotMode;
    private final IComponentsProvider mComponentsProvider;

    public CurrentFrameScreenshotProvider(IComponentsProvider componentsProvider, boolean includeAllLayers, boolean hideCaret, ScreenshotMode screenshotMode) {
        this.mIncludeAllLayers = includeAllLayers;
        this.mHideCaret = hideCaret;
        this.screenshotMode = screenshotMode;
        this.mComponentsProvider = componentsProvider;
    }

    public byte[] getImage() {
        Bitmap bitmap;
        Activity activity = this.mComponentsProvider.getCurrentActivity();
        try {
            bitmap = this.mComponentsProvider.captureViewportScreenshot(activity, false, true, this.mIncludeAllLayers, this.mHideCaret, this.screenshotMode);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to capture screenshot.");
        }
        return ImageUtils.bitmapToBytes(bitmap);
    }
}

