/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso.logger;

import android.os.Environment;
import com.applitools.eyes.android.common.exceptions.EyesException;
import com.applitools.eyes.android.common.logger.LogHandler;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.espresso.logger.CommandLineUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class FileLogHandler
implements LogHandler {
    private Logger mLogger;
    private boolean mIsVerbose;

    public FileLogHandler(String fileName, boolean append, boolean isVerbose) {
        ArgumentGuard.notNullOrEmpty((String)fileName, (String)"fileName");
        this.mLogger = Logger.getLogger("EyesLog");
        this.mIsVerbose = isVerbose;
        try {
            FileHandler fileHandler = new FileHandler(this.getFileLogDir().getAbsolutePath() + "/" + fileName, append);
            this.mLogger.addHandler(fileHandler);
            SimpleFormatter formatter = new SimpleFormatter();
            fileHandler.setFormatter(formatter);
        }
        catch (IOException e) {
            throw new EyesException("FileLogHandler: ", (Throwable)e);
        }
    }

    public FileLogHandler(boolean isVerbose) {
        this("eyes.log", true, isVerbose);
    }

    public void onMessage(boolean verbose, String logString) {
        if (this.mLogger != null && (!verbose || this.mIsVerbose)) {
            this.mLogger.info(logString);
        }
    }

    public void close() {
    }

    public boolean isOpen() {
        return true;
    }

    public void open() {
    }

    private File getFileLogDir() throws IOException {
        File dir = new File(Environment.getExternalStorageDirectory().getPath() + "/applitools/logs");
        File directory = FileLogHandler.initDir(dir);
        if (directory == null) {
            throw new IOException("Can not create directory for logs. If you use API 23 and higher you need permission for access to storage.");
        }
        return directory;
    }

    private static File initDir(File directory) throws IOException {
        File result = null;
        try {
            FileLogHandler.createDir(directory);
            if (directory.isDirectory() && directory.canWrite()) {
                result = directory;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static void createDir(File dir) throws IOException {
        File parent = dir.getParentFile();
        if (!parent.exists()) {
            FileLogHandler.createDir(parent);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Can not create output dir: " + dir.getAbsolutePath());
        }
        CommandLineUtils.cmdPermissionRWX(dir);
    }
}

