/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso;

import android.annotation.SuppressLint;
import com.applitools.eyes.android.common.AbstractProxySettings;
import com.applitools.eyes.android.common.BatchInfo;
import com.applitools.eyes.android.common.EyesRunner;
import com.applitools.eyes.android.common.IEyesBase;
import com.applitools.eyes.android.common.ImageMatchSettings;
import com.applitools.eyes.android.common.LatestCommitInfo;
import com.applitools.eyes.android.common.MatchLevel;
import com.applitools.eyes.android.common.RectangleSize;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.common.TestResultContainer;
import com.applitools.eyes.android.common.TestResults;
import com.applitools.eyes.android.common.TestResultsSummary;
import com.applitools.eyes.android.common.config.Configuration;
import com.applitools.eyes.android.common.config.IConfigurationGetter;
import com.applitools.eyes.android.common.config.IConfigurationProvider;
import com.applitools.eyes.android.common.config.IConfigurationSetter;
import com.applitools.eyes.android.common.exceptions.EyesException;
import com.applitools.eyes.android.common.logger.LogHandler;
import com.applitools.eyes.android.common.logger.Logger;
import com.applitools.eyes.android.common.network.RestClient;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.common.utils.IGuardable;
import com.applitools.eyes.android.components.IComponentsProvider;
import com.applitools.eyes.android.core.ClassicRunner;
import com.applitools.eyes.android.core.EyesBase;
import com.applitools.eyes.android.core.IEyes;
import com.applitools.eyes.android.core.TestFailedException;
import com.applitools.eyes.android.core.fluent.ICheckSettings;
import com.applitools.eyes.android.espresso.EspressoEyes;
import com.applitools.eyes.android.espresso.fluent.IEspressoCheckSettings;
import com.applitools.eyes.android.espresso.fluent.Target;
import java.net.URI;
import java.util.Arrays;
import org.hamcrest.Matcher;

public class Eyes
implements IEyesBase,
IGuardable {
    public static final int GOOGLE_MAP_SCREENSHOT_TIMEOUT = 15000;
    private Configuration configuration = new Configuration();
    private EyesRunner eyesRunner;
    private EspressoEyes espressoEyes;
    private IEyes activeEyes;
    private boolean isVisualGridEyes = false;
    private boolean isStarted = false;
    final IConfigurationProvider configurationProvider = new IConfigurationProvider(){

        public IConfigurationGetter get() {
            return Eyes.this.configuration;
        }

        public IConfigurationSetter set() {
            return Eyes.this.configuration;
        }
    };

    public Eyes() {
        this(EyesBase.getDefaultServerUrl());
    }

    public Eyes(EyesRunner eyesRunner) {
        this(EyesBase.getDefaultServerUrl(), eyesRunner);
    }

    public Eyes(URI serverUrl) {
        this(serverUrl, null);
    }

    public Eyes(URI serverUrl, EyesRunner eyesRunner) {
        Object object = this.eyesRunner = eyesRunner == null ? new ClassicRunner() : eyesRunner;
        if (this.eyesRunner instanceof ClassicRunner) {
            this.espressoEyes = new EspressoEyes(this.configurationProvider, serverUrl, (ClassicRunner)this.eyesRunner);
            this.activeEyes = this.espressoEyes;
        }
    }

    public void setApiKey(String apiKey) {
        if (this.espressoEyes != this.activeEyes) {
            this.espressoEyes.setApiKey(apiKey);
        }
        this.activeEyes.setApiKey(apiKey);
    }

    public String getApiKey() {
        return this.activeEyes.getApiKey();
    }

    public void setServerUrl(URI serverUrl) {
        this.activeEyes.setServerUrl(serverUrl);
    }

    public URI getServerUrl() {
        return this.activeEyes.getServerUrl();
    }

    public String getBaseAgentId() {
        return this.espressoEyes.getBaseAgentId();
    }

    public Logger getLogger() {
        return this.activeEyes.getLogger();
    }

    public boolean getIsDisabled() {
        return this.activeEyes.getIsDisabled();
    }

    public void setIsDisabled(boolean isDisabled) {
        this.activeEyes.setIsDisabled(isDisabled);
    }

    public void setLogHandler(LogHandler logHandler) {
        this.activeEyes.setLogHandler(logHandler);
    }

    public LogHandler getLogHandler() {
        return this.activeEyes.getLogHandler();
    }

    public TestResults abortIfNotClosed() {
        if (this.isVisualGridEyes) {
            this.abortAsync();
            return this.waitForEyesToFinish(false);
        }
        return this.espressoEyes.abortIfNotClosed();
    }

    public void addProperty(String name, String value) {
        this.activeEyes.addProperty(name, value);
    }

    public boolean isHideCaret() {
        return this.configuration.getHideCaret();
    }

    public void setHideCaret(boolean hideCaret) {
        if (this.configuration != null) {
            this.configuration.setHideCaret(hideCaret);
        }
    }

    protected RectangleSize getViewportSize() {
        return this.espressoEyes.getViewportSize();
    }

    protected void setViewportSize(RectangleSize size) {
        this.configuration.setViewportSize(size);
    }

    public void setForceFullPageScreenshot(boolean shouldForce) {
        this.configuration.setForceFullPageScreenshot(shouldForce);
    }

    public boolean getForceFullPageScreenshot() {
        return this.configuration.getForceFullPageScreenshot();
    }

    public void open(String testName) {
        this.open(null, testName);
    }

    public void open(String appName, String testName) {
        this.open(appName, testName, null);
    }

    public void open(String appName, String testName, RectangleSize viewportSize) {
        if (this.activeEyes != this.espressoEyes) {
            this.configuration.setIsVisualGrid(true);
        }
        this.guard();
        this.isStarted = true;
        if (this.configuration.getAppName() == null) {
            if (appName != null) {
                this.configuration.setAppName(appName);
            } else {
                try {
                    this.configuration.setAppName(this.espressoEyes.getAppName());
                }
                catch (Exception e) {
                    throw new EyesException("Please verify activity launched or provide AppName");
                }
            }
        }
        this.configuration.setTestName(testName);
        this.configuration.setAgentId(this.espressoEyes.getBaseAgentId());
        this.activeEyes.open(viewportSize, null);
    }

    public void check(IEspressoCheckSettings checkSettings) {
        this.check(null, checkSettings);
    }

    public void check(String name, IEspressoCheckSettings checkSettings) {
        this.activeEyes.check(name, (ICheckSettings)checkSettings);
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    @SuppressLint(value={"DefaultLocale"})
    public void checkWindow(String tag) {
        if (this.getIsDisabled()) {
            this.getLogger().log(String.format("CheckWindow('%s'): Ignored", tag));
            return;
        }
        this.getLogger().log(String.format("CheckWindow('%s')", tag));
        this.check(tag, (IEspressoCheckSettings)((IEspressoCheckSettings)Target.window().withName(tag)).hideCaret(this.configuration.getHideCaret()));
    }

    public void checkRegion(Region region) {
        this.checkRegion(region, null);
    }

    @SuppressLint(value={"DefaultLocale"})
    public void checkRegion(Region region, String tag) {
        if (this.getIsDisabled()) {
            this.getLogger().log(String.format("CheckRegion([%s], '%s'): Ignored", region, tag));
            return;
        }
        ArgumentGuard.notNull((Object)region, (String)"region");
        this.getLogger().verbose(String.format("CheckRegion([%s], '%s')", region, tag));
        this.check(tag, (IEspressoCheckSettings)((IEspressoCheckSettings)Target.region(region).withName(tag)).hideCaret(this.configuration.getHideCaret()));
    }

    public void checkRegion(Matcher matcher) {
        this.checkRegion(matcher, null);
    }

    public void checkRegion(Matcher matcher, String tag) {
        if (this.getIsDisabled()) {
            this.getLogger().log(String.format("CheckRegion([%s], '%s'): Ignored", matcher, tag));
            return;
        }
        ArgumentGuard.notNull((Object)matcher, (String)"matcher");
        this.getLogger().verbose(String.format("CheckRegion([%s], '%s')", matcher, tag));
        this.check(tag, (IEspressoCheckSettings)Target.region(matcher).hideCaret(this.configuration.getHideCaret()));
    }

    public void checkElement(int elementId) {
        this.checkElement(elementId, null);
    }

    public void checkElement(int elementId, String tag) {
        this.espressoEyes.checkElement(elementId, tag);
    }

    public void checkWindowAllLayers() {
        this.checkWindowAllLayers(null);
    }

    public void checkWindowAllLayers(String tag) {
        if (this.getIsDisabled()) {
            this.getLogger().log(String.format("CheckWindowAllLayers('%s'): Ignored", tag));
            return;
        }
        this.getLogger().log(String.format("CheckWindowAllLayers('%s')", tag));
        this.check(tag, (IEspressoCheckSettings)((IEspressoCheckSettings)Target.window().includeAllLayers()).hideCaret(this.configuration.getHideCaret()));
    }

    public void checkGoogleMapFragment(int fragmentId, boolean isSupportMapFragment, IEspressoCheckSettings checkSettings) {
        this.checkGoogleMapFragment(fragmentId, isSupportMapFragment, null, 15000L, checkSettings);
    }

    public void checkGoogleMapFragment(int fragmentId, boolean isSupportMapFragment, long timeout, IEspressoCheckSettings checkSettings) {
        this.checkGoogleMapFragment(fragmentId, isSupportMapFragment, null, timeout, checkSettings);
    }

    public void checkGoogleMapFragment(int fragmentId, boolean isSupportMapFragment, String tag, IEspressoCheckSettings checkSettings) {
        this.checkGoogleMapFragment(fragmentId, isSupportMapFragment, tag, 15000L, checkSettings);
    }

    public void checkGoogleMapFragment(int fragmentId, boolean isSupportMapFragment, String tag, long timeout, IEspressoCheckSettings checkSettings) {
        this.espressoEyes.checkGoogleMapFragment(fragmentId, isSupportMapFragment, tag, timeout, checkSettings);
    }

    public void checkGoogleMapView(int mapViewId, IEspressoCheckSettings checkSettings) {
        this.checkGoogleMapView(mapViewId, null, 15000L, checkSettings);
    }

    public void checkGoogleMapView(int mapViewId, long timeout, IEspressoCheckSettings checkSettings) {
        this.checkGoogleMapView(mapViewId, null, timeout, checkSettings);
    }

    public void checkGoogleMapView(int mapViewId, String tag, IEspressoCheckSettings checkSettings) {
        this.checkGoogleMapView(mapViewId, tag, 15000L, checkSettings);
    }

    public void checkGoogleMapView(int mapViewId, String tag, long timeout, IEspressoCheckSettings checkSettings) {
        this.espressoEyes.checkGoogleMapView(mapViewId, tag, timeout, checkSettings);
    }

    protected String getTitle() {
        return this.espressoEyes.getTitle();
    }

    protected String getDeviceModel() {
        return this.espressoEyes.getDeviceModel();
    }

    protected String getOsName() {
        return this.espressoEyes.getOsName();
    }

    protected String getApplicationNameFromPackage() {
        return this.espressoEyes.getApplicationNameFromPackage();
    }

    protected String getParentBranchBaselineSavedBefore() {
        return this.espressoEyes.getParentBranchBaselineSavedBefore();
    }

    protected LatestCommitInfo getLatestCommitInfo() {
        return this.espressoEyes.getLatestCommitInfo();
    }

    protected String getBatchID() {
        return this.espressoEyes.getBatchID();
    }

    public void setAgentId(String agentId) {
        this.configuration.setAgentId(agentId);
    }

    public String getAgentId() {
        return this.configuration.getAgentId();
    }

    public boolean getIgnoreCaret() {
        return this.configuration.getIgnoreCaret();
    }

    public void setIgnoreCaret(boolean value) {
        this.configuration.setIgnoreCaret(value);
    }

    public void setAppName(String appName) {
        this.configuration.setAppName(appName);
    }

    public String getAppName() {
        return this.configuration.getAppName();
    }

    public void setSaveDiffs(Boolean saveDiffs) {
        this.configuration.setSaveDiffs(saveDiffs);
    }

    public Boolean getSaveDiffs() {
        return this.configuration.getSaveDiffs();
    }

    public void setMatchLevel(MatchLevel matchLevel) {
        this.configuration.setMatchLevel(matchLevel);
    }

    public MatchLevel getMatchLevel() {
        return this.configuration.getMatchLevel();
    }

    public void setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        ArgumentGuard.notNull((Object)defaultMatchSettings, (String)"defaultMatchSettings");
        this.configuration.setDefaultMatchSettings(defaultMatchSettings);
    }

    public ImageMatchSettings getDefaultMatchSettings() {
        return this.configuration.getDefaultMatchSettings();
    }

    public void setSaveNewTests(boolean saveNewTests) {
        this.configuration.setSaveNewTests(saveNewTests);
    }

    public boolean getSaveNewTests() {
        return this.configuration.getSaveNewTests();
    }

    public void setSaveFailedTests(boolean saveFailedTests) {
        this.configuration.setSaveFailedTests(saveFailedTests);
    }

    public boolean getSaveFailedTests() {
        return this.configuration.getSaveFailedTests();
    }

    public void setMatchTimeout(int ms) {
        this.configuration.setMatchTimeout(ms);
    }

    public int getMatchTimeout() {
        return this.configuration.getMatchTimeout();
    }

    public void setBranchName(String branchName) {
        this.configuration.setBranchName(branchName);
    }

    public String getBranchName() {
        return this.configuration.getBranchName();
    }

    public void setParentBranchName(String branchName) {
        this.configuration.setParentBranchName(branchName);
    }

    public String getParentBranchName() {
        return this.configuration.getParentBranchName();
    }

    public void setBaselineBranchName(String branchName) {
        this.configuration.setBaselineBranchName(branchName);
    }

    public String getBaselineBranchName() {
        return this.configuration.getBaselineBranchName();
    }

    @Deprecated
    public void setBaselineName(String baselineName) {
        this.setBaselineEnvName(baselineName);
    }

    @Deprecated
    public String getBaselineName() {
        return this.getBaselineEnvName();
    }

    public void setBaselineEnvName(String baselineEnvName) {
        this.configuration.setBaselineEnvName(baselineEnvName);
    }

    public String getBaselineEnvName() {
        return this.configuration.getBaselineEnvName();
    }

    public void setProxy(AbstractProxySettings proxySettings) {
        if (this.configuration != null) {
            this.configuration.setProxy(proxySettings);
        }
        this.activeEyes.proxy(proxySettings);
    }

    public void setBatch(BatchInfo batch) {
        ArgumentGuard.notNull((Object)batch, (String)"batch");
        this.configuration.setBatch(batch);
    }

    public BatchInfo getBatch() {
        return this.configuration.getBatch();
    }

    public Configuration getConfiguration() {
        return new Configuration((IConfigurationGetter)this.configuration);
    }

    public void setConfiguration(Configuration configuration) {
        AbstractProxySettings proxy;
        URI serverUrl;
        ArgumentGuard.notNull((Object)configuration, (String)"configuration");
        String apiKey = configuration.getApiKey();
        if (apiKey != null) {
            this.setApiKey(apiKey);
        }
        if ((serverUrl = configuration.getServerUrl()) != null) {
            this.setServerUrl(serverUrl);
        }
        if ((proxy = configuration.getProxy()) != null) {
            this.setProxy(proxy);
        }
        this.configuration = new Configuration((IConfigurationGetter)configuration);
        this.activeEyes.onConfigurationUpdated();
    }

    public IConfigurationGetter get() {
        return this.configuration;
    }

    public IConfigurationSetter set() {
        return this.configuration;
    }

    @Deprecated
    public void setComponentsProvider(IComponentsProvider componentsProvider) {
    }

    public IComponentsProvider getComponentsProvider() {
        return this.espressoEyes.getComponentsProvider();
    }

    public void closeAsync() {
        this.close();
    }

    public void abortAsync() {
        this.abortIfNotClosed();
    }

    public TestResults close() {
        return this.close(true);
    }

    public TestResults close(boolean throwEx) {
        if (this.isVisualGridEyes) {
            this.closeAsync();
            return this.waitForEyesToFinish(throwEx);
        }
        this.isStarted = false;
        return this.espressoEyes.close(throwEx);
    }

    public IConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    @Deprecated
    public int getStitchOverlap() {
        return this.configuration.getStitchOverlap();
    }

    public void setStitchOverlap(int pixels) {
        this.configuration.setStitchOverlap(pixels);
    }

    public void setSaveDebugScreenshots(boolean saveDebugScreenshots) {
        this.espressoEyes.setSaveDebugScreenshots(saveDebugScreenshots);
    }

    protected String getDefaultDebugScreenshotPath() {
        return this.espressoEyes.getDefaultDebugScreenshotPath();
    }

    public boolean shouldStitchContent() {
        return this.espressoEyes.shouldStitchContent();
    }

    public void setRestClient(RestClient restClient) {
        if (restClient != null) {
            this.espressoEyes.setRestClient(restClient);
        }
    }

    public TestResults waitForEyesToFinish(boolean throwException) {
        if (!this.isStarted) {
            if (throwException) {
                throw new TestFailedException("Open is never called. Aborting waiting for test results.");
            }
            return new TestResults();
        }
        while (!this.isCompleted()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.isStarted = false;
        TestResultContainer[] allResults = this.eyesRunner.getAllTestResults().getAllResults();
        TestResultContainer errorResult = null;
        TestResults firstResult = null;
        for (TestResultContainer result : allResults) {
            if (firstResult == null) {
                firstResult = result.getTestResults();
            }
            if (result.getException() == null) continue;
            errorResult = result;
            break;
        }
        TestResultsSummary testResultsSummary = new TestResultsSummary(Arrays.asList(allResults));
        if (errorResult != null) {
            if (throwException) {
                throw new TestFailedException(testResultsSummary, errorResult.getException());
            }
            return errorResult.getTestResults();
        }
        return firstResult;
    }

    public boolean isCompleted() {
        return this.eyesRunner.getAllTestResults() != null;
    }

    public EspressoEyes getEspressoEyes() {
        return this.espressoEyes;
    }

    public void guard() throws EyesException {
        if (this.isVisualGridEyes) {
            this.eyesRunner.guard();
            this.configuration.guard();
        }
    }
}

