/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso.regions;

import android.graphics.Bitmap;
import android.os.Build;
import android.view.View;
import android.webkit.WebView;
import com.applitools.eyes.android.common.Location;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.common.RegionProvider;
import com.applitools.eyes.android.common.ScreenshotMode;
import com.applitools.eyes.android.components.IComponentsProvider;
import com.applitools.eyes.android.espresso.utils.ImageUtils;
import com.applitools.eyes.android.espresso.utils.LocationUtils;
import com.applitools.eyes.android.espresso.utils.RegionUtils;

public class ViewRegionProvider
implements RegionProvider {
    private View mView;
    private boolean hideCaret;
    private IComponentsProvider mComponentsProvider;
    private boolean fully;
    private int stitchOverlap;
    private final ScreenshotMode mScreenshotMode;

    public ViewRegionProvider(View view, boolean hideCaret, IComponentsProvider componentsProvider, boolean fully, int stitchOverlap, ScreenshotMode screenshotMode) {
        this.mView = view;
        this.hideCaret = hideCaret;
        this.mComponentsProvider = componentsProvider;
        this.fully = fully;
        this.stitchOverlap = stitchOverlap;
        this.mScreenshotMode = screenshotMode;
    }

    public Region getRegion() {
        if (this.mScreenshotMode == ScreenshotMode.SCREEN_CAPTURE && Build.VERSION.SDK_INT >= 26 && !this.fully || this.mView instanceof WebView) {
            return RegionUtils.buildRegion(this.mView, this.mComponentsProvider);
        }
        return Region.EMPTY;
    }

    public byte[] getImage(byte[] screenshotImage) {
        this.mComponentsProvider.getLogger().verbose("getting image");
        if (this.mView instanceof WebView) {
            return null;
        }
        if (screenshotImage == null) {
            this.mComponentsProvider.getLogger().verbose("screenshotImage is null");
            return ImageUtils.bitmapToBytes(this.mComponentsProvider.getBitmapFromView(this.mView, this.hideCaret, this.fully, this.stitchOverlap, this.mScreenshotMode));
        }
        Region region = this.mComponentsProvider.getViewRegion(this.mView, this.fully);
        if (region.getHeight() <= this.mView.getHeight()) {
            this.mComponentsProvider.getLogger().verbose("Region height is smaller than element height");
            return ImageUtils.bitmapToBytes(this.mComponentsProvider.getBitmapFromView(this.mView, this.hideCaret, this.fully, this.stitchOverlap, this.mScreenshotMode));
        }
        this.mComponentsProvider.getLogger().verbose("Crop region from full page screenshot");
        Bitmap screenshotBitmap = ImageUtils.bytesToBitmap(screenshotImage);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)screenshotBitmap, (int)region.getLeft(), (int)region.getTop(), (int)region.getWidth(), (int)region.getHeight());
        return ImageUtils.bitmapToBytes(bitmap);
    }

    public Location getLocation() {
        return LocationUtils.getLocation(this.mView, this.mComponentsProvider);
    }
}

