/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso.regions;

import androidx.annotation.RequiresApi;
import androidx.compose.ui.test.SemanticsMatcher;
import com.applitools.android.screenshotprovider.ViewSelectorHolder;
import com.applitools.eyes.android.common.exceptions.EyesException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemanticsMatcherInspector {
    @RequiresApi(api=26)
    public static List<ViewSelectorHolder> semanticsMatcherToViewSelectorHolder(SemanticsMatcher semanticsMatcher) {
        String matcherString = semanticsMatcher.getDescription();
        List<String> contentDescriptions = SemanticsMatcherInspector.extractContentDescriptions(matcherString);
        ArrayList<ViewSelectorHolder> viewSelectorHolders = new ArrayList<ViewSelectorHolder>();
        for (String contentDescription : contentDescriptions) {
            viewSelectorHolders.add(new ViewSelectorHolder(new ViewSelectorHolder.CommonSelector("accessibility-identifier", contentDescription)));
        }
        return viewSelectorHolders;
    }

    public static List<String> extractContentDescriptions(String input) {
        Pattern pattern = Pattern.compile("ContentDescription = '\\[([^']*)]'");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            String capturedValues = matcher.group(1);
            if (capturedValues.isEmpty()) {
                return Collections.emptyList();
            }
            String[] valuesArray = capturedValues.split(",");
            ArrayList<String> resultList = new ArrayList<String>();
            for (String value : valuesArray) {
                resultList.add(value.trim());
            }
            return resultList;
        }
        throw new EyesException(String.format("Unable to extract content description from semantic matcher with description %s.Only ContentDescription based semantic matcher is supported.", input));
    }
}

