/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso;

import android.app.Activity;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Environment;
import android.util.DisplayMetrics;
import android.view.View;
import com.applitools.android.screenshotprovider.ScreenshotProvider;
import com.applitools.eyes.android.common.AbstractProxySettings;
import com.applitools.eyes.android.common.DensitySettings;
import com.applitools.eyes.android.common.EmptyRegionProvider;
import com.applitools.eyes.android.common.EyesRunner;
import com.applitools.eyes.android.common.EyesScreenshot;
import com.applitools.eyes.android.common.GetRegion;
import com.applitools.eyes.android.common.IBatchCloser;
import com.applitools.eyes.android.common.LatestCommitInfo;
import com.applitools.eyes.android.common.Location;
import com.applitools.eyes.android.common.Property;
import com.applitools.eyes.android.common.RectangleSize;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.common.RegionProvider;
import com.applitools.eyes.android.common.ScreenshotMode;
import com.applitools.eyes.android.common.TestResults;
import com.applitools.eyes.android.common.config.IConfigurationProvider;
import com.applitools.eyes.android.common.exceptions.EyesException;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.components.IComponentsProvider;
import com.applitools.eyes.android.components.androidx.AndroidXComponentsProvider;
import com.applitools.eyes.android.core.ClassicRunner;
import com.applitools.eyes.android.core.IEspressoEyes;
import com.applitools.eyes.android.core.MatchWindowTask;
import com.applitools.eyes.android.core.RunningTest;
import com.applitools.eyes.android.core.fluent.ICheckSettings;
import com.applitools.eyes.android.core.fluent.ICheckSettingsInternal;
import com.applitools.eyes.android.espresso.AbstractBitmapProvider;
import com.applitools.eyes.android.espresso.BitmapProvider;
import com.applitools.eyes.android.espresso.CurrentFrameScreenshotProvider;
import com.applitools.eyes.android.espresso.EyesImageScreenshot;
import com.applitools.eyes.android.espresso.FullPageScreenshotProvider;
import com.applitools.eyes.android.espresso.exceptions.GoogleMapScreenshotTimeoutException;
import com.applitools.eyes.android.espresso.fluent.EspressoCheckSettings;
import com.applitools.eyes.android.espresso.fluent.IEspressoCheckInternal;
import com.applitools.eyes.android.espresso.fluent.IEspressoCheckSettings;
import com.applitools.eyes.android.espresso.fluent.Target;
import com.applitools.eyes.android.espresso.regions.RegionProviderFactory;
import com.applitools.eyes.android.espresso.regions.SimpleRegionBySelector;
import com.applitools.eyes.android.espresso.regions.SimpleRegionBySelectorHolder;
import com.applitools.eyes.android.espresso.utils.ImageUtils;
import com.applitools.eyes.android.espresso.utils.LocationUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;

public class EspressoEyes
extends RunningTest
implements IEspressoEyes {
    private boolean shouldStitchContent = false;
    private final IComponentsProvider componentsProvider = new AndroidXComponentsProvider(this.mLogger);
    private final IConfigurationProvider configurationProvider;
    private View scrollRootElement;

    public EspressoEyes(IConfigurationProvider configurationProvider, URI serverUrl, ClassicRunner runner) {
        super(serverUrl, (EyesRunner)runner);
        this.configurationProvider = configurationProvider;
        this.setConfigurationProvider(this.configurationProvider);
    }

    public boolean shouldStitchContent() {
        return this.shouldStitchContent;
    }

    protected RectangleSize getViewportSize() {
        RectangleSize viewportSize = this.configurationProvider.get().getViewportSize();
        if (viewportSize == null) {
            try {
                viewportSize = this.componentsProvider.getViewportSize();
            }
            catch (Exception e) {
                throw new EyesException("Please verify activity is launched or provide ViewPortSize", (Throwable)e);
            }
        }
        return viewportSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EyesScreenshot getScreenshot(ICheckSettingsInternal checkSettingsInternal) {
        this.getLogger().verbose("getScreenshot() Start");
        IEspressoCheckInternal espressoCheckTarget = (IEspressoCheckInternal)checkSettingsInternal;
        EyesImageScreenshot result = null;
        boolean tmpForceFullPage = this.configurationProvider.get().getForceFullPageScreenshot();
        boolean tmpStitchContent = this.shouldStitchContent;
        try {
            if (checkSettingsInternal.getIncludeAllLayers()) {
                this.configurationProvider.set().setForceFullPageScreenshot(false);
                this.shouldStitchContent = false;
            }
            this.getLogger().log("Using " + this.componentsProvider.getClass().getSimpleName());
            if (this.configurationProvider.get().getNMLScreenshotProvider()) {
                this.getLogger().verbose("Running NML Screenshot Provider");
                if (Build.VERSION.SDK_INT < 26) {
                    throw new RuntimeException(String.format("NML Screenshot Provider requires minimum Android SDK Version 26. This device runs on version %s", Build.VERSION.SDK_INT));
                }
                int MAX_ATTEMPTS = 3;
                Exception lastException = null;
                for (int attempt = 1; attempt <= 3; ++attempt) {
                    try {
                        this.getLogger().verbose(String.format("NML Screenshot Provider init (Attempt %d/%d)", attempt, 3));
                        ScreenshotProvider NMLScreenshotProvider = new ScreenshotProvider(this.componentsProvider.getCurrentActivity(), espressoCheckTarget.buildNMLScreenshotSettings());
                        this.getLogger().verbose(String.format("calling NMLScreenshotProvider.takeScreenshot (Attempt %d/%d)", attempt, 3));
                        ScreenshotProvider.ScreenshotResult screenshotResult = NMLScreenshotProvider.takeScreenshot();
                        result = new EyesImageScreenshot(this.getLogger(), screenshotResult.getScreenshot(), screenshotResult.getRegionsResult());
                        lastException = null;
                        this.getLogger().verbose("NML ScreenshotProvider.takeScreenshot successful.");
                        break;
                    }
                    catch (Exception e) {
                        lastException = e;
                        this.getLogger().error(String.format("Error in NML takeScreenshot (Attempt %d/%d): %s", attempt, 3, e.getMessage()));
                        if (attempt >= 3) continue;
                        try {
                            this.getLogger().verbose("Waiting 500ms before next attempt...");
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException("NML screenshot retry was interrupted", ie);
                        }
                    }
                }
                if (result == null) {
                    this.getLogger().error("All NML screenshot attempts failed.");
                    throw new RuntimeException("Failed to take NML screenshot after 3 attempts", lastException);
                }
            } else {
                Object imageProvider;
                this.getLogger().verbose("Running Espresso Screenshot Provider");
                if (this.configurationProvider.get().getForceFullPageScreenshot().booleanValue() || this.shouldStitchContent) {
                    this.getLogger().verbose("Full page screenshot requested");
                    imageProvider = new FullPageScreenshotProvider(espressoCheckTarget, this.componentsProvider, this.configurationProvider, this.mLogger, this.debugScreenshotsProvider, this.scrollRootElement);
                } else {
                    this.getLogger().verbose("Frame screenshot requested");
                    imageProvider = new CurrentFrameScreenshotProvider(this.componentsProvider, espressoCheckTarget.getIncludeAllLayers(), espressoCheckTarget.getHideCaret(this.configurationProvider.get().getHideCaret()), espressoCheckTarget.getScreenShotMode(this.configurationProvider.get().getScreenshotMode()));
                }
                byte[] resultBytes = imageProvider.getImage();
                result = new EyesImageScreenshot(this.getLogger(), resultBytes);
            }
        }
        finally {
            this.configurationProvider.set().setForceFullPageScreenshot(tmpForceFullPage);
            this.shouldStitchContent = tmpStitchContent;
        }
        this.getLogger().verbose("getScreenshot() Done");
        return result;
    }

    protected EyesScreenshot getScreenshot(byte[] image) {
        this.getLogger().verbose("getScreenshot(Bitmap)");
        return new EyesImageScreenshot(this.getLogger(), image);
    }

    protected String getTitle() {
        return this.componentsProvider.getCurrentScreenName();
    }

    protected String getDeviceModel() {
        return Build.MODEL;
    }

    protected String getOsName() {
        return "Android " + Build.VERSION.RELEASE;
    }

    protected String getApplicationNameFromPackage() {
        return this.componentsProvider.getAppName();
    }

    protected String getParentBranchBaselineSavedBefore() {
        return this.componentsProvider.getParentBranchBaselineSavedBefore();
    }

    protected LatestCommitInfo getLatestCommitInfo() {
        return this.componentsProvider.getLatestCommitInfo();
    }

    public String getBatchID() {
        return this.componentsProvider.getBatchID();
    }

    protected String getDefaultDebugScreenshotPath() {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).toString() + File.separator + "testScreenshots_" + this.debugScreenshotsProvider.getFormattedTimeStamp();
    }

    public String getBaseAgentId() {
        return this.configurationProvider.get().getAgentId();
    }

    public void addProperty(String name, String value) {
        this.mProperties.add((Object)new Property(name, value));
    }

    public void open(RectangleSize viewportSize, String parentBranchBaselineSavedBefore) {
        this.mLogger.verbose("open start");
        if (this.getIsDisabled()) {
            this.getLogger().verbose("open Ignored");
            return;
        }
        if (this.configurationProvider.get().getAppName() == null) {
            this.configurationProvider.set().setAppName(this.getAppName());
        }
        this.configurationProvider.set().setViewportSize(viewportSize != null ? viewportSize : this.getViewportSize());
        this.configurationProvider.set().setSessionType(null);
        this.openBase();
        this.eyesRunner.addBatch(this.configurationProvider.get().getBatch().getId(), (IBatchCloser)this);
    }

    public TestResults close(boolean throwEx) {
        TestResults results;
        block5: {
            results = null;
            try {
                results = super.close(throwEx);
            }
            finally {
                if (this.eyesRunner != null) {
                }
                break block5;
            }
            this.eyesRunner.aggregateResult(results);
        }
        return results;
    }

    public void check(String stepName, ICheckSettings checkSettings) {
        Region targetRegion;
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        this.getLogger().verbose(String.format("check(\"%s\", checkSettings) - begin", stepName));
        MatchWindowTask.cropRegion = Region.EMPTY;
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
        IEspressoCheckInternal espressoCheckTarget = checkSettings instanceof IEspressoCheckInternal ? (IEspressoCheckInternal)checkSettings : null;
        ScreenshotMode screenshotMode = espressoCheckTarget.getScreenShotMode(this.configurationProvider.get().getScreenshotMode());
        if (checkSettingsInternal.getName() != null) {
            stepName = checkSettingsInternal.getName();
        }
        if (checkSettingsInternal instanceof EspressoCheckSettings) {
            this.getLogger().verbose(checkSettingsInternal.toString());
        }
        if (espressoCheckTarget.isBitmap()) {
            this.checkWindowBase((RegionProvider)new BitmapProvider(espressoCheckTarget.getBitmap(), checkSettingsInternal.getTargetRegion()), stepName, false, checkSettings);
            this.getLogger().verbose("check - done!");
            return;
        }
        if (checkSettings instanceof EspressoCheckSettings) {
            DisplayMetrics displayMetrics = this.componentsProvider.getDisplayMetrics();
            ((EspressoCheckSettings)checkSettings).setDensitySettings(new DensitySettings(displayMetrics.density, displayMetrics.xdpi, displayMetrics.ydpi));
        }
        this.shouldStitchContent = checkSettingsInternal.getStitchContent();
        boolean tmpForceFullPage = this.configurationProvider.get().getForceFullPageScreenshot();
        if (checkSettingsInternal.getFullpageScreenshot() != null) {
            this.configurationProvider.set().setForceFullPageScreenshot(checkSettingsInternal.getFullpageScreenshot().booleanValue());
        }
        if (espressoCheckTarget.hasScrollRootElement()) {
            this.scrollRootElement = espressoCheckTarget.getScrollRootElement();
            if (this.scrollRootElement == null) {
                if (espressoCheckTarget.getScrollRootElementId() != null) {
                    this.getLogger().verbose("Get scrollRootElement with ID: " + espressoCheckTarget.getScrollRootElementId());
                    this.scrollRootElement = this.getComponentsProvider().findView(espressoCheckTarget.getScrollRootElementId().intValue());
                } else if (espressoCheckTarget.getScrollRootElementMatcher() != null) {
                    this.getLogger().verbose("Get scrollRootElement with Matcher: " + espressoCheckTarget.getScrollRootElementMatcher());
                    this.scrollRootElement = this.getComponentsProvider().findView(espressoCheckTarget.getScrollRootElementMatcher()).getView();
                }
            }
        }
        if (espressoCheckTarget instanceof EspressoCheckSettings) {
            List<GetRegion> getRegions = this.getSimpleRegionBySelectorList(espressoCheckTarget.getIgnoreRegionHolders(), (EspressoCheckSettings)espressoCheckTarget);
            espressoCheckTarget.setIgnore(getRegions);
            getRegions = this.getSimpleRegionBySelectorList(espressoCheckTarget.getLayoutRegionHolders(), (EspressoCheckSettings)espressoCheckTarget);
            espressoCheckTarget.setLayout(getRegions);
            getRegions = this.getSimpleRegionBySelectorList(espressoCheckTarget.getStrictRegionHolders(), (EspressoCheckSettings)espressoCheckTarget);
            espressoCheckTarget.setStrict(getRegions);
            getRegions = this.getSimpleRegionBySelectorList(espressoCheckTarget.getIgnoreColorsRegionHolders(), (EspressoCheckSettings)espressoCheckTarget);
            espressoCheckTarget.setContent(getRegions);
        }
        if ((targetRegion = checkSettingsInternal.getTargetRegion()) != null) {
            this.checkWindowBase(RegionProviderFactory.createEmptyBitmapProvider(targetRegion, LocationUtils.getLocation(targetRegion), this.configurationProvider.get().getNMLScreenshotProvider()), stepName, false, checkSettings);
        } else if (espressoCheckTarget.isGoogleMap()) {
            this.checkGoogleMapFragment(espressoCheckTarget.getId(), !espressoCheckTarget.isNotSupportMap(), stepName, 15000L, checkSettings);
        } else if (espressoCheckTarget.isDialogView()) {
            View dialogView = this.componentsProvider.getDialogView();
            if (dialogView == null) {
                this.getLogger().verbose("Dialog is not presented. Couldn't take the screenshot");
                return;
            }
            this.checkWindowBase(RegionProviderFactory.createViewRegionProvider(dialogView, checkSettingsInternal.getHideCaret(), this.componentsProvider, false, 0, screenshotMode, this.configurationProvider.get().getNMLScreenshotProvider()), stepName, false, checkSettings);
        } else if (espressoCheckTarget.isPopupView()) {
            View popupView = this.componentsProvider.getPopupView();
            if (popupView == null) {
                this.getLogger().verbose("Popup is not presented. Couldn't take the screenshot");
                return;
            }
            this.checkWindowBase(RegionProviderFactory.createViewRegionProvider(popupView, checkSettingsInternal.getHideCaret(), this.componentsProvider, false, 0, screenshotMode, this.configurationProvider.get().getNMLScreenshotProvider()), stepName, false, checkSettings);
        } else {
            Matcher targetMatcher = espressoCheckTarget.getTargetMatcher();
            View targetElement = espressoCheckTarget.getTargetView();
            if (targetElement == null && targetMatcher != null) {
                this.getLogger().verbose("Target matcher presented. Get target element by matcher.");
                targetElement = this.componentsProvider.findView(targetMatcher).getView();
            }
            if (targetElement != null) {
                MatchWindowTask.cropRegion = this.componentsProvider.getViewRegion(targetElement, this.configurationProvider.get().getForceFullPageScreenshot() != false || this.shouldStitchContent);
                RegionProvider viewRegion = RegionProviderFactory.createViewRegionProvider(targetElement, checkSettingsInternal.getHideCaret(), this.componentsProvider, this.configurationProvider.get().getForceFullPageScreenshot() != false || this.shouldStitchContent, this.configurationProvider.get().getStitchOverlap(), screenshotMode, this.configurationProvider.get().getNMLScreenshotProvider());
                this.checkWindowBase(viewRegion, stepName, false, checkSettings);
            } else {
                this.checkWindowBase((RegionProvider)EmptyRegionProvider.INSTANCE, stepName, false, checkSettings);
            }
        }
        this.shouldStitchContent = false;
        this.configurationProvider.set().setForceFullPageScreenshot(tmpForceFullPage);
        this.scrollRootElement = null;
        this.getLogger().verbose("check - done!");
    }

    public void proxy(AbstractProxySettings proxySettings) {
        super.setProxy(proxySettings);
    }

    public void onConfigurationUpdated() {
        if (this.componentsProvider != null) {
            this.componentsProvider.setConfigurationProvider(this.configurationProvider);
        }
    }

    public void checkGoogleMapView(int mapViewId, String tag, long timeout, ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            this.getLogger().log(String.format("CheckGoogleMapView([%d], '%s'): Ignored", mapViewId, tag));
            return;
        }
        this.getLogger().verbose(String.format("CheckGoogleMapView([%d], '%s')", mapViewId, tag));
        Activity activity = this.componentsProvider.getCurrentActivity();
        final Bitmap bitmap = this.componentsProvider.getGoogleMapViewScreenshot(activity, mapViewId, timeout);
        if (bitmap == null) {
            throw new GoogleMapScreenshotTimeoutException("Can not get screenshot from GoogleMap");
        }
        super.checkWindowBase((RegionProvider)new AbstractBitmapProvider(){

            public byte[] getImage(byte[] screenshotImage) {
                return ImageUtils.bitmapToBytes(bitmap);
            }

            public Location getLocation() {
                return LocationUtils.empty();
            }
        }, tag, false, checkSettings);
    }

    public void checkGoogleMapFragment(int fragmentId, boolean isSupportMapFragment, String tag, long timeout, ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            this.getLogger().log(String.format("CheckGoogleMapFragment([%d], '%b', '%s'): Ignored", fragmentId, isSupportMapFragment, tag));
            return;
        }
        this.getLogger().verbose(String.format("CheckGoogleMapFragment([%d], '%b', '%s')", fragmentId, isSupportMapFragment, tag));
        Activity activity = this.componentsProvider.getCurrentActivity();
        final Bitmap bitmap = this.componentsProvider.getGoogleMapFragmentScreenshot(activity, fragmentId, isSupportMapFragment, timeout);
        if (bitmap == null) {
            throw new GoogleMapScreenshotTimeoutException("Can not get screenshot from GoogleMap");
        }
        super.checkWindowBase((RegionProvider)new AbstractBitmapProvider(){

            public byte[] getImage(byte[] screenshotImage) {
                return ImageUtils.bitmapToBytes(bitmap);
            }

            public Location getLocation() {
                return LocationUtils.empty();
            }
        }, tag, false, checkSettings);
    }

    public void checkElement(int elementId, String tag) {
        if (this.getIsDisabled()) {
            this.getLogger().log(String.format("checkElement([%s], '%s'): Ignored", elementId, tag));
            return;
        }
        View element = this.componentsProvider.findView(elementId);
        ArgumentGuard.notNull((Object)element, (String)"element");
        this.getLogger().verbose(String.format("checkElement([%s], '%s')", element, tag));
        this.check(tag, (ICheckSettings)((IEspressoCheckSettings)Target.region(element).withName(tag)).hideCaret(this.configurationProvider.get().getHideCaret()));
    }

    public IComponentsProvider getComponentsProvider() {
        return this.componentsProvider;
    }

    public void setSaveDebugScreenshots(boolean saveDebugScreenshots) {
        if (saveDebugScreenshots && !this.componentsProvider.isStoragePermissionGranted()) {
            this.getLogger().log("Storage permission should be granted to enable debug screenshot!");
            saveDebugScreenshots = false;
        }
        super.setSaveDebugScreenshots(saveDebugScreenshots);
    }

    public String getAppName() {
        return this.componentsProvider.getAppName();
    }

    private List<GetRegion> getSimpleRegionBySelectorList(List<SimpleRegionBySelectorHolder> simpleRegionBySelectorHolders, EspressoCheckSettings espressoCheckSettings) {
        ArrayList<GetRegion> getRegionList = new ArrayList<GetRegion>();
        for (SimpleRegionBySelectorHolder holder : simpleRegionBySelectorHolders) {
            getRegionList.add(new SimpleRegionBySelector(espressoCheckSettings, this.componentsProvider, holder.getMatcher(), holder.getPadding()));
        }
        return getRegionList;
    }
}

