/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso.fluent;

import android.graphics.Bitmap;
import android.view.View;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.test.SemanticsMatcher;
import com.applitools.android.screenshotprovider.RegionSelectorHolder;
import com.applitools.android.screenshotprovider.ScreenshotSettings;
import com.applitools.android.screenshotprovider.ViewSelectorHolder;
import com.applitools.eyes.android.common.AccessibilityRegionType;
import com.applitools.eyes.android.common.DensitySettings;
import com.applitools.eyes.android.common.GetRegion;
import com.applitools.eyes.android.common.LazyLoadOptions;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.common.ScreenshotMode;
import com.applitools.eyes.android.common.config.Configuration;
import com.applitools.eyes.android.common.exceptions.EyesException;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.components.androidx.AndroidXComponentsProvider;
import com.applitools.eyes.android.core.fluent.CheckSettings;
import com.applitools.eyes.android.espresso.AccessibilityRegionBySelector;
import com.applitools.eyes.android.espresso.fluent.IEspressoCheckInternal;
import com.applitools.eyes.android.espresso.fluent.IEspressoCheckSettings;
import com.applitools.eyes.android.espresso.fluent.OVERLAP_EDGE;
import com.applitools.eyes.android.espresso.fluent.Padding;
import com.applitools.eyes.android.espresso.regions.SemanticsMatcherInspector;
import com.applitools.eyes.android.espresso.regions.SimpleRegionBySelectorHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;

public class EspressoCheckSettings
extends CheckSettings<IEspressoCheckSettings>
implements IEspressoCheckSettings,
IEspressoCheckInternal,
Cloneable {
    private Matcher mTargetMatcher;
    private SemanticsMatcher mTargetSemanticsMatcher;
    private View mTargetView;
    private boolean mGoogleMap = false;
    private boolean mIsNotSupportMap = false;
    private Integer mId;
    private boolean mDialog = false;
    private boolean mPopupView = false;
    private Integer scrollRootElementId = null;
    private View scrollRootElement = null;
    private Matcher scrollRootElementMatcher = null;
    private Bitmap mBitmap = null;
    private boolean isBitmap = false;
    private Integer[] mStitchingOverlap = new Integer[OVERLAP_EDGE.values().length];
    private ScreenshotMode mScreenshotMode = null;
    private LazyLoadOptions mLazyLoadOptions = null;
    private Integer mWaitBeforeCaptureMillis = null;
    private Integer mWaitBetweenStitchesMillis = null;
    private DensitySettings mDensitySettings = null;
    private List<SimpleRegionBySelectorHolder> mIgnoreRegionHolders = new ArrayList<SimpleRegionBySelectorHolder>();
    private List<SimpleRegionBySelectorHolder> mLayoutRegionHolders = new ArrayList<SimpleRegionBySelectorHolder>();
    private List<SimpleRegionBySelectorHolder> mStrictRegionHolders = new ArrayList<SimpleRegionBySelectorHolder>();
    private List<SimpleRegionBySelectorHolder> mIgnoreColorsRegionHolders = new ArrayList<SimpleRegionBySelectorHolder>();

    EspressoCheckSettings() {
    }

    EspressoCheckSettings(Bitmap bitmap) {
        ArgumentGuard.notNull((Object)bitmap, (String)"Check bitmap");
        this.mBitmap = bitmap;
        this.isBitmap = true;
    }

    EspressoCheckSettings(Region region) {
        super(region);
    }

    EspressoCheckSettings(Matcher matcher) {
        this.mTargetMatcher = matcher;
    }

    EspressoCheckSettings(SemanticsMatcher semanticsMatcher) {
        this.mTargetSemanticsMatcher = semanticsMatcher;
    }

    EspressoCheckSettings(View view) {
        this.mTargetView = view;
    }

    EspressoCheckSettings(boolean googleMap) {
        this.mGoogleMap = googleMap;
    }

    @Override
    public Matcher getTargetMatcher() {
        return this.mTargetMatcher;
    }

    public SemanticsMatcher getTargetSemanticsMatcher() {
        return this.mTargetSemanticsMatcher;
    }

    @Override
    public View getTargetView() {
        return this.mTargetView;
    }

    @Override
    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    @Override
    public boolean isBitmap() {
        return this.isBitmap;
    }

    @Override
    public boolean isGoogleMap() {
        return this.mGoogleMap;
    }

    @Override
    public boolean isNotSupportMap() {
        return this.mIsNotSupportMap;
    }

    @Override
    public Integer getId() {
        return this.mId;
    }

    @Override
    public boolean isDialogView() {
        return this.mDialog;
    }

    @Override
    public boolean isPopupView() {
        return this.mPopupView;
    }

    @Override
    public View getScrollRootElement() {
        return this.scrollRootElement;
    }

    @Override
    public Integer getScrollRootElementId() {
        return this.scrollRootElementId;
    }

    @Override
    public Matcher getScrollRootElementMatcher() {
        return this.scrollRootElementMatcher;
    }

    @Override
    public boolean hasScrollRootElement() {
        return this.scrollRootElementId != null || this.scrollRootElement != null || this.scrollRootElementMatcher != null;
    }

    @Override
    public IEspressoCheckSettings region(Region region) {
        super.updateTargetRegion(region);
        return this;
    }

    @Override
    public IEspressoCheckSettings region(SemanticsMatcher semanticsMatcher) {
        this.mTargetSemanticsMatcher = semanticsMatcher;
        this.mTargetMatcher = null;
        return this;
    }

    @Override
    public IEspressoCheckSettings region(Matcher matcher) {
        this.mTargetMatcher = matcher;
        this.mTargetSemanticsMatcher = null;
        return this;
    }

    @Override
    public IEspressoCheckSettings ignore(Matcher ... matchers) {
        for (Matcher matcher : matchers) {
            this.mIgnoreRegionHolders.add(new SimpleRegionBySelectorHolder(this, matcher));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings ignore(Matcher matcher, Padding padding, Matcher ... matchers) {
        this.mIgnoreRegionHolders.add(new SimpleRegionBySelectorHolder(this, matcher, padding));
        for (Matcher matcher1 : matchers) {
            this.mIgnoreRegionHolders.add(new SimpleRegionBySelectorHolder(this, matcher1, padding));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings layout(Matcher ... matchers) {
        for (Matcher matcher : matchers) {
            this.mLayoutRegionHolders.add(new SimpleRegionBySelectorHolder(this, matcher));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings layout(Matcher matcher, Padding padding, Matcher ... matchers) {
        this.mLayoutRegionHolders.add(new SimpleRegionBySelectorHolder(this, matcher, padding));
        for (Matcher matcher1 : matchers) {
            this.mLayoutRegionHolders.add(new SimpleRegionBySelectorHolder(this, matcher1, padding));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings content(Matcher ... matchers) {
        for (Matcher matcher : matchers) {
            this.mIgnoreColorsRegionHolders.add(new SimpleRegionBySelectorHolder(this, matcher));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings content(Matcher matcher, Padding padding, Matcher ... matchers) {
        this.mIgnoreColorsRegionHolders.add(new SimpleRegionBySelectorHolder(this, matcher, padding));
        for (Matcher matcher1 : matchers) {
            this.mIgnoreColorsRegionHolders.add(new SimpleRegionBySelectorHolder(this, matcher1, padding));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings strict(Matcher ... matchers) {
        for (Matcher matcher : matchers) {
            this.mStrictRegionHolders.add(new SimpleRegionBySelectorHolder(this, matcher));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings strict(Matcher matcher, Padding padding, Matcher ... matchers) {
        this.mStrictRegionHolders.add(new SimpleRegionBySelectorHolder(this, matcher, padding));
        for (Matcher matcher1 : matchers) {
            this.mStrictRegionHolders.add(new SimpleRegionBySelectorHolder(this, matcher1, padding));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings accessibility(Matcher matcher, AccessibilityRegionType regionType) {
        this.accessibility_(new AccessibilityRegionBySelector(matcher, regionType));
        return this;
    }

    @Override
    public IEspressoCheckSettings ignore(SemanticsMatcher ... semanticsMatchers) {
        for (SemanticsMatcher semanticsMatcher : semanticsMatchers) {
            this.mIgnoreRegionHolders.add(new SimpleRegionBySelectorHolder(this, semanticsMatcher));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings ignore(SemanticsMatcher semanticsMatcher, Padding padding) {
        this.mIgnoreRegionHolders.add(new SimpleRegionBySelectorHolder(this, semanticsMatcher, padding));
        return this;
    }

    @Override
    public IEspressoCheckSettings layout(SemanticsMatcher ... semanticsMatchers) {
        for (SemanticsMatcher semanticsMatcher : semanticsMatchers) {
            this.mLayoutRegionHolders.add(new SimpleRegionBySelectorHolder(this, semanticsMatcher));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings layout(SemanticsMatcher semanticsMatcher, Padding padding) {
        this.mLayoutRegionHolders.add(new SimpleRegionBySelectorHolder(this, semanticsMatcher, padding));
        return this;
    }

    @Override
    public IEspressoCheckSettings ignoreColors(SemanticsMatcher ... semanticsMatchers) {
        for (SemanticsMatcher semanticsMatcher : semanticsMatchers) {
            this.mIgnoreColorsRegionHolders.add(new SimpleRegionBySelectorHolder(this, semanticsMatcher));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings ignoreColors(SemanticsMatcher semanticsMatcher, Padding padding) {
        this.mIgnoreColorsRegionHolders.add(new SimpleRegionBySelectorHolder(this, semanticsMatcher, padding));
        return this;
    }

    @Override
    public IEspressoCheckSettings strict(SemanticsMatcher ... semanticsMatchers) {
        for (SemanticsMatcher semanticsMatcher : semanticsMatchers) {
            this.mStrictRegionHolders.add(new SimpleRegionBySelectorHolder(this, semanticsMatcher));
        }
        return this;
    }

    @Override
    public IEspressoCheckSettings strict(SemanticsMatcher semanticsMatcher, Padding padding) {
        this.mStrictRegionHolders.add(new SimpleRegionBySelectorHolder(this, semanticsMatcher, padding));
        return this;
    }

    @Override
    public IEspressoCheckSettings accessibility(SemanticsMatcher semanticsMatcher, AccessibilityRegionType regionType) {
        return null;
    }

    @Override
    public IEspressoCheckSettings isNotSupportGoogleMap() {
        this.mIsNotSupportMap = true;
        return this;
    }

    @Override
    public IEspressoCheckSettings id(int id) {
        this.mId = id;
        return this;
    }

    @Override
    public IEspressoCheckSettings dialog() {
        this.mDialog = true;
        return this;
    }

    @Override
    public IEspressoCheckSettings popup() {
        this.mPopupView = true;
        return this;
    }

    public IEspressoCheckSettings fully() {
        return (EspressoCheckSettings)super.fully();
    }

    public IEspressoCheckSettings fully(boolean fully) {
        return (EspressoCheckSettings)super.fully(fully);
    }

    @Override
    public IEspressoCheckSettings scrollRootElement(View view) {
        this.scrollRootElement = view;
        return this;
    }

    @Override
    public IEspressoCheckSettings waitBetweenStitches(int waitBetweenStitches) {
        this.mWaitBetweenStitchesMillis = waitBetweenStitches;
        return this;
    }

    @Override
    public IEspressoCheckSettings scrollRootElement(int id) {
        this.scrollRootElementId = id;
        return this;
    }

    @Override
    public IEspressoCheckSettings scrollRootElement(Matcher matcher) {
        this.scrollRootElementMatcher = matcher;
        return this;
    }

    @Override
    public IEspressoCheckSettings stitchingOverlap(int sizePx, OVERLAP_EDGE overlapEdge) {
        if (overlapEdge != null) {
            this.mStitchingOverlap[overlapEdge.ordinal()] = Math.max(sizePx, 0);
        }
        return this;
    }

    @Override
    public int getStitchingOverlap(OVERLAP_EDGE edge) {
        return this.getStitchingOverlap(edge, null);
    }

    @Override
    public int getStitchingOverlap(OVERLAP_EDGE edge, Integer defaultValue) {
        if (this.mStitchingOverlap[edge.ordinal()] == null) {
            return defaultValue == null ? 0 : defaultValue;
        }
        return this.mStitchingOverlap[edge.ordinal()];
    }

    @Override
    public IEspressoCheckSettings setScreenshotMode(ScreenshotMode screenshotMode) {
        this.mScreenshotMode = screenshotMode;
        return this;
    }

    @Override
    public ScreenshotMode getScreenShotMode() {
        return this.getScreenShotMode(null);
    }

    @Override
    public ScreenshotMode getScreenShotMode(ScreenshotMode defaultValue) {
        if (this.mScreenshotMode == null) {
            return defaultValue == null ? Configuration.DEFAULT_SCREENSHOT_MODE : defaultValue;
        }
        return this.mScreenshotMode;
    }

    @Override
    public IEspressoCheckSettings setLazyLoadOptions(LazyLoadOptions lazyLoadOptions) {
        this.mLazyLoadOptions = lazyLoadOptions;
        return this;
    }

    @Override
    @Deprecated
    public LazyLoadOptions getLazyLoadOptions() {
        return this.getLazyLoadOptions(null);
    }

    @Override
    @Deprecated
    public LazyLoadOptions getLazyLoadOptions(LazyLoadOptions defaultValue) {
        if (this.mLazyLoadOptions == null) {
            return defaultValue == null ? new LazyLoadOptions() : defaultValue;
        }
        return this.mLazyLoadOptions;
    }

    @Override
    public IEspressoCheckSettings setWaitBeforeCapture(int millis) {
        this.mWaitBeforeCaptureMillis = millis;
        return this;
    }

    @Override
    public IEspressoCheckSettings setWaitBetweenStitches(int millis) {
        this.mWaitBetweenStitchesMillis = millis;
        if (this.mLazyLoadOptions == null) {
            this.mLazyLoadOptions = new LazyLoadOptions(this.getWaitBetweenStitches());
        }
        return this;
    }

    @Override
    public int getWaitBeforeCapture() {
        return this.getWaitBeforeCapture(null);
    }

    @Override
    public int getWaitBeforeCapture(Integer defaultValue) {
        if (this.mWaitBeforeCaptureMillis == null) {
            return defaultValue == null ? Configuration.DEFAULT_WAIT_BEFORE_CAPTURE : defaultValue;
        }
        return this.mWaitBeforeCaptureMillis;
    }

    @Override
    public int getWaitBetweenStitches() {
        return this.getWaitBetweenStitches(null);
    }

    @Override
    public int getWaitBetweenStitches(Integer defaultValue) {
        if (this.mWaitBetweenStitchesMillis == null) {
            return defaultValue == null ? Configuration.DEFAULT_WAIT_BETWEEN_STITCHES : defaultValue;
        }
        return this.mWaitBetweenStitchesMillis;
    }

    public IEspressoCheckSettings setDensitySettings(DensitySettings densitySettings) {
        this.mDensitySettings = densitySettings;
        return this;
    }

    public DensitySettings getDensitySettings() {
        return this.mDensitySettings;
    }

    @Override
    public List<SimpleRegionBySelectorHolder> getIgnoreRegionHolders() {
        return this.mIgnoreRegionHolders;
    }

    @Override
    public void setIgnore(List<GetRegion> getRegions) {
        for (GetRegion getRegion : getRegions) {
            this.ignore(getRegion);
        }
    }

    @Override
    public List<SimpleRegionBySelectorHolder> getLayoutRegionHolders() {
        return this.mLayoutRegionHolders;
    }

    @Override
    public void setLayout(List<GetRegion> getRegions) {
        for (GetRegion getRegion : getRegions) {
            this.layout(getRegion);
        }
    }

    @Override
    public List<SimpleRegionBySelectorHolder> getStrictRegionHolders() {
        return this.mStrictRegionHolders;
    }

    @Override
    public void setStrict(List<GetRegion> getRegions) {
        for (GetRegion getRegion : getRegions) {
            this.strict(getRegion);
        }
    }

    @Override
    public List<SimpleRegionBySelectorHolder> getIgnoreColorsRegionHolders() {
        return this.mIgnoreColorsRegionHolders;
    }

    @Override
    public void setContent(List<GetRegion> getRegions) {
        for (GetRegion getRegion : getRegions) {
            this.content(getRegion);
        }
    }

    public EspressoCheckSettings clone() {
        EspressoCheckSettings clone = new EspressoCheckSettings();
        super.populateClone((CheckSettings)clone);
        clone.mTargetMatcher = this.mTargetMatcher;
        clone.mTargetSemanticsMatcher = this.mTargetSemanticsMatcher;
        clone.mTargetView = this.mTargetView;
        clone.mGoogleMap = this.mGoogleMap;
        clone.mIsNotSupportMap = this.mIsNotSupportMap;
        clone.mId = this.mId;
        clone.mDialog = this.mDialog;
        clone.mPopupView = this.mPopupView;
        clone.isBitmap = this.isBitmap;
        clone.mBitmap = this.mBitmap;
        clone.mStitchingOverlap = Arrays.copyOf(this.mStitchingOverlap, this.mStitchingOverlap.length);
        clone.mScreenshotMode = this.mScreenshotMode;
        clone.mLazyLoadOptions = this.mLazyLoadOptions;
        clone.mWaitBeforeCaptureMillis = this.mWaitBeforeCaptureMillis;
        clone.mWaitBetweenStitchesMillis = this.mWaitBetweenStitchesMillis;
        clone.mIgnoreRegionHolders = this.mIgnoreRegionHolders;
        clone.mLayoutRegionHolders = this.mLayoutRegionHolders;
        clone.mStrictRegionHolders = this.mStrictRegionHolders;
        clone.mIgnoreColorsRegionHolders = this.mIgnoreColorsRegionHolders;
        return clone;
    }

    public String toString() {
        return "EspressoCheckSettings{mTargetMatcher=" + this.mTargetMatcher + ", mTargetSemanticsMatcher=" + this.mTargetSemanticsMatcher + ", mTargetView=" + this.mTargetView + ", mGoogleMap=" + this.mGoogleMap + ", mIsNotSupportMap=" + this.mIsNotSupportMap + ", mId=" + this.mId + ", mDialog=" + this.mDialog + ", mPopupView=" + this.mPopupView + ", mBitmap=" + this.mBitmap + ", scrollRootElementId=" + this.scrollRootElementId + ", scrollRootElement=" + this.scrollRootElement + ", scrollRootElementMatcher=" + this.scrollRootElementMatcher + ", ignoreRegions=" + Arrays.toString(this.getIgnoreRegions()) + ", layoutRegions=" + Arrays.toString(this.getLayoutRegions()) + ", strictRegions=" + Arrays.toString(this.getStrictRegions()) + ", contentRegions=" + Arrays.toString(this.getContentRegions()) + ", mIgnoreRegionHolders=" + this.mIgnoreRegionHolders + ", mLayoutRegionHolders=" + this.mLayoutRegionHolders + ", mStrictRegionHolders=" + this.mStrictRegionHolders + ", mIgnoreColorsRegionHolders=" + this.mIgnoreColorsRegionHolders + ", floatingRegions=" + Arrays.toString(this.getFloatingRegions()) + ", accessibilityRegions=" + Arrays.toString(this.getAccessibilityRegions()) + ", mStitchingOverlap=" + Arrays.toString((Object[])this.mStitchingOverlap) + ", mLazyLoadOptions=" + this.mLazyLoadOptions + ", mScreenshotMode=" + this.mScreenshotMode + ", mWaitBeforeCaptureMillis=" + this.mWaitBeforeCaptureMillis + ", mWaitBetweenStitchesMillis=" + this.mWaitBetweenStitchesMillis + '}';
    }

    @Override
    @RequiresApi(api=26)
    public ScreenshotSettings buildNMLScreenshotSettings() {
        LazyLoadOptions lazyLoadOptions;
        ScreenshotSettings screenshotSettings = new ScreenshotSettings();
        screenshotSettings.setHideCaret(this.getHideCaret());
        screenshotSettings.setWaitBeforeCapture(this.getWaitBeforeCapture(0));
        screenshotSettings.setFully(this.getStitchContent());
        screenshotSettings.setWaitBetweenStitches(this.getWaitBetweenStitches());
        if (this.getScrollRootElement() != null) {
            screenshotSettings.setScrollRootElement(this.getScrollRootElement());
        }
        if (this.getScrollRootElementId() != null) {
            screenshotSettings.setScrollRootElement(this.getScrollRootElementId());
        }
        if (this.getTargetRegion() != null) {
            screenshotSettings.setRegion(this.getTargetRegion());
        }
        if (this.getTargetMatcher() != null) {
            screenshotSettings.setRegion(new RegionSelectorHolder((Object)this.getTargetMatcher()));
        }
        if (this.getTargetSemanticsMatcher() != null) {
            SemanticsMatcher targetSemanticsMatcher = this.getTargetSemanticsMatcher();
            List<ViewSelectorHolder> viewSelectorHolders = SemanticsMatcherInspector.semanticsMatcherToViewSelectorHolder(targetSemanticsMatcher);
            if (viewSelectorHolders.size() != 1) {
                throw new EyesException("Only a single semantic matcher can be used for target region!");
            }
            screenshotSettings.setRegion(viewSelectorHolders.get(0).getCommonSelector());
        }
        if (this.getTargetView() != null) {
            screenshotSettings.setRegion(this.getTargetView());
        }
        if (this.isDialogView()) {
            screenshotSettings.captureDialog();
            screenshotSettings.setRegion(new AndroidXComponentsProvider().getDialogView());
        }
        if (this.isPopupView()) {
            screenshotSettings.captureDialog();
            screenshotSettings.setRegion(new AndroidXComponentsProvider().getPopupView());
        }
        if ((lazyLoadOptions = this.getLazyLoadOptions()) != null) {
            this.setWaitBetweenStitches(lazyLoadOptions.delayBetweenScrolls);
        }
        ArrayList<ViewSelectorHolder> selectorsToFindRegionsFor = new ArrayList<ViewSelectorHolder>();
        if (this.getIgnoreColorsRegionHolders() != null) {
            selectorsToFindRegionsFor.addAll(this.simpleRegionBySelectorHoldersToViewSelectorHolders(this.getIgnoreColorsRegionHolders()));
        }
        if (this.getIgnoreRegionHolders() != null) {
            selectorsToFindRegionsFor.addAll(this.simpleRegionBySelectorHoldersToViewSelectorHolders(this.getIgnoreRegionHolders()));
        }
        if (this.getLayoutRegionHolders() != null) {
            selectorsToFindRegionsFor.addAll(this.simpleRegionBySelectorHoldersToViewSelectorHolders(this.getLayoutRegionHolders()));
        }
        if (this.getStrictRegionHolders() != null) {
            selectorsToFindRegionsFor.addAll(this.simpleRegionBySelectorHoldersToViewSelectorHolders(this.getStrictRegionHolders()));
        }
        screenshotSettings.setSelectorsToFindRegionsFor(selectorsToFindRegionsFor);
        return screenshotSettings;
    }

    @RequiresApi(api=26)
    private ArrayList<ViewSelectorHolder> simpleRegionBySelectorHoldersToViewSelectorHolders(List<SimpleRegionBySelectorHolder> selectorHolders) {
        ArrayList<ViewSelectorHolder> selectorsToFindRegionsFor = new ArrayList<ViewSelectorHolder>();
        for (SimpleRegionBySelectorHolder selectorHolder : selectorHolders) {
            if (selectorHolder.isSemantics()) {
                selectorsToFindRegionsFor.addAll(SemanticsMatcherInspector.semanticsMatcherToViewSelectorHolder(selectorHolder.getSemanticsMatcher()));
                continue;
            }
            selectorsToFindRegionsFor.add(new ViewSelectorHolder((Object)selectorHolder.getMatcher()));
        }
        return selectorsToFindRegionsFor;
    }
}

