/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso.regions;

import androidx.compose.ui.test.SemanticsMatcher;
import com.applitools.eyes.android.espresso.fluent.EspressoCheckSettings;
import com.applitools.eyes.android.espresso.fluent.Padding;
import org.hamcrest.Matcher;

public class SimpleRegionBySelectorHolder {
    private final Matcher mMatcher;
    private final SemanticsMatcher mSemanticsMatcher;
    private final Padding padding;
    private final boolean isWindowBased;

    public SimpleRegionBySelectorHolder(EspressoCheckSettings checkSettings, Matcher matcher, Padding padding) {
        this.mMatcher = matcher;
        this.mSemanticsMatcher = null;
        this.padding = padding;
        this.isWindowBased = checkSettings.isDialogView() || checkSettings.isPopupView();
    }

    public SimpleRegionBySelectorHolder(EspressoCheckSettings checkSettings, Matcher matcher) {
        this(checkSettings, matcher, new Padding());
    }

    public SimpleRegionBySelectorHolder(EspressoCheckSettings checkSettings, SemanticsMatcher semanticsMatcher, Padding padding) {
        this.mMatcher = null;
        this.mSemanticsMatcher = semanticsMatcher;
        this.padding = padding;
        this.isWindowBased = checkSettings.isDialogView() || checkSettings.isPopupView();
    }

    public SimpleRegionBySelectorHolder(EspressoCheckSettings checkSettings, SemanticsMatcher semanticsMatcher) {
        this(checkSettings, semanticsMatcher, new Padding());
    }

    public Matcher getMatcher() {
        return this.mMatcher;
    }

    public SemanticsMatcher getSemanticsMatcher() {
        return this.mSemanticsMatcher;
    }

    public Padding getPadding() {
        return this.padding;
    }

    public boolean getIsWindowBased() {
        return this.isWindowBased;
    }

    public boolean isSemantics() {
        return this.mSemanticsMatcher != null;
    }

    public String toString() {
        return "SimpleRegionBySelectorHolder{mMatcher=" + this.mMatcher + ", mSemanticsMatcher=" + (this.mSemanticsMatcher == null ? "null" : this.mSemanticsMatcher.getDescription()) + ", padding=" + this.padding + ", isWindowBased=" + this.isWindowBased + '}';
    }
}

