/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso;

import android.graphics.Bitmap;
import com.applitools.eyes.android.common.EyesScreenshot;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.common.exceptions.OutOfBoundsException;
import com.applitools.eyes.android.common.logger.Logger;
import com.applitools.eyes.android.common.utils.ArgumentGuard;
import com.applitools.eyes.android.espresso.utils.ImageUtils;

class EyesImageScreenshot
extends EyesScreenshot {
    private final Logger mLogger;
    private Bitmap mBitmap;

    public EyesImageScreenshot(Logger logger, byte[] image) {
        super(image);
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.mLogger = logger;
        this.mBitmap = ImageUtils.bytesToBitmap(image);
        logger.verbose("Done!");
    }

    public EyesScreenshot getSubScreenshot(Region region) {
        this.mLogger.verbose(String.format("getSubScreenshot([%s]", region));
        ArgumentGuard.notNull((Object)region, (String)"region");
        if (region.getTop() + region.getHeight() > this.mBitmap.getHeight() || region.getLeft() + region.getWidth() > this.mBitmap.getWidth()) {
            throw new OutOfBoundsException(String.format("Region [%s] is out of screenshot bounds", region));
        }
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)this.mBitmap, (int)region.getLeft(), (int)region.getTop(), (int)region.getWidth(), (int)region.getHeight());
        EyesImageScreenshot screenshot = new EyesImageScreenshot(this.mLogger, ImageUtils.bitmapToBytes(bitmap));
        this.mLogger.verbose("Done!");
        return screenshot;
    }

    public int getWidth() {
        return this.mBitmap.getWidth();
    }

    public int getHeight() {
        return this.mBitmap.getHeight();
    }
}

