/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.android.espresso.fluent;

import android.app.Activity;
import android.content.Context;
import com.applitools.eyes.android.common.IEyesBase;
import com.applitools.eyes.android.common.Region;
import com.applitools.eyes.android.components.IComponentsProvider;
import com.applitools.eyes.android.components.ViewAndLocation;
import com.applitools.eyes.android.core.fluent.GetRegion;
import com.applitools.eyes.android.espresso.EspressoEyes;
import com.applitools.eyes.android.espresso.fluent.EspressoCheckSettings;
import com.applitools.eyes.android.espresso.fluent.Padding;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;

public class IgnoreRegionBySelector
implements GetRegion {
    private final Matcher mMatcher;
    private final Padding padding;
    private final boolean isWindowBased;

    public IgnoreRegionBySelector(EspressoCheckSettings checkSettings, Matcher matcher, Padding padding) {
        this.mMatcher = matcher;
        this.padding = padding;
        this.isWindowBased = checkSettings.isDialogView() || checkSettings.isPopupView();
    }

    public IgnoreRegionBySelector(EspressoCheckSettings checkSettings, Matcher matcher) {
        this(checkSettings, matcher, new Padding());
    }

    public List<Region> getRegions(IEyesBase eyesBase) {
        IComponentsProvider componentsProvider = ((EspressoEyes)eyesBase).getComponentsProvider();
        componentsProvider.getLogger().verbose("IgnoreRegionBySelector for matcher: " + this.mMatcher.toString());
        ViewAndLocation viewAndLocation = ((EspressoEyes)eyesBase).getComponentsProvider().findView(this.mMatcher);
        if (viewAndLocation == null) {
            return null;
        }
        if (this.isWindowBased) {
            int[] location = new int[2];
            viewAndLocation.getView().getLocationInWindow(location);
            ArrayList<Region> value = new ArrayList<Region>();
            value.add(new Region(viewAndLocation.getView().getWidth() + this.padding.getLeft() + this.padding.getRight(), viewAndLocation.getView().getHeight() + this.padding.getTop() + this.padding.getBottom(), location[1] - this.padding.getTop(), location[0] - this.padding.getLeft()));
            return value;
        }
        Activity activity = ((EspressoEyes)eyesBase).getComponentsProvider().scanForActivity(viewAndLocation.getView().getContext());
        int statusBarHeight = ((EspressoEyes)eyesBase).getComponentsProvider().getStatusBarHeight((Context)activity);
        int statusBarHeightToRemove = componentsProvider.isContentUnderBars(activity, 1) ? 0 : statusBarHeight;
        ArrayList<Region> value = new ArrayList<Region>();
        value.add(new Region(viewAndLocation.getView().getWidth() + this.padding.getLeft() + this.padding.getRight(), viewAndLocation.getView().getHeight() + this.padding.getTop() + this.padding.getBottom(), viewAndLocation.getLocation()[1] - statusBarHeightToRemove - this.padding.getTop(), viewAndLocation.getLocation()[0] - this.padding.getLeft()));
        return value;
    }

    public String toString() {
        return "IgnoreRegionBySelector{mMatcher=" + this.mMatcher + ", padding=" + this.padding + '}';
    }
}

