/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.CutProvider;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.appium.AndroidScrollPositionProvider;
import com.applitools.eyes.appium.AppiumFullPageCaptureAlgorithm;
import com.applitools.eyes.appium.AppiumScrollPositionProvider;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.WebElement;

public class AndroidFullPageCaptureAlgorithm
extends AppiumFullPageCaptureAlgorithm {
    private String scrollableElementId = null;

    public AndroidFullPageCaptureAlgorithm(Logger logger, String testId, AppiumScrollPositionProvider scrollProvider, ImageProvider imageProvider, DebugScreenshotsProvider debugScreenshotsProvider, ScaleProviderFactory scaleProviderFactory, CutProvider cutProvider, EyesScreenshotFactory screenshotFactory, int waitBeforeScreenshots, Integer stitchingAdjustment, WebElement scrollRootElement) {
        super(logger, testId, scrollProvider, imageProvider, debugScreenshotsProvider, scaleProviderFactory, cutProvider, screenshotFactory, waitBeforeScreenshots, null, stitchingAdjustment, scrollRootElement);
        this.coordinatesAreScaled = true;
        if (scrollRootElement != null) {
            this.scrollableElementId = scrollRootElement.getAttribute("resourceId").split("/")[1];
        }
    }

    @Override
    protected void captureAndStitchTailParts(RectangleSize entireSize, RectangleSize initialPartSize) {
        Region regionToCrop;
        Region scrollViewRegion = this.scaleSafe(((AppiumScrollPositionProvider)this.scrollProvider).getScrollableViewRegion());
        Location originalViewLocation = new Location(scrollViewRegion.getLeft(), scrollViewRegion.getTop());
        Location newLoc = new Location(originalViewLocation.getX(), originalViewLocation.getY() - this.scaleSafe(((AppiumScrollPositionProvider)this.scrollProvider).getStatusBarHeight()));
        RectangleSize newSize = new RectangleSize(initialPartSize.getWidth(), scrollViewRegion.getHeight());
        scrollViewRegion.setLocation(newLoc);
        scrollViewRegion.setSize(newSize);
        ContentSize contentSize = ((AppiumScrollPositionProvider)this.scrollProvider).getCachedContentSize();
        int xPos = scrollViewRegion.getLeft() + 1;
        int oneScrollStep = scrollViewRegion.getHeight() - this.stitchingAdjustment;
        int maxScrollSteps = contentSize.getScrollContentHeight() / oneScrollStep;
        this.logger.log(TraceLevel.Debug, this.testId, Stage.CHECK, new Pair[]{Pair.of((Object)"entireScrollableHeight", (Object)contentSize.getScrollContentHeight()), Pair.of((Object)"oneScrollStep", (Object)oneScrollStep)});
        for (int step = 1; step <= maxScrollSteps; ++step) {
            regionToCrop = new Region(0, scrollViewRegion.getTop() + this.stitchingAdjustment, initialPartSize.getWidth(), scrollViewRegion.getHeight() - this.stitchingAdjustment);
            this.currentPosition = new Location(0, scrollViewRegion.getTop() + scrollViewRegion.getHeight() * step - (this.stitchingAdjustment * step - this.stitchingAdjustment));
            int startY = scrollViewRegion.getHeight() + originalViewLocation.getY() - 1 - (step != maxScrollSteps ? this.stitchingAdjustment / 2 : 0);
            int endY = originalViewLocation.getY() + (step != maxScrollSteps ? this.stitchingAdjustment / 2 : 0);
            boolean isScrolledWithHelperLibrary = false;
            if (this.scrollableElementId != null) {
                this.logger.log(TraceLevel.Debug, this.testId, Stage.CHECK, new Pair[]{Pair.of((Object)"scrollRootElementId", (Object)this.scrollableElementId)});
                isScrolledWithHelperLibrary = ((AndroidScrollPositionProvider)this.scrollProvider).tryScrollWithHelperLibrary(this.scrollableElementId, startY - endY, step, maxScrollSteps);
                if (step == maxScrollSteps && isScrolledWithHelperLibrary) {
                    ((AndroidScrollPositionProvider)this.scrollProvider).tryScrollWithHelperLibrary(this.scrollableElementId, startY - endY, -1, maxScrollSteps);
                }
            }
            if (!isScrolledWithHelperLibrary) {
                ((AppiumScrollPositionProvider)this.scrollProvider).scrollTo(xPos, startY, xPos, endY, step != maxScrollSteps);
            }
            if (step == maxScrollSteps) {
                int cropTo = contentSize.getScrollContentHeight() - oneScrollStep * step;
                int cropFrom = oneScrollStep - cropTo + scrollViewRegion.getTop() + this.stitchingAdjustment;
                regionToCrop = new Region(0, cropFrom, initialPartSize.getWidth(), cropTo);
                this.currentPosition = new Location(0, scrollViewRegion.getTop() + scrollViewRegion.getHeight() * step - this.stitchingAdjustment * step);
            }
            this.captureAndStitchCurrentPart(regionToCrop);
        }
        int heightUnderScrollableView = initialPartSize.getHeight() - oneScrollStep - scrollViewRegion.getTop();
        if (heightUnderScrollableView > 0) {
            regionToCrop = new Region(0, scrollViewRegion.getHeight() + scrollViewRegion.getTop() - this.stitchingAdjustment, initialPartSize.getWidth(), heightUnderScrollableView);
            this.currentPosition = new Location(0, scrollViewRegion.getTop() + contentSize.getScrollContentHeight() - this.stitchingAdjustment);
            this.captureAndStitchCurrentPart(regionToCrop);
        }
        this.moveToTopLeft();
    }

    @Override
    protected void moveToTopLeft() {
        boolean isScrolledWithHelperLibrary = false;
        if (this.scrollableElementId != null) {
            isScrolledWithHelperLibrary = ((AndroidScrollPositionProvider)this.scrollProvider).moveToTop(this.scrollableElementId);
        }
        if (!isScrolledWithHelperLibrary) {
            super.moveToTopLeft();
        }
    }

    @Override
    protected void moveToTopLeft(int startX, int startY, int endX, int endY) {
        this.moveToTopLeft();
    }
}

