/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.appium.AppiumScrollPositionProvider;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.selenium.exceptions.EyesDriverOperationException;
import com.applitools.eyes.selenium.positioning.NullRegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.WebElement;

public class AppiumFullPageCaptureAlgorithm {
    protected static final int DEFAULT_STITCHING_ADJUSTMENT = 50;
    protected Logger logger;
    protected final String testId;
    private final PositionProvider originProvider;
    protected final ImageProvider imageProvider;
    protected final DebugScreenshotsProvider debugScreenshotsProvider;
    private final ScaleProviderFactory scaleProviderFactory;
    private final EyesScreenshotFactory screenshotFactory;
    protected final int waitBeforeScreenshots;
    private PositionMemento originalPosition;
    private ScaleProvider scaleProvider;
    private CutProvider cutProvider;
    protected Region regionInScreenshot;
    private double pixelRatio;
    private BufferedImage stitchedImage;
    protected Location currentPosition;
    protected WebElement scrollRootElement;
    protected boolean coordinatesAreScaled;
    protected final PositionProvider positionProvider;
    protected final ScrollPositionProvider scrollProvider;
    private final WebElement cutElement;
    protected Integer stitchingAdjustment = 50;

    public AppiumFullPageCaptureAlgorithm(Logger logger, String testId, PositionProvider originProvider, PositionProvider positionProvider, ScrollPositionProvider scrollProvider, ImageProvider imageProvider, DebugScreenshotsProvider debugScreenshotsProvider, ScaleProviderFactory scaleProviderFactory, CutProvider cutProvider, EyesScreenshotFactory screenshotFactory, int waitBeforeScreenshots, WebElement cutElement, Integer stitchingAdjustment) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.testId = testId;
        this.originProvider = originProvider;
        this.positionProvider = positionProvider;
        this.scrollProvider = scrollProvider;
        this.imageProvider = imageProvider;
        this.debugScreenshotsProvider = debugScreenshotsProvider;
        this.scaleProviderFactory = scaleProviderFactory;
        this.cutProvider = cutProvider;
        this.screenshotFactory = screenshotFactory;
        this.waitBeforeScreenshots = waitBeforeScreenshots;
        this.pixelRatio = 1.0;
        this.originalPosition = null;
        this.scaleProvider = null;
        this.regionInScreenshot = null;
        this.stitchedImage = null;
        this.currentPosition = null;
        this.coordinatesAreScaled = false;
        this.cutElement = cutElement;
        if (stitchingAdjustment != null) {
            this.stitchingAdjustment = stitchingAdjustment;
        }
    }

    public AppiumFullPageCaptureAlgorithm(Logger logger, String testId, AppiumScrollPositionProvider scrollProvider, ImageProvider imageProvider, DebugScreenshotsProvider debugScreenshotsProvider, ScaleProviderFactory scaleProviderFactory, CutProvider cutProvider, EyesScreenshotFactory screenshotFactory, int waitBeforeScreenshots, WebElement cutElement, Integer stitchingAdjustment, WebElement scrollRootElement) {
        this(logger, testId, (PositionProvider)scrollProvider, (PositionProvider)scrollProvider, scrollProvider, imageProvider, debugScreenshotsProvider, scaleProviderFactory, cutProvider, screenshotFactory, waitBeforeScreenshots, cutElement, stitchingAdjustment);
        this.scrollRootElement = scrollRootElement;
        scrollProvider.setScrollRootElement(scrollRootElement);
    }

    protected RectangleSize captureAndStitchCurrentPart(Region partRegion) {
        GeneralUtils.sleep((long)this.waitBeforeScreenshots);
        BufferedImage partImage = this.imageProvider.getImage();
        this.debugScreenshotsProvider.save(partImage, "original-scrolled=" + this.currentPosition.toStringForFilename());
        this.setRegionInScreenshot(partImage, partRegion, (RegionPositionCompensation)new NullRegionPositionCompensation());
        partImage = this.cropPartToRegion(partImage, partRegion);
        this.stitchPartIntoContainer(partImage);
        return new RectangleSize(partImage.getWidth(), partImage.getHeight());
    }

    protected void captureAndStitchTailParts(RectangleSize entireSize, RectangleSize initialPartSize) {
        Region regionToCrop;
        RectangleSize lastSuccessfulPartSize = new RectangleSize(initialPartSize.getWidth(), initialPartSize.getHeight());
        PositionMemento originalStitchedState = this.scrollProvider.getState();
        int statusBarHeight = ((AppiumScrollPositionProvider)this.scrollProvider).getStatusBarHeight();
        Region scrollViewRegion = this.scaleSafe(((AppiumScrollPositionProvider)this.scrollProvider).getScrollableViewRegion());
        Location newLoc = new Location(scrollViewRegion.getLeft(), scrollViewRegion.getTop() - this.scaleSafe(statusBarHeight) + 1);
        RectangleSize newSize = new RectangleSize(initialPartSize.getWidth(), scrollViewRegion.getHeight() - 1);
        if (this.scrollRootElement == null) {
            scrollViewRegion.setLocation(newLoc);
        }
        scrollViewRegion.setSize(newSize);
        ((AppiumScrollPositionProvider)this.scrollProvider).setCutElement(this.cutElement);
        ContentSize contentSize = ((AppiumScrollPositionProvider)this.scrollProvider).getCachedContentSize();
        int xPos = this.downscaleSafe(scrollViewRegion.getLeft() + 1);
        int oneScrollStep = this.downscaleSafe(scrollViewRegion.getHeight() - this.stitchingAdjustment);
        int maxScrollSteps = contentSize.getScrollContentHeight() / oneScrollStep;
        int startY = this.downscaleSafe(scrollViewRegion.getHeight() + scrollViewRegion.getTop()) - 1 - this.stitchingAdjustment / 2;
        int endY = startY - oneScrollStep + 2 + this.stitchingAdjustment / 2;
        for (int step = 1; step <= maxScrollSteps; ++step) {
            regionToCrop = new Region(0, scrollViewRegion.getTop() + this.stitchingAdjustment, initialPartSize.getWidth(), scrollViewRegion.getHeight() - this.stitchingAdjustment);
            ((AppiumScrollPositionProvider)this.scrollProvider).scrollTo(xPos, startY, xPos, endY, false);
            this.currentPosition = this.scaleSafe(((AppiumScrollPositionProvider)this.scrollProvider).getCurrentPositionWithoutStatusBar(true));
            this.currentPosition = new Location(this.currentPosition.getX(), this.currentPosition.getY() + 1 + this.stitchingAdjustment + (this.scrollRootElement == null ? 0 : this.scaleSafe(statusBarHeight)));
            lastSuccessfulPartSize = this.captureAndStitchCurrentPart(regionToCrop);
        }
        int heightUnderScrollableView = initialPartSize.getHeight() - this.scaleSafe(oneScrollStep) - scrollViewRegion.getTop();
        if (heightUnderScrollableView > 0) {
            regionToCrop = new Region(0, scrollViewRegion.getHeight() + scrollViewRegion.getTop() - this.stitchingAdjustment, initialPartSize.getWidth(), heightUnderScrollableView);
            this.currentPosition = new Location(this.currentPosition.getX(), this.currentPosition.getY() + lastSuccessfulPartSize.getHeight() - this.stitchingAdjustment);
            lastSuccessfulPartSize = this.captureAndStitchCurrentPart(regionToCrop);
        }
        this.cleanupStitch(originalStitchedState, this.currentPosition, lastSuccessfulPartSize, entireSize);
        this.moveToTopLeft(xPos, endY + statusBarHeight + 50 + this.stitchingAdjustment, xPos, startY + statusBarHeight);
    }

    private void saveDebugScreenshotPart(BufferedImage image, Region region, String name) {
        String suffix = "part-" + name + "-" + region.getLeft() + "_" + region.getTop() + "_" + region.getWidth() + "x" + region.getHeight();
        this.debugScreenshotsProvider.save(image, suffix);
    }

    protected void moveToTopLeft(int startX, int startY, int endX, int endY) {
        this.currentPosition = this.originProvider.getCurrentPosition();
        if (this.currentPosition.getX() <= 0 && this.currentPosition.getY() <= 0) {
            return;
        }
        if (startX == 0 && startY == 0 && endX == 0 && endY == 0) {
            Region scrollViewRegion = this.scaleSafe(((AppiumScrollPositionProvider)this.scrollProvider).getScrollableViewRegion());
            int oneScrollStep = this.downscaleSafe(scrollViewRegion.getHeight());
            startX = endX = this.downscaleSafe(scrollViewRegion.getLeft() + 1);
            startY = this.downscaleSafe(scrollViewRegion.getTop()) + 1;
            endY = startY + oneScrollStep - 2;
        }
        do {
            ((AppiumScrollPositionProvider)this.scrollProvider).scrollTo(startX, startY, endX, endY, false);
            GeneralUtils.sleep((long)this.waitBeforeScreenshots);
            this.currentPosition = this.originProvider.getCurrentPosition();
        } while (this.currentPosition.getX() > 0 || this.currentPosition.getY() > 0);
    }

    protected void moveToTopLeft() {
        this.currentPosition = this.originProvider.getCurrentPosition();
        if (this.currentPosition.getX() <= 0 && this.currentPosition.getY() <= 0) {
            return;
        }
        int setPositionRetries = 3;
        do {
            this.originProvider.setPosition(new Location(0, 0));
            GeneralUtils.sleep((long)this.waitBeforeScreenshots);
            this.currentPosition = this.originProvider.getCurrentPosition();
        } while (this.currentPosition.getX() != 0 && this.currentPosition.getY() != 0 && --setPositionRetries > 0);
        if (this.currentPosition.getY() > 0) {
            this.originProvider.restoreState(this.originalPosition);
            throw new EyesException("Couldn't set position to the top/left corner!");
        }
    }

    private BufferedImage getTopLeftScreenshot() {
        this.moveToTopLeft(0, 0, 0, 0);
        BufferedImage image = this.imageProvider.getImage();
        this.debugScreenshotsProvider.save(image, "original");
        this.scaleProvider = this.scaleProviderFactory.getScaleProvider(image.getWidth());
        this.pixelRatio = 1.0 / this.scaleProvider.getScaleRatio();
        this.cutProvider = this.cutProvider.scale(this.pixelRatio);
        if (!(this.cutProvider instanceof NullCutProvider)) {
            image = this.cutProvider.cut(image);
            this.debugScreenshotsProvider.save(image, "original-cut");
        }
        return image;
    }

    private BufferedImage cropToRegion(BufferedImage image, Region region, RegionPositionCompensation regionPositionCompensation) {
        this.setRegionInScreenshot(image, region, regionPositionCompensation);
        if (!this.regionInScreenshot.isEmpty()) {
            image = ImageUtils.getImagePart((BufferedImage)image, (Region)this.regionInScreenshot);
            this.saveDebugScreenshotPart(image, region, "cropped");
        }
        return image;
    }

    private RectangleSize getEntireSize(BufferedImage image, boolean checkingAnElement) {
        RectangleSize entireSize;
        if (!checkingAnElement) {
            try {
                entireSize = this.scrollProvider.getEntireSize();
            }
            catch (EyesDriverOperationException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.CAPTURE_SCREENSHOT, (Throwable)e, (String[])new String[]{this.testId});
                entireSize = new RectangleSize(image.getWidth(), image.getHeight());
            }
        } else {
            entireSize = this.positionProvider.getEntireSize();
        }
        return entireSize;
    }

    protected void setRegionInScreenshot(BufferedImage image, Region region, RegionPositionCompensation regionPositionCompensation) {
        EyesScreenshot screenshot = this.screenshotFactory.makeScreenshot(image);
        this.regionInScreenshot = this.getRegionInScreenshot(region, image, this.pixelRatio, screenshot, regionPositionCompensation);
        if (!this.regionInScreenshot.getSize().equals((Object)region.getSize())) {
            this.regionInScreenshot = this.getRegionInScreenshot(region, image, this.pixelRatio, screenshot, regionPositionCompensation);
        }
    }

    protected BufferedImage cropPartToRegion(BufferedImage partImage, Region partRegion) {
        if (!(this.cutProvider instanceof NullCutProvider)) {
            partImage = this.cutProvider.cut(partImage);
            this.debugScreenshotsProvider.save(partImage, "original-scrolled-cut-" + this.currentPosition.toStringForFilename());
        }
        if (!this.regionInScreenshot.isEmpty()) {
            partImage = ImageUtils.getImagePart((BufferedImage)partImage, (Region)this.regionInScreenshot);
            this.saveDebugScreenshotPart(partImage, partRegion, "original-scrolled-" + this.currentPosition.toStringForFilename());
        }
        return partImage;
    }

    protected void cleanupStitch(PositionMemento originalStitchedState, Location lastSuccessfulLocation, RectangleSize lastSuccessfulPartSize, RectangleSize entireSize) {
        this.positionProvider.restoreState(originalStitchedState);
        this.originProvider.restoreState(this.originalPosition);
        int actualImageWidth = lastSuccessfulLocation.getX() + lastSuccessfulPartSize.getWidth();
        int actualImageHeight = lastSuccessfulLocation.getY() + lastSuccessfulPartSize.getHeight();
        if (actualImageWidth < this.stitchedImage.getWidth() || actualImageHeight < this.stitchedImage.getHeight()) {
            this.stitchedImage = ImageUtils.getImagePart((BufferedImage)this.stitchedImage, (Region)new Region(0, 0, Math.min(actualImageWidth, this.stitchedImage.getWidth()), Math.min(actualImageHeight, this.stitchedImage.getHeight())));
        }
        this.debugScreenshotsProvider.save(this.stitchedImage, "stitched");
    }

    protected void stitchPartIntoContainer(BufferedImage partImage) {
        this.stitchedImage.getRaster().setRect(0, this.currentPosition.getY(), partImage.getData());
    }

    public BufferedImage getStitchedRegion(Region region, RegionPositionCompensation regionPositionCompensation) {
        ArgumentGuard.notNull((Object)region, (String)"region");
        this.originalPosition = this.originProvider.getState();
        BufferedImage image = this.getTopLeftScreenshot();
        this.logger.log(this.testId, Stage.CHECK, Type.CAPTURE_SCREENSHOT, new Pair[]{Pair.of((Object)"region", (Object)region), Pair.of((Object)"pixelRatio", (Object)this.pixelRatio), Pair.of((Object)"originProvider", (Object)this.originalPosition.getClass().getName()), Pair.of((Object)"positionProvider", (Object)this.positionProvider.getClass().getName()), Pair.of((Object)"cutProvider", (Object)this.cutProvider.getClass().getName())});
        image = this.cropToRegion(image, region, regionPositionCompensation);
        boolean checkingAnElement = !region.isEmpty();
        RectangleSize entireSize = this.scaleSafe(this.getEntireSize(image, checkingAnElement));
        this.logger.log(this.testId, Stage.CHECK, Type.CAPTURE_SCREENSHOT, new Pair[]{Pair.of((Object)"entireSize", (Object)entireSize)});
        if (image.getWidth() >= entireSize.getWidth() && image.getHeight() >= entireSize.getHeight()) {
            this.originProvider.restoreState(this.originalPosition);
            return ImageUtils.scaleImage((BufferedImage)image, (double)this.scaleProvider.getScaleRatio(), (boolean)true);
        }
        this.stitchedImage = new BufferedImage(image.getWidth(), entireSize.getHeight(), image.getType());
        Raster initialPart = image.getData();
        RectangleSize initialPartSize = new RectangleSize(initialPart.getWidth(), initialPart.getHeight());
        this.logger.log(this.testId, Stage.CHECK, Type.CAPTURE_SCREENSHOT, new Pair[]{Pair.of((Object)"initialPart", (Object)initialPartSize)});
        this.stitchedImage.getRaster().setRect(0, 0, initialPart);
        this.captureAndStitchTailParts(entireSize, initialPartSize);
        if (this.pixelRatio != 1.0) {
            this.stitchedImage = ImageUtils.scaleImage((BufferedImage)this.stitchedImage, (double)this.scaleProvider.getScaleRatio(), (boolean)true);
            this.debugScreenshotsProvider.save(this.stitchedImage, "scaled");
        }
        return this.stitchedImage;
    }

    private Region getRegionInScreenshot(Region region, BufferedImage image, double pixelRatio, EyesScreenshot screenshot, RegionPositionCompensation regionPositionCompensation) {
        region.setLocation(new Location(0, region.getLocation().getY()));
        Region regionInScreenshot = screenshot.getIntersectedRegion(region, CoordinatesType.SCREENSHOT_AS_IS);
        if (regionPositionCompensation == null) {
            regionPositionCompensation = new NullRegionPositionCompensation();
        }
        regionInScreenshot = regionPositionCompensation.compensateRegionPosition(regionInScreenshot, pixelRatio);
        regionInScreenshot.intersect(new Region(0, 0, image.getWidth(), image.getHeight()));
        this.logger.log(this.testId, Stage.CHECK, Type.CAPTURE_SCREENSHOT, new Pair[]{Pair.of((Object)"regionInScreenshot", (Object)regionInScreenshot)});
        return regionInScreenshot;
    }

    protected RectangleSize scaleSafe(RectangleSize rs) {
        if (this.coordinatesAreScaled) {
            return rs;
        }
        return rs.scale(this.pixelRatio);
    }

    protected Location scaleSafe(Location loc) {
        if (this.coordinatesAreScaled) {
            return loc;
        }
        return loc.scale(this.pixelRatio);
    }

    protected Region scaleSafe(Region reg) {
        if (this.coordinatesAreScaled) {
            return reg;
        }
        return reg.scale(this.pixelRatio);
    }

    protected Location downscaleSafe(Location loc) {
        if (this.coordinatesAreScaled) {
            return loc;
        }
        return loc.scale(1.0 / this.pixelRatio);
    }

    protected int scaleSafe(int value) {
        if (this.coordinatesAreScaled) {
            return value;
        }
        return (int)Math.ceil((double)value * this.pixelRatio);
    }

    protected int downscaleSafe(int value) {
        if (this.coordinatesAreScaled) {
            return value;
        }
        return (int)Math.ceil((double)value / this.pixelRatio);
    }
}

