/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.EyesAppiumUtils;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.selenium.positioning.ScrollPositionMemento;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import io.appium.java_client.AppiumDriver;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class AppiumScrollPositionProvider
implements ScrollPositionProvider {
    protected final Logger logger;
    protected final AppiumDriver driver;
    protected final EyesAppiumDriver eyesDriver;
    protected double distanceRatio;
    protected int verticalScrollGap;
    protected WebElement cutElement = null;
    protected WebElement scrollRootElement = null;
    protected ContentSize contentSize;
    private WebElement firstVisibleChild;
    private boolean isVerticalScrollGapSet;

    public AppiumScrollPositionProvider(Logger logger, EyesAppiumDriver driver) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)((Object)driver), (String)"driver");
        this.logger = logger;
        this.driver = driver.getRemoteWebDriver();
        this.eyesDriver = driver;
        this.distanceRatio = 0.0;
        this.verticalScrollGap = 0;
        this.isVerticalScrollGapSet = false;
    }

    public void setCutElement(WebElement cutElement) {
        this.cutElement = cutElement;
    }

    protected WebElement getCachedFirstVisibleChild() {
        WebElement activeScroll = this.getFirstScrollableView();
        if (this.firstVisibleChild == null) {
            this.firstVisibleChild = EyesAppiumUtils.getFirstVisibleChild(activeScroll);
        } else {
            Rectangle firstVisibleChildRect = this.firstVisibleChild.getRect();
            if (firstVisibleChildRect.getWidth() == 0 && firstVisibleChildRect.getHeight() == 0) {
                this.firstVisibleChild = EyesAppiumUtils.getFirstVisibleChild(activeScroll);
            }
        }
        return this.firstVisibleChild;
    }

    protected ContentSize getCachedContentSize() {
        if (this.contentSize != null) {
            return this.contentSize;
        }
        try {
            WebElement activeScroll = this.getFirstScrollableView();
            this.contentSize = EyesAppiumUtils.getContentSize(this.driver, activeScroll);
            this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"contentSize", (Object)this.contentSize)});
        }
        catch (NoSuchElementException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
        }
        return this.contentSize;
    }

    public Location getScrollableViewLocation() {
        WebElement firstVisChild;
        WebElement activeScroll;
        try {
            activeScroll = this.getFirstScrollableView();
            firstVisChild = this.getCachedFirstVisibleChild();
        }
        catch (NoSuchElementException e) {
            return new Location(0, 0);
        }
        Point scrollLoc = activeScroll.getLocation();
        Point firstVisChildLoc = firstVisChild.getLocation();
        if (!this.isVerticalScrollGapSet) {
            this.verticalScrollGap = firstVisChildLoc.y - scrollLoc.y;
            this.isVerticalScrollGapSet = true;
        }
        Location loc = new Location(scrollLoc.x, scrollLoc.y + this.verticalScrollGap);
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"location", (Object)loc), Pair.of((Object)"verticalScrollGap", (Object)this.verticalScrollGap)});
        return loc;
    }

    public Region getScrollableViewRegion() {
        Region reg;
        try {
            WebElement activeScroll = this.getFirstScrollableView();
            Location scrollLoc = this.getScrollableViewLocation();
            Dimension scrollDim = activeScroll.getSize();
            reg = new Region(scrollLoc.getX(), scrollLoc.getY(), scrollDim.width, scrollDim.height - this.verticalScrollGap);
        }
        catch (NoSuchElementException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
            reg = new Region(0, 0, 0, 0);
        }
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"region", (Object)reg), Pair.of((Object)"verticalScrollGap", (Object)this.verticalScrollGap)});
        return reg;
    }

    public Location getFirstVisibleChildLocation() {
        WebElement childElement;
        try {
            childElement = this.getCachedFirstVisibleChild();
        }
        catch (NoSuchElementException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
            return new Location(0, 0);
        }
        Point childLoc = childElement.getLocation();
        return new Location(childLoc.getX(), childLoc.getY());
    }

    public Location getCurrentPosition(boolean absolute) {
        Location loc = this.getScrollableViewLocation();
        Location childLoc = this.getFirstVisibleChildLocation();
        Location pos = absolute ? new Location(loc.getX() * 2 - childLoc.getX(), loc.getY() * 2 - childLoc.getY()) : new Location(loc.getX() - childLoc.getX(), loc.getY() - childLoc.getY());
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"currentPosition", (Object)pos)});
        return pos;
    }

    public Location getCurrentPositionWithoutStatusBar(boolean absolute) {
        Location loc = this.getScrollableViewLocation();
        Location childLoc = this.getFirstVisibleChildLocation();
        Location pos = absolute ? new Location(loc.getX() * 2 - childLoc.getX(), loc.getY() * 2 - this.getStatusBarHeight() - childLoc.getY()) : new Location(loc.getX() - childLoc.getX(), loc.getY() - this.getStatusBarHeight() - childLoc.getY());
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"currentPosition", (Object)pos)});
        return pos;
    }

    public Location getCurrentPosition() {
        return this.getCurrentPosition(false);
    }

    public RectangleSize getEntireSize() {
        int windowHeight = this.driver.manage().window().getSize().getHeight() - this.getStatusBarHeight();
        ContentSize contentSize = this.getCachedContentSize();
        if (contentSize == null) {
            return this.eyesDriver.getDefaultContentViewportSize();
        }
        int scrollContentHeight = contentSize.getScrollContentHeight();
        int outsideScrollViewHeight = windowHeight - contentSize.height;
        return new RectangleSize(contentSize.width, scrollContentHeight + outsideScrollViewHeight + this.verticalScrollGap);
    }

    public PositionMemento getState() {
        return new ScrollPositionMemento(this.getCurrentPosition());
    }

    public abstract void restoreState(PositionMemento var1);

    public void scrollToBottomRight() {
        this.setPosition(new Location(9999999, 9999999));
    }

    public abstract Location scrollDown(boolean var1);

    public abstract void scrollTo(int var1, int var2, int var3, int var4, boolean var5);

    int getStatusBarHeight() {
        return this.eyesDriver.getStatusBarHeight();
    }

    public abstract Region getElementRegion(WebElement var1, boolean var2, Boolean var3);

    protected WebElement getFirstScrollableView() {
        if (this.scrollRootElement != null) {
            return this.scrollRootElement;
        }
        return EyesAppiumUtils.getFirstScrollableView((WebDriver)this.driver);
    }

    public void cleanupCachedData() {
        this.contentSize = null;
        this.firstVisibleChild = null;
    }

    public void setScrollRootElement(WebElement scrollRootElement) {
        this.scrollRootElement = scrollRootElement;
    }
}

