/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.utils.ArgumentGuard;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.ios.IOSDriver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;

public class EyesAppiumElement
extends RemoteWebElement {
    private final EyesAppiumDriver driver;
    private final RemoteWebElement webElement;
    private final double pixelRatio;

    public EyesAppiumElement(EyesAppiumDriver driver, WebElement webElement, double pixelRatio) {
        ArgumentGuard.notNull((Object)((Object)driver), (String)"driver");
        ArgumentGuard.notNull((Object)webElement, (String)"webElement");
        webElement = EyesDriverUtils.getWrappedWebElement((WebElement)webElement);
        if (!(webElement instanceof RemoteWebElement)) {
            throw new EyesException("The input web element is not a RemoteWebElement.");
        }
        this.webElement = (RemoteWebElement)webElement;
        this.pixelRatio = pixelRatio;
        this.driver = driver;
        this.setParent((RemoteWebDriver)driver.getRemoteWebDriver());
        this.setId(this.webElement.getId());
    }

    public Dimension getSize() {
        int unscaledHeight;
        int unscaledWidth;
        Dimension size = this.webElement.getSize();
        if (this.pixelRatio == 1.0) {
            return size;
        }
        if (this.driver.getRemoteWebDriver() instanceof IOSDriver) {
            unscaledWidth = size.getWidth();
            unscaledHeight = size.getHeight();
        } else {
            unscaledWidth = (int)Math.ceil((double)size.getWidth() * this.pixelRatio);
            unscaledHeight = (int)Math.ceil((double)size.getHeight() * this.pixelRatio);
        }
        return new Dimension(unscaledWidth, unscaledHeight);
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    private WebElement wrapElement(WebElement elementToWrap) {
        Object resultElement = elementToWrap;
        if (elementToWrap instanceof RemoteWebElement) {
            resultElement = new EyesAppiumElement(this.driver, elementToWrap, this.pixelRatio);
        }
        return resultElement;
    }

    private List<WebElement> wrapElements(List<WebElement> elementsToWrap) {
        ArrayList<WebElement> wrappedElementsList = new ArrayList<WebElement>(elementsToWrap.size());
        for (WebElement currentElement : elementsToWrap) {
            if (currentElement instanceof RemoteWebElement) {
                wrappedElementsList.add((WebElement)new EyesAppiumElement(this.driver, currentElement, this.pixelRatio));
                continue;
            }
            wrappedElementsList.add(currentElement);
        }
        return wrappedElementsList;
    }

    public List<WebElement> findElements(By by) {
        return this.wrapElements(this.webElement.findElements(by));
    }

    public WebElement findElement(By by) {
        return this.wrapElement(this.webElement.findElement(by));
    }

    public WebElement findElementById(String using) {
        return this.wrapElement(this.webElement.findElementById(using));
    }

    public List<WebElement> findElementsById(String using) {
        return this.wrapElements(this.webElement.findElementsById(using));
    }

    public WebElement findElementByLinkText(String using) {
        return this.wrapElement(this.webElement.findElementByLinkText(using));
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.wrapElements(this.webElement.findElementsByLinkText(using));
    }

    public WebElement findElementByName(String using) {
        return this.wrapElement(this.webElement.findElementByName(using));
    }

    public List<WebElement> findElementsByName(String using) {
        return this.wrapElements(this.webElement.findElementsByName(using));
    }

    public WebElement findElementByClassName(String using) {
        return this.wrapElement(this.webElement.findElementByClassName(using));
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.wrapElements(this.webElement.findElementsByClassName(using));
    }

    public WebElement findElementByCssSelector(String using) {
        return this.wrapElement(this.webElement.findElementByCssSelector(using));
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return this.wrapElements(this.webElement.findElementsByCssSelector(using));
    }

    public WebElement findElementByXPath(String using) {
        return this.wrapElement(this.webElement.findElementByXPath(using));
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.wrapElements(this.webElement.findElementsByXPath(using));
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.wrapElement(this.webElement.findElementByPartialLinkText(using));
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.wrapElements(this.webElement.findElementsByPartialLinkText(using));
    }

    public WebElement findElementByTagName(String using) {
        return this.wrapElement(this.webElement.findElementByTagName(using));
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.wrapElements(this.webElement.findElementsByTagName(using));
    }

    public boolean equals(Object obj) {
        return obj instanceof RemoteWebElement && this.webElement.equals(obj);
    }

    public int hashCode() {
        return this.webElement.hashCode();
    }

    public void setFileDetector(FileDetector detector) {
        this.webElement.setFileDetector(detector);
    }

    public void submit() {
        this.webElement.submit();
    }

    public void clear() {
        this.webElement.clear();
    }

    public String getTagName() {
        return this.webElement.getTagName();
    }

    public String getAttribute(String name) {
        return this.webElement.getAttribute(name);
    }

    public boolean isSelected() {
        return this.webElement.isSelected();
    }

    public boolean isEnabled() {
        return this.webElement.isEnabled();
    }

    public String getText() {
        return this.webElement.getText();
    }

    public Point getLocation() {
        int unscaledY;
        int unscaledX;
        String elementId = this.getId();
        Response response = this.execute("getElementLocation", (Map)ImmutableMap.of((Object)"id", (Object)elementId));
        Map rawPoint = (Map)response.getValue();
        int x = (int)Math.round(((Number)rawPoint.get("x")).doubleValue());
        int y = (int)Math.round(((Number)rawPoint.get("y")).doubleValue());
        Point location = new Point(x, y);
        location = new Point(location.getX(), location.getY() - this.driver.getStatusBarHeight());
        if (this.pixelRatio == 1.0) {
            return location;
        }
        if (this.driver.getRemoteWebDriver() instanceof IOSDriver) {
            unscaledX = location.getX();
            unscaledY = location.getY();
        } else {
            unscaledX = (int)Math.ceil((double)location.getX() * this.pixelRatio);
            unscaledY = (int)Math.ceil((double)location.getY() * this.pixelRatio);
        }
        return new Point(unscaledX, unscaledY);
    }

    public Coordinates getCoordinates() {
        return this.webElement.getCoordinates();
    }

    public String toString() {
        return "EyesAppiumElement: " + this.webElement.getId();
    }
}

