/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.Region;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.exceptions.CoordinatesTypeConversionException;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;

public class EyesAppiumScreenshot
extends EyesScreenshot {
    private final EyesAppiumDriver driver;

    public EyesAppiumScreenshot(Logger logger, EyesAppiumDriver driver, BufferedImage image) {
        super(logger, image);
        this.driver = driver;
    }

    public Location getLocationInScreenshot(Location location, CoordinatesType coordinatesType) throws OutOfBoundsException {
        return location;
    }

    public Region getIntersectedRegion(Region region, CoordinatesType resultCoordinatesType) {
        if (region.isSizeEmpty()) {
            return new Region((IRegion)region);
        }
        CoordinatesType originalCoordinatesType = region.getCoordinatesType();
        if (!originalCoordinatesType.equals((Object)CoordinatesType.SCREENSHOT_AS_IS)) {
            throw new CoordinatesTypeConversionException(String.format("Unknown coordinates type: '%s'", originalCoordinatesType));
        }
        Region intersectedRegion = this.convertRegionLocation(region, originalCoordinatesType, CoordinatesType.SCREENSHOT_AS_IS);
        intersectedRegion.intersect(new Region(0, 0, this.image.getWidth(), this.image.getHeight()));
        if (intersectedRegion.isSizeEmpty()) {
            return intersectedRegion;
        }
        intersectedRegion = this.convertRegionLocation(intersectedRegion, CoordinatesType.SCREENSHOT_AS_IS, resultCoordinatesType);
        return intersectedRegion;
    }

    public EyesAppiumScreenshot getSubScreenshot(Region region, boolean throwIfClipped) {
        BufferedImage subImage = ImageUtils.getImagePart((BufferedImage)this.image, (Region)region);
        return new EyesAppiumScreenshot(this.logger, this.driver, subImage);
    }

    public Location convertLocation(Location location, CoordinatesType from, CoordinatesType to) {
        return location;
    }
}

