/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.Logger;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.LastScrollData;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.MobileBy;
import io.appium.java_client.android.AndroidDriver;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class EyesAppiumUtils {
    private static final String NATIVE_APP = "NATIVE_APP";
    static String SCROLLVIEW_XPATH = "//*[@scrollable='true']";
    private static String FIRST_VIS_XPATH = "/*[@firstVisible='true']";
    public static final String STATUS_BAR = "statusBar";
    public static final String NAVIGATION_BAR = "navigationBar";

    public static WebElement getFirstScrollableView(WebDriver driver) {
        return driver.findElement(By.xpath((String)SCROLLVIEW_XPATH));
    }

    public static WebElement getFirstVisibleChild(WebElement element) {
        return element.findElement(By.xpath((String)FIRST_VIS_XPATH));
    }

    public static void scrollByDirection(AppiumDriver driver, String direction) {
        EyesAppiumUtils.scrollByDirection(driver, direction, 1.0);
    }

    public static void scrollByDirection(AppiumDriver driver, String direction, double distanceRatio) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("direction", direction);
        args.put("distance", Double.toString(distanceRatio));
        driver.executeScript("mobile: scroll", new Object[]{args});
    }

    public static void scrollBackToElement(AndroidDriver driver, RemoteWebElement scroller, RemoteWebElement scrollToEl) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("elementId", scroller.getId());
        args.put("elementToId", scrollToEl.getId());
        driver.executeScript("mobile: scrollBackTo", new Object[]{args});
    }

    public static ContentSize getContentSize(AppiumDriver driver, WebElement element) {
        ContentSize contentSize;
        try {
            String contentSizeJson = element.getAttribute("contentSize");
            ObjectMapper objectMapper = new ObjectMapper();
            contentSize = (ContentSize)objectMapper.readValue(contentSizeJson, ContentSize.class);
            contentSize.setDriver(driver);
        }
        catch (IOException | WebDriverException e) {
            contentSize = new ContentSize();
            contentSize.height = element.getSize().getHeight();
            contentSize.width = element.getSize().getWidth();
            contentSize.top = element.getLocation().getY();
            contentSize.left = element.getLocation().getX();
            contentSize.scrollableOffset = element.getSize().getHeight();
        }
        return contentSize;
    }

    @Nullable
    public static LastScrollData getLastScrollData(AppiumDriver driver) {
        Map scrollData = (Map)driver.getSessionDetail("lastScrollData");
        if (scrollData == null) {
            return null;
        }
        return new LastScrollData(scrollData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLandscapeOrientation(Logger logger, WebDriver driver) {
        if (!EyesDriverUtils.isMobileDevice((WebDriver)driver)) {
            return false;
        }
        AppiumDriver appiumDriver = (AppiumDriver)EyesDriverUtils.getUnderlyingDriver((WebDriver)driver);
        String originalContext = null;
        try {
            originalContext = appiumDriver.getContext();
            if (appiumDriver.getContextHandles().size() > 1 && !originalContext.equalsIgnoreCase(NATIVE_APP)) {
                appiumDriver.context(NATIVE_APP);
            } else {
                originalContext = null;
            }
        }
        catch (WebDriverException e) {
            originalContext = null;
        }
        try {
            ScreenOrientation orientation = appiumDriver.getOrientation();
            boolean bl = orientation == ScreenOrientation.LANDSCAPE;
            return bl;
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            if (originalContext != null) {
                appiumDriver.context(originalContext);
            }
        }
    }

    public static int tryAutomaticRotation(Logger logger, WebDriver driver, BufferedImage image) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        int degrees = 0;
        try {
            if (EyesDriverUtils.isMobileDevice((WebDriver)driver) && EyesAppiumUtils.isLandscapeOrientation(logger, driver) && image.getHeight() > image.getWidth()) {
                degrees = EyesDriverUtils.isAndroid((WebDriver)driver) ? 90 : -90;
            }
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
        }
        return degrees;
    }

    public static BufferedImage normalizeRotation(Logger logger, WebDriver driver, BufferedImage image, ImageRotation rotation) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)image, (String)"image");
        int degrees = rotation != null ? rotation.getRotation() : EyesAppiumUtils.tryAutomaticRotation(logger, driver, image);
        return ImageUtils.rotateImage((BufferedImage)image, (double)degrees);
    }

    public static Map<String, Integer> getSystemBarsHeights(EyesAppiumDriver driver) {
        HashMap<String, Integer> systemBarHeights = new HashMap<String, Integer>();
        systemBarHeights.put(STATUS_BAR, null);
        systemBarHeights.put(NAVIGATION_BAR, null);
        try {
            if (EyesDriverUtils.isAndroid((WebDriver)driver)) {
                EyesAppiumUtils.fillSystemBarsHeightsMap((AndroidDriver)driver.getRemoteWebDriver(), systemBarHeights);
            } else {
                EyesAppiumUtils.fillSystemBarsHeightsMap(driver, systemBarHeights);
            }
        }
        catch (Exception ignored) {
            int statusBarHeight = driver.getStatusBarHeight();
            int navigationBarHeight = driver.getDeviceHeight() - driver.getViewportHeight() - statusBarHeight;
            systemBarHeights.put(STATUS_BAR, statusBarHeight);
            systemBarHeights.put(NAVIGATION_BAR, navigationBarHeight);
        }
        return systemBarHeights;
    }

    private static void fillSystemBarsHeightsMap(AndroidDriver driver, Map<String, Integer> systemBarHeights) {
        Map systemBars = driver.getSystemBars();
        for (String systemBarName : systemBars.keySet()) {
            systemBarHeights.put(systemBarName, EyesAppiumUtils.getSystemBar(systemBarName, systemBars));
        }
    }

    private static Integer getSystemBar(String systemBarName, Map<String, String> systemBars) {
        String value;
        if (systemBars.containsKey(systemBarName) && EyesAppiumUtils.getSystemBarVisibility(value = String.valueOf(systemBars.get(systemBarName))).booleanValue()) {
            return EyesAppiumUtils.getSystemBarHeight(value);
        }
        return null;
    }

    private static Boolean getSystemBarVisibility(String systemBarDetails) {
        Pattern p = Pattern.compile("visible=(\\w+)");
        Matcher m = p.matcher(systemBarDetails);
        m.find();
        return Boolean.parseBoolean(m.group(1));
    }

    private static Integer getSystemBarHeight(String systemBarDetails) {
        Pattern p = Pattern.compile("height=(\\d+)");
        Matcher m = p.matcher(systemBarDetails);
        m.find();
        return Integer.parseInt(m.group(1));
    }

    private static void fillSystemBarsHeightsMap(EyesAppiumDriver driver, Map<String, Integer> systemBarHeights) {
        int statusBarHeight = driver.getStatusBarHeight();
        int navigationBarHeight = driver.getDeviceHeight() - driver.getViewportRect().get("height") - statusBarHeight;
        systemBarHeights.put(STATUS_BAR, statusBarHeight);
        systemBarHeights.put(NAVIGATION_BAR, navigationBarHeight);
    }

    public static String getHelperLibraryVersion(EyesAppiumDriver driver, Logger logger) {
        String version = "";
        if (driver.getRemoteWebDriver() instanceof AndroidDriver) {
            WebElement hiddenElement2;
            try {
                hiddenElement2 = driver.getRemoteWebDriver().findElement(MobileBy.AndroidUIAutomator((String)"new UiSelector().description(\"EyesAppiumHelper_Version\")"));
                if (hiddenElement2 != null) {
                    version = hiddenElement2.getText();
                }
            }
            catch (NoSuchElementException | StaleElementReferenceException hiddenElement2) {
                // empty catch block
            }
            if (version == null) {
                try {
                    hiddenElement2 = driver.getRemoteWebDriver().findElement(MobileBy.AndroidUIAutomator((String)"new UiSelector().description(\"EyesAppiumHelper\")"));
                    if (hiddenElement2 != null) {
                        version = "1.0.0";
                    }
                }
                catch (NoSuchElementException | StaleElementReferenceException throwable) {
                    // empty catch block
                }
            }
        }
        logger.log(TraceLevel.Debug, driver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"helperLibraryVersion", (Object)version)});
        return version;
    }
}

