/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.Region;
import com.applitools.eyes.appium.AppiumScrollPositionProvider;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.EyesAppiumUtils;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import io.appium.java_client.MobileBy;
import io.appium.java_client.PerformsTouchActions;
import io.appium.java_client.TouchAction;
import io.appium.java_client.touch.WaitOptions;
import io.appium.java_client.touch.offset.PointOption;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;

public class IOSScrollPositionProvider
extends AppiumScrollPositionProvider {
    private static final String SCROLL_DIRECTION_UP = "up";
    private static final String SCROLL_DIRECTION_DOWN = "down";
    private static final String SCROLL_DIRECTION_LEFT = "left";
    private static final String SCROLL_DIRECTION_RIGHT = "right";
    private WebElement firstVisibleChild;

    public IOSScrollPositionProvider(Logger logger, EyesAppiumDriver driver) {
        super(logger, driver);
    }

    public Location setPosition(Location location) {
        Location lastPos;
        Location curPos = this.getCurrentPosition();
        HashMap<String, String> args = new HashMap<String, String>();
        String directionY = "";
        String directionX = "";
        if (curPos.getY() < location.getY()) {
            directionY = SCROLL_DIRECTION_DOWN;
        } else if (curPos.getY() > location.getY()) {
            directionY = SCROLL_DIRECTION_UP;
        }
        if (curPos.getX() < location.getX()) {
            directionX = SCROLL_DIRECTION_RIGHT;
        } else if (curPos.getX() > location.getX()) {
            directionX = SCROLL_DIRECTION_LEFT;
        }
        if (!directionY.isEmpty()) {
            args.put("direction", directionY);
            while (directionY.equals(SCROLL_DIRECTION_DOWN) && curPos.getY() < location.getY() || directionY.equals(SCROLL_DIRECTION_UP) && curPos.getY() > location.getY()) {
                this.driver.executeScript("mobile: scroll", new Object[]{args});
                lastPos = curPos;
                curPos = this.getCurrentPosition();
                if (curPos.getY() != lastPos.getY()) continue;
            }
        }
        if (!directionX.isEmpty()) {
            args.put("direction", directionX);
            while (directionX.equals(SCROLL_DIRECTION_RIGHT) && curPos.getX() < location.getX() || directionX.equals(SCROLL_DIRECTION_LEFT) && curPos.getX() > location.getX()) {
                this.driver.executeScript("mobile: scroll", new Object[]{args});
                lastPos = curPos;
                curPos = this.getCurrentPosition();
                if (curPos.getX() != lastPos.getX()) continue;
                break;
            }
        }
        return curPos;
    }

    public void setPosition(WebElement element) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("toVisible", "true");
        params.put("element", (String)element);
        this.driver.executeScript("mobile: scroll", new Object[]{params});
    }

    @Override
    public void restoreState(PositionMemento state) {
    }

    private double getScrollDistanceRatio() {
        if (this.distanceRatio == 0.0) {
            int viewportHeight = this.eyesDriver.getDefaultContentViewportSize(false).getHeight() + this.eyesDriver.getStatusBarHeight();
            double pixelRatio = this.eyesDriver.getDevicePixelRatio();
            double scrollviewHeight = this.getScrollableViewRegion().getHeight() - (this.cutElement != null ? this.cutElement.getSize().getHeight() : 0);
            this.distanceRatio = scrollviewHeight / (double)viewportHeight;
        }
        return this.distanceRatio;
    }

    @Override
    public Location scrollDown(boolean returnAbsoluteLocation) {
        EyesAppiumUtils.scrollByDirection(this.driver, SCROLL_DIRECTION_DOWN, this.getScrollDistanceRatio());
        return this.getCurrentPositionWithoutStatusBar(returnAbsoluteLocation);
    }

    @Override
    public void scrollTo(int startX, int startY, int endX, int endY, boolean shouldCancel) {
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"from", (Object)new Location(startX, startY)), Pair.of((Object)"to", (Object)new Location(startX, startY))});
        TouchAction scrollAction = new TouchAction((PerformsTouchActions)this.driver);
        scrollAction.press(new PointOption().withCoordinates(startX, startY)).waitAction(new WaitOptions().withDuration(Duration.ofMillis(3000L)));
        scrollAction.moveTo(new PointOption().withCoordinates(startX, endY));
        scrollAction.release();
        this.driver.performTouchAction(scrollAction);
        try {
            Thread.sleep(750L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Region getElementRegion(WebElement element, boolean shouldStitchContent, Boolean statusBarExists) {
        double devicePixelRatio = this.eyesDriver.getDevicePixelRatio();
        Region region = new Region((int)((double)element.getLocation().getX() * devicePixelRatio), (int)((double)element.getLocation().getY() * devicePixelRatio), (int)((double)element.getSize().getWidth() * devicePixelRatio), (int)((double)element.getSize().getHeight() * devicePixelRatio));
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"elementClass", (Object)element.getAttribute("type"))});
        if (shouldStitchContent) {
            ContentSize contentSize = EyesAppiumUtils.getContentSize(this.driver, element);
            switch (element.getAttribute("type")) {
                case "XCUIElementTypeTable": {
                    List list = element.findElements(MobileBy.xpath((String)"//XCUIElementTypeTable[1]/*"));
                    if (list.isEmpty()) break;
                    WebElement lastElement = (WebElement)list.get(list.size() - 1);
                    contentSize.scrollableOffset = lastElement.getLocation().getY() + lastElement.getSize().getHeight() - element.getRect().getY() + this.eyesDriver.getStatusBarHeight();
                    break;
                }
                case "XCUIElementTypeScrollView": {
                    List list = element.findElements(MobileBy.xpath((String)"//XCUIElementTypeScrollView[1]/*"));
                    if (list.isEmpty()) break;
                    WebElement firstElement = (WebElement)list.get(0);
                    contentSize.scrollableOffset = firstElement.getLocation().getY() + firstElement.getSize().getHeight() - element.getRect().getY() + this.eyesDriver.getStatusBarHeight();
                }
            }
            contentSize.top = this.positionCorrectionRegardingStatusBar(element.getRect().getY(), statusBarExists);
            if (contentSize.scrollableOffset == 0) {
                contentSize.scrollableOffset = contentSize.height;
            }
            region = new Region((int)((double)contentSize.left * devicePixelRatio), (int)((double)contentSize.top * devicePixelRatio), (int)((double)contentSize.width * devicePixelRatio), (int)((double)contentSize.getScrollContentHeight() * devicePixelRatio));
        }
        return region;
    }

    @Override
    @Nullable
    protected ContentSize getCachedContentSize() {
        if (this.contentSize != null) {
            return this.contentSize;
        }
        try {
            WebElement activeScroll = this.getFirstScrollableView();
            this.contentSize = EyesAppiumUtils.getContentSize(this.driver, activeScroll);
            this.contentSize.scrollableOffset = this.getEntireScrollableHeight(activeScroll, this.contentSize);
        }
        catch (NoSuchElementException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
            this.contentSize = null;
            String base64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            BufferedImage image = ImageUtils.imageFromBase64((String)base64);
            this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"pageSource", (Object)this.driver.getPageSource())});
        }
        return this.contentSize;
    }

    @Override
    protected WebElement getCachedFirstVisibleChild() {
        WebElement activeScroll = this.getFirstScrollableView();
        if (this.firstVisibleChild == null) {
            this.firstVisibleChild = this.getFirstChild(activeScroll);
        } else {
            Rectangle firstVisibleChildRect = this.firstVisibleChild.getRect();
            if (firstVisibleChildRect.getWidth() == 0 && firstVisibleChildRect.getHeight() == 0) {
                this.firstVisibleChild = this.getFirstChild(activeScroll);
            }
        }
        return this.firstVisibleChild;
    }

    private WebElement getFirstChild(WebElement activeScroll) {
        if (activeScroll.getAttribute("type").equals("XCUIElementTypeTable")) {
            List list = activeScroll.findElements(MobileBy.xpath((String)"//XCUIElementTypeTable[1]/*"));
            WebElement firstCell = this.getFirstCellForXCUIElementTypeTable(list);
            if (firstCell == null) {
                return EyesAppiumUtils.getFirstVisibleChild(activeScroll);
            }
            return firstCell;
        }
        return EyesAppiumUtils.getFirstVisibleChild(activeScroll);
    }

    private WebElement getFirstCellForXCUIElementTypeTable(List<WebElement> list) {
        for (WebElement element : list) {
            if (!element.getTagName().equals("XCUIElementTypeCell")) continue;
            return element;
        }
        return null;
    }

    private int positionCorrectionRegardingStatusBar(int position, Boolean statusBarExists) {
        if (statusBarExists != null && !statusBarExists.booleanValue()) {
            return position;
        }
        Double platformVersion = null;
        try {
            String platformVersionString = EyesDriverUtils.getPlatformVersion((HasCapabilities)this.driver);
            if (platformVersionString != null) {
                platformVersion = Double.valueOf(platformVersionString);
            }
        }
        catch (NumberFormatException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
        }
        if (platformVersion != null && platformVersion.compareTo(Double.valueOf("13.0")) >= 0) {
            return position - this.getDeviceStatusBarHeight(((String)this.driver.getCapabilities().getCapability("deviceName")).toLowerCase());
        }
        return position - this.getStatusBarHeight();
    }

    private int getDeviceStatusBarHeight(String deviceName) {
        int statusBarHeight = 0;
        int density = 1;
        switch (deviceName) {
            case "iphone 6": 
            case "iphone 6s": 
            case "iphone 7": 
            case "iphone 8": {
                statusBarHeight = 40;
                density = 2;
                break;
            }
            case "iphone 6 plus": 
            case "iphone 6s plus": 
            case "iphone 7 plus": 
            case "iphone 8 plus": {
                statusBarHeight = 60;
                density = 3;
                break;
            }
            case "iphone x": 
            case "iphone xs": 
            case "iphone xs max": 
            case "iphone 11 pro": 
            case "iphone 11 pro max": {
                statusBarHeight = 132;
                density = 3;
                break;
            }
            case "iphone xr": 
            case "iphone 11": {
                statusBarHeight = 88;
                density = 2;
            }
        }
        return statusBarHeight / density;
    }

    private int getEntireScrollableHeight(WebElement element, ContentSize contentSize) {
        int scrollableOffset = contentSize.scrollableOffset;
        switch (element.getAttribute("type")) {
            case "XCUIElementTypeTable": {
                List list = element.findElements(MobileBy.xpath((String)"//XCUIElementTypeTable[1]/*"));
                if (list.isEmpty()) break;
                WebElement lastElement = (WebElement)list.get(list.size() - 1);
                scrollableOffset = lastElement.getLocation().getY() + lastElement.getSize().getHeight();
                break;
            }
            case "XCUIElementTypeScrollView": {
                List list = element.findElements(MobileBy.xpath((String)"//XCUIElementTypeScrollView[1]/*"));
                if (list.isEmpty()) break;
                WebElement firstElement = (WebElement)list.get(0);
                scrollableOffset = firstElement.getLocation().getY() + firstElement.getSize().getHeight();
            }
        }
        return scrollableOffset;
    }
}

