/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium.fluent;

import com.applitools.eyes.AccessibilityRegionByRectangle;
import com.applitools.eyes.AccessibilityRegionType;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.EyesAppiumElement;
import com.applitools.eyes.selenium.fluent.ImplicitInitiation;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class AccessibilityRegionByElement
extends com.applitools.eyes.selenium.fluent.AccessibilityRegionByElement
implements ImplicitInitiation {
    @JsonIgnore
    private EyesAppiumDriver driver;

    public AccessibilityRegionByElement(WebElement element, AccessibilityRegionType regionType) {
        super(element, regionType);
    }

    public void init(Logger logger, EyesWebDriver driver) {
        this.driver = (EyesAppiumDriver)driver;
    }

    public List<AccessibilityRegionByRectangle> getRegions(EyesScreenshot screenshot) {
        EyesAppiumElement eyesAppiumElement = new EyesAppiumElement(this.driver, this.element, 1.0 / this.driver.getDevicePixelRatio());
        Point p = eyesAppiumElement.getLocation();
        Dimension size = eyesAppiumElement.getSize();
        Location pTag = screenshot.convertLocation(new Location(p.x, p.y), CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
        return Collections.singletonList(new AccessibilityRegionByRectangle(new Region(pTag, new RectangleSize(size.width, size.height)), this.regionType));
    }
}

