/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.CutProvider;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.appium.AppiumFullPageCaptureAlgorithm;
import com.applitools.eyes.appium.AppiumScrollPositionProvider;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.selenium.positioning.NullRegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.utils.GeneralUtils;
import java.awt.image.BufferedImage;

public class AndroidFullPageCaptureAlgorithm
extends AppiumFullPageCaptureAlgorithm {
    private static final int DEFAULT_STITCHING_ADJUSTMENT = 50;
    private Integer stitchingAdjustment = 50;

    public AndroidFullPageCaptureAlgorithm(Logger logger, AppiumScrollPositionProvider scrollProvider, ImageProvider imageProvider, DebugScreenshotsProvider debugScreenshotsProvider, ScaleProviderFactory scaleProviderFactory, CutProvider cutProvider, EyesScreenshotFactory screenshotFactory, int waitBeforeScreenshots, Integer stitchingAdjustment) {
        super(logger, scrollProvider, imageProvider, debugScreenshotsProvider, scaleProviderFactory, cutProvider, screenshotFactory, waitBeforeScreenshots, null);
        this.coordinatesAreScaled = true;
        if (stitchingAdjustment != null) {
            this.stitchingAdjustment = stitchingAdjustment;
        }
    }

    @Override
    protected void captureAndStitchTailParts(BufferedImage image, int stitchingOverlap, RectangleSize entireSize, RectangleSize initialPartSize) {
        Region regionToCrop;
        Region scrollViewRegion = this.scaleSafe(((AppiumScrollPositionProvider)this.scrollProvider).getScrollableViewRegion());
        Location newLoc = new Location(scrollViewRegion.getLeft(), scrollViewRegion.getTop() - this.scaleSafe(((AppiumScrollPositionProvider)this.scrollProvider).getStatusBarHeight()));
        RectangleSize newSize = new RectangleSize(initialPartSize.getWidth(), scrollViewRegion.getHeight());
        scrollViewRegion.setLocation(newLoc);
        scrollViewRegion.setSize(newSize);
        ContentSize contentSize = ((AppiumScrollPositionProvider)this.scrollProvider).getCachedContentSize();
        int xPos = scrollViewRegion.getLeft() + 1;
        int oneScrollStep = scrollViewRegion.getHeight() - this.stitchingAdjustment;
        int maxScrollSteps = contentSize.getScrollContentHeight() / oneScrollStep;
        this.logger.verbose("Entire scrollable height: " + contentSize.getScrollContentHeight());
        this.logger.verbose("One scroll step: " + oneScrollStep);
        this.logger.verbose("Max scroll steps: " + (double)contentSize.getScrollContentHeight() / (double)oneScrollStep);
        for (int step = 1; step <= maxScrollSteps; ++step) {
            regionToCrop = new Region(0, scrollViewRegion.getTop() + this.stitchingAdjustment, initialPartSize.getWidth(), scrollViewRegion.getHeight() - this.stitchingAdjustment);
            this.currentPosition = new Location(0, scrollViewRegion.getTop() + scrollViewRegion.getHeight() * step - (this.stitchingAdjustment * step - this.stitchingAdjustment));
            ((AppiumScrollPositionProvider)this.scrollProvider).scrollTo(xPos, scrollViewRegion.getHeight() + scrollViewRegion.getTop() - 1, xPos, scrollViewRegion.getTop() + (step != maxScrollSteps ? this.stitchingAdjustment : 0), step != maxScrollSteps);
            if (step == maxScrollSteps) {
                int cropTo = contentSize.getScrollContentHeight() - oneScrollStep * step;
                int cropFrom = oneScrollStep - cropTo + scrollViewRegion.getTop() + this.stitchingAdjustment;
                regionToCrop = new Region(0, cropFrom, initialPartSize.getWidth(), cropTo);
                this.currentPosition = new Location(0, scrollViewRegion.getTop() + scrollViewRegion.getHeight() * step - this.stitchingAdjustment * step);
            }
            this.captureAndStitchCurrentPart(regionToCrop, scrollViewRegion);
        }
        int heightUnderScrollableView = initialPartSize.getHeight() - oneScrollStep - scrollViewRegion.getTop();
        if (heightUnderScrollableView > 0) {
            regionToCrop = new Region(0, scrollViewRegion.getHeight() + scrollViewRegion.getTop() - this.stitchingAdjustment, initialPartSize.getWidth(), heightUnderScrollableView);
            this.currentPosition = new Location(0, scrollViewRegion.getTop() + contentSize.getScrollContentHeight() - this.stitchingAdjustment);
            this.captureAndStitchCurrentPart(regionToCrop, scrollViewRegion);
        }
        this.moveToTopLeft();
    }

    @Override
    protected RectangleSize captureAndStitchCurrentPart(Region partRegion, Region scrollViewRegion) {
        this.logger.verbose("Taking screenshot for current scroll location");
        GeneralUtils.sleep((long)this.waitBeforeScreenshots);
        BufferedImage partImage = this.imageProvider.getImage();
        this.debugScreenshotsProvider.save(partImage, "original-scrolled=" + this.currentPosition.toStringForFilename());
        this.setRegionInScreenshot(partImage, partRegion, (RegionPositionCompensation)new NullRegionPositionCompensation());
        partImage = this.cropPartToRegion(partImage, partRegion);
        this.stitchPartIntoContainer(partImage);
        return new RectangleSize(partImage.getWidth(), partImage.getHeight());
    }
}

