/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.appium.AppiumScrollPositionProvider;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.EyesAppiumUtils;
import com.applitools.eyes.appium.LastScrollData;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.selenium.positioning.ScrollPositionMemento;
import io.appium.java_client.MobileBy;
import io.appium.java_client.MobileElement;
import io.appium.java_client.PerformsTouchActions;
import io.appium.java_client.TouchAction;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.touch.WaitOptions;
import io.appium.java_client.touch.offset.PointOption;
import java.io.IOException;
import java.time.Duration;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class AndroidScrollPositionProvider
extends AppiumScrollPositionProvider {
    private Location curScrollPos;
    private Location scrollableViewLoc;
    private RectangleSize entireSize = null;

    public AndroidScrollPositionProvider(Logger logger, EyesAppiumDriver driver) {
        super(logger, driver);
    }

    @Override
    public Location getScrollableViewLocation() {
        this.logger.verbose("Getting the location of the scrollable view..");
        if (this.scrollableViewLoc == null) {
            WebElement activeScroll;
            try {
                activeScroll = EyesAppiumUtils.getFirstScrollableView((WebDriver)this.driver);
            }
            catch (NoSuchElementException e) {
                this.logger.verbose("WARNING: could not find a scrollable view, using (0,0)");
                return new Location(0, 0);
            }
            Point scrollLoc = activeScroll.getLocation();
            this.scrollableViewLoc = new Location(scrollLoc.x, scrollLoc.y);
        }
        this.logger.verbose("The location of the scrollable view is " + this.scrollableViewLoc);
        return this.scrollableViewLoc;
    }

    private void checkCurrentScrollPosition() {
        if (this.curScrollPos == null) {
            this.logger.verbose("There was no current scroll position registered, so setting it for the first time");
            ContentSize contentSize = this.getCachedContentSize();
            LastScrollData scrollData = EyesAppiumUtils.getLastScrollData(this.driver);
            this.logger.verbose("Last scroll data from the server was: " + scrollData);
            this.curScrollPos = this.getScrollPosFromScrollData(contentSize, scrollData, 0, false);
        }
    }

    @Override
    public Location getCurrentPosition(boolean absolute) {
        this.logger.verbose("AndroidScrollPositionProvider - getCurrentPosition()");
        Location loc = this.getScrollableViewLocation();
        this.checkCurrentScrollPosition();
        Location pos = absolute ? new Location(loc.getX() + this.curScrollPos.getX(), loc.getY() + this.curScrollPos.getY()) : new Location(this.curScrollPos.getX(), this.curScrollPos.getY());
        this.logger.verbose("The current scroll position is " + pos);
        return pos;
    }

    @Override
    public Location getCurrentPositionWithoutStatusBar(boolean absolute) {
        this.logger.verbose("AndroidScrollPositionProvider - getCurrentPositionWithoutStatusBar()");
        Location loc = this.getScrollableViewLocation();
        this.checkCurrentScrollPosition();
        Location pos = absolute ? new Location(loc.getX() + this.curScrollPos.getX(), loc.getY() - this.getStatusBarHeight() + this.curScrollPos.getY()) : new Location(this.curScrollPos.getX(), this.curScrollPos.getY() - this.getStatusBarHeight());
        this.logger.verbose("The current scroll position is " + pos);
        return pos;
    }

    @Override
    public void setPosition(Location location) {
        if (location.getY() != 0 && location.getX() != 0) {
            this.logger.log("Warning: tried to set position on an Android scroll view, which is not possible");
        }
        if (location.getY() == this.curScrollPos.getY() && location.getX() == this.curScrollPos.getX()) {
            this.logger.log("Already at the desired position, doing nothing");
        } else {
            this.logger.verbose("Setting position to 0, 0 by scrolling all the way back to the top");
            Location lastScrollPos = this.curScrollPos;
            while (this.curScrollPos.getY() > 0) {
                this.scroll(false);
                if (lastScrollPos.getY() == this.curScrollPos.getY()) break;
                lastScrollPos = this.curScrollPos;
            }
            this.scroll(false);
            this.entireSize = null;
        }
    }

    @Override
    public void setPosition(WebElement element) {
        this.logger.log("Warning: can only scroll back to elements that have already been seen");
        try {
            WebElement activeScroll = EyesAppiumUtils.getFirstScrollableView((WebDriver)this.driver);
            EyesAppiumUtils.scrollBackToElement((AndroidDriver)this.driver, (RemoteWebElement)activeScroll, (RemoteWebElement)element);
            LastScrollData lastScrollData = EyesAppiumUtils.getLastScrollData(this.driver);
            this.logger.verbose("After scrolling back to first child, lastScrollData was: " + lastScrollData);
            this.curScrollPos = new Location(lastScrollData.scrollX, lastScrollData.scrollY);
        }
        catch (NoSuchElementException e) {
            this.logger.verbose("Could not set position because there was no scrollable view; doing nothing");
        }
    }

    @Override
    public void restoreState(PositionMemento state) {
        this.setPosition(new Location(((ScrollPositionMemento)state).getX(), ((ScrollPositionMemento)state).getY()));
    }

    private void scroll(boolean isDown) {
        ContentSize contentSize = this.getCachedContentSize();
        int extraPadding = (int)((double)contentSize.height * 0.1);
        int startX = contentSize.left + contentSize.width / 2;
        int startY = contentSize.top + contentSize.height - contentSize.touchPadding - extraPadding;
        int endX = startX;
        int endY = contentSize.top + contentSize.touchPadding + extraPadding;
        if (!isDown) {
            int temp = endY;
            endY = startY;
            startY = temp;
        }
        int supposedScrollAmt = startY - endY;
        TouchAction scrollAction = new TouchAction((PerformsTouchActions)this.driver);
        scrollAction.press(new PointOption().withCoordinates(startX, startY)).waitAction(new WaitOptions().withDuration(Duration.ofMillis(1500L)));
        scrollAction.moveTo(new PointOption().withCoordinates(endX, endY));
        scrollAction.release();
        this.driver.performTouchAction(scrollAction);
        try {
            Thread.sleep(750L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LastScrollData lastScrollData = EyesAppiumUtils.getLastScrollData(this.driver);
        this.logger.verbose("After scroll lastScrollData was: " + lastScrollData);
        this.curScrollPos = this.getScrollPosFromScrollData(contentSize, lastScrollData, supposedScrollAmt, isDown);
    }

    @Override
    public Location scrollDown(boolean returnAbsoluteLocation) {
        this.scroll(true);
        return this.getCurrentPositionWithoutStatusBar(returnAbsoluteLocation);
    }

    @Override
    public void scrollTo(int startX, int startY, int endX, int endY, boolean shouldCancel) {
        this.logger.verbose("Trying to scroll from startX: " + startX + " | startY: " + startY + " | endX: " + endX + " | endY: " + endY);
        TouchAction scrollAction = new TouchAction((PerformsTouchActions)this.driver);
        scrollAction.press(new PointOption().withCoordinates(startX, startY)).waitAction(new WaitOptions().withDuration(Duration.ofMillis(1500L)));
        scrollAction.moveTo(new PointOption().withCoordinates(endX, endY - this.contentSize.touchPadding));
        if (shouldCancel) {
            scrollAction.cancel();
        } else {
            scrollAction.release();
        }
        this.driver.performTouchAction(scrollAction);
        this.curScrollPos = new Location(this.curScrollPos.getX(), this.curScrollPos.getY() + startX);
        try {
            Thread.sleep(750L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Region getElementRegion(WebElement element, boolean shouldStitchContent, Boolean statusBarExists) {
        Region region;
        block7: {
            region = new Region(element.getLocation().getX(), element.getLocation().getY(), element.getSize().getWidth(), element.getSize().getHeight());
            if (shouldStitchContent) {
                try {
                    this.logger.verbose("Element is instance of " + element.getAttribute("className"));
                    double devicePixelRatio = this.eyesDriver.getDevicePixelRatio();
                    ContentSize contentSize = EyesAppiumUtils.getContentSize(this.driver, element);
                    region = new Region(contentSize.left, contentSize.top, contentSize.width, contentSize.getScrollContentHeight());
                    if (!element.getAttribute("className").equals("android.support.v7.widget.RecyclerView") && !element.getAttribute("className").equals("androidx.recyclerview.widget.RecyclerView") && !element.getAttribute("className").equals("androidx.viewpager2.widget.ViewPager2") && !element.getAttribute("className").equals("android.widget.ListView") && !element.getAttribute("className").equals("android.widget.GridView")) break block7;
                    try {
                        MobileElement hiddenElement = (MobileElement)((AndroidDriver)this.driver).findElement(MobileBy.AndroidUIAutomator((String)"new UiSelector().descriptionContains(\"EyesAppiumHelper\")"));
                        if (hiddenElement == null) break block7;
                        hiddenElement.click();
                        String scrollableContentSize = hiddenElement.getText();
                        try {
                            int scrollableHeight = Integer.valueOf(scrollableContentSize);
                            this.logger.verbose("Scrollable height received from EyesAppiumHelper = " + scrollableContentSize);
                            region = new Region((int)((double)element.getLocation().getX() * devicePixelRatio), (int)((double)element.getLocation().getY() * devicePixelRatio), (int)((double)element.getSize().getWidth() * devicePixelRatio), scrollableHeight);
                        }
                        catch (NumberFormatException nfe) {
                            this.logger.verbose("Could not parse scrollable content height");
                        }
                    }
                    catch (NoSuchElementException | StaleElementReferenceException ignored) {
                        this.logger.verbose("Could not get EyesAppiumHelper element.");
                    }
                }
                catch (IOException e) {
                    this.logger.verbose("Could not get element content size.");
                }
            }
        }
        return region;
    }

    private Location getScrollPosFromScrollData(ContentSize contentSize, LastScrollData scrollData, int supposedScrollAmt, boolean isDown) {
        int newYPos;
        this.logger.verbose("Getting scroll position from last scroll data (" + scrollData + ") and contentSize (" + contentSize + ")");
        if (scrollData == null) {
            this.logger.verbose("Did not get last scroll data; assume there was no more scroll");
            if (isDown) {
                this.logger.verbose("Since we're scrolling down, setting Y location to the last page of the scrollableOffset");
                return new Location(this.curScrollPos.getX(), contentSize.scrollableOffset);
            }
            this.logger.verbose("Since we're scrolling up, just say we reached 0, 0");
            return new Location(this.curScrollPos == null ? 0 : this.curScrollPos.getX(), 0);
        }
        if (scrollData.scrollX != -1 && scrollData.scrollY != -1) {
            this.logger.verbose("Setting scroll position based on pixel values from scroll data");
            return new Location(scrollData.scrollX, scrollData.scrollY);
        }
        if (contentSize == null) {
            this.logger.verbose("Retrieved content size is null... Initialized temporary with default values");
            contentSize = new ContentSize();
        }
        double avgItemHeight = contentSize.getScrollContentHeight() / scrollData.itemCount;
        int curYPos = this.curScrollPos == null ? 0 : this.curScrollPos.getY();
        int yPosByIndex = (int)avgItemHeight * scrollData.fromIndex;
        int yPosByAssumption = curYPos + supposedScrollAmt;
        this.logger.verbose("By assumption we are now at " + yPosByAssumption + " pixels, and by item index we are now at " + yPosByIndex + " pixels");
        if ((double)Math.abs(yPosByAssumption - yPosByIndex) / (double)contentSize.height > 0.1) {
            newYPos = yPosByIndex;
            this.logger.verbose("Estimating that current scroll Y position is " + newYPos + ", based on item count of " + scrollData.itemCount + ", avg item height of " + avgItemHeight + ", and scrolled-to fromIndex of " + scrollData.fromIndex);
        } else {
            newYPos = yPosByAssumption;
            this.logger.verbose("Assuming we scrolled down exactly " + supposedScrollAmt + " pixels");
        }
        return new Location(this.curScrollPos == null ? 0 : this.curScrollPos.getX(), newYPos);
    }

    @Override
    public RectangleSize getEntireSize() {
        int scrollableHeight;
        ContentSize contentSize;
        int windowHeight;
        block8: {
            if (this.curScrollPos != null && this.curScrollPos.getY() != 0 && this.entireSize != null) {
                return this.entireSize;
            }
            windowHeight = this.driver.manage().window().getSize().getHeight() - this.getStatusBarHeight();
            this.logger.verbose("window height: " + windowHeight);
            contentSize = this.getCachedContentSize();
            if (contentSize == null) {
                return this.eyesDriver.getDefaultContentViewportSize();
            }
            scrollableHeight = 0;
            try {
                WebElement activeScroll = EyesAppiumUtils.getFirstScrollableView((WebDriver)this.driver);
                this.logger.verbose("Scrollable element is instance of " + activeScroll.getAttribute("className"));
                String className = activeScroll.getAttribute("className");
                if (!className.equals("android.support.v7.widget.RecyclerView") && !className.equals("androidx.recyclerview.widget.RecyclerView") && !className.equals("androidx.viewpager2.widget.ViewPager2") && !className.equals("android.widget.ListView") && !className.equals("android.widget.GridView")) break block8;
                try {
                    MobileElement hiddenElement = (MobileElement)((AndroidDriver)this.driver).findElement(MobileBy.AndroidUIAutomator((String)"new UiSelector().descriptionContains(\"EyesAppiumHelper\")"));
                    if (hiddenElement == null) break block8;
                    hiddenElement.click();
                    String scrollableContentSize = hiddenElement.getText();
                    try {
                        scrollableHeight = Integer.valueOf(scrollableContentSize);
                        this.logger.verbose("Scrollable height received from EyesAppiumHelper = " + scrollableContentSize);
                    }
                    catch (NumberFormatException nfe) {
                        this.logger.verbose("Could not parse scrollable content height");
                    }
                }
                catch (NoSuchElementException | StaleElementReferenceException ignored) {
                    scrollableHeight = contentSize.scrollableOffset;
                    this.logger.verbose("Could not get EyesAppiumHelper element. Return scrollable offset from cached content size (" + scrollableHeight + ")");
                }
            }
            catch (NoSuchElementException ex) {
                this.logger.log("WARNING: No active scroll element, so no scrollable height to retrieve");
            }
        }
        this.contentSize.scrollableOffset = scrollableHeight == 0 ? contentSize.scrollableOffset : scrollableHeight - contentSize.height;
        int scrollContentHeight = this.contentSize.getScrollContentHeight();
        int outsideScrollviewHeight = windowHeight - contentSize.height;
        this.entireSize = new RectangleSize(contentSize.width, scrollContentHeight + outsideScrollviewHeight + this.verticalScrollGap);
        this.logger.verbose("AppiumScrollPositionProvider - Entire size: " + this.entireSize + " (Accounting for a vertical scroll gap of " + this.verticalScrollGap + ", with a scroll content height of " + scrollContentHeight + ")");
        return this.entireSize;
    }
}

