/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.CutProvider;
import com.applitools.eyes.Logger;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.appium.AndroidFullPageCaptureAlgorithm;
import com.applitools.eyes.appium.AppiumFullPageCaptureAlgorithm;
import com.applitools.eyes.appium.AppiumScrollPositionProvider;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.EyesAppiumUtils;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class AppiumCaptureAlgorithmFactory {
    private EyesAppiumDriver driver;
    private Logger logger;
    private AppiumScrollPositionProvider scrollProvider;
    private ImageProvider imageProvider;
    private DebugScreenshotsProvider debugScreenshotsProvider;
    private ScaleProviderFactory scaleProviderFactory;
    private CutProvider cutProvider;
    private EyesScreenshotFactory screenshotFactory;
    private int waitBeforeScreenshot;
    private WebElement cutElement;
    private Integer stitchingAdjustment;

    public AppiumCaptureAlgorithmFactory(EyesAppiumDriver driver, Logger logger, AppiumScrollPositionProvider scrollProvider, ImageProvider imageProvider, DebugScreenshotsProvider debugScreenshotsProvider, ScaleProviderFactory scaleProviderFactory, CutProvider cutProvider, EyesScreenshotFactory screenshotFactory, int waitBeforeScreenshots, WebElement cutElement, Integer stitchingAdjustment) {
        this.driver = driver;
        this.logger = logger;
        this.scrollProvider = scrollProvider;
        this.imageProvider = imageProvider;
        this.debugScreenshotsProvider = debugScreenshotsProvider;
        this.scaleProviderFactory = scaleProviderFactory;
        this.cutProvider = cutProvider;
        this.screenshotFactory = screenshotFactory;
        this.waitBeforeScreenshot = waitBeforeScreenshots;
        this.cutElement = cutElement;
        this.stitchingAdjustment = stitchingAdjustment;
    }

    public AppiumFullPageCaptureAlgorithm getAlgorithm() {
        if (EyesAppiumUtils.isAndroid((WebDriver)this.driver.getRemoteWebDriver())) {
            return new AndroidFullPageCaptureAlgorithm(this.logger, this.scrollProvider, this.imageProvider, this.debugScreenshotsProvider, this.scaleProviderFactory, this.cutProvider, this.screenshotFactory, this.waitBeforeScreenshot, this.stitchingAdjustment);
        }
        if (EyesAppiumUtils.isIOS((WebDriver)this.driver.getRemoteWebDriver())) {
            return new AppiumFullPageCaptureAlgorithm(this.logger, this.scrollProvider, this.imageProvider, this.debugScreenshotsProvider, this.scaleProviderFactory, this.cutProvider, this.screenshotFactory, this.waitBeforeScreenshot, this.cutElement);
        }
        throw new Error("Could not find driver type for getting capture algorithm");
    }
}

