/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.appium.AppiumScrollPositionProvider;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.positioning.ScrollingPositionProvider;
import com.applitools.eyes.selenium.exceptions.EyesDriverOperationException;
import com.applitools.eyes.selenium.positioning.NullRegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.openqa.selenium.WebElement;

public class AppiumFullPageCaptureAlgorithm {
    private static final int MIN_SCREENSHOT_PART_HEIGHT = 10;
    protected Logger logger;
    private final PositionProvider originProvider;
    protected final ImageProvider imageProvider;
    protected final DebugScreenshotsProvider debugScreenshotsProvider;
    private final ScaleProviderFactory scaleProviderFactory;
    private final EyesScreenshotFactory screenshotFactory;
    protected final int waitBeforeScreenshots;
    private PositionMemento originalPosition;
    private ScaleProvider scaleProvider;
    private CutProvider cutProvider;
    protected Region regionInScreenshot;
    private double pixelRatio;
    private BufferedImage stitchedImage;
    protected Location currentPosition;
    protected boolean coordinatesAreScaled;
    protected final PositionProvider positionProvider;
    protected final ScrollingPositionProvider scrollProvider;
    private WebElement cutElement;

    public AppiumFullPageCaptureAlgorithm(Logger logger, PositionProvider originProvider, PositionProvider positionProvider, ScrollingPositionProvider scrollProvider, ImageProvider imageProvider, DebugScreenshotsProvider debugScreenshotsProvider, ScaleProviderFactory scaleProviderFactory, CutProvider cutProvider, EyesScreenshotFactory screenshotFactory, int waitBeforeScreenshots, WebElement cutElement) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.originProvider = originProvider;
        this.positionProvider = positionProvider;
        this.scrollProvider = scrollProvider;
        this.imageProvider = imageProvider;
        this.debugScreenshotsProvider = debugScreenshotsProvider;
        this.scaleProviderFactory = scaleProviderFactory;
        this.cutProvider = cutProvider;
        this.screenshotFactory = screenshotFactory;
        this.waitBeforeScreenshots = waitBeforeScreenshots;
        this.pixelRatio = 1.0;
        this.originalPosition = null;
        this.scaleProvider = null;
        this.regionInScreenshot = null;
        this.stitchedImage = null;
        this.currentPosition = null;
        this.coordinatesAreScaled = false;
        this.cutElement = cutElement;
    }

    public AppiumFullPageCaptureAlgorithm(Logger logger, AppiumScrollPositionProvider scrollProvider, ImageProvider imageProvider, DebugScreenshotsProvider debugScreenshotsProvider, ScaleProviderFactory scaleProviderFactory, CutProvider cutProvider, EyesScreenshotFactory screenshotFactory, int waitBeforeScreenshots, WebElement cutElement) {
        this(logger, (PositionProvider)scrollProvider, (PositionProvider)scrollProvider, (ScrollingPositionProvider)scrollProvider, imageProvider, debugScreenshotsProvider, scaleProviderFactory, cutProvider, screenshotFactory, waitBeforeScreenshots, cutElement);
    }

    protected RectangleSize captureAndStitchCurrentPart(Region partRegion, Region scrollViewRegion) {
        this.logger.verbose("Taking screenshot for current scroll location");
        GeneralUtils.sleep((long)this.waitBeforeScreenshots);
        BufferedImage partImage = this.imageProvider.getImage();
        this.debugScreenshotsProvider.save(partImage, "original-scrolled=" + this.currentPosition.toStringForFilename());
        this.setRegionInScreenshot(partImage, partRegion, (RegionPositionCompensation)new NullRegionPositionCompensation());
        partImage = this.cropPartToRegion(partImage, partRegion);
        this.stitchPartIntoContainer(partImage);
        return new RectangleSize(partImage.getWidth(), partImage.getHeight());
    }

    protected void captureAndStitchTailParts(BufferedImage image, int stitchingOverlap, RectangleSize entireSize, RectangleSize initialPartSize) {
        Region regionToCrop;
        this.logger.verbose("Capturing all the tail parts for an Appium screen");
        RectangleSize lastSuccessfulPartSize = new RectangleSize(initialPartSize.getWidth(), initialPartSize.getHeight());
        PositionMemento originalStitchedState = this.scrollProvider.getState();
        int statusBarHeight = ((AppiumScrollPositionProvider)this.scrollProvider).getStatusBarHeight();
        Region scrollViewRegion = this.scaleSafe(((AppiumScrollPositionProvider)this.scrollProvider).getScrollableViewRegion());
        Location newLoc = new Location(scrollViewRegion.getLeft(), scrollViewRegion.getTop() - this.scaleSafe(statusBarHeight) + 1);
        RectangleSize newSize = new RectangleSize(initialPartSize.getWidth(), scrollViewRegion.getHeight() - 1);
        scrollViewRegion.setLocation(newLoc);
        scrollViewRegion.setSize(newSize);
        ((AppiumScrollPositionProvider)this.scrollProvider).setCutElement(this.cutElement);
        ContentSize contentSize = ((AppiumScrollPositionProvider)this.scrollProvider).getCachedContentSize();
        int xPos = this.downscaleSafe(scrollViewRegion.getLeft() + 1);
        int oneScrollStep = this.downscaleSafe(scrollViewRegion.getHeight());
        int maxScrollSteps = contentSize.getScrollContentHeight() / oneScrollStep;
        this.logger.verbose("maxScrollSteps: " + maxScrollSteps);
        for (int step = 1; step <= maxScrollSteps; ++step) {
            regionToCrop = new Region(0, scrollViewRegion.getTop(), initialPartSize.getWidth(), scrollViewRegion.getHeight());
            int startY = this.downscaleSafe(scrollViewRegion.getHeight() + scrollViewRegion.getTop()) - 1;
            int endY = startY - oneScrollStep;
            ((AppiumScrollPositionProvider)this.scrollProvider).scrollTo(xPos, startY, xPos, endY, false);
            this.currentPosition = this.scaleSafe(((AppiumScrollPositionProvider)this.scrollProvider).getCurrentPositionWithoutStatusBar(true));
            Region scrolledRegion = new Region(scrollViewRegion.getLeft(), scrollViewRegion.getTop() + 1, scrollViewRegion.getWidth(), scrollViewRegion.getHeight());
            this.currentPosition = new Location(this.currentPosition.getX(), this.currentPosition.getY() + 1);
            this.logger.verbose("The region to capture will be " + scrolledRegion);
            lastSuccessfulPartSize = this.captureAndStitchCurrentPart(regionToCrop, scrollViewRegion);
        }
        int heightUnderScrollableView = initialPartSize.getHeight() - this.scaleSafe(oneScrollStep) - scrollViewRegion.getTop();
        if (heightUnderScrollableView > 0) {
            this.logger.verbose("There are extra space under the scrollable element. (height: " + heightUnderScrollableView + ")");
            regionToCrop = new Region(0, scrollViewRegion.getHeight() + scrollViewRegion.getTop(), initialPartSize.getWidth(), heightUnderScrollableView);
            this.currentPosition = new Location(this.currentPosition.getX(), this.currentPosition.getY() + lastSuccessfulPartSize.getHeight());
            lastSuccessfulPartSize = this.captureAndStitchCurrentPart(regionToCrop, scrollViewRegion);
        }
        this.cleanupStitch(originalStitchedState, this.currentPosition, lastSuccessfulPartSize, entireSize);
        this.moveToTopLeft();
    }

    private void saveDebugScreenshotPart(BufferedImage image, Region region, String name) {
        String suffix = "part-" + name + "-" + region.getLeft() + "_" + region.getTop() + "_" + region.getWidth() + "x" + region.getHeight();
        this.debugScreenshotsProvider.save(image, suffix);
    }

    protected void moveToTopLeft() {
        this.logger.verbose("Moving to the top left of the screen");
        this.currentPosition = this.originProvider.getCurrentPosition();
        if (this.currentPosition.getX() <= 0 && this.currentPosition.getY() <= 0) {
            this.logger.verbose("We are already at the top left, doing nothing");
            return;
        }
        int setPositionRetries = 3;
        do {
            this.originProvider.setPosition(new Location(0, 0));
            GeneralUtils.sleep((long)this.waitBeforeScreenshots);
            this.currentPosition = this.originProvider.getCurrentPosition();
        } while (this.currentPosition.getX() != 0 && this.currentPosition.getY() != 0 && --setPositionRetries > 0);
        if (this.currentPosition.getY() > 0) {
            this.originProvider.restoreState(this.originalPosition);
            throw new EyesException("Couldn't set position to the top/left corner!");
        }
    }

    private BufferedImage getTopLeftScreenshot() {
        this.moveToTopLeft();
        this.logger.verbose("Getting top/left image...");
        BufferedImage image = this.imageProvider.getImage();
        this.debugScreenshotsProvider.save(image, "original");
        this.scaleProvider = this.scaleProviderFactory.getScaleProvider(image.getWidth());
        this.pixelRatio = 1.0 / this.scaleProvider.getScaleRatio();
        this.logger.verbose("Set pixel ratio for this run to " + this.pixelRatio);
        this.cutProvider = this.cutProvider.scale(this.pixelRatio);
        if (!(this.cutProvider instanceof NullCutProvider)) {
            this.logger.verbose("We have a cut provider, so cutting top left screenshot");
            image = this.cutProvider.cut(image);
            this.debugScreenshotsProvider.save(image, "original-cut");
        }
        return image;
    }

    private BufferedImage cropToRegion(BufferedImage image, Region region, RegionPositionCompensation regionPositionCompensation) {
        this.logger.verbose("Cropping image with dimensions [" + image.getWidth() + ", " + image.getHeight() + "] to region " + region);
        this.setRegionInScreenshot(image, region, regionPositionCompensation);
        if (this.regionInScreenshot.isEmpty()) {
            this.logger.verbose("Region in screenshot was empty, no need to crop");
        } else {
            image = ImageUtils.getImagePart((BufferedImage)image, (Region)this.regionInScreenshot);
            this.saveDebugScreenshotPart(image, region, "cropped");
        }
        return image;
    }

    private RectangleSize getEntireSize(BufferedImage image, boolean checkingAnElement) {
        RectangleSize entireSize;
        if (!checkingAnElement) {
            try {
                entireSize = this.scrollProvider.getEntireSize();
                this.logger.verbose("Entire size of region context: " + entireSize);
            }
            catch (EyesDriverOperationException e) {
                this.logger.log("WARNING: Failed to extract entire size of region context" + e.getMessage());
                this.logger.log("Using image size instead: " + image.getWidth() + "x" + image.getHeight());
                entireSize = new RectangleSize(image.getWidth(), image.getHeight());
            }
        } else {
            entireSize = this.positionProvider.getEntireSize();
        }
        return entireSize;
    }

    protected void setRegionInScreenshot(BufferedImage image, Region region, RegionPositionCompensation regionPositionCompensation) {
        this.logger.verbose("Creating screenshot object...");
        EyesScreenshot screenshot = this.screenshotFactory.makeScreenshot(image);
        this.logger.verbose("Getting region in screenshot...");
        this.regionInScreenshot = this.getRegionInScreenshot(region, image, this.pixelRatio, screenshot, regionPositionCompensation);
        if (!this.regionInScreenshot.getSize().equals((Object)region.getSize())) {
            this.regionInScreenshot = this.getRegionInScreenshot(region, image, this.pixelRatio, screenshot, regionPositionCompensation);
        }
    }

    protected BufferedImage cropPartToRegion(BufferedImage partImage, Region partRegion) {
        if (!(this.cutProvider instanceof NullCutProvider)) {
            this.logger.verbose("cutting...");
            partImage = this.cutProvider.cut(partImage);
            this.debugScreenshotsProvider.save(partImage, "original-scrolled-cut-" + this.currentPosition.toStringForFilename());
        }
        if (!this.regionInScreenshot.isEmpty()) {
            this.logger.verbose("cropping...");
            partImage = ImageUtils.getImagePart((BufferedImage)partImage, (Region)this.regionInScreenshot);
            this.saveDebugScreenshotPart(partImage, partRegion, "original-scrolled-" + this.currentPosition.toStringForFilename());
        }
        return partImage;
    }

    protected void cleanupStitch(PositionMemento originalStitchedState, Location lastSuccessfulLocation, RectangleSize lastSuccessfulPartSize, RectangleSize entireSize) {
        this.logger.verbose("Stitching done!");
        this.positionProvider.restoreState(originalStitchedState);
        this.originProvider.restoreState(this.originalPosition);
        int actualImageWidth = lastSuccessfulLocation.getX() + lastSuccessfulPartSize.getWidth();
        int actualImageHeight = lastSuccessfulLocation.getY() + lastSuccessfulPartSize.getHeight();
        this.logger.verbose("Extracted entire size: " + entireSize);
        this.logger.verbose("Actual stitched size: " + actualImageWidth + "x" + actualImageHeight);
        if (actualImageWidth < this.stitchedImage.getWidth() || actualImageHeight < this.stitchedImage.getHeight()) {
            this.logger.verbose("Trimming unnecessary margins..");
            this.stitchedImage = ImageUtils.getImagePart((BufferedImage)this.stitchedImage, (Region)new Region(0, 0, Math.min(actualImageWidth, this.stitchedImage.getWidth()), Math.min(actualImageHeight, this.stitchedImage.getHeight())));
            this.logger.verbose("Done!");
        }
        this.debugScreenshotsProvider.save(this.stitchedImage, "stitched");
    }

    private void captureAndStitchPart(Region partRegion) {
        this.logger.verbose(String.format("Taking screenshot for %s", partRegion));
        this.positionProvider.setPosition(this.downscaleSafe(partRegion.getLocation()));
        GeneralUtils.sleep((long)this.waitBeforeScreenshots);
        this.currentPosition = this.scaleSafe(this.positionProvider.getCurrentPosition());
        this.logger.verbose(String.format("Set position to %s", this.currentPosition));
        this.logger.verbose("Getting image...");
        BufferedImage partImage = this.imageProvider.getImage();
        this.debugScreenshotsProvider.save(partImage, "original-scrolled-" + this.currentPosition.toStringForFilename());
        partImage = this.cropPartToRegion(partImage, partRegion);
        this.stitchPartIntoContainer(partImage);
    }

    protected void stitchPartIntoContainer(BufferedImage partImage) {
        this.logger.verbose("Stitching part into the image container...");
        this.stitchedImage.getRaster().setRect(0, this.currentPosition.getY(), partImage.getData());
        this.logger.verbose("Done!");
    }

    public BufferedImage getStitchedRegion(Region region, int stitchingOverlap, RegionPositionCompensation regionPositionCompensation) {
        this.logger.verbose("getStitchedRegion()");
        ArgumentGuard.notNull((Object)region, (String)"region");
        this.logger.verbose(String.format("getStitchedRegion: originProvider: %s ; positionProvider: %s ; cutProvider: %s", this.originProvider.getClass(), this.positionProvider.getClass(), this.cutProvider.getClass()));
        this.logger.verbose(String.format("Region to check: %s", region));
        this.originalPosition = this.originProvider.getState();
        BufferedImage image = this.getTopLeftScreenshot();
        image = this.cropToRegion(image, region, regionPositionCompensation);
        boolean checkingAnElement = !region.isEmpty();
        RectangleSize entireSize = this.scaleSafe(this.getEntireSize(image, checkingAnElement));
        this.logger.verbose("Scaled entire size is " + entireSize);
        if (image.getWidth() >= entireSize.getWidth() && image.getHeight() >= entireSize.getHeight()) {
            this.logger.verbose("Image was already bigger than entire size, so returning straightaway");
            this.originProvider.restoreState(this.originalPosition);
            return ImageUtils.scaleImage((BufferedImage)image, (ScaleProvider)this.scaleProvider);
        }
        this.logger.verbose("Creating stitchedImage container. Size: " + entireSize);
        this.stitchedImage = new BufferedImage(image.getWidth(), entireSize.getHeight(), image.getType());
        this.logger.verbose("Done!");
        this.logger.verbose("Adding initial screenshot..");
        Raster initialPart = image.getData();
        RectangleSize initialPartSize = new RectangleSize(initialPart.getWidth(), initialPart.getHeight());
        this.logger.verbose(String.format("Initial part:(0,0)[%d x %d]", initialPart.getWidth(), initialPart.getHeight()));
        this.stitchedImage.getRaster().setRect(0, 0, initialPart);
        this.logger.verbose("Done!");
        this.captureAndStitchTailParts(image, stitchingOverlap, entireSize, initialPartSize);
        if (this.pixelRatio == 1.0) {
            this.logger.verbose("Pixel ratio was 1, no need to scale stitched image");
        } else {
            this.logger.verbose("Pixel ratio was " + this.pixelRatio + "; scaling stitched image");
            this.stitchedImage = ImageUtils.scaleImage((BufferedImage)this.stitchedImage, (ScaleProvider)this.scaleProvider);
            this.debugScreenshotsProvider.save(this.stitchedImage, "scaled");
        }
        return this.stitchedImage;
    }

    private Region getRegionInScreenshot(Region region, BufferedImage image, double pixelRatio, EyesScreenshot screenshot, RegionPositionCompensation regionPositionCompensation) {
        region.setLocation(new Location(0, region.getLocation().getY()));
        Region regionInScreenshot = screenshot.getIntersectedRegion(region, CoordinatesType.SCREENSHOT_AS_IS);
        this.logger.verbose("Done! Region in screenshot: " + regionInScreenshot);
        if (regionPositionCompensation == null) {
            regionPositionCompensation = new NullRegionPositionCompensation();
        }
        regionInScreenshot = regionPositionCompensation.compensateRegionPosition(regionInScreenshot, pixelRatio);
        regionInScreenshot.intersect(new Region(0, 0, image.getWidth(), image.getHeight()));
        this.logger.verbose("Region after intersect: " + regionInScreenshot);
        return regionInScreenshot;
    }

    protected RectangleSize scaleSafe(RectangleSize rs) {
        if (this.coordinatesAreScaled) {
            return rs;
        }
        return rs.scale(this.pixelRatio);
    }

    protected Location scaleSafe(Location loc) {
        if (this.coordinatesAreScaled) {
            return loc;
        }
        return loc.scale(this.pixelRatio);
    }

    protected Region scaleSafe(Region reg) {
        if (this.coordinatesAreScaled) {
            return reg;
        }
        return reg.scale(this.pixelRatio);
    }

    protected Location downscaleSafe(Location loc) {
        if (this.coordinatesAreScaled) {
            return loc;
        }
        return loc.scale(1.0 / this.pixelRatio);
    }

    protected int scaleSafe(int value) {
        if (this.coordinatesAreScaled) {
            return value;
        }
        return (int)Math.ceil((double)value * this.pixelRatio);
    }

    protected int downscaleSafe(int value) {
        if (this.coordinatesAreScaled) {
            return value;
        }
        return (int)Math.ceil((double)value / this.pixelRatio);
    }
}

