/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.EyesAppiumUtils;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.selenium.frames.Frame;
import com.applitools.eyes.selenium.positioning.ScrollPositionMemento;
import com.applitools.eyes.selenium.positioning.SeleniumScrollingPositionProvider;
import com.applitools.utils.ArgumentGuard;
import io.appium.java_client.AppiumDriver;
import java.io.IOException;
import javax.annotation.Nullable;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class AppiumScrollPositionProvider
implements SeleniumScrollingPositionProvider {
    protected final Logger logger;
    protected final AppiumDriver driver;
    protected final EyesAppiumDriver eyesDriver;
    protected double distanceRatio;
    protected int verticalScrollGap;
    protected WebElement cutElement = null;
    protected ContentSize contentSize;
    private WebElement firstVisibleChild;
    private boolean isVerticalScrollGapSet;

    public AppiumScrollPositionProvider(Logger logger, EyesAppiumDriver driver) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)((Object)driver), (String)"driver");
        this.logger = logger;
        this.driver = driver.getRemoteWebDriver();
        this.eyesDriver = driver;
        this.distanceRatio = 0.0;
        this.verticalScrollGap = 0;
        this.isVerticalScrollGapSet = false;
    }

    public void setCutElement(WebElement cutElement) {
        this.cutElement = cutElement;
    }

    protected WebElement getCachedFirstVisibleChild() {
        WebElement activeScroll = EyesAppiumUtils.getFirstScrollableView((WebDriver)this.driver);
        if (this.firstVisibleChild == null) {
            this.logger.verbose("Could not find first visible child in cache, getting (this could take a while)");
            this.firstVisibleChild = EyesAppiumUtils.getFirstVisibleChild(activeScroll);
        } else {
            Rectangle firstVisibleChildRect = this.firstVisibleChild.getRect();
            if (firstVisibleChildRect.getWidth() == 0 && firstVisibleChildRect.getHeight() == 0) {
                this.logger.verbose("Cached visible child is invalid for some reason(e.g. user opened another screen and current firstVisibleChild is useless and it is not already in the view hierarchy). It should be updated. Getting (this could take a while)");
                this.firstVisibleChild = EyesAppiumUtils.getFirstVisibleChild(activeScroll);
            }
        }
        return this.firstVisibleChild;
    }

    @Nullable
    protected ContentSize getCachedContentSize() {
        if (this.contentSize == null) {
            try {
                WebElement activeScroll = EyesAppiumUtils.getFirstScrollableView((WebDriver)this.driver);
                this.contentSize = EyesAppiumUtils.getContentSize(this.driver, activeScroll);
                this.logger.verbose("Retrieved contentSize, it is: " + this.contentSize);
            }
            catch (NoSuchElementException e) {
                this.logger.log("WARNING: No active scroll element, so no content size to retrieve");
            }
            catch (IOException e) {
                this.logger.log("WARNING: could not retrieve content size from active scroll element");
            }
        }
        return this.contentSize;
    }

    public Location getScrollableViewLocation() {
        WebElement firstVisChild;
        WebElement activeScroll;
        this.logger.verbose("Getting the location of the scrollable view");
        try {
            activeScroll = EyesAppiumUtils.getFirstScrollableView((WebDriver)this.driver);
            firstVisChild = this.getCachedFirstVisibleChild();
        }
        catch (NoSuchElementException e) {
            return new Location(0, 0);
        }
        Point scrollLoc = activeScroll.getLocation();
        Point firstVisChildLoc = firstVisChild.getLocation();
        this.logger.verbose("The location of the first visible child is " + firstVisChildLoc);
        if (!this.isVerticalScrollGapSet) {
            this.verticalScrollGap = firstVisChildLoc.y - scrollLoc.y;
            this.isVerticalScrollGapSet = true;
        }
        Location loc = new Location(scrollLoc.x, scrollLoc.y + this.verticalScrollGap);
        this.logger.verbose("The location of the scrollable view is " + loc + ", accounting for a vertical scroll gap of " + this.verticalScrollGap);
        return loc;
    }

    public Region getScrollableViewRegion() {
        Region reg;
        this.logger.verbose("Getting the region of the scrollable view");
        try {
            WebElement activeScroll = EyesAppiumUtils.getFirstScrollableView((WebDriver)this.driver);
            Location scrollLoc = this.getScrollableViewLocation();
            Dimension scrollDim = activeScroll.getSize();
            reg = new Region(scrollLoc.getX(), scrollLoc.getY(), scrollDim.width, scrollDim.height - this.verticalScrollGap);
        }
        catch (NoSuchElementException e) {
            this.logger.verbose("WARNING: couldn't find scrollview, returning empty Region");
            reg = new Region(0, 0, 0, 0);
        }
        this.logger.verbose("The region of the scrollable view is " + reg + ", accounting for a vertical scroll gap of " + this.verticalScrollGap);
        return reg;
    }

    public Location getFirstVisibleChildLocation() {
        WebElement childElement;
        this.logger.verbose("Started..");
        try {
            childElement = this.getCachedFirstVisibleChild();
        }
        catch (NoSuchElementException e) {
            this.logger.verbose("No child element found. Using (0,0).");
            return new Location(0, 0);
        }
        Point childLoc = childElement.getLocation();
        this.logger.verbose("The first visible child is at " + childLoc);
        return new Location(childLoc.getX(), childLoc.getY());
    }

    public Location getCurrentPosition(boolean absolute) {
        this.logger.verbose("AppiumScrollPositionProvider - getCurrentPosition()");
        Location loc = this.getScrollableViewLocation();
        Location childLoc = this.getFirstVisibleChildLocation();
        Location pos = absolute ? new Location(loc.getX() * 2 - childLoc.getX(), loc.getY() * 2 - childLoc.getY()) : new Location(loc.getX() - childLoc.getX(), loc.getY() - childLoc.getY());
        this.logger.verbose("The current scroll position is " + pos);
        return pos;
    }

    public Location getCurrentPositionWithoutStatusBar(boolean absolute) {
        this.logger.verbose("AppiumScrollPositionProvider - getCurrentPositionWithoutStatusBar()");
        Location loc = this.getScrollableViewLocation();
        Location childLoc = this.getFirstVisibleChildLocation();
        Location pos = absolute ? new Location(loc.getX() * 2 - childLoc.getX(), loc.getY() * 2 - this.getStatusBarHeight() - childLoc.getY()) : new Location(loc.getX() - childLoc.getX(), loc.getY() - this.getStatusBarHeight() - childLoc.getY());
        this.logger.verbose("The current scroll position is " + pos);
        return pos;
    }

    public Location getCurrentPosition() {
        return this.getCurrentPosition(false);
    }

    public abstract void setPosition(Location var1);

    public abstract void setPosition(WebElement var1);

    public void setPosition(Frame frame) {
        this.setPosition(frame.getReference());
    }

    public RectangleSize getEntireSize() {
        int windowHeight = this.driver.manage().window().getSize().getHeight() - this.getStatusBarHeight();
        this.logger.verbose("window height: " + windowHeight);
        ContentSize contentSize = this.getCachedContentSize();
        if (contentSize == null) {
            return this.eyesDriver.getDefaultContentViewportSize();
        }
        int scrollContentHeight = contentSize.getScrollContentHeight();
        int outsideScrollviewHeight = windowHeight - contentSize.height;
        RectangleSize result = new RectangleSize(contentSize.width, scrollContentHeight + outsideScrollviewHeight + this.verticalScrollGap);
        this.logger.verbose("AppiumScrollPositionProvider - Entire size: " + result + " (Accounting for a vertical scroll gap of " + this.verticalScrollGap + ", with a scroll content height of " + scrollContentHeight + ")");
        return result;
    }

    public PositionMemento getState() {
        return new ScrollPositionMemento(this.getCurrentPosition());
    }

    public abstract void restoreState(PositionMemento var1);

    public void scrollToBottomRight() {
        this.setPosition(new Location(9999999, 9999999));
    }

    public abstract Location scrollDown(boolean var1);

    public abstract void scrollTo(int var1, int var2, int var3, int var4, boolean var5);

    int getStatusBarHeight() {
        return this.eyesDriver.getStatusBarHeight();
    }

    public abstract Region getElementRegion(WebElement var1, boolean var2, Boolean var3);
}

