/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.appium.AppiumCaptureAlgorithmFactory;
import com.applitools.eyes.appium.AppiumFullPageCaptureAlgorithm;
import com.applitools.eyes.appium.AppiumScrollPositionProvider;
import com.applitools.eyes.appium.AppiumScrollPositionProviderFactory;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.appium.ElementType;
import com.applitools.eyes.appium.EyesAppiumCheckSettings;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.EyesAppiumScreenshot;
import com.applitools.eyes.appium.EyesAppiumScreenshotFactory;
import com.applitools.eyes.appium.EyesAppiumUtils;
import com.applitools.eyes.appium.capture.ImageProviderFactory;
import com.applitools.eyes.appium.locators.VisualLocatorProviderFactory;
import com.applitools.eyes.fluent.ICheckSettings;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.locators.IVisualLocatorSettings;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.positioning.RegionProvider;
import com.applitools.eyes.scaling.FixedScaleProviderFactory;
import com.applitools.eyes.selenium.fluent.SeleniumCheckSettings;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import io.appium.java_client.AppiumDriver;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class Eyes
extends com.applitools.eyes.selenium.Eyes {
    private static final String NATIVE_APP = "NATIVE_APP";
    private EyesAppiumDriver driver;
    private ElementType cutElementType;
    private WebElement cutElement;

    public Eyes() {
        this.init();
        this.doNotGetTitle = true;
    }

    public String getBaseAgentId() {
        return "eyes.appium.java/4.14.0";
    }

    private void init() {
    }

    public EyesAppiumDriver getEyesDriver() {
        return this.driver;
    }

    protected void initDriverBasedPositionProviders() {
        this.logger.verbose("Initializing Appium position provider");
        this.setPositionProvider((PositionProvider)new AppiumScrollPositionProviderFactory(this.logger, this.getEyesDriver()).getScrollPositionProvider());
    }

    protected void initImageProvider() {
        this.imageProvider = ImageProviderFactory.getImageProvider(this, this.logger, (WebDriver)this.getEyesDriver(), true);
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    protected void initDriver(WebDriver driver) {
        if (driver instanceof AppiumDriver) {
            this.logger.verbose("Found an instance of AppiumDriver, so using EyesAppiumDriver instead");
            this.driver = new EyesAppiumDriver(this.logger, this, (AppiumDriver)driver);
        } else {
            this.logger.verbose("Did not find an instance of AppiumDriver, using regular logic");
            super.initDriver(driver);
        }
    }

    protected ScaleProviderFactory getScaleProviderFactory() {
        return new FixedScaleProviderFactory(1.0 / this.getDevicePixelRatio(), this.scaleProviderHandler);
    }

    protected boolean isMobileDevice(WebDriver driver) {
        return EyesAppiumUtils.isMobileDevice(driver);
    }

    protected AppEnvironment getAppEnvironment() {
        AppEnvironment appEnv = super.getAppEnvironment();
        AppiumDriver underlyingDriver = this.driver.getRemoteWebDriver();
        if (appEnv.getOs() == null) {
            this.logger.log("No OS set, checking for mobile OS...");
            if (EyesAppiumUtils.isMobileDevice((WebDriver)underlyingDriver)) {
                Object deviceNameCapability;
                String platformName = null;
                this.logger.log("Mobile device detected! Checking device type..");
                if (EyesAppiumUtils.isAndroid((WebDriver)underlyingDriver)) {
                    this.logger.log("Android detected.");
                    platformName = "Android";
                } else if (EyesAppiumUtils.isIOS((WebDriver)underlyingDriver)) {
                    this.logger.log("iOS detected.");
                    platformName = "iOS";
                } else {
                    this.logger.log("Unknown device type.");
                }
                if (platformName != null) {
                    String majorVersion;
                    String os = platformName;
                    String platformVersion = EyesAppiumUtils.getPlatformVersion((HasCapabilities)underlyingDriver);
                    if (platformVersion != null && !(majorVersion = platformVersion.split("\\.", 2)[0]).isEmpty()) {
                        os = os + " " + majorVersion;
                    }
                    this.logger.verbose("Setting OS: " + os);
                    appEnv.setOs(os);
                }
                String deviceName = (deviceNameCapability = underlyingDriver.getCapabilities().getCapability("deviceName")) != null ? deviceNameCapability.toString() : "Unknown";
                appEnv.setDeviceInfo(deviceName);
            } else {
                this.logger.log("No mobile OS detected.");
            }
        }
        this.logger.log("Done!");
        return appEnv;
    }

    protected double extractDevicePixelRatio() {
        return this.getEyesDriver().getDevicePixelRatio();
    }

    private void updateCutElement(EyesAppiumCheckSettings checkSettings) {
        this.cutElementType = checkSettings.getCutElementType();
        try {
            if (checkSettings.getCutElementSelector() == null) {
                return;
            }
            this.cutElement = this.getDriver().findElement(checkSettings.getCutElementSelector());
        }
        catch (NoSuchElementException ignored) {
            this.logger.verbose("Element to cut is not found with selector: " + checkSettings.getCutElementSelector());
        }
    }

    public void check(ICheckSettings checkSettings) {
        if (checkSettings instanceof EyesAppiumCheckSettings) {
            this.updateCutElement((EyesAppiumCheckSettings)checkSettings);
        }
        super.check(checkSettings);
    }

    protected MatchResult checkElement(final WebElement element, String name, final ICheckSettings checkSettings) {
        return this.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                return Eyes.this.getElementRegion(element, checkSettings);
            }
        }, name, false, checkSettings);
    }

    protected EyesAppiumScreenshot getFullPageScreenshot() {
        this.logger.verbose("Full page Appium screenshot requested.");
        EyesAppiumScreenshotFactory screenshotFactory = new EyesAppiumScreenshotFactory(this.logger, this.getEyesDriver());
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        AppiumScrollPositionProvider scrollPositionProvider = (AppiumScrollPositionProvider)this.getPositionProvider();
        AppiumCaptureAlgorithmFactory algoFactory = new AppiumCaptureAlgorithmFactory(this.getEyesDriver(), this.logger, scrollPositionProvider, this.imageProvider, this.debugScreenshotsProvider, scaleProviderFactory, (CutProvider)this.cutProviderHandler.get(), screenshotFactory, this.getWaitBeforeScreenshots(), this.cutElement, this.getStitchOverlap());
        AppiumFullPageCaptureAlgorithm algo = algoFactory.getAlgorithm();
        BufferedImage fullPageImage = algo.getStitchedRegion(Region.EMPTY, this.getStitchOverlap(), this.regionPositionCompensation);
        return new EyesAppiumScreenshot(this.logger, this.getEyesDriver(), fullPageImage);
    }

    protected EyesAppiumScreenshot getSimpleScreenshot() {
        CutProvider cutProvider;
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        this.logger.verbose("Screenshot requested...");
        BufferedImage screenshotImage = this.imageProvider.getImage();
        this.debugScreenshotsProvider.save(screenshotImage, "original");
        ScaleProvider scaleProvider = scaleProviderFactory.getScaleProvider(screenshotImage.getWidth());
        if (scaleProvider.getScaleRatio() != 1.0) {
            this.logger.verbose("scaling...");
            screenshotImage = ImageUtils.scaleImage((BufferedImage)screenshotImage, (ScaleProvider)scaleProvider);
            this.debugScreenshotsProvider.save(screenshotImage, "scaled");
        }
        if (!((cutProvider = (CutProvider)this.cutProviderHandler.get()) instanceof NullCutProvider)) {
            this.logger.verbose("cutting...");
            screenshotImage = cutProvider.cut(screenshotImage);
            this.debugScreenshotsProvider.save(screenshotImage, "cut");
        }
        this.logger.verbose("Creating screenshot object...");
        return new EyesAppiumScreenshot(this.logger, this.getEyesDriver(), screenshotImage);
    }

    protected MatchResult checkRegion(String name, ICheckSettings checkSettings) {
        MatchResult result = this.checkWindowBase(new RegionProvider(){

            public Region getRegion() {
                Point p = Eyes.this.targetElement.getLocation();
                Dimension d = Eyes.this.targetElement.getSize();
                return new Region(p.getX(), p.getY(), d.getWidth(), d.getHeight(), CoordinatesType.CONTEXT_RELATIVE);
            }
        }, name, false, checkSettings);
        this.logger.verbose("Done! trying to scroll back to original position.");
        return result;
    }

    protected EyesScreenshot getSubScreenshot(EyesScreenshot screenshot, Region region, ICheckSettingsInternal checkSettingsInternal) {
        ArgumentGuard.notNull((Object)region, (String)"region");
        if ((EyesAppiumUtils.isAndroid((WebDriver)this.driver) || EyesAppiumUtils.isIOS((WebDriver)this.driver)) && region.getCoordinatesType() != CoordinatesType.CONTEXT_RELATIVE) {
            this.logger.verbose(String.format("getSubScreenshot([%s])", region));
            BufferedImage image = screenshot.getImage();
            if (image.getWidth() < this.driver.getViewportRect().get("width")) {
                image = ImageUtils.scaleImage((BufferedImage)image, (double)this.driver.getEyes().getDevicePixelRatio());
            }
            BufferedImage subScreenshotImage = ImageUtils.scaleImage((BufferedImage)ImageUtils.getImagePart((BufferedImage)image, (Region)region), (double)(1.0 / this.driver.getEyes().getDevicePixelRatio()));
            EyesAppiumScreenshot result = new EyesAppiumScreenshot(this.logger, this.driver, subScreenshotImage, new RectangleSize(subScreenshotImage.getWidth(), subScreenshotImage.getHeight()));
            this.logger.verbose("Done!");
            return result;
        }
        return screenshot.getSubScreenshot(region, false);
    }

    public Location getElementOriginalLocation(WebElement element) {
        try {
            ContentSize contentSize = EyesAppiumUtils.getContentSize(this.driver.getRemoteWebDriver(), element);
            return new Location(contentSize.left, contentSize.top);
        }
        catch (IOException ignored) {
            return new Location(element.getLocation().getX(), element.getLocation().getY());
        }
    }

    protected void initVisualLocatorProvider() {
        VisualLocatorProviderFactory factory = new VisualLocatorProviderFactory(this.driver, this.logger, this.serverConnector, this.debugScreenshotsProvider);
        this.visualLocatorProvider = factory.getProvider();
    }

    public Map<String, List<Region>> locate(IVisualLocatorSettings visualLocatorSettings) {
        ArgumentGuard.notNull((Object)visualLocatorSettings, (String)"visualLocatorSettings");
        return this.visualLocatorProvider.getLocators(visualLocatorSettings);
    }

    private Region getElementRegion(WebElement element, ICheckSettings checkSettings) {
        this.logger.verbose("Get element region...");
        Boolean statusBarExists = null;
        if (checkSettings instanceof SeleniumCheckSettings) {
            statusBarExists = ((SeleniumCheckSettings)checkSettings).getStatusBarExists();
        }
        Region region = ((AppiumScrollPositionProvider)this.getPositionProvider()).getElementRegion(element, this.shouldStitchContent(), statusBarExists);
        this.logger.verbose("Element region: " + region.toString());
        return region;
    }
}

