/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Trigger;
import com.applitools.eyes.appium.AppiumJsCommandExtractor;
import com.applitools.eyes.appium.EyesAppiumElement;
import com.applitools.eyes.appium.EyesAppiumUtils;
import com.applitools.eyes.selenium.Eyes;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.eyes.triggers.MouseTrigger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import io.appium.java_client.AppiumDriver;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

public class EyesAppiumDriver
extends EyesWebDriver {
    private Map<String, Object> sessionDetails;

    public EyesAppiumDriver(Logger logger, Eyes eyes, AppiumDriver driver) {
        super(logger, eyes, (RemoteWebDriver)driver);
    }

    public AppiumDriver getRemoteWebDriver() {
        return (AppiumDriver)this.driver;
    }

    public EyesAppiumElement getEyesElement(WebElement element) {
        if (element instanceof EyesAppiumElement) {
            return (EyesAppiumElement)element;
        }
        if (element instanceof EyesRemoteWebElement) {
            throw new Error("Programming error: should not have sent an EyesRemoteWebElement in");
        }
        return new EyesAppiumElement(this.logger, this, element, 1.0 / this.getDevicePixelRatio());
    }

    private Map<String, Object> getCachedSessionDetails() {
        if (this.sessionDetails == null) {
            this.logger.verbose("Retrieving session details and caching the result...");
            this.sessionDetails = this.getRemoteWebDriver().getSessionDetails();
            this.logger.verbose("Session details: " + this.sessionDetails.toString());
        }
        return this.sessionDetails;
    }

    public HashMap<String, Integer> getViewportRect() {
        Map rectMap = (Map)this.getCachedSessionDetails().get("viewportRect");
        HashMap<String, Integer> intRectMap = new HashMap<String, Integer>();
        intRectMap.put("width", ((Long)rectMap.get("width")).intValue());
        intRectMap.put("height", ((Long)rectMap.get("height")).intValue());
        return intRectMap;
    }

    public int getStatusBarHeight() {
        Object statusBarHeight = this.getCachedSessionDetails().get("statBarHeight");
        if (statusBarHeight instanceof Double) {
            return ((Double)statusBarHeight).intValue();
        }
        return ((Long)statusBarHeight).intValue();
    }

    public double getDevicePixelRatio() {
        Object pixelRatio = this.getCachedSessionDetails().get("pixelRatio");
        if (pixelRatio instanceof Double) {
            return (Double)pixelRatio;
        }
        return ((Long)pixelRatio).doubleValue();
    }

    public RectangleSize getDefaultContentViewportSize(boolean forceQuery) {
        this.logger.verbose("getDefaultContentViewportSize(forceQuery: " + forceQuery + ")");
        if (this.defaultContentViewportSize != null && !forceQuery) {
            this.logger.verbose("Using cached viewport size: " + this.defaultContentViewportSize);
            return this.defaultContentViewportSize;
        }
        HashMap<String, Integer> rect = this.getViewportRect();
        double dpr = this.getDevicePixelRatio();
        this.defaultContentViewportSize = new RectangleSize(rect.get("width").intValue(), rect.get("height").intValue()).scale(1.0 / dpr);
        this.logger.verbose("Done! Viewport size: " + this.defaultContentViewportSize);
        return this.defaultContentViewportSize;
    }

    public Object executeScript(String script, Object ... args) {
        Trigger trigger;
        if (AppiumJsCommandExtractor.isAppiumJsCommand(script) && (trigger = AppiumJsCommandExtractor.extractTrigger(this.getElementIds(), this.getRemoteWebDriver().manage().window().getSize(), script, args)) != null && trigger instanceof MouseTrigger) {
            MouseTrigger mt = (MouseTrigger)trigger;
            this.eyes.addMouseTrigger(mt.getMouseAction(), mt.getControl(), mt.getLocation());
        }
        Object result = this.driver.executeScript(script, args);
        return result;
    }

    public Object executeAsyncScript(String script, Object ... args) {
        Trigger trigger;
        if (AppiumJsCommandExtractor.isAppiumJsCommand(script) && (trigger = AppiumJsCommandExtractor.extractTrigger(this.elementsIds, this.driver.manage().window().getSize(), script, args)) != null && trigger instanceof MouseTrigger) {
            MouseTrigger mt = (MouseTrigger)trigger;
            this.eyes.addMouseTrigger(mt.getMouseAction(), mt.getControl(), mt.getLocation());
        }
        return this.driver.executeAsyncScript(script, args);
    }

    public static BufferedImage normalizeRotation(Logger logger, WebDriver driver, BufferedImage image, ImageRotation rotation) {
        ArgumentGuard.notNull((Object)driver, (String)"driver");
        ArgumentGuard.notNull((Object)image, (String)"image");
        int degrees = rotation != null ? rotation.getRotation() : EyesAppiumUtils.tryAutomaticRotation(logger, driver, image);
        return ImageUtils.rotateImage((BufferedImage)image, (double)degrees);
    }

    public <X> X getScreenshotAs(OutputType<X> xOutputType) throws WebDriverException {
        String screenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
        BufferedImage screenshot = ImageUtils.imageFromBase64((String)screenshot64);
        screenshot = EyesAppiumDriver.normalizeRotation(this.logger, (WebDriver)this.driver, screenshot, this.rotation);
        screenshot64 = ImageUtils.base64FromImage((BufferedImage)screenshot);
        return (X)xOutputType.convertFromBase64Png(screenshot64);
    }

    public EyesAppiumElement findElement(By by) {
        WebElement webElement = this.driver.findElement(by);
        if (webElement instanceof RemoteWebElement) {
            EyesAppiumElement appiumElement = new EyesAppiumElement(this.logger, this, webElement, 1.0 / this.getDevicePixelRatio());
            this.elementsIds.put(((RemoteWebElement)webElement).getId(), webElement);
            return appiumElement;
        }
        throw new EyesException("findElement: Element is not a RemoteWebElement: " + by);
    }

    public List<WebElement> findElements(By by) {
        List foundWebElementsList = this.driver.findElements(by);
        ArrayList<WebElement> resultElementsList = new ArrayList<WebElement>(foundWebElementsList.size());
        for (WebElement currentElement : foundWebElementsList) {
            if (currentElement instanceof RemoteWebElement) {
                resultElementsList.add((WebElement)new EyesAppiumElement(this.logger, this, currentElement, 1.0 / this.getDevicePixelRatio()));
                this.elementsIds.put(((RemoteWebElement)currentElement).getId(), currentElement);
                continue;
            }
            throw new EyesException(String.format("findElements: element is not a RemoteWebElement: %s", by));
        }
        return resultElementsList;
    }
}

