/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.Logger;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.selenium.wrappers.EyesRemoteWebElement;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import io.appium.java_client.ios.IOSDriver;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class EyesAppiumElement
extends EyesRemoteWebElement {
    private Dimension size;
    private double pixelRatio;
    private EyesAppiumDriver driver;

    public EyesAppiumElement(Logger logger, EyesAppiumDriver driver, WebElement element, double pixelRatio) {
        super(logger, (EyesWebDriver)driver, element);
        this.pixelRatio = pixelRatio;
        this.driver = driver;
    }

    protected Dimension getCachedSize() {
        if (this.size == null) {
            this.size = this.webElement.getSize();
        }
        return this.size;
    }

    public Dimension getSize() {
        int unscaledHeight;
        int unscaledWidth;
        Dimension size = super.getSize();
        if (this.pixelRatio == 1.0) {
            return size;
        }
        if (this.driver.getRemoteWebDriver() instanceof IOSDriver) {
            unscaledWidth = this.webElement.getSize().getWidth();
            unscaledHeight = this.webElement.getSize().getHeight();
        } else {
            unscaledWidth = (int)Math.ceil((double)this.webElement.getSize().getWidth() * this.pixelRatio);
            unscaledHeight = (int)Math.ceil((double)this.webElement.getSize().getHeight() * this.pixelRatio);
        }
        return new Dimension(unscaledWidth, unscaledHeight);
    }

    public int getClientWidth() {
        return this.getCachedSize().width;
    }

    public int getClientHeight() {
        return this.getCachedSize().height;
    }

    public int getComputedStyleInteger(String propStyle) {
        return 0;
    }

    public Point getLocation() {
        int unscaledY;
        int unscaledX;
        Point location = super.getLocation();
        location = new Point(location.getX(), location.getY() - this.driver.getStatusBarHeight());
        if (this.pixelRatio == 1.0) {
            return location;
        }
        if (this.driver.getRemoteWebDriver() instanceof IOSDriver) {
            unscaledX = location.getX();
            unscaledY = location.getY();
        } else {
            unscaledX = (int)Math.ceil((double)location.getX() * this.pixelRatio);
            unscaledY = (int)Math.ceil((double)location.getY() * this.pixelRatio);
        }
        return new Point(unscaledX, unscaledY);
    }
}

